
#include "Sys_Scheduler_Lib.h"
#include "Application.h"
#include "Components.h"
#include "RTE.h"
#include "UDS_ISO14229_Server.h"

void Sys_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();
    UDS_Server_Application_Service();
    BU98R10_Update_Service();
    LED_Driver_Service();
}

void Sys_2ms_Tasks(void)
{
    Common_Input_Para();
    Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 2000u);
    Sys_Status_Update_Service();
    Analog_Signal_Conv_Service();
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 2u);
}

void Sys_5ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
    Data_Gear_Cutterhead_Service();
}

void Sys_10ms_Tasks(void)
{
    Line_In_Debounce_Service(10u);
    Can_BusOff_Recover(10u);
    Data_CumulativeWorkHours_EEPROM_Write();
}

void Sys_20ms_Tasks(void)
{
}

void Sys_50ms_Tasks(void)
{
    BU98R10_Update_Request();
    LED_Driver_Scan_Refresh();
    Telltales_Management();
    Set_CAN_ALL_Signal();
    Gauge_Service();
    Data_Soc_Service();
}

void Sys_15ms_Tasks(void)
{
    if ((Common_GetIgnOnTime() <= 1500) && (Common_GetIgnOnTime() > 0) && (checkself_seg_Flag == 1))
    {
        BU98R10_Update_Request();
        Checkself_SEG_Display();
    }
}

uint8_t u8LEDDriverCheckCount = 0U;
void Sys_100ms_Tasks(void)
{

    BackLight_Process();
    BackLight_Clock_All_Process();
    Interact_Light_Process();
    S3_ServerCNTT();

    if (u8LEDDriverCheckCount >= 10U)
    {
        u8LEDDriverCheckCount = 0U;
        LED_Driver_Work_Check();
        LED_Driver_Service_Immediate(); // 注意顺序1
    }
    else
    {
        u8LEDDriverCheckCount++;
    }
    Data_Time_Single_Working_Hours();
    Data_Time_Total_Working_Hours();
    
}

/**
 * @brief 50us中断服务 尽可能的减少中断使用
 *
 */
void Sys_Exact_50us_Tasks(void)
{
    static uint32_t task_1ms = 0u;
    DoCAN_Timer_Update(50u);
    GenDelay_Tick();
    task_1ms++;
    if (task_1ms >= 20U)
    {
        task_1ms = 0U;
        eeprom_1ms_timeCount();
    }
}
