
#include "CommonInterface\CommonInterface.h"
#include "CAN_APP\CAN_CH0_CAN_Communication_Matrix.h"

static uint32_t PowerIgnOnTimeLine;
uint32_t PowerIgnOffTimeLine;

uint8_t Power_CheckSelf = 0;
static uint32_t PowerSocTimeLine;

static COMMON_PowerStatus_t PowerSts; /*1 ON ;  0 OFF*/
static DataValid_t PowerSts_Valid;

// static uint16_t u16SelfCheckTime;
/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts = COMMON_POWER_UNKNOW;
    PowerIgnOnTimeLine = 0x0ul;
    PowerIgnOffTimeLine = 0x0ul;
    PowerSocTimeLine = 0x0ul;
    // u16SelfCheckTime = DisplaySelfCheckTime;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

uint8_t Common_Get_IG_Sts(void)
{
    return (uint8_t)PowerSts;
}

uint16_t Common_Get_TireSize(void)
{
    return 1u;
}

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}

void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}

void Common_Input_Para(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if ((Get_CAN_Power_State() != KEY_OFF) && (System_Indicator_CANFlag != 1))
        {
            Common_Set_IG_Sts(COMMON_POWER_ON);
            Common_Set_IG_Sts_Valid(COMMON_Valid);

            PowerIgnOffTimeLine = 0ul;

            if (PowerIgnOnTimeLine < 0x7ffffffful && (Get_CAN_Power_State() != PKEY_ON))
            {
                PowerIgnOnTimeLine += 2u;
            }
        }
        else if (System_Indicator_CANFlag == 1)
        {
            Common_Set_IG_Sts(COMMON_POWER_ON);
            Common_Set_IG_Sts_Valid(COMMON_Valid);
            PowerIgnOffTimeLine = 0ul;
            PowerIgnOnTimeLine = 1501ul;
        }
        else
        {
            PowerIgnOnTimeLine = 0ul;
            if (PowerIgnOffTimeLine < 0x7ffffffful)
            {
                PowerIgnOffTimeLine += 2u;
            }
            Common_Set_IG_Sts(COMMON_POWER_OFF);
            Common_Set_IG_Sts_Valid(COMMON_Valid);
        }
        if ((Get_CAN_Power_State() == PKEY_ON))
        {
            PowerIgnOnTimeLine = 0ul;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if (PowerIgnOffTimeLine < 0x7ffffffful)
        {
            PowerIgnOffTimeLine += 2u;
        }
        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);
    }
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

uint32_t Common_GetSocTime(void)
{
    return PowerSocTimeLine;
}
