#ifndef BACKLIGHT_USER_H__
#define BACKLIGHT_USER_H__

#include "Application.h"
#include "Components.h"

/*NTC 降背光策略采用BYD策略
L超过60℃需要有背光策略，背光策略优先依据BYD策略
L温度要设计≥2℃的温度回差
注：BYD策略，如下：
采集温度达到60度  输出背光=当前背光等级亮度*95%
采集温度达到65度  输出背光=当前背光等级亮度*90%
采集温度达到70度  输出背光=当前背光等级亮度*85%
采集温度达到75度  输出背光=当前背光等级亮度*80%
采集温度达到80度  输出背光=当前背光等级亮度*75%
采集温度达到85度  输出背光=当前背光等级亮度*70%
采集温度达到88度  输出背光=当前背光等级亮度*20%
采集温度达到90度  输出背光=当前背光等级亮度*10



温度上升
2S下降1%
温度下降
4S上升1%

*/

#define  BACKLIGHT_DELAY_NUM                  15U                /*背光延迟点亮等待时长 = （BACKLIGHT_DELAY_NUM * 10ms） */
#define  BLACK_TO_WHITE_LUMINOUS_VALUE      2000U                /*从黑背景切换到白背景时的临界光感值*/
#define  WHITE_TO_BLACK_LUMINOUS_VALUE       900U                /*从白背景切换到黑背景时的临界光感值*/
#define  SCREEN_SWITCHOVER_DELAY_NUM          15U                /*白天夜间模式切换光感滤波时间 = SCREEN_SWITCHOVER_HOLD_NUM * 100ms） */

typedef enum{

    DAY_SCREEN = 0,   /*白天模式、白背景*/
    NIGHT_SCREEN,       /*夜间模式、黑背景*/

}BackLight_Screen_Status_en_t;

/*光感数据存储结构体*/
typedef struct __attribute__((aligned(4))) 
{
    uint32_t u32Result;
    uint8_t u8DayandNightSts;

}Backlight_User_OPT3004_st_t;

extern Backlight_User_OPT3004_st_t opt3004;
extern uint16_t u16Backlightcount;
extern uint8_t u8BacklightLevel;

extern void BackLight_User_Init(void);
extern uint8_t Get_BackLight_Level_Display(void);

extern uint8_t interact_PWM_Low_Duty;
void BackLight_Process(void);
void Interact_Light_Process(void);
void BackLight_Clock_All_Process(void);
extern uint8_t Get_Interact_Light_State(void);

#endif
