#ifndef _SEG_DISPLAY_H_
#define _SEG_DISPLAY_H_

#include "SEG_Ref.h"
#include "Components.h"


typedef enum
{
    SEG_LED_Recharge = 0u,        
    //SEG_LED_Auto_Start_Stop,
    //SEG_LED_Fuel,
    SEG_LED_Engine_Failure, //发动机故障
    SEG_LED_Battery_Failure,//电池故障
    SEG_LED_Oil_press_Warning,  //机油压力报警
    SEG_LED_System_Light,//系统知识灯
    SEG_LED_Power_Battery_Failure, //动力电池故障
    SEG_LED_Chloramine, //草满
    SEG_LED_Cutter_Overload,  //刀盘过载
    SEG_LED_Seat_Detection, //座椅检测
    SEG_LED_Key_Access,//钥匙接入
    SEG_LED_Ready,  //Ready
    SEG_LED_Cutter_Head_switch,//刀盘开关
    SEG_LED_engine_Burn,  //发动机工作
    SEG_LED_External_Discharge, //对外放电
    SEG_LED_bluetooth, //蓝牙
    SEG_LED_Distance_Light,//远光灯
    SEG_LED_Cruise_Control,//定速巡航
    SEG_LED_HHT_Charger,  //充电枪
    SEG_LED_Fuel_Oil,  //燃油灯

    SEG_LED_MAX
} SEG_LED_Idx_t;

enum
{
  Gear_P = 0,  //P
  Gear_1,      //R
  Gear_2,      //N
  Gear_OFF,      //D
}; 

/**@brief 边框线显示函数*/
_Fun_Res SEG_SET_Frame(uint8_t m_Flag);

/**@brief 挡位显示函数*/
_Fun_Res SEG_SET_GEAR(uint8_t m_Gear_Flag,uint8_t m_Gear,uint8_t checkself);

/**@brief 电量表盘1SOC显示函数*/
_Fun_Res SEG_SET_EleDial_1SOC(uint8_t m_Flag,uint8_t m_SEG);

/**@brief 电量表盘2SOC显示函数*/
_Fun_Res SEG_SET_EleDial_2SOC(uint8_t m_Flag,uint8_t m_SEG);

/**@brief 电量表盘AllSOC显示函数*/
_Fun_Res SEG_SET_EleDial_AllSOC(uint8_t m_Flag,uint16_t m_NUM);

// /**@brief 燃油表盘显示函数*/
// _Fun_Res SEG_SET_FuelDial(uint8_t m_Flag,uint8_t m_SEG);

/**@brief 转速表盘显示函数*/
//_Fun_Res SEG_SET_EspeedDial(uint8_t m_Flag, uint8_t m_SEG, uint16_t m_NUM);

/**@brief 功率表盘显示函数*/
_Fun_Res SEG_SET_PowerDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint8_t m_NUM);

/**@brief 续航里程显示函数*/
_Fun_Res SEG_SET_DTE_NUM(uint8_t m_Flag, uint16_t m_NUM);

/**@brief 车速8字段显示函数*/
_Fun_Res SEG_SET_VSpeed_NUM(uint8_t m_Flag , uint16_t m_NUM);

/**@brief L8字段显示函数*/
_Fun_Res SEG_SET_L8_NUM(uint8_t m_Flag , uint8_t m_NUM);


/**@brief 故障码显示函数*/
_Fun_Res SEG_SET_Fault_Code(uint8_t m_Flag, uint16_t m_NUM);

/**@brief 单次时间显示函数*/
_Fun_Res SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 );

/**@brief 累计时间显示函数*/
_Fun_Res SEG_SET_Clock_ALL(uint8_t m_Flag , uint32_t m_NUM);

void Check_SEG_Display(void);




#define IC_SEG_OFF   0x00u
#define IC_SEG_ON    0x07u
#define IC_SEG_GREY  0x01u 

/**@brief 指示灯显示函数*/
_Fun_Res SEG_SET_LED_STS(uint8_t LED_NUM , uint8_t m_Flag);
/**@brief 行驶时间显示函数*/
_Fun_Res SEG_SET_Travel_Time_NUM(uint8_t m_Flag, uint32_t m_NUM);
//扫盘用
_Fun_Res SEG_Scan_SET_EleDial(uint8_t m_SEG);
_Fun_Res SEG_Scan_SET_PowerDial(uint8_t m_SEG);
/**@brief 刀盘显示函数*/
_Fun_Res SEG_SET_Cutterhead(uint8_t m_Flag, uint8_t LED_NUM,  uint8_t checkself);

void SEG_Scan_SET_FuelDial(void);
void SEG_Scan_SET_EspeedDial(void);

//void SEG_Scan_SET_FuelDial_Checkself(void);
//void SEG_Scan_SET_EspeedDial_Checkself(void);
//void SEG_Scan_SET_VSpeed_Checkself(void);

extern void Checkself_Init (void);
extern void Checkself_SEG_Display(void);

extern uint8_t SOC_charge_seg_Flag;
extern uint8_t Checkself_SEG_step;
extern uint8_t Checkself_SEG_step_count;
extern uint8_t checkself_seg_Flag;
extern uint8_t g_u8TYWClearEepromFlag;
extern uint16_t Buzzer_time;



#endif
