#include "Can_RX_User.h"
#include "DoCAN_ISO15765.h"
#include "can.h"
#include "RTE.h"

static uint8_t BMCU_ErrorGrage = 0;
static uint8_t BMCU_BladeSpeedGear = 0;
static uint8_t BMCU_PTOSwicthState = 0;

static uint8_t BMCU_Moto2_Locked_RotorFault = 0;
static uint8_t BMCU_Moto1_Locked_RotorFault = 0;
static uint8_t MBMS_Soc = 0;

static uint8_t MBMS_TOTALWorkState = 0;
static uint8_t MBMS_TOTALSigOn = 0;
static uint8_t MBMS_TOTALSigAcc = 0;
static uint8_t MBMS_TOTALSigCharge = 0;

static uint8_t MBMS_StatSoc = 0;

static uint8_t MBMS_StatBattChargeState = 0;
static uint8_t MBMS_StatBattWorkState = 0;

static uint8_t MMCU_ErrorGrage = 0;
static uint8_t MMCU_ChgProtectState = 0;
static uint8_t MMCU_DCDCEnableState = 0;
static uint8_t MMCU_ParkingGearState = 0;
static uint8_t MMCU_SeatDetectState = 0;
static uint8_t MMCU_LockMotoState = 0;
static uint8_t MMCU_EBSState = 0;
static uint8_t MMCU_TravelSpeedGear = 0;
static uint8_t MMCU_PowerMode = 0;
static uint8_t MMCU_WorkState = 0;

static uint16_t MMCU_AccumulatedWorkHours = 0;
static uint8_t MMCU_SingleWorkingHours = 0;
static uint8_t SBMS_Soc = 0;
static uint8_t SMCU_ErrorGrage = 0;
void Set_CAN_ALL_Signal(void)
{
    #if (PART_NUMBER == RMR42E_60)
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL)
        {
            BMCU_ErrorGrage = Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage();
            BMCU_BladeSpeedGear = Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear();
            BMCU_PTOSwicthState = Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x38E_Msg)) == CAN_SIG_NORMAL)
        {
            BMCU_Moto1_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault();
            BMCU_Moto2_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL)
        {
            MBMS_Soc = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18202922_Msg)) == CAN_SIG_NORMAL)
        {
            MBMS_TOTALWorkState = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState();
            MBMS_TOTALSigOn = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn();
            MBMS_TOTALSigAcc = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc();
            MBMS_TOTALSigCharge = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203020_Msg)) == CAN_SIG_NORMAL)
        {
            MBMS_StatSoc = Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL)
        {
            MBMS_StatBattChargeState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState();
            MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL)
        {
            MMCU_ErrorGrage = Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage();
            MMCU_ChgProtectState = Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState();
            MMCU_DCDCEnableState = Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState();
            MMCU_ParkingGearState = Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState();
            MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
            MMCU_LockMotoState = Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState();
            MMCU_EBSState = Get_CAN_CH0_ID_125_Sig_MMCU_EBSState();
            MMCU_TravelSpeedGear = Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear();
            MMCU_PowerMode = Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode();
            MMCU_WorkState = Get_CAN_CH0_ID_125_Sig_MMCU_WorkState();
        }
        else
        {
            MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
            MMCU_PowerMode = POWER_CHECK_NULL;
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_SIG_NORMAL)
        {
            MMCU_AccumulatedWorkHours = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
            MMCU_SingleWorkingHours = Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL)
        {
            SBMS_Soc = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
        }
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x134_Msg)) == CAN_SIG_NORMAL)
        {
            SMCU_ErrorGrage = Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage();
        }
    #endif
    
}

uint8_t Get_CAN_Num_BMCU_ErrorGrage(void)
{
    return BMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_BMCU_BladeSpeedGear(void)
{
    return BMCU_BladeSpeedGear;
}
uint8_t Get_CAN_Num_BMCU_PTOSwicthState(void)
{
    return BMCU_PTOSwicthState;
}
uint8_t Get_CAN_Num_BMCU_Moto2_Locked_RotorFault(void)
{
    return BMCU_Moto2_Locked_RotorFault;
}
uint8_t Get_CAN_Num_BMCU_Moto1_Locked_RotorFault(void)
{
    return BMCU_Moto1_Locked_RotorFault;
}
uint8_t Get_CAN_Num_MBMS_Soc(void)
{
    return MBMS_Soc;
}
uint8_t Get_CAN_Num_MBMS_TOTALWorkState(void)
{
    return MBMS_TOTALWorkState;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigOn(void)
{
    return MBMS_TOTALSigOn;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigAcc(void)
{
    return MBMS_TOTALSigAcc;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigCharge(void)
{
    return MBMS_TOTALSigCharge;
}
uint8_t Get_CAN_Num_MBMS_StatSoc(void)
{
    return MBMS_StatSoc;
}
uint8_t Get_CAN_Num_MBMS_StatBattChargeState(void)
{
    return MBMS_StatBattChargeState;
}
uint8_t Get_CAN_Num_MBMS_StatBattWorkState(void)
{
    return MBMS_StatBattWorkState;
}
uint8_t Get_CAN_Num_MMCU_ErrorGrage(void)
{
    return MMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_MMCU_ChgProtectState(void)
{
    return MMCU_ChgProtectState;
}
uint8_t Get_CAN_Num_MMCU_DCDCEnableState(void)
{
    return MMCU_DCDCEnableState;
}
uint8_t Get_CAN_Num_MMCU_ParkingGearState(void)
{
    return MMCU_ParkingGearState;
}
uint8_t Get_CAN_Num_MMCU_SeatDetectState(void)
{
    return MMCU_SeatDetectState;
}
uint8_t Get_CAN_Num_MMCU_LockMotoState(void)
{
    return MMCU_LockMotoState;
}
uint8_t Get_CAN_Num_MMCU_EBSState(void)
{
    return MMCU_EBSState;
}
uint8_t Get_CAN_Num_MMCU_TravelSpeedGear(void)
{
    return MMCU_TravelSpeedGear;
}
uint8_t Get_CAN_Num_MMCU_PowerMode(void)
{
    return MMCU_PowerMode;
}
uint8_t Get_CAN_Num_MMCU_WorkState(void)
{
    return MMCU_WorkState;
}
uint16_t Get_CAN_Num_MMCU_AccumulatedWorkHours(void)
{
    return MMCU_AccumulatedWorkHours;
}
uint8_t Get_CAN_Num_MMCU_SingleWorkingHours(void)
{
    return MMCU_SingleWorkingHours;
}
uint8_t Get_CAN_Num_SBMS_Soc(void)
{
    return SBMS_Soc;
}
uint8_t Get_CAN_Num_SMCU_ErrorGrage(void)
{
    return SMCU_ErrorGrage;
}


uint8_t g_powerState = 0U;

uint8_t Get_CAN_Power_State(void)
{
    uint8_t state = 0;
    uint8_t Power_State = Get_CAN_Num_MMCU_PowerMode();

    #if (PART_NUMBER == RMR42E_60)
        if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
        {
            switch (Power_State)
            {
            case 0x0:
                state = KEY_OFF;
                break;
            case 0x1:
                state = PKEY_ON;
                break;
            case 0x2:
                state = KEY_ACC;
                break;
            case 0x3:
                state = READY;
                break;
            case 0x4:
                state = CHRG_PLUGIN;
                break;
            case 0x5:
                state = CHRGING;
                break;
            case 0x6:
                state = CHRGEND;
                break;
            default:
                state = POWER_CHECK_NULL;
                break;
            }
        }
        else 
        {
            state = POWER_CHECK_NULL;
        }
    #else
        switch(g_powerState)
        {
        case 0:
            state = KEY_OFF;
            break;
        case 1:
            state = PKEY_ON;
            break;
        case 2:
            state = KEY_ACC;
            break;
        default:
            state = KEY_OFF;
            break;
        }
    #endif
    return state;
}

void CAN_0x18E_Receive(uint8_t CopyData [])
{
    if((Fuel.FuelSeg != Fuel.FuelSegDis) && (Fuel.FuelStatusCount >= 3U))
    {
        Fuel.FuelSegDis = Fuel.FuelSeg;
        Fuel.FuelStatusCount = 0U;
    }
    else if((Fuel.FuelSeg != Fuel.FuelSegDis) && (Fuel.FuelStatusCount < 3U))
    {
        Fuel.FuelStatusCount ++;
    }
    else 
    {
        Fuel.FuelStatusCount = 0U;
    }
}

void CAN_0x225_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)
        if ((Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3() == 1U) && (g_EngineMalfunctionStatus == 0U))
        {
            g_u8EmsFltLv3Count++;
        }
        else if ((Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3() == 0U) && (g_EngineMalfunctionStatus == 1U))
        {
            g_u8EmsFltLv3Count++;
        }
        else 
        {
            g_u8EmsFltLv3Count = 0U;
        }

        if ((Get_CAN_CH0_ID_225_Sig_VCU_VoltLow() == 1U) && (g_VoltLowStatus == 0U))
        {
            g_VoltLowCount++;
        }
        else if ((Get_CAN_CH0_ID_225_Sig_VCU_VoltLow() == 0U) && (g_VoltLowStatus == 1U))
        {
            g_VoltLowCount++;
        }
        else 
        {
            g_VoltLowCount = 0U;
        }

        uint8_t u8Signal[2] = {0,0};
        u8Signal[0] = Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv3();
        u8Signal[1] = Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv4();

        for(uint8_t i = 0U; i < 2U; i++)
        {
            if ((u8Signal[i] == 1U) && (g_BmsFltStatus[i] == 0U))
            {
                if (g_BmsFltCount[i] < 3U)
                {
                    g_BmsFltCount[i]++;
                }
            }
            else if ((u8Signal[i] == 0U) && (g_BmsFltStatus[i] == 1U))
            {
                if (g_BmsFltCount[i] < 3U)
                {
                    g_BmsFltCount[i]++;
                }
            }
            else 
            {
                g_BmsFltCount[i] = 0U;
            }
        }
        
    #endif
}

void CAN_0x234_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)
        if ((Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow() == 1U) && (g_EngineOilLowStatus == 0U))
        {
            g_EngineOilLowCount++;
        }
        else if ((Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow() == 0U) && (g_EngineOilLowStatus == 1U))
        {
            g_EngineOilLowCount++;
        }
        else 
        {
            g_EngineOilLowCount = 0U;
        }
    #endif
}

void CAN_0x38E_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)

        uint8_t u8Signal[9] = {0,0,0,0,0,0,0,0,0};
        u8Signal[0] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault();
        u8Signal[1] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault();
        u8Signal[2] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_Locked_RotorFault();
        u8Signal[3] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_SoftOverCurrentFault();
        u8Signal[4] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_SoftOverCurrentFault();
        u8Signal[5] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_SoftOverCurrentFault();
        u8Signal[6] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1HWOverCurrentFault();
        u8Signal[7] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2HWOverCurrentFault();
        u8Signal[8] = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3HWOverCurrentFault();

        for(uint8_t i = 0U; i < 9U; i++)
        {
            if ((u8Signal[i] == 1U) && (g_OverLoadStatus[i] == 0U))
            {
                if (g_OverLoadCount[i] < 3U)
                {
                    g_OverLoadCount[i]++;
                }
            }
            else if ((u8Signal[i] == 0U) && (g_OverLoadStatus[i] == 1U))
            {
                if (g_OverLoadCount[i] < 3U)
                {
                    g_OverLoadCount[i]++;
                }
            }
            else 
            {
                g_OverLoadCount[i] = 0U;
            }
        }

    #endif
}

void CAN_0x220_Receive(uint8_t CopyData [])
{
    System_Indicator_CANFlag = 0;

    #if (PART_NUMBER == G54_A01)
        if ((Get_CAN_CH0_ID_220_Sig_VCU_GrassSwSts() == 1U) && (g_GrassSwStatus == 0U))
        {
            if (g_GrassSwCount < 3U)
            {
                g_GrassSwCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_GrassSwSts() == 0U) && (g_GrassSwStatus == 1U))
        {
            if (g_GrassSwCount < 3U)
            {
                g_GrassSwCount++;
            }
        }
        else 
        {
            g_GrassSwCount = 0U;
        }

        if ((Get_CAN_CH0_ID_220_Sig_VCU_SeatSts() == 1U) && (g_SeatStatus == 0U))
        {
            if (g_SeatCount < 3U)
            {
                g_SeatCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_SeatSts() == 0U) && (g_SeatStatus == 1U))
        {
            if (g_SeatCount < 3U)
            {
                g_SeatCount++;
            }
        }
        else 
        {
            g_SeatCount = 0U;
        }
        
        if ((Get_CAN_CH0_ID_220_Sig_VCU_KeySts() == 1U) && (g_KeyStatus == 0U))
        {
            if (g_KeyCount < 3U)
            {
                g_KeyCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_KeySts() == 0U) && (g_KeyStatus == 1U))
        {
            if (g_KeyCount < 3U)
            {
                g_KeyCount++;
            }
        }
        else 
        {
            g_KeyCount = 0U;
        }

        if ((Get_CAN_CH0_ID_220_Sig_VCU_ReadySts() == 1U) && (g_ReadyStatus == 0U))
        {
            if (g_ReadyCount < 3U)
            {
                g_ReadyCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_ReadySts() == 0U) && (g_ReadyStatus == 1U))
        {
            if (g_ReadyCount < 3U)
            {
                g_ReadyCount++;
            }
        }
        else 
        {
            g_ReadyCount = 0U;
        }

        if ((Get_CAN_CH0_ID_220_Sig_VCU_PtoSwSts() == 1U) && (g_PtoSwStatus == 0U))
        {
            if (g_PtoSwCount < 3U)
            {
                g_PtoSwCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_PtoSwSts() == 0U) && (g_PtoSwStatus == 1U))
        {
            if (g_PtoSwCount < 3U)
            {
                g_PtoSwCount++;
            }
        }
        else 
        {
            g_PtoSwCount = 0U;
        }

        if ((Get_CAN_CH0_ID_220_Sig_VCU_SysFltLamp() == 1U) && (g_SysFltLampStatus == 0U))
        {
            if (g_SysFltLampCount < 3U)
            {
                g_SysFltLampCount++;
            }
        }
        else if ((Get_CAN_CH0_ID_220_Sig_VCU_SysFltLamp() == 0U) && (g_SysFltLampStatus == 1U))
        {
            if (g_SysFltLampCount < 3U)
            {
                g_SysFltLampCount++;
            }
        }
        else 
        {
            g_SysFltLampCount = 0U;
        }
    #endif
}

void CAN_0x16B_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)
        uint8_t u8Signal = Get_CAN_CH0_ID_16B_Sig_MBMS_SafeBattWorkState();

        if ((u8Signal == 1U) && (g_ChgModeStatus != 1U))
        {
            if (g_ChgModeCount < 3U)
            {
                g_ChgModeCount++;
            }
            else
            {
                g_ChgModeStatus = 1U;
                g_ChgModeCount = 0U;
            }
        }
        else if ((u8Signal == 3U) && (g_ChgModeStatus != 2U))
        {
            if (g_ChgModeCount < 3U)
            {
                g_ChgModeCount++;
            }
            else 
            {
                g_ChgModeStatus = 2U;
                g_ChgModeCount = 0U;
            }
        }
        else if ((u8Signal != 1U) && (u8Signal != 3U) && (g_ChgModeStatus != 0U))
        {
            if (g_ChgModeCount < 3U)
            {
                g_ChgModeCount++;
            }
            else
            {
                g_ChgModeStatus = 0U;
                g_ChgModeCount = 0U;
            }
        }
        else 
        {
            g_ChgModeCount = 0U;
        }
        

    #endif
}

void CAN_0x22F_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)
        uint8_t u8Signal = Get_CAN_CH0_ID_22F_Sig_EMS_WorkSts();

        if ((u8Signal == 2U) && (g_WorkStatus != 2U))
        {
            if (g_WorkCount < 3U)
            {
                g_WorkCount++;
            }
            else
            {
                g_WorkStatus = 2U;
                g_WorkCount = 0U;
            }
        }
        else if ((u8Signal == 3U) && (g_WorkStatus != 3U))
        {
            if (g_WorkCount < 3U)
            {
                g_WorkCount++;
            }
            else
            {
                g_WorkStatus = 3U;
                g_WorkCount = 0U;
            }
        }
        else if ((u8Signal == 4U) && (g_WorkStatus != 4U))
        {
            if (g_WorkCount < 3U)
            {
                g_WorkCount++;
            }
            else
            {
                g_WorkStatus = 4U;
                g_WorkCount = 0U;
            }
        }
        else if ((u8Signal != 2U) && (u8Signal != 3U) && (u8Signal != 4U) && (g_WorkStatus != 0U))
        {
            if (g_WorkCount < 3U)
            {
                g_WorkCount++;
            }
            else
            {
                g_WorkStatus = 0U;
                g_WorkCount = 0U;
            }
        }
        else 
        {
            g_WorkCount = 0U;
        }

    #endif
}

void CAN_0x170_Receive(uint8_t CopyData [])
{
    #if (PART_NUMBER == G54_A01)
        uint8_t u8Signal = Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigCharge();

        if ((u8Signal == 1U) && (g_TOTALSigChargeStatus == 0U))
        {
            g_TOTALSigChargeCount++;
        }
        else if ((u8Signal == 0U) && (g_TOTALSigChargeStatus == 1U))
        {
            g_TOTALSigChargeCount++;
        }
        else 
        {
            g_TOTALSigChargeCount = 0U;
        }

    #endif
}

void CAN_0x339_Receive(uint8_t CopyData [])
{
    g_u8ID339flag = 1U;
}
