

#include "System_Monitor.h"
#include <stdio.h>

typedef struct
{
    monitorlib_uint8_t  SumCnt;
    monitorlib_uint16_t DebounceTimer;
    monitorlib_uint32_t ActVoltage;
    monitorlib_uint8_t  FinalSts;
    monitorlib_uint8_t  ActSts;
} MonitorStruct;

MonitorStruct SysFun_KL30Monitor;
MonitorStruct SysFun_KL15Monitor;

MonitorStruct SysNM_KL30Monitor;
MonitorStruct SysNM_KL15Monitor;

#define Base_Vol           0u
#define ENTER_LOW_N_RANGE  6500U
#define EXIT_LOW_N_RANGE   7000U
#define ENTER_LOW_Y_RANGE  9000U
#define EXIT_LOW_Y_RANGE   9500U
#define EXIT_HIGH_Y_RANGE  17500U
#define ENTER_HIGH_Y_RANGE 18000U
#define EXIT_HIGH_N_RANGE  18500U
#define ENTER_HIGH_N_RANGE 19000U
#define Top_Vol            0xffffu

static monitorlib_uint8_t System_Calc_NMRange(monitorlib_uint16_t u16Vol);
static monitorlib_uint8_t System_Calc_FunRange(monitorlib_uint16_t u16Vol);

static void System_Fast_WakeUp(void);
static void System_Fun_Process(void);
static void System_NM_Process(void);

MonitorExt_st pfunction;

monitorlib_uint8_t SysWakeUpMode = 0u;
monitorlib_uint8_t SetVolFlag    = 0u;

monitorlib_uint16_t FUNSysVol_Range [ 10u ] = {
    Base_Vol,
    ENTER_LOW_N_RANGE,
    EXIT_LOW_N_RANGE,
    ENTER_LOW_Y_RANGE,
    EXIT_LOW_Y_RANGE,
    EXIT_HIGH_Y_RANGE,
    ENTER_HIGH_Y_RANGE,
    EXIT_HIGH_N_RANGE,
    ENTER_HIGH_N_RANGE,
    Top_Vol,
};

monitorlib_uint16_t NMSysVol_Range [ 10u ] = {
    Base_Vol,
    ENTER_LOW_N_RANGE,
    EXIT_LOW_N_RANGE,
    ENTER_LOW_Y_RANGE,
    EXIT_LOW_Y_RANGE,
    EXIT_HIGH_Y_RANGE,
    ENTER_HIGH_Y_RANGE,
    EXIT_HIGH_N_RANGE,
    ENTER_HIGH_N_RANGE,
    Top_Vol,
};

monitorlib_uint16_t t_FUN_KL30_Debounce;
monitorlib_uint16_t t_FUN_KL15_Debounce;
monitorlib_uint16_t t_NM_KL30_Debounce;
monitorlib_uint16_t t_NM_KL15_Debounce;
monitorlib_uint16_t t_NM_KL30_Debounce_Cancel;
monitorlib_uint16_t t_NM_KL15_Debounce_Cancel;
monitorlib_uint16_t t_FUN_KL30_Debounce_Cancel;
monitorlib_uint16_t t_FUN_KL15_Debounce_Cancel;

monitorlib_uint16_t t_NM_KL30_timer;
monitorlib_uint16_t t_FUN_KL30_timer;

monitorlib_uint8_t Read_KL30_ConvertFinish(void)
{
    return SysWakeUpMode;
}

static monitorlib_uint8_t System_Calc_FunRange(monitorlib_uint16_t u16Vol)
{
    monitorlib_uint8_t i;
    for ( i = 0u; i < (sizeof(FUNSysVol_Range) / sizeof(FUNSysVol_Range [ 0 ])); i++ )
    {
        if ( u16Vol < FUNSysVol_Range [ i ] )
        {
            break;
        }
    }
    return i;
}

static monitorlib_uint8_t System_Calc_NMRange(monitorlib_uint16_t u16Vol)
{
    monitorlib_uint8_t i;
    for ( i = 0u; i < (sizeof(NMSysVol_Range) / sizeof(NMSysVol_Range [ 0 ])); i++ )
    {
        if ( u16Vol < NMSysVol_Range [ i ] )
        {
            break;
        }
    }
    return i;
}

void Sys_Set_Pata(const monitorlib_uint16_t FUN_Vol [], MonitorExt_st *pfunc)
{
    FUNSysVol_Range [ 0 ] = FUN_Vol [ 0 ];
    FUNSysVol_Range [ 1 ] = FUN_Vol [ 1 ];
    FUNSysVol_Range [ 2 ] = FUN_Vol [ 2 ];
    FUNSysVol_Range [ 3 ] = FUN_Vol [ 3 ];
    FUNSysVol_Range [ 4 ] = FUN_Vol [ 4 ];
    FUNSysVol_Range [ 5 ] = FUN_Vol [ 5 ];
    FUNSysVol_Range [ 6 ] = FUN_Vol [ 6 ];
    FUNSysVol_Range [ 7 ] = FUN_Vol [ 7 ];
    FUNSysVol_Range [ 8 ] = FUN_Vol [ 8 ];
    FUNSysVol_Range [ 9 ] = FUN_Vol [ 9 ];

    t_FUN_KL30_Debounce = FUN_Vol [ 10 ];
    t_FUN_KL15_Debounce = FUN_Vol [ 11 ];

    NMSysVol_Range [ 0 ] = FUN_Vol [ 12 ];
    NMSysVol_Range [ 1 ] = FUN_Vol [ 13 ];
    NMSysVol_Range [ 2 ] = FUN_Vol [ 14 ];
    NMSysVol_Range [ 3 ] = FUN_Vol [ 15 ];
    NMSysVol_Range [ 4 ] = FUN_Vol [ 16 ];
    NMSysVol_Range [ 5 ] = FUN_Vol [ 17 ];
    NMSysVol_Range [ 6 ] = FUN_Vol [ 18 ];
    NMSysVol_Range [ 7 ] = FUN_Vol [ 19 ];
    NMSysVol_Range [ 8 ] = FUN_Vol [ 20 ];
    NMSysVol_Range [ 9 ] = FUN_Vol [ 21 ];

    t_NM_KL30_Debounce = FUN_Vol [ 22 ];
    t_NM_KL15_Debounce = FUN_Vol [ 23 ];

    t_NM_KL30_Debounce_Cancel  = FUN_Vol [ 24 ];
    t_FUN_KL30_Debounce_Cancel = FUN_Vol [ 25 ];

    pfunction.SysGet_KL30_Valid       = pfunc->SysGet_KL30_Valid;
    pfunction.SysGet_KL15_Valid       = pfunc->SysGet_KL15_Valid;
    pfunction.SysGet_KL30_value_Force = pfunc->SysGet_KL30_value_Force;
    pfunction.SysGet_KL15_value_Force = pfunc->SysGet_KL15_value_Force;
    pfunction.SysGet_KL30_value       = pfunc->SysGet_KL30_value;
    pfunction.SysGet_KL15_value       = pfunc->SysGet_KL15_value;
    pfunction.SysGet_KL15Line         = pfunc->SysGet_KL15Line;
    pfunction.COM_Delay               = pfunc->COM_Delay;
    pfunction.SysMonitorLogic         = pfunc->SysMonitorLogic;

    SetVolFlag = 0x55u;
}

void System_Monitor_KL30Init(void)
{
    SysWakeUpMode                    = 0u;
    SysFun_KL30Monitor.SumCnt        = 0u;
    SysFun_KL30Monitor.DebounceTimer = 0u;
    SysFun_KL30Monitor.ActVoltage    = 0u;
    SysFun_KL30Monitor.FinalSts      = 0u;
    SysFun_KL30Monitor.ActSts        = 0u;

    SysFun_KL15Monitor.SumCnt        = 0u;
    SysFun_KL15Monitor.DebounceTimer = 0u;
    SysFun_KL15Monitor.ActVoltage    = 0u;
    SysFun_KL15Monitor.FinalSts      = 0u;
    SysFun_KL15Monitor.ActSts        = 0u;

    SysNM_KL30Monitor.SumCnt        = 0u;
    SysNM_KL30Monitor.DebounceTimer = 0u;
    SysNM_KL30Monitor.ActVoltage    = 0u;
    SysNM_KL30Monitor.FinalSts      = 0u;
    SysNM_KL30Monitor.ActSts        = 0u;

    SysNM_KL15Monitor.SumCnt        = 0u;
    SysNM_KL15Monitor.DebounceTimer = 0u;
    SysNM_KL15Monitor.ActVoltage    = 0u;
    SysNM_KL15Monitor.FinalSts      = 0u;
    SysNM_KL15Monitor.ActSts        = 0u;

    if ( SetVolFlag != 0x55u )
    {
        t_NM_KL30_Debounce  = 1000u;
        t_NM_KL15_Debounce  = 2u;
        t_FUN_KL30_Debounce = 1000u;
        t_FUN_KL15_Debounce = 2u;

        t_NM_KL30_Debounce_Cancel  = 1000U;
        t_NM_KL15_Debounce_Cancel  = 2U;
        t_FUN_KL30_Debounce_Cancel = 1000U;
        t_FUN_KL15_Debounce_Cancel = 2U;

        FUNSysVol_Range [ 0 ] = Base_Vol;
        FUNSysVol_Range [ 1 ] = ENTER_LOW_N_RANGE;
        FUNSysVol_Range [ 2 ] = EXIT_LOW_N_RANGE;
        FUNSysVol_Range [ 3 ] = ENTER_LOW_Y_RANGE;
        FUNSysVol_Range [ 4 ] = EXIT_LOW_Y_RANGE;
        FUNSysVol_Range [ 5 ] = EXIT_HIGH_Y_RANGE;
        FUNSysVol_Range [ 6 ] = ENTER_HIGH_Y_RANGE;
        FUNSysVol_Range [ 7 ] = EXIT_HIGH_N_RANGE;
        FUNSysVol_Range [ 8 ] = ENTER_HIGH_N_RANGE;
        FUNSysVol_Range [ 9 ] = Top_Vol;

        NMSysVol_Range [ 0 ] = Base_Vol;
        NMSysVol_Range [ 1 ] = ENTER_LOW_N_RANGE;
        NMSysVol_Range [ 2 ] = EXIT_LOW_N_RANGE;
        NMSysVol_Range [ 3 ] = ENTER_LOW_Y_RANGE;
        NMSysVol_Range [ 4 ] = EXIT_LOW_Y_RANGE;
        NMSysVol_Range [ 5 ] = EXIT_HIGH_Y_RANGE;
        NMSysVol_Range [ 6 ] = ENTER_HIGH_Y_RANGE;
        NMSysVol_Range [ 7 ] = EXIT_HIGH_N_RANGE;
        NMSysVol_Range [ 8 ] = ENTER_HIGH_N_RANGE;
        NMSysVol_Range [ 9 ] = Top_Vol;
        SetVolFlag           = 0x55u;
    }
    if ( pfunction.COM_Delay != (( void * )0) )
    {
        pfunction.COM_Delay(260U);
    }
    System_Fast_WakeUp( );
}

void System_Monitor_WakeupInit(void)
{
    SysWakeUpMode                    = 0u;
    SysFun_KL30Monitor.SumCnt        = 0u;
    SysFun_KL30Monitor.DebounceTimer = 0u;
    SysFun_KL30Monitor.ActVoltage    = 0u;
    SysFun_KL30Monitor.FinalSts      = 0u;
    SysFun_KL30Monitor.ActSts        = 0u;

    SysFun_KL15Monitor.SumCnt        = 0u;
    SysFun_KL15Monitor.DebounceTimer = 0u;
    SysFun_KL15Monitor.ActVoltage    = 0u;
    SysFun_KL15Monitor.FinalSts      = 0u;
    SysFun_KL15Monitor.ActSts        = 0u;

    SysNM_KL30Monitor.SumCnt        = 0u;
    SysNM_KL30Monitor.DebounceTimer = 0u;
    SysNM_KL30Monitor.ActVoltage    = 0u;
    SysNM_KL30Monitor.FinalSts      = 0u;
    SysNM_KL30Monitor.ActSts        = 0u;

    SysNM_KL15Monitor.SumCnt        = 0u;
    SysNM_KL15Monitor.DebounceTimer = 0u;
    SysNM_KL15Monitor.ActVoltage    = 0u;
    SysNM_KL15Monitor.FinalSts      = 0u;
    SysNM_KL15Monitor.ActSts        = 0u;

    if ( SetVolFlag != 0x55u )
    {
        t_NM_KL30_Debounce  = 1000u;
        t_NM_KL15_Debounce  = 2u;
        t_FUN_KL30_Debounce = 1000u;
        t_FUN_KL15_Debounce = 2u;

        t_NM_KL30_Debounce_Cancel  = 1000U;
        t_NM_KL15_Debounce_Cancel  = 2U;
        t_FUN_KL30_Debounce_Cancel = 1000U;
        t_FUN_KL15_Debounce_Cancel = 2U;
        FUNSysVol_Range [ 0 ]      = Base_Vol;
        FUNSysVol_Range [ 1 ]      = ENTER_LOW_N_RANGE;
        FUNSysVol_Range [ 2 ]      = EXIT_LOW_N_RANGE;
        FUNSysVol_Range [ 3 ]      = ENTER_LOW_Y_RANGE;
        FUNSysVol_Range [ 4 ]      = EXIT_LOW_Y_RANGE;
        FUNSysVol_Range [ 5 ]      = EXIT_HIGH_Y_RANGE;
        FUNSysVol_Range [ 6 ]      = ENTER_HIGH_Y_RANGE;
        FUNSysVol_Range [ 7 ]      = EXIT_HIGH_N_RANGE;
        FUNSysVol_Range [ 8 ]      = ENTER_HIGH_N_RANGE;
        FUNSysVol_Range [ 9 ]      = Top_Vol;

        NMSysVol_Range [ 0 ] = Base_Vol;
        NMSysVol_Range [ 1 ] = ENTER_LOW_N_RANGE;
        NMSysVol_Range [ 2 ] = EXIT_LOW_N_RANGE;
        NMSysVol_Range [ 3 ] = ENTER_LOW_Y_RANGE;
        NMSysVol_Range [ 4 ] = EXIT_LOW_Y_RANGE;
        NMSysVol_Range [ 5 ] = EXIT_HIGH_Y_RANGE;
        NMSysVol_Range [ 6 ] = ENTER_HIGH_Y_RANGE;
        NMSysVol_Range [ 7 ] = EXIT_HIGH_N_RANGE;
        NMSysVol_Range [ 8 ] = ENTER_HIGH_N_RANGE;
        NMSysVol_Range [ 9 ] = Top_Vol;
        SetVolFlag           = 0x55u;
    }
    System_Fast_WakeUp( );
}

void Sys_Status_Update_Service(void)
{
    System_Fun_Process( );
    System_NM_Process( );
    if ( pfunction.SysMonitorLogic != (( void * )0) )
    {
        pfunction.SysMonitorLogic( );
    }
}

static void System_Fast_WakeUp(void)
{
    monitorlib_uint16_t KL30_Voltage;
    monitorlib_uint16_t KL15_Voltage;
    monitorlib_uint16_t Voltage;
    monitorlib_uint8_t  NormalKL30Cnt   = 0U;
    monitorlib_uint8_t  abnormalKL30Cnt = 0U;
    monitorlib_uint8_t  AttemptCnt      = 0U;

    AttemptCnt = 0u;
    while ( SysNM_KL30Monitor.FinalSts == 0u )
    {
        if ( pfunction.COM_Delay != (( void * )0) )
        {
            pfunction.COM_Delay(2U);
        }
        /*KL30 KL15 voltage */
        if ( pfunction.SysGet_KL30_value_Force != ( void * )0 )
        {
            KL30_Voltage = pfunction.SysGet_KL30_value_Force( );
        }
        else
        {
            KL30_Voltage = 0u;
        }
        if ( pfunction.SysGet_KL15_value_Force != ( void * )0 )
        {
            KL15_Voltage = pfunction.SysGet_KL15_value_Force( );
        }
        else
        {
            KL15_Voltage = 0u;
        }
        if ( KL30_Voltage > KL15_Voltage )
        {
            Voltage = KL30_Voltage;
        }
        else
        {
            Voltage = KL15_Voltage;
        }

        if ( (Voltage <= NMSysVol_Range [ 2 ]) || (Voltage >= NMSysVol_Range [ 7 ]) )
        {
            NormalKL30Cnt = 0U;
            abnormalKL30Cnt++;
        }
        else
        {
            NormalKL30Cnt++;
            abnormalKL30Cnt = 0U;
        }
        AttemptCnt++;
        if ( AttemptCnt >= 10u )
        {
            break;
        }
        if ( NormalKL30Cnt >= 5U )
        {
            SysNM_KL30Monitor.FinalSts = 5u;
        }
        if ( abnormalKL30Cnt >= 5U )
        {
            SysNM_KL30Monitor.FinalSts = 9u;
        }
    }

    if ( (SysNM_KL30Monitor.FinalSts != 0u) )
    {

        SysWakeUpMode = 0x55U;
        if ( pfunction.SysGet_KL15Line != (( void * )0) )
        {
            SysNM_KL15Monitor.FinalSts = pfunction.SysGet_KL15Line( );
            SysNM_KL15Monitor.ActSts   = pfunction.SysGet_KL15Line( );

        }
        else
        {
            SysNM_KL15Monitor.FinalSts = 0u;
            SysNM_KL15Monitor.ActSts   = 0u;
        }


        if ( pfunction.SysMonitorLogic != ( void * )0 )
        {
            pfunction.SysMonitorLogic( );
        }
    }
}

static void System_NM_Process(void)
{
    monitorlib_uint8_t         m8;
    static monitorlib_uint16_t DebpounceTimer;
    monitorlib_uint16_t        Voltage;
    monitorlib_uint8_t         VoltageKL30Valid;
    monitorlib_uint8_t         VoltageKL15Valid;
    monitorlib_uint16_t        Voltage_KL15;
    monitorlib_uint16_t        Voltage_KL30;

    if ( pfunction.SysGet_KL15Line != (( void * )0) )
    {
        if ( SysNM_KL15Monitor.ActSts == pfunction.SysGet_KL15Line( ) )
        {
            if ( SysNM_KL15Monitor.DebounceTimer < t_NM_KL15_Debounce )
            {
                SysNM_KL15Monitor.DebounceTimer++;
            }
            else
            {
                SysNM_KL15Monitor.FinalSts = SysNM_KL15Monitor.ActSts;
            }
        }
        else
        {
            SysNM_KL15Monitor.DebounceTimer = 0u;
            SysNM_KL15Monitor.ActSts        = pfunction.SysGet_KL15Line( );
        }
    }
    else
    {
        SysNM_KL15Monitor.FinalSts      = 0u;
        SysNM_KL15Monitor.ActSts        = 0u;
        SysNM_KL15Monitor.DebounceTimer = 0u;
    }

    if ( pfunction.SysGet_KL30_Valid != ( void * )0 )
    {
        VoltageKL30Valid = pfunction.SysGet_KL30_Valid( );
    }
    else
    {
        VoltageKL30Valid = 0u;
    }

    if ( pfunction.SysGet_KL15_Valid != ( void * )0 )
    {
        VoltageKL15Valid = pfunction.SysGet_KL15_Valid( );
    }
    else
    {
        VoltageKL15Valid = 0u;
    }

    if ( (VoltageKL30Valid == 1U) && (VoltageKL15Valid == 1U) )
    {
        if ( pfunction.SysGet_KL15_value != (( void * )0) )
        {
            Voltage_KL15 = pfunction.SysGet_KL15_value( );
        }
        else
        {
            Voltage_KL15 = 0u;
        }

        if ( pfunction.SysGet_KL15_value != (( void * )0) )
        {
            Voltage_KL30 = pfunction.SysGet_KL30_value( );
        }
        else
        {
            Voltage_KL30 = 0u;
        }

        if ( Voltage_KL30 > Voltage_KL15 )
        {
            Voltage = Voltage_KL30;
        }
        else
        {
            Voltage = Voltage_KL15;
        }
        if ( SysNM_KL30Monitor.SumCnt < 50u )
        {
            SysNM_KL30Monitor.ActVoltage += Voltage;
            SysNM_KL30Monitor.SumCnt += 1u;
            Voltage = ( monitorlib_uint16_t )(SysNM_KL30Monitor.ActVoltage / SysNM_KL30Monitor.SumCnt);
        }
        else
        {
            SysNM_KL30Monitor.SumCnt     = 0u;
            SysNM_KL30Monitor.ActVoltage = 0u;
            SysNM_KL30Monitor.ActVoltage += Voltage;
            SysNM_KL30Monitor.SumCnt += 1u;
            Voltage = ( monitorlib_uint16_t )(SysNM_KL30Monitor.ActVoltage / SysNM_KL30Monitor.SumCnt);
        }

        m8 = System_Calc_NMRange(Voltage);
        if ( SysNM_KL30Monitor.ActSts == m8 )
        {
            switch ( SysNM_KL30Monitor.FinalSts )
            {
                case 0:
                case 1:
                case 9:
                    t_NM_KL30_timer = t_NM_KL30_Debounce_Cancel;
                    break;

                default:
                    t_NM_KL30_timer = t_NM_KL30_Debounce;
                    break;
            }
            if ( SysNM_KL30Monitor.DebounceTimer < t_NM_KL30_timer ) /*40202-8*/
            {
                SysNM_KL30Monitor.DebounceTimer++;
            }
            else
            {
                DebpounceTimer = 0u;
                if ( SysNM_KL30Monitor.FinalSts == 9u ) /* 高压 */
                {
                    if ( (m8 == 9u) || (m8 == 8u) )
                    {
                        SysNM_KL30Monitor.FinalSts = 9u; /** 维持不变 **/
                    }
                    else
                    {
                        SysNM_KL30Monitor.FinalSts = m8; /**退�?*/
                    }
                }
                if ( SysNM_KL30Monitor.FinalSts == 1u ) /* 低压 */
                {
                    if ( (m8 == 1u) || (m8 == 2u) )
                    {
                        SysNM_KL30Monitor.FinalSts = 1u; /** 维持不变 */
                    }
                    else
                    {
                        SysNM_KL30Monitor.FinalSts = m8; /**退�?*/
                    }
                }
                /* 非高低压 */
                if ( (SysNM_KL30Monitor.FinalSts != 1u) && (SysNM_KL30Monitor.FinalSts != 9u) )
                {
                    SysNM_KL30Monitor.FinalSts = m8; /** 进入*/
                }
            }
        }
        else
        {
            /* 计时时间清除 */
            SysNM_KL30Monitor.DebounceTimer = 0U;
            DebpounceTimer++;
            if ( DebpounceTimer >= 5u )
            {
                DebpounceTimer           = 0u;
                SysNM_KL30Monitor.ActSts = m8;
            }
        }
    }
}

static void System_Fun_Process(void)
{
    monitorlib_uint8_t         m8;
    monitorlib_uint8_t         VoltageKL30Valid;
    monitorlib_uint8_t         VoltageKL15Valid;
    monitorlib_uint16_t        Voltage;
    monitorlib_uint16_t        Voltage_KL15;
    monitorlib_uint16_t        Voltage_KL30;
    static monitorlib_uint16_t DebpounceTimer;

    if ( pfunction.SysGet_KL15Line != (( void * )0) )
    {
        if ( SysFun_KL15Monitor.ActSts == pfunction.SysGet_KL15Line( ) )
        {
            if ( SysFun_KL15Monitor.DebounceTimer < t_FUN_KL15_Debounce )
            {
                SysFun_KL15Monitor.DebounceTimer++;
            }
            else
            {
                SysFun_KL15Monitor.FinalSts = SysFun_KL15Monitor.ActSts;
            }
            if(SysFun_KL15Monitor.ActSts)
            {
                SysFun_KL15Monitor.FinalSts = SysFun_KL15Monitor.ActSts;
            }
        }
        else
        {
            SysFun_KL15Monitor.DebounceTimer = 0u;
            SysFun_KL15Monitor.ActSts        = pfunction.SysGet_KL15Line( );
        }
    }
    else
    {
        SysFun_KL15Monitor.DebounceTimer = 0u;
        SysFun_KL15Monitor.FinalSts      = 0u;
        SysFun_KL15Monitor.ActSts        = 0u;
    }

    if ( pfunction.SysGet_KL30_Valid != (( void * )0) )
    {
        VoltageKL30Valid = pfunction.SysGet_KL30_Valid( );
    }else
    {
        VoltageKL30Valid = 0u;
    }
    
    if ( pfunction.SysGet_KL15_Valid != (( void * )0) )
    {
        VoltageKL15Valid = pfunction.SysGet_KL15_Valid( );
    }else
    {
        VoltageKL15Valid = 0u;
    }
    

    if ( (VoltageKL30Valid == 1U) && (VoltageKL15Valid == 1U) )
    {
        if ( pfunction.SysGet_KL15_value != (( void * )0) )
        {
            Voltage_KL15 = pfunction.SysGet_KL15_value( );
        }
        else
        {
            Voltage_KL15 = 0u;
        }

        if ( pfunction.SysGet_KL30_value != (( void * )0) )
        {
            Voltage_KL30 = pfunction.SysGet_KL30_value( );
        }
        else
        {
            Voltage_KL30 = 0u;
        }

        if ( Voltage_KL30 > Voltage_KL15 )
        {
            Voltage = Voltage_KL30;
        }
        else
        {
            Voltage = Voltage_KL15;
        }
        if ( SysFun_KL30Monitor.SumCnt < 50u )
        {
            SysFun_KL30Monitor.ActVoltage += Voltage;
            SysFun_KL30Monitor.SumCnt += 1u;
            Voltage = ( monitorlib_uint16_t )(SysFun_KL30Monitor.ActVoltage / SysFun_KL30Monitor.SumCnt);
        }
        else
        {
            SysFun_KL30Monitor.SumCnt     = 0u;
            SysFun_KL30Monitor.ActVoltage = 0u;
            SysFun_KL30Monitor.ActVoltage += Voltage;
            SysFun_KL30Monitor.SumCnt += 1u;
            Voltage = ( monitorlib_uint16_t )(SysFun_KL30Monitor.ActVoltage / SysFun_KL30Monitor.SumCnt);
        }
        
        m8 = System_Calc_FunRange(Voltage);


        // //printf("1 is %d, 2 is %d\r\n", m8, SysFun_KL30Monitor.FinalSts);

        if ( SysFun_KL30Monitor.ActSts == m8 )
        {
            DebpounceTimer = 0u;
            switch ( SysFun_KL30Monitor.FinalSts )
            {
                case 0:
                case 1:
                case 9:
                    t_FUN_KL30_timer = t_FUN_KL30_Debounce_Cancel;
                    break;

                default:
                    t_FUN_KL30_timer = t_FUN_KL30_Debounce;
                    break;
            }
            /* 计时�?计时�?1000*2ms */
            if ( SysFun_KL30Monitor.DebounceTimer < t_FUN_KL30_timer ) /*40202-8*/
            {
                SysFun_KL30Monitor.DebounceTimer++;
            }
            else
            {
                if ( SysFun_KL30Monitor.FinalSts > 7u ) /* 高压 */
                {
                    if ( (m8 == 9u) || (m8 == 8u) || (m8 == 7u) )
                    {
                        SysFun_KL30Monitor.FinalSts = 9u;
                        SysFun_KL15Monitor.FinalSts = 0u;
                    }
                    else
                    {
                        SysFun_KL30Monitor.FinalSts = m8;
                    }
                }
                if ( SysFun_KL30Monitor.FinalSts == 1u ) /* 低压 */
                {
                    if ( (m8 == 1u) || (m8 == 2u) )
                    {
                        SysFun_KL30Monitor.FinalSts = 1u;
                        SysFun_KL15Monitor.FinalSts = 0u;
                    }
                    else
                    {
                        SysFun_KL30Monitor.FinalSts = m8;
                    }
                }
                /* 非高低压 */
                if ( (SysFun_KL30Monitor.FinalSts != 1u) && (SysFun_KL30Monitor.FinalSts <= 7u) )
                {
                    SysFun_KL30Monitor.FinalSts = m8;
                }
            }
        }
        else
        {
            /* 计时时间清除 */
            SysFun_KL30Monitor.DebounceTimer = 0U;
            DebpounceTimer++;
            if ( DebpounceTimer >= 5u )
            {
                DebpounceTimer            = 0u;
                SysFun_KL30Monitor.ActSts = m8;
            }
        }
    }
    /*
    else
    {
        SysFun_KL30Monitor.FinalSts = 1u;
        SysFun_KL15Monitor.FinalSts = 0u;
    }*/
}

monitorlib_uint8_t System_NM_KL30_Status_Get(void)
{
    return SysNM_KL30Monitor.FinalSts;
}
monitorlib_uint8_t System_NM_KL15_Status_Get(void)
{
    return SysNM_KL15Monitor.FinalSts;
}

monitorlib_uint8_t System_FUN_KL30_Status_Get(void)
{
    return SysFun_KL30Monitor.FinalSts;
}
monitorlib_uint8_t System_FUN_KL15_Status_Get(void)
{
    return SysFun_KL15Monitor.FinalSts;
}
monitorlib_uint16_t Get_Sysmonitor_Version(void)
{
    return 0x0002u;
}
