#ifndef  FAULT_CODE_H__
#define  FAULT_CODE_H__

#include "Application.h"
#include "Components.h"

#define     MAX_CODE_NUM             7U
#define     CODE_DISPLAY_TIME        2000U

typedef struct //__attribute__((aligned(4))) 
{
    uint16_t  FaultCodeArr[MAX_CODE_NUM];           //故障码列表
    uint16_t  FaultCodeDis;                         //当前显示故障
    uint16_t  DisTimeCount;                         /*故障码显示计时*/
    uint8_t   FaultCodeValid;                       /*故障码有效状态*/ 
    uint8_t   FaultCodeValidHistory;                /*故障码有效状态*/ 
    
}FaultCodeStruct_st_t;


extern void Fault_Code_KL30_Init(void);
extern void Fault_Code_KL15_Init(void);
extern void Fault_Code_Service(void);
extern void Fault_Code_Display_Queue(uint8_t TaskTime);

extern uint16_t Get_FaultCode_Value(void);
extern uint8_t Get_FaultCode_Valid(void);


#endif
