#include "Components.h"
#include "Buzzer\Buzzer.h"

uint8_t BUZZER_ON = 0;
uint16_t Buzzer_time = 0;

void Buzzer_KL30_Init(void)
{

}

void Buzzer_KL15_Init(void)
{

}

void BUZZER_Init(void)
{
    Buzzer_time = 0;
    BUZZER_ON = 0;
    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
}

void Buzzer_Service(void)
{

    if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
    {
        if (g_u8TYWClearEepromFlag >= 1)
        {
            ;
        }
        else
        {
            BUZZER_Init();
        }
    }
    else if (Get_CAN_Power_State() == PKEY_ON)
    {
        if (Buzzer_time == 0)
        {
            ;
        }

        if (FLASH_SYNC_05Hz)
        {
            if (Buzzer_time <= 6000)
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_HIGH); // OUT_EN_1
                BUZZER_ON = 1;
            }
            else
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
                BUZZER_ON = 0;
            }
        }
        else
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
            BUZZER_ON = 0;
        }
        if (Buzzer_time < 0xFFFF)
        {
            Buzzer_time++;
        }
    }
    else 
    {
        BUZZER_Init();
    }


}

/******************************************************************************
函数名：Get_Buzzer_Status
功  能：获取显示燃油格数函数
参  数：无
返回值：Fuel.FuelSeg 显示的电量值 x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Buzzer_Status(void)
{
    return 0;
}


