#include "Components.h"
#include "Buzzer\Buzzer.h"

uint8_t BUZZER_ON = 0;
uint16_t Buzzer_time = 0;
uint8_t BuzzerReadyCount = 0U;

void Buzzer_KL30_Init(void)
{
    BUZZER_ON = 0;
    Buzzer_time = 0;
    BuzzerReadyCount = 0U;

}

void Buzzer_KL15_Init(void)
{

}

void BUZZER_Init(void)
{
    #if (PART_NUMBER == RMR42E_60)
        Buzzer_time = 0;
        BUZZER_ON = 0;
        RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
    #endif
}

void Buzzer_Service(void)
{
    #if (PART_NUMBER == RMR42E_60)
        if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
        {
            if (g_u8TYWClearEepromFlag >= 1)
            {
                ;
            }
            else
            {
                BUZZER_Init();
            }
        }
        else if (Get_CAN_Power_State() == PKEY_ON)
        {
            if (Buzzer_time == 0)
            {
                ;
            }

            if (FLASH_SYNC_05Hz)
            {
                if (Buzzer_time <= 6000)
                {
                    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_HIGH); // OUT_EN_1
                    BUZZER_ON = 1;
                }
                else
                {
                    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
                    BUZZER_ON = 0;
                }
            }
            else
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
                BUZZER_ON = 0;
            }
            if (Buzzer_time < 0xFFFF)
            {
                Buzzer_time++;
            }
        }
        else 
        {
            BUZZER_Init();
        }
    #else
        if (Get_TelltalesLedSts(em_LED_Grass_Full_R) == 1U)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_HIGH);
            BUZZER_ON = 1U;
        }
        else if (Get_TelltalesLedSts(em_LED_READY_G) == 1U)
        {
            if (BuzzerReadyCount < 20U)
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_HIGH);
                BUZZER_ON = 1U;
                BuzzerReadyCount ++;
            }
            else
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW);
                BUZZER_ON = 0U;
            }
        }
        else
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW);
            BUZZER_ON = 0U;
            BuzzerReadyCount = 0U;
        }

    #endif

}

/******************************************************************************
函数名：Get_Buzzer_Status
功  能：获取显示燃油格数函数
参  数：无
返回值：Fuel.FuelSeg 显示的电量值 x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Buzzer_Status(void)
{
    return BUZZER_ON;
}


