#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "Application.h"
#define DISPLAY_OPEN ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
#define TYW_CLEAR_TIME_FLAG ()

uint16_t poweroff_time = 0;

uint8_t SOC_Count_Time = 0;
uint8_t BUZZER_ON = 0;
uint8_t Charge_OFF_Flag = 0;

void TYW_Clear_Eeprom_Service(void)
{
    uint8_t u8MBMS_StatBattChargeState = 0;
    uint8_t u8MBMS_StatBattWorkState = 0;
    uint8_t u8BMCU_BladeSpeedGear = 0;
    uint16_t u16MMCU_AccumulatedWorkHours = 0;
    if (Get_CAN_Power_State() == READY)
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_SIG_NORMAL))
        {
            u8MBMS_StatBattChargeState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState();
            u8MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
            u16MMCU_AccumulatedWorkHours = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
            u8BMCU_BladeSpeedGear = Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear();
            if ((u8MBMS_StatBattChargeState == 0x7) && (u8MBMS_StatBattWorkState == 0xf) && (u8BMCU_BladeSpeedGear == 0x7) && (u16MMCU_AccumulatedWorkHours >= 60000))
            {
                g_u8TYWClearEepromFlag = 1;
            }
            else
            {
                g_u8TYWClearEepromFlag = 0;
            }
        }
        else
        {
            g_u8TYWClearEepromFlag = 0;
        }
    }
    else
    {
        g_u8TYWClearEepromFlag = 0;
    }
}

void Gauge_Power_SOC_pull_Display(void)
{
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
    {
        uint8_t Current_1_Grid = Get_CAN_Num_MBMS_Soc_1_Grid();
        uint8_t Current_2_Grid = Get_CAN_Num_SBMS_Soc_2_Grid();
        SEG_SET_EleDial_1SOC(1, Current_1_Grid);
        SEG_SET_EleDial_2SOC(1, Current_2_Grid);
    }
    else
    {
        SEG_SET_EleDial_1SOC(0, 0);
        SEG_SET_EleDial_2SOC(0, 0);
    }
}

void Gauge_Cutterhead_Gear_Display(void)
{
    uint8_t Signal1 = Get_CAN_Num_BMCU_BladeSpeedGear();
    uint8_t Signal2 = Get_CAN_Num_BMCU_ErrorGrage();
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (System_Indicator_CANFlag != 1))
    {
        if ((Signal2 == 0x1) || (Signal2 == 0x2) || (Signal2 == 0x3) || (Signal2 == 0x4))
        {
            if (FLASH_SYNC_1Hz)
            {
                SEG_SET_Cutterhead(1, Signal1, 0);
            }
            else
            {
                SEG_SET_Cutterhead(1, 4, 0);
            }
        }
        else if (Signal2 == 0x0)
        {
            SEG_SET_Cutterhead(1, Signal1, 0);
        }
    }
    else
    {
        SEG_SET_Cutterhead(0, Signal1, 0);
    }
}

void Gauge_Gears_Display(void)
{
    uint8_t Signal1 = Get_CAN_Num_MMCU_TravelSpeedGear();
    uint8_t Signal2 = Get_CAN_Num_MMCU_ParkingGearState();
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (System_Indicator_CANFlag != 1))
    {
        if (Signal2 != 0x1)
        {
            if ((Signal1 == 0x1) || (Signal1 == 0x2))
            {
                SEG_SET_GEAR(1, Signal1, 0);
            }
            else
            {
                SEG_SET_GEAR(1, Gear_OFF, 0);
            }
        }
        else
        {
            SEG_SET_GEAR(1, Gear_P, 0);
        }
    }
    else
    {
        SEG_SET_GEAR(0, Signal1, 0);
    }
}

uint8_t Get_CAN_Num_MBMS_Soc_1_Grid(void)
{
    uint8_t num = 0;
    uint8_t Current_SOC_1_Num = Get_CAN_Num_MBMS_Soc();
    num = (Current_SOC_1_Num / 10);
    if ((Current_SOC_1_Num % 10) != 0)
    {
        num++;
    }
    if (num > 10)
    {
        num = 10;
    }
    return num;
}
uint8_t Get_CAN_Num_SBMS_Soc_2_Grid(void)
{
    uint8_t num = 0;
    uint8_t Current_SOC_2_Num = Get_CAN_Num_SBMS_Soc();
    num = (Current_SOC_2_Num / 10);
    if ((Current_SOC_2_Num % 10) != 0)
    {
        num++;
    }
    if (num > 10)
    {
        num = 10;
    }
    return num;
}
uint8_t SOC1_Count = 0;
uint8_t SOC2_Count = 0;
void Gauge_Power_SOC_CHAGING_Display(void)
{
    uint8_t MBMS_TOTALSigAcc = Get_CAN_Num_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_Num_MBMS_TOTALSigCharge();
    uint8_t MBMS_StatBattWorkState = Get_CAN_Num_MBMS_StatBattWorkState();
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
    {
        uint8_t Current_1_Grid = Get_CAN_Num_MBMS_Soc_1_Grid();
        uint8_t Current_2_Grid = Get_CAN_Num_SBMS_Soc_2_Grid();

        if (((MBMS_TOTALSigAcc == 0x1) && (MBMS_TOTALSigCharge == 0x1)) || ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1))) // 上电充电
        {
            if (MBMS_StatBattWorkState == 0x1) // 主电池
            {
                if (++SOC_Count_Time > 10)
                {
                    SOC_Count_Time = 0;

                    SEG_SET_EleDial_1SOC(1, SOC1_Count);
                    SOC1_Count++;
                    if (SOC1_Count > Current_1_Grid)
                    {
                        SOC1_Count = 0;
                    }
                }

                SEG_SET_EleDial_2SOC(1, Current_2_Grid);
            }
            else if (MBMS_StatBattWorkState == 0x4) // 副电池
            {
                if (++SOC_Count_Time > 10)
                {
                    SOC_Count_Time = 0;

                    SEG_SET_EleDial_2SOC(1, SOC2_Count);
                    SOC2_Count++;
                    if (SOC2_Count > Current_2_Grid)
                    {
                        SOC2_Count = 0;
                    }
                }

                SEG_SET_EleDial_1SOC(1, Current_1_Grid);
            }
            else if (MBMS_StatBattWorkState == 0x7) // 主副电池
            {
                if (++SOC_Count_Time > 10)
                {
                    SOC_Count_Time = 0;

                    SEG_SET_EleDial_1SOC(1, SOC1_Count);
                    SEG_SET_EleDial_2SOC(1, SOC2_Count);
                    SOC1_Count++;
                    SOC2_Count++;
                    if (Current_1_Grid > Current_2_Grid)
                    {
                        if (SOC2_Count > Current_2_Grid)
                        {
                            SOC2_Count--;
                            if (SOC1_Count > Current_1_Grid)
                            {
                                SOC1_Count = 0;
                                SOC2_Count = 0;
                            }
                        }
                    }
                    else
                    {
                        if (SOC1_Count > Current_1_Grid)
                        {
                            SOC1_Count--;
                            if (SOC2_Count > Current_2_Grid)
                            {
                                SOC1_Count = 0;
                                SOC2_Count = 0;
                            }
                        }
                    }
                }
            }
            else
            {
                SOC1_Count = 0;
                SOC2_Count = 0;
                SEG_SET_EleDial_1SOC(1, Current_1_Grid);
                SEG_SET_EleDial_2SOC(1, Current_2_Grid);
            }
        }
        if ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1)) // 下电充电
        {
            poweroff_time++;
        }
        else
        {
            poweroff_time = 0;
        }
    }
    else
    {
        SEG_SET_EleDial_1SOC(0, 0);
        SEG_SET_EleDial_2SOC(0, 0);
    }
}
uint8_t AllSOC_DIS = 0;
void Gauge_EleDial_AllSOC_Display(void)
{

    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
    {
        AllSOC_DIS = Get_CAN_Num_MBMS_StatSoc();
        if (AllSOC_DIS > 100)
        {
            AllSOC_DIS = 100;
        }
        SEG_SET_EleDial_AllSOC(1, AllSOC_DIS);
    }
    else
    {
        SEG_SET_EleDial_AllSOC(0, 0);
    }
}

uint8_t Get_EleDial_AllSOC_lenth(void)
{
    uint8_t num = 0;
    if (AllSOC_DIS > 99)
    {
        num = 2;
    }
    else if (AllSOC_DIS > 9)
    {
        num = 1;
    }
    return num;
}
uint8_t Clockonetime_flag = 0;
void Gauge_Clock_Display(void)
{
    uint32_t Clock_all = 0;
    if (DISPLAY_OPEN)
    {
        Clock_all = Get_CAN_Num_MMCU_SingleWorkingHours();
        uint8_t Clock_hours = Clock_all / 10;
        uint8_t Clock_min = (Clock_all % 10) * 6;
        SEG_SET_Clock(Clock_hours, Clock_min, FLASH_SYNC_1Hz, 1, 1);
        Clockonetime_flag = 1;
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
        Clockonetime_flag = 0;
    }
}
uint8_t Get_Clockonetime_lenth(void)
{
    return Clockonetime_flag;
}

uint32_t u32Data_read[1] = {0};
uint32_t CumulativeWorkHours_Writeback = 0;
uint32_t CumulativeWorkHours_readDiffer = 0;
uint8_t CumulativeWorkHours_MAX_flag = 0;
void Data_CumulativeWorkHours_EEPROM_Write(void)
{
    uint32_t CurrentData = 0;
    uint32_t u32Data[1] = {0};
    if (DISPLAY_OPEN)
    {
        CurrentData = Get_CAN_Num_MMCU_AccumulatedWorkHours();
        if (CumulativeWorkHours_MAX_flag == 0)
        {
            if (CurrentData > CumulativeWorkHours_Writeback)
            {
                CumulativeWorkHours_readDiffer = CurrentData - CumulativeWorkHours_Writeback;
                eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                u32Data[0] = u32Data_read[0] + CumulativeWorkHours_readDiffer;
                eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                CumulativeWorkHours_Writeback = CurrentData;
            }
            else if (CurrentData < CumulativeWorkHours_Writeback)
            {
                CumulativeWorkHours_readDiffer = CumulativeWorkHours_Writeback - CurrentData;
                eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                u32Data[0] = u32Data_read[0] - CumulativeWorkHours_readDiffer;
                eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                CumulativeWorkHours_Writeback = CurrentData;
            }
        }
        else
        {
            if (CumulativeWorkHours_Writeback != 0)
            {
                if (CurrentData < CumulativeWorkHours_Writeback)
                {
                    CumulativeWorkHours_readDiffer = CumulativeWorkHours_Writeback - CurrentData;
                    eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                    u32Data[0] = u32Data_read[0] - CumulativeWorkHours_readDiffer;
                    eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                }
                CumulativeWorkHours_Writeback = CurrentData;
            }
        }
    }
}

void Gauge_Clock_All_Display(void)
{
    uint32_t u32Data[1] = {0};
    eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
    if (u32Data_read[0] > 99999)
    {
        u32Data[0] = 99999;
        eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
        CumulativeWorkHours_MAX_flag = 1;
    }
    else
    {
        CumulativeWorkHours_MAX_flag = 0;
    }
    if (DISPLAY_OPEN)
    {
        SEG_SET_Clock_ALL(1, u32Data_read[0]);
    }
    else
    {
        SEG_SET_Clock_ALL(0, 0);
    }
}
uint8_t Get_Clock_All_lenth(void)
{
    uint8_t num = 0;
    if (u32Data_read[0] > 999)
    {
        num = 2;
    }
    else if (u32Data_read[0] > 9)
    {
        num = 1;
    }
    return num;
}
void Gauge_Frame_Display(void)
{
    if (DISPLAY_OPEN)
    {
        SEG_SET_Frame(1);
    }
    else
    {
        SEG_SET_Frame(0);
    }
}

void Clear_Bu98(void)
{
    uint8_t i = 0;
    for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}

void Gauge_Service(void)
{
    uint8_t i = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
        {
            if (g_u8TYWClearEepromFlag >= 1)
            {
                TYW_RESET_TIME();
            }
            else
            {
                TYW_Clear_Eeprom_Service();
                BUZZER_Init();
                interact_PWM_Low_Duty = 100;
                if (Common_GetIgnOnTime() > 1500)
                {
                    SOC_charge_seg_Flag = 0;
                    Checkself_Init();
                    Gauge_CAN_setup_Service();
                }
                else
                {
                    checkself_seg_Flag = 1;
                    if (Get_CAN_Power_State() == KEY_ACC)
                    {
                        interact_PWM_Low_Duty = 0;
                    }

                    Checkself_LED_Display();
                    // Checkself_SEG_Display();
                }
            }
        }
        else if (Get_CAN_Power_State() == PKEY_ON)
        {
            poweroff_time = 0;
            if (Buzzer_time == 0)
            {
                Clear_Bu98();
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
                Checkself_Init();
                // Gpio_Init(Gpio_Sleep_Init);
            }
            interact_PWM_Low_Duty = 50;
            if (FLASH_SYNC_05Hz)
            {
                if (Buzzer_time <= 6000)
                {
                    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_HIGH); // OUT_EN_1
                    BUZZER_ON = 1;
                }
                else
                {
                    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
                    BUZZER_ON = 0;
                }
            }
            else
            {
                RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
                BUZZER_ON = 0;
            }
            if (Buzzer_time < 0xFFFF)
            {
                Buzzer_time++;
            }
        }
    }
    else
    {
        BUZZER_Init();
        poweroff_time = 0;
        Clear_Bu98();
        interact_PWM_Low_Duty = 100;
        for (i = 0; i < LampCh0_MAX; i++)
        {
            LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
        }
            }
}

void Gauge_CAN_setup_Service(void)
{
    uint8_t state = Get_CAN_Power_State();
    Gauge_Clock_Display();
    Gauge_Clock_All_Display();
    Gauge_EleDial_AllSOC_Display();
    // SEG_SET_GEAR(1, 1);
    // SEG_SET_Cutterhead(1, 2);
    Gauge_Frame_Display();
    Gauge_Cutterhead_Gear_Display();
    Gauge_Gears_Display();
    uint8_t MBMS_TOTALSigAcc = Get_CAN_Num_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_Num_MBMS_TOTALSigCharge();
    switch (state)
    {
    case KEY_ACC:
    {
        poweroff_time = 0;
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 0;
        Gauge_Power_SOC_pull_Display();
    }
    break;
    case READY:
    {
        poweroff_time = 0;
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 30;
        Gauge_Power_SOC_pull_Display();
    }
    break;
    case CHRGING:
    {
        SOC_charge_seg_Flag = 1;
        if (poweroff_time < 3600)
        {
            Gauge_Power_SOC_CHAGING_Display();
            if ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1)) // 下电充电)
            {
                Charge_OFF_Flag = 1;
            }
            else
            {
                Charge_OFF_Flag = 0;
            }
        }
        else
        {
            Charge_OFF_Flag = 2;
            SEG_SET_EleDial_1SOC(0, 0);
            SEG_SET_EleDial_2SOC(0, 0);
            if ((MBMS_TOTALSigAcc == 0x1) && (MBMS_TOTALSigCharge == 0x1)) // 上电充电)
            {
                Charge_OFF_Flag = 0;
                poweroff_time = 0;
            }
        }
    }
    break;
    case CHRG_PLUGIN:
    case CHRGEND:
    {
        if ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1)) // 下电充电)
        {
            Charge_OFF_Flag = 1;
        }
        else if ((MBMS_TOTALSigAcc == 0x1) && (MBMS_TOTALSigCharge == 0x1))
        {
            Charge_OFF_Flag = 0;
        }
        Gauge_Power_SOC_pull_Display();
        SOC1_Count = 0;
        SOC2_Count = 0;
        poweroff_time = 0;
    }
    break;

    default:
        break;
    }
}

void Checkself_LED_Display(void)
{
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_ON);
    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);

    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_External_Discharge_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_ON);
    SEG_SET_LED_STS(SEG_LED_Recharge, 1);
    SEG_SET_LED_STS(SEG_LED_System_Light, 1);
    SEG_SET_LED_STS(SEG_LED_Chloramine, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 1);
    SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
    SEG_SET_LED_STS(SEG_LED_Key_Access, 1);
    SEG_SET_LED_STS(SEG_LED_Ready, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 1);
    // SEG_SET_LED_STS(SEG_LED_External_Discharge, 1);
    SEG_SET_LED_STS(SEG_LED_Distance_Light, 1);
    SEG_SET_LED_STS(SEG_LED_HHT_Charger, 1);
    SEG_SET_Frame(1);
}

void BUZZER_Init(void)
{
    Buzzer_time = 0;
    BUZZER_ON = 0;
    RTE_GPIO_Set_Level(RTE_GPIO_PORT04_PIN01, RTE_GPIO_LEVEL_LOW); // OUT_EN_1
}

void TYW_RESET_TIME(void)
{
    uint32_t Clear_EE[1] = {0};
    if (g_u8TYWClearEepromFlag == 1)
    {
        g_u8TYWClearEepromFlag = 2;
        Clear_EE[0] = 0;
        eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)&Clear_EE, 4);
    }
    Check_SEG_Display();
}
