#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"
#include "Application.h"
/* 2024/06/16 14:48:34 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

#if (PART_NUMBER == RMR42E_60)
const st_CAN_SendAttribute CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
    {
        {0x3A2ul, 200ul * 1000ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3A2, (void *)0},
        {0x3A7ul, 200ul * 1000ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3A7, (void *)0},
        {0x393ul, 2000ul * 1000ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_393, (void *)0},
};
uint8_t System_Indicator_CANFlag = 0;
const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
    {
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            20000ul,
            0x398ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            20000ul,
            0x39Dul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            500ul,
            0x157ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2000ul,
            0x38Eul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18200A20ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            1000ul,
            0x18202922ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18203020ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18203220ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2000ul,
            0x125ul,
            ((void *)0),
            (System_Indicator_ON_callback),
            (System_Indicator_OFF_callback),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            20000ul,
            0x339ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18200A21ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            500ul,
            0x134ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        /*以下新增报文待矩阵更新后按要求修改*/
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            1000ul,
            0x220ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            1000ul,
            0x225ul,
            ((void *)0),
            (CAN_0x225_Receive),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            1000ul,
            0x234ul,
            ((void *)0),
            (CAN_0x234_Receive),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            500ul,
            0x18Eul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            500ul,
            0x17Aul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
};
void System_Indicator_ON_callback(canlib_uint8_t CopyData[])
{
    System_Indicator_CANFlag = 0;
}
void System_Indicator_OFF_callback(canlib_uint8_t CopyData[])
{
    System_Indicator_CANFlag = 1;
    uint8_t i = 0;
    BUZZER_Init();
    Clear_Bu98();
    for (i = 0; i < LampCh0_MAX; i++)
    {
        LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
    }
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN0(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductDay(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductMon(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductYear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_CustomerCode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductName(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x38E_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x38E_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18200A20_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203020_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203220_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203220_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 6u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 0u) >> 2u) & 0x0Fu));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18200A21_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x134_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_220_Sig_VCU_KeySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x220_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x225_Msg_Count, 7u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x234_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18E_Sig_EMS_FuelRemainLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18E_Msg_Count, 0u) >> 4u) & 0xFu));
}

uint8_t Get_CAN_CH0_ID_17A_Sig_MBMS_StatSoc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x17A_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_CAN_0x398_Msg:
        u8Result = CAN_CH0_ID_CAN_0x398_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x39D_Msg:
        u8Result = CAN_CH0_ID_CAN_0x39D_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x157_Msg:
        u8Result = CAN_CH0_ID_CAN_0x157_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x38E_Msg:
        u8Result = CAN_CH0_ID_CAN_0x38E_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18200A20_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18200A20_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18202922_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18202922_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18203020_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18203020_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18203220_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18203220_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x125_Msg:
        u8Result = CAN_CH0_ID_CAN_0x125_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x339_Msg:
        u8Result = CAN_CH0_ID_CAN_0x339_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18200A21_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18200A21_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x134_Msg:
        u8Result = CAN_CH0_ID_CAN_0x134_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x220_Msg:
        u8Result = CAN_CH0_ID_CAN_0x220_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x225_Msg:
        u8Result = CAN_CH0_ID_CAN_0x225_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x234_Msg:
        u8Result = CAN_CH0_ID_CAN_0x234_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18E_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18E_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x17A_Msg:
        u8Result = CAN_CH0_ID_CAN_0x17A_Msg_Count;
        break;
    default:
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
#else
uint8_t System_Indicator_CANFlag = 0;
const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0x3A2ul, 200ul * 1000ul, 199ul * 1000ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3A2, (void *)0},
    {0x3D4ul, 200ul * 1000ul, 197ul * 1000ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3D4, (void *)0},
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x225ul,
        (( void * )0),
        (CAN_0x225_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x220ul,
        (( void * )0),
        (CAN_0x220_Receive),
        (System_Indicator_OFF_callback),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x361ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x134ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x33Eul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        20000ul,
        0x339ul,
        (( void * )0),
        (CAN_0x339_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x125ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x11Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x31Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x315ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x17Aul,
        (( void * )0),
        (CAN_0x17A_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x175ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x170ul,
        (( void * )0),
        (CAN_0x170_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x16Bul,
        (( void * )0),
        (CAN_0x16B_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x161ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x22Aul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x234ul,
        (( void * )0),
        (CAN_0x234_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        1000ul,
        0x22Ful,
        (( void * )0),
        (CAN_0x22F_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x18Eul,
        (( void * )0),
        (CAN_0x18E_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x3B1ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        2000ul,
        0x38Eul,
        (( void * )0),
        (CAN_0x38E_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        20000ul,
        0x389ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

void System_Indicator_OFF_callback(canlib_uint8_t CopyData[])
{
    System_Indicator_CANFlag = 1;
    uint8_t i = 0;
    BUZZER_Init();
    Clear_Bu98();
    for (i = 0; i < LampCh0_MAX; i++)
    {
        LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
    }
}

uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_VoltLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_225_Sig_VCU_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 7u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Error_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_SysFltLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_SeatSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 1u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_ReadySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_PtoSwSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_KeySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_HvSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_GrassSwSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 1u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_DrvSpdGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_ChgMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_BladeSpdGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_VCU_Status_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_361_Sig_SMCU_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_WorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ParkingGearState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_LockMotoState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_EBSState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ChgProtectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_33E_Sig_MMCU_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_RunStatistics_339h_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_RunStatistics_339h_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_RunStatistics_339h_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_Speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_Rpm(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_MotorPower(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_31A_Sig_MBMS_StatBattChargeState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_DynamicParamTotal_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_315_Sig_MBMS_StatRemainTime(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_DChgCtrl_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_DChgCtrl_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_17A_Sig_MBMS_StatSoc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_175_Sig_MBMS_Soc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_VoltCurrSoc_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigDisCharge(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_SignalStateInfo_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigCharge(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_SignalStateInfo_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigAcc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_SignalStateInfo_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_16B_Sig_MBMS_SafeBattWorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_SafeDataStat_Msg_Count, 7u) >> 4u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_161_Sig_MBMS_FaultNum(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_DynamicParam1_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_MBMS_DynamicParam1_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_22A_Sig_GCU_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_GCU_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_GCU_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Error_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_234_Sig_EMS_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_WorkSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Status_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_SvsLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Status_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_MilLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Status_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_EgnOilLvLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Status_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18E_Sig_EMS_FuelSensorVld(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Parameter2_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18E_Sig_EMS_FuelRemainLevel(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_EMS_Parameter2_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_3B1_Sig_CHG_TotalChargeTime(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_StartState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_InputVoltState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 0u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_HardFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_CommState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 0u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_ChargeStage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CHG_DynamicParam0_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_SoftOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3HWOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2HWOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_SoftOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1HWOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_SoftOverCurrentFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_38E_Sig_BMCU_FaultCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_Error_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_389_Sig_BMCU_AccumulatedWorkHour(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_RunStatistics_389h_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_BMCU_RunStatistics_389h_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_VCU_Error_Msg:
        u8Result = CAN_CH0_ID_VCU_Error_Msg_Count;
        break;
    case CAN_CH0_ID_VCU_Status_Msg:
        u8Result = CAN_CH0_ID_VCU_Status_Msg_Count;
        break;
    case CAN_CH0_ID_SMCU_Error_Msg:
        u8Result = CAN_CH0_ID_SMCU_Error_Msg_Count;
        break;
    case CAN_CH0_ID_SMCU_StateInfo_134h_Msg:
        u8Result = CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count;
        break;
    case CAN_CH0_ID_MMCU_Error_Msg:
        u8Result = CAN_CH0_ID_MMCU_Error_Msg_Count;
        break;
    case CAN_CH0_ID_MMCU_RunStatistics_339h_Msg:
        u8Result = CAN_CH0_ID_MMCU_RunStatistics_339h_Msg_Count;
        break;
    case CAN_CH0_ID_MMCU_StateInfo_125h_Msg:
        u8Result = CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count;
        break;
    case CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg:
        u8Result = CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_DynamicParamTotal_Msg:
        u8Result = CAN_CH0_ID_MBMS_DynamicParamTotal_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_DChgCtrl_Msg:
        u8Result = CAN_CH0_ID_MBMS_DChgCtrl_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg:
        u8Result = CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_VoltCurrSoc_Msg:
        u8Result = CAN_CH0_ID_MBMS_VoltCurrSoc_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_SignalStateInfo_Msg:
        u8Result = CAN_CH0_ID_MBMS_SignalStateInfo_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_SafeDataStat_Msg:
        u8Result = CAN_CH0_ID_MBMS_SafeDataStat_Msg_Count;
        break;
    case CAN_CH0_ID_MBMS_DynamicParam1_Msg:
        u8Result = CAN_CH0_ID_MBMS_DynamicParam1_Msg_Count;
        break;
    case CAN_CH0_ID_GCU_Error_Msg:
        u8Result = CAN_CH0_ID_GCU_Error_Msg_Count;
        break;
    case CAN_CH0_ID_EMS_Error_Msg:
        u8Result = CAN_CH0_ID_EMS_Error_Msg_Count;
        break;
    case CAN_CH0_ID_EMS_Status_Msg:
        u8Result = CAN_CH0_ID_EMS_Status_Msg_Count;
        break;
    case CAN_CH0_ID_EMS_Parameter2_Msg:
        u8Result = CAN_CH0_ID_EMS_Parameter2_Msg_Count;
        break;
    case CAN_CH0_ID_CHG_DynamicParam0_Msg:
        u8Result = CAN_CH0_ID_CHG_DynamicParam0_Msg_Count;
        break;
    case CAN_CH0_ID_BMCU_Error_Msg:
        u8Result = CAN_CH0_ID_BMCU_Error_Msg_Count;
        break;
    case CAN_CH0_ID_BMCU_RunStatistics_389h_Msg:
        u8Result = CAN_CH0_ID_BMCU_RunStatistics_389h_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
#endif
