#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h" 
#include "Application.h"

void Gauge_Clock_Display(void)
{
    uint8_t PageType_DIS = 0;
    if (Common_Get_IG_Sts( ) == COMMON_POWER_ON)
    {
        PageType_DIS = Get_Current_PageType();

        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_ON);
        
        if ( PageType_DIS == 1 )
        {
            if(FLASH_SYNC_1Hz)
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 1);
            }
            else
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 0, 1);
            }
            
        }
        else if ( PageType_DIS == 2 )
        {
            if(FLASH_SYNC_1Hz)
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 1);
            }
            else
            {
                SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), 1, 1, 0);
            }
        }
        else 
        {
            SEG_SET_Clock(Get_Dis_Hour_Time(), Get_Dis_Minute_Time(), FLASH_SYNC_1Hz, 1, 1);
        }
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_OFF);
    }
}







void Clear_Bu98(void)
{
    uint8_t i = 0;
    for(i = 0; i < BU98R10_DDRAM_SIZE; i ++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}


void Gauge_Service(void)
{
   
    uint8_t k = 0;
    if (ClearODO_Flag == 1)
    {
        if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
        {
            Check_SEG_Display();    
            for(k = 0; k < LampCh0_MAX; k ++)     
            {
                if (k == 24)
                {
                    k ++;
                }
                else
                {
                    LED_Driver_Channel_Set(LampChannel_0, k, LED_ON); 
                }
                
            }
            
        }
        else
        {
            Clear_Bu98();  
            for(k = 0; k < LampCh0_MAX; k ++)     
            {
                LED_Driver_Channel_Set(LampChannel_0, k, LED_OFF); 
            }
    
        }
    }
    else
    {
        if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
        {
            if (Common_GetIgnOnTime() >= 3000)
            {
               
                
                

              
                Gauge_Clock_Display();                
               
                SEG_SET_Voltage_NUM(1, Get_Battery_Voltage());
    
          
            }
            else
            {            
                Checkself_SEG_Display();                
            }
        }
        else
        {
            Clear_Bu98();
           
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_35_ODO, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_34_TRIP, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Screen_Time, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_KMH, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_MPH, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_Navigator1, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_19_Navigator2, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_Length2, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_18_Length1, LED_OFF);
            
        }
    }    
        
}

