#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

//#include "TYW_stdint.h"
//#include "CAN_Lib.h"
#include "Components.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    KEY_OFF = 0,
    PKEY_ON,
    KEY_ACC,
    READY,
    CHRG_PLUGIN,
    CHRGING,
    CHRGEND,
    POWER_CHECK_NULL,
} POWER_CHECK_STATE_t;

#if (PART_NUMBER == RMR42E_60)
typedef enum
{
    CAN_CH0_ID_CAN_0x398_Msg_Count,
    CAN_CH0_ID_CAN_0x39D_Msg_Count,
    CAN_CH0_ID_CAN_0x157_Msg_Count,
    CAN_CH0_ID_CAN_0x38E_Msg_Count,
    CAN_CH0_ID_CAN_0x18200A20_Msg_Count,
    CAN_CH0_ID_CAN_0x18202922_Msg_Count,
    CAN_CH0_ID_CAN_0x18203020_Msg_Count,
    CAN_CH0_ID_CAN_0x18203220_Msg_Count,
    CAN_CH0_ID_CAN_0x125_Msg_Count,
    CAN_CH0_ID_CAN_0x339_Msg_Count,
    CAN_CH0_ID_CAN_0x18200A21_Msg_Count,
    CAN_CH0_ID_CAN_0x134_Msg_Count,
    CAN_CH0_ID_CAN_0x220_Msg_Count,
    CAN_CH0_ID_CAN_0x225_Msg_Count,
    CAN_CH0_ID_CAN_0x234_Msg_Count,
    CAN_CH0_ID_CAN_0x18E_Msg_Count,
    CAN_CH0_ID_CAN_0x17A_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{

    CAN_CH0_ID_SEND_3A2_TOTAL,
    CAN_CH0_ID_SEND_3A7_TOTAL,
    CAN_CH0_ID_SEND_393_TOTAL,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_CAN_0x398_Msg         0x398ul
#define  CAN_CH0_ID_CAN_0x39D_Msg         0x39Dul
#define  CAN_CH0_ID_CAN_0x157_Msg         0x157ul
#define  CAN_CH0_ID_CAN_0x38E_Msg         0x38Eul
#define  CAN_CH0_ID_CAN_0x18200A20_Msg    0x18200A20ul
#define  CAN_CH0_ID_CAN_0x18202922_Msg    0x18202922ul
#define  CAN_CH0_ID_CAN_0x18203020_Msg    0x18203020ul
#define  CAN_CH0_ID_CAN_0x18203220_Msg    0x18203220ul
#define  CAN_CH0_ID_CAN_0x125_Msg         0x125ul
#define  CAN_CH0_ID_CAN_0x339_Msg         0x339ul
#define  CAN_CH0_ID_CAN_0x18200A21_Msg    0x18200A21ul
#define  CAN_CH0_ID_CAN_0x134_Msg         0x134ul
#define  CAN_CH0_ID_CAN_0x220_Msg         0x220ul
#define  CAN_CH0_ID_CAN_0x225_Msg         0x225ul
#define  CAN_CH0_ID_CAN_0x234_Msg         0x234ul
#define  CAN_CH0_ID_CAN_0x18E_Msg         0x18Eul
#define  CAN_CH0_ID_CAN_0x17A_Msg         0x17Aul



extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN0(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN1(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN2(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN3(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN4(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN5(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductDay(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductMon(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductYear(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_CustomerCode(void);
extern uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductCode(void);
extern uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductName(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge(void);
extern uint8_t  Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc(void);
extern uint8_t  Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState(void);
extern uint8_t  Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void);
extern uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void);
extern uint8_t  Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void);
extern uint8_t  Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage(void);
extern uint8_t Get_CAN_CH0_ID_220_Sig_VCU_KeySts(void);
extern uint8_t Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3(void);
extern uint8_t Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow(void);
extern uint8_t Get_CAN_CH0_ID_18E_Sig_EMS_FuelRemainLevel(void);
extern uint8_t Get_CAN_CH0_ID_17A_Sig_MBMS_StatSoc(void);



extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);
extern uint8_t System_Indicator_CANFlag;

void System_Indicator_ON_callback(canlib_uint8_t CopyData []);
void System_Indicator_OFF_callback(canlib_uint8_t CopyData []);

#else

typedef enum
{
    CAN_CH0_ID_VCU_Error_Msg_Count,
    CAN_CH0_ID_VCU_Status_Msg_Count,
    CAN_CH0_ID_SMCU_Error_Msg_Count,
    CAN_CH0_ID_SMCU_StateInfo_134h_Msg_Count,
    CAN_CH0_ID_MMCU_Error_Msg_Count,
    CAN_CH0_ID_MMCU_RunStatistics_339h_Msg_Count,
    CAN_CH0_ID_MMCU_StateInfo_125h_Msg_Count,
    CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg_Count,
    CAN_CH0_ID_MBMS_DynamicParamTotal_Msg_Count,
    CAN_CH0_ID_MBMS_DChgCtrl_Msg_Count,
    CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg_Count,
    CAN_CH0_ID_MBMS_VoltCurrSoc_Msg_Count,
    CAN_CH0_ID_MBMS_SignalStateInfo_Msg_Count,
    CAN_CH0_ID_MBMS_SafeDataStat_Msg_Count,
    CAN_CH0_ID_MBMS_DynamicParam1_Msg_Count,
    CAN_CH0_ID_GCU_Error_Msg_Count,
    CAN_CH0_ID_EMS_Error_Msg_Count,
    CAN_CH0_ID_EMS_Status_Msg_Count,
    CAN_CH0_ID_EMS_Parameter2_Msg_Count,
    CAN_CH0_ID_CHG_DynamicParam0_Msg_Count,
    CAN_CH0_ID_BMCU_Error_Msg_Count,
    CAN_CH0_ID_BMCU_RunStatistics_389h_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH0_ID_SEND_3A2_TOTAL,
    CAN_CH0_ID_SEND_3D4_TOTAL,

    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_VCU_Error_Msg                   0x225ul
#define  CAN_CH0_ID_VCU_Status_Msg                  0x220ul
#define  CAN_CH0_ID_SMCU_Error_Msg                  0x361ul
#define  CAN_CH0_ID_SMCU_StateInfo_134h_Msg         0x134ul
#define  CAN_CH0_ID_MMCU_Error_Msg                  0x33Eul
#define  CAN_CH0_ID_MMCU_RunStatistics_339h_Msg     0x339ul
#define  CAN_CH0_ID_MMCU_StateInfo_125h_Msg         0x125ul
#define  CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg      0x11Bul
#define  CAN_CH0_ID_MBMS_DynamicParamTotal_Msg      0x31Aul
#define  CAN_CH0_ID_MBMS_DChgCtrl_Msg               0x315ul
#define  CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg         0x17Aul
#define  CAN_CH0_ID_MBMS_VoltCurrSoc_Msg            0x175ul
#define  CAN_CH0_ID_MBMS_SignalStateInfo_Msg        0x170ul
#define  CAN_CH0_ID_MBMS_SafeDataStat_Msg           0x16Bul
#define  CAN_CH0_ID_MBMS_DynamicParam1_Msg          0x161ul
#define  CAN_CH0_ID_GCU_Error_Msg                   0x22Aul
#define  CAN_CH0_ID_EMS_Error_Msg                   0x234ul
#define  CAN_CH0_ID_EMS_Status_Msg                  0x22Ful
#define  CAN_CH0_ID_EMS_Parameter2_Msg              0x18Eul
#define  CAN_CH0_ID_CHG_DynamicParam0_Msg           0x3B1ul
#define  CAN_CH0_ID_BMCU_Error_Msg                  0x38Eul
#define  CAN_CH0_ID_BMCU_RunStatistics_389h_Msg     0x389ul

#define  CAN_CH0_ID_CAN_0x225_Msg   CAN_CH0_ID_VCU_Error_Msg                   
#define  CAN_CH0_ID_CAN_0x220_Msg   CAN_CH0_ID_VCU_Status_Msg                  
#define  CAN_CH0_ID_CAN_0x361_Msg   CAN_CH0_ID_SMCU_Error_Msg                  
#define  CAN_CH0_ID_CAN_0x134_Msg   CAN_CH0_ID_SMCU_StateInfo_134h_Msg         
#define  CAN_CH0_ID_CAN_0x33E_Msg   CAN_CH0_ID_MMCU_Error_Msg                  
#define  CAN_CH0_ID_CAN_0x339_Msg   CAN_CH0_ID_MMCU_RunStatistics_339h_Msg     
#define  CAN_CH0_ID_CAN_0x125_Msg   CAN_CH0_ID_MMCU_StateInfo_125h_Msg         
#define  CAN_CH0_ID_CAN_0x11B_Msg   CAN_CH0_ID_MMCU_DynamicParam_11Bh_Msg      
#define  CAN_CH0_ID_CAN_0x31A_Msg   CAN_CH0_ID_MBMS_DynamicParamTotal_Msg      
#define  CAN_CH0_ID_CAN_0x315_Msg   CAN_CH0_ID_MBMS_DChgCtrl_Msg               
#define  CAN_CH0_ID_CAN_0x17A_Msg   CAN_CH0_ID_MBMS_VoltCurrSocALL_Msg         
#define  CAN_CH0_ID_CAN_0x175_Msg   CAN_CH0_ID_MBMS_VoltCurrSoc_Msg            
#define  CAN_CH0_ID_CAN_0x170_Msg   CAN_CH0_ID_MBMS_SignalStateInfo_Msg        
#define  CAN_CH0_ID_CAN_0x16B_Msg   CAN_CH0_ID_MBMS_SafeDataStat_Msg           
#define  CAN_CH0_ID_CAN_0x161_Msg   CAN_CH0_ID_MBMS_DynamicParam1_Msg          
#define  CAN_CH0_ID_CAN_0x22A_Msg   CAN_CH0_ID_GCU_Error_Msg                   
#define  CAN_CH0_ID_CAN_0x234_Msg   CAN_CH0_ID_EMS_Error_Msg                   
#define  CAN_CH0_ID_CAN_0x22F_Msg   CAN_CH0_ID_EMS_Status_Msg                  
#define  CAN_CH0_ID_CAN_0x18E_Msg   CAN_CH0_ID_EMS_Parameter2_Msg              
#define  CAN_CH0_ID_CAN_0x3B1_Msg   CAN_CH0_ID_CHG_DynamicParam0_Msg           
#define  CAN_CH0_ID_CAN_0x38E_Msg   CAN_CH0_ID_BMCU_Error_Msg                  
#define  CAN_CH0_ID_CAN_0x389_Msg   CAN_CH0_ID_BMCU_RunStatistics_389h_Msg     

extern uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_VoltLow(void);
extern uint16_t Get_CAN_CH0_ID_225_Sig_VCU_FaultCode(void);
extern uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_EmsFltLv3(void);
extern uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv4(void);
extern uint8_t  Get_CAN_CH0_ID_225_Sig_VCU_BmsFltLv3(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_SysFltLamp(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_SeatSts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_ReadySts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_PtoSwSts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_KeySts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_HvSts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_GrassSwSts(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_DrvSpdGear(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_ChgMode(void);
extern uint8_t  Get_CAN_CH0_ID_220_Sig_VCU_BladeSpdGear(void);
extern uint16_t Get_CAN_CH0_ID_361_Sig_SMCU_FaultCode(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_WorkState(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ParkingGearState(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_LockMotoState(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_EBSState(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ChgProtectState(void);
extern uint16_t Get_CAN_CH0_ID_33E_Sig_MMCU_FaultCode(void);
extern uint8_t  Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void);
extern uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void);
extern uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_Speed(void);
extern uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_Rpm(void);
extern uint16_t Get_CAN_CH0_ID_11B_Sig_MMCU_MotorPower(void);
extern uint8_t  Get_CAN_CH0_ID_31A_Sig_MBMS_StatBattChargeState(void);
extern uint16_t Get_CAN_CH0_ID_315_Sig_MBMS_StatRemainTime(void);
extern uint8_t  Get_CAN_CH0_ID_17A_Sig_MBMS_StatSoc(void);
extern uint8_t  Get_CAN_CH0_ID_175_Sig_MBMS_Soc(void);
extern uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigDisCharge(void);
extern uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigCharge(void);
extern uint8_t  Get_CAN_CH0_ID_170_Sig_MBMS_TOTALSigAcc(void);
extern uint8_t  Get_CAN_CH0_ID_16B_Sig_MBMS_SafeBattWorkState(void);
extern uint16_t Get_CAN_CH0_ID_161_Sig_MBMS_FaultNum(void);
extern uint16_t Get_CAN_CH0_ID_22A_Sig_GCU_FaultCode(void);
extern uint8_t  Get_CAN_CH0_ID_234_Sig_EMS_EngineOilLow(void);
extern uint16_t Get_CAN_CH0_ID_234_Sig_EMS_FaultCode(void);
extern uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_WorkSts(void);
extern uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_SvsLamp(void);
extern uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_MilLamp(void);
extern uint8_t  Get_CAN_CH0_ID_22F_Sig_EMS_EgnOilLvLow(void);
extern uint8_t  Get_CAN_CH0_ID_18E_Sig_EMS_FuelSensorVld(void);
extern uint8_t  Get_CAN_CH0_ID_18E_Sig_EMS_FuelRemainLevel(void);
extern uint16_t Get_CAN_CH0_ID_3B1_Sig_CHG_TotalChargeTime(void);
extern uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_StartState(void);
extern uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_InputVoltState(void);
extern uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_HardFault(void);
extern uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_CommState(void);
extern uint8_t  Get_CAN_CH0_ID_3B1_Sig_CHG_ChargeStage(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3HWOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_SoftOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto3_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2HWOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_SoftOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1HWOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_SoftOverCurrentFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void);
extern uint16_t Get_CAN_CH0_ID_38E_Sig_BMCU_FaultCode(void);
extern uint16_t Get_CAN_CH0_ID_389_Sig_BMCU_AccumulatedWorkHour(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);


extern uint8_t System_Indicator_CANFlag;

void System_Indicator_OFF_callback(canlib_uint8_t CopyData []);

#endif

#endif
