#include "stdint.h"

typedef struct stSysTime
{
    uint32_t u32Hour;
    uint32_t u32Min;
    uint32_t u32Sec;
    uint32_t u32mSec;
}Sys_Time_st_t;

typedef void (*Sys_Timer_Cb_pfn_t)(void);

/**@struct Sys_Timer_st_t
 * @brief  Sys Timer 控制块
 */
typedef struct stSysTimer
{
    uint32_t u32Run;  /**< Sys Timer运行标志   */
    uint32_t u32Cnt;  /**< Sys Timer计数器     */
    uint32_t u32Dst;  /**< Sys Timer计数目标值 */
    
    Sys_Timer_Cb_pfn_t  pfnCallBack;  /**< Sys Timer计时结束回调函数 */
    struct stSysTimer  *pstNext;      /**< 下一个Sys Timer控制块 */
}Sys_Timer_st_t;

extern uint32_t Sys_Get_ms_Rolling_Counter(void);
extern int32_t  Sys_Get_Running_Time(Sys_Time_st_t *pstTime);

extern int32_t  Sys_Timer_Start(Sys_Timer_st_t *pHandle, uint32_t u32Interval, uint32_t u32Loop, Sys_Timer_Cb_pfn_t pfnCallBack);
extern int32_t  Sys_Timer_Stop(Sys_Timer_st_t *pHandle);
extern int32_t  Sys_Timer_Get_Status(Sys_Timer_st_t *pHandle);
extern int32_t  Sys_Timer_Get_Counter(Sys_Timer_st_t *pHandle, uint32_t *pu32Counter);

extern void Sys_Scheduler_Start(uint32_t u32SchCycle);
extern void Sys_Scheduling_Service(void);
extern void Sys_Scheduler_ISR(void);

extern void Sys_Pseudo_Real_Time_Tasks(void);
extern void Sys_2ms_Tasks(void);
extern void Sys_5ms_Tasks(void);
extern void Sys_10ms_Tasks(void);
extern void Sys_20ms_Tasks(void);
extern void Sys_50ms_Tasks(void);
extern void Sys_75ms_Tasks(void);
extern void Sys_100ms_Tasks(void);
