#ifndef _CAN_APP_H_
#define _CAN_APP_H_

#include "RTE.h"
#include "Application.h"
#include "Components.h"

extern uint8_t Msg0x17ALostFlag;
extern uint8_t Msg0x38ELostFlag;
extern uint8_t Msg0x339LostFlag;

void Can_Set_Buff_3A2(canlib_uint8_t CopyData[]);
void Can_Set_Buff_3A7(canlib_uint8_t CopyData[]);
void Can_Set_Buff_393(canlib_uint8_t CopyData[]);
void Can_Set_Buff_3D4(canlib_uint8_t CopyData[]);

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        #if (PART_NUMBER == RMR42E_60)
            uint8_t ICU_POWERStateFB : 4;
            uint8_t ICU_KL15State : 1;
            uint8_t ICU_LEDLightState : 1;
            uint8_t ICU_BuzzerState : 1;
            uint8_t Res0: 1;
            uint8_t ICU_IndicatorLightState : 3;
            uint8_t ICU_IndicatorLightPowerState : 1;
            uint8_t ICU_GrassFullState : 1;
            uint8_t Res1: 3;
            uint8_t Res2: 8;
            uint8_t Res3: 8;

            uint8_t Res4: 8;
            uint8_t Res5: 8;
            uint8_t Res6 : 8;
            uint8_t Res7 : 8;
            // uint8_t ICU_MasterBMSCommunicatlost : 1;
            // uint8_t ICU_SlaveBMSCommunicatlost : 1;
            // uint8_t ICU_MCUCommunicatlost : 1;
            // uint8_t ICU_VCUCommunicatlost : 1;
            // uint8_t Res0: 4;
            // uint8_t Res1: 8;
            // uint8_t Res2: 8;
            // uint8_t Res3: 8;

            // uint8_t Res4: 8;
            // uint8_t Res5: 8;
            // uint8_t Res6 : 8;
            // uint8_t Res7 : 8;        
        #else
            uint8_t Res0                    : 4;
            uint8_t ICU_PowerEnable         : 1;
            uint8_t ICU_LEDLightState       : 1;
            uint8_t ICU_BuzzerState         : 1;
            uint8_t Res1                    : 1;

            uint8_t Res2                    : 4;
            uint8_t ICU_GrassFullState      : 1;
            uint8_t Res3                    : 3;

            uint8_t Res4                    : 8;

            uint8_t Res5                    : 8;

            uint8_t Res6                    : 8;

            uint8_t Res7                    : 8;

            uint8_t Res8                    : 8;

            uint8_t Res9                    : 8;

        #endif
    } Sig;
} CANMsg3A2Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t ICU_MasterBMSCommunicatlost : 1;
        uint8_t ICU_SlaveBMSCommunicatlost : 1;
        uint8_t ICU_MCUCommunicatlost : 1;
        uint8_t ICU_VCUCommunicatlost : 1;
        uint8_t Res0: 4;
        uint8_t Res1: 8;
        uint8_t Res2: 8;
        uint8_t Res3: 8;

        uint8_t Res4: 8;
        uint8_t Res5: 8;
        uint8_t Res6 : 8;
        uint8_t Res7 : 8;
    } Sig;
} CANMsg3A7Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t ICU_HardVer : 8;
        uint8_t ICU_SubHardVer : 8;
        uint8_t ICU_SoftVer : 8;
        uint8_t ICU_SubSoftVer : 8;
        uint8_t ICU_SoftPhaseVer: 4;
        uint8_t Res0: 4;
        uint8_t ICU_ProtoVer: 8;
        uint8_t ICU_ProtoSubVer: 8;
        uint8_t Res1: 8;
    } Sig;
} CANMsg393Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t ICU_MasterBMSCommunicatlost : 1;
        uint8_t ICU_SlaveBMSCommunicatlost : 1;
        uint8_t ICU_MCUCommunicatlost : 1;
        uint8_t ICU_VCUCommunicatlost : 1;
        uint8_t Res0: 2;
        uint8_t ICU_BMCUCommunicatlost: 1;
        uint8_t Res8: 1;

        

        uint8_t Res1: 8;

        uint8_t Res2: 8;

        uint8_t Res3: 8;

        uint8_t Res4: 8;

        uint8_t Res5: 8;

        uint8_t Res6 : 8;

        uint8_t Res7 : 8;

    } Sig;
} CANMsg3D4Union;


#endif
