#ifndef TELLTALES_USER_H
#define TELLTALES_USER_H

#include "Components.h"

typedef enum
{                  
    em_LED_EFI_failure_Y = 0,                       /*电喷故障指示灯*/
    em_LED_Fuel_Alarm_Y,                            /*燃油低指示灯（黄色）*/
    em_LED_Lead_Acid_Battery_Failure_R,             /*铅酸电池故障指示灯*/
    em_LED_Oil_Pressure_R,                          /*机油压力报警指示灯*/
    em_LED_Grass_Full_R,                            /*草满指示灯*/

    em_LED_OVERLOAD_R,                              /*刀盘过载指示灯*/
    em_LED_READY_G,                                 /*Ready指示灯*/
    em_LED_Seat_Detection_W,                        /*座椅检测指示灯*/

    em_LED_Key_Access_W,                            /*钥匙接入指示灯*/
    em_LED_Battery_Charging_W,                      /*电池充电进行中指示灯*/
    em_LED_Cutterhead_Switch_W,                     /*刀盘开关指示*/
    em_LED_GEAR_W,                                  /*挡位指示灯*/

    em_LED_External_Discharge_W,                    /*对外放电指示灯*/
    em_LED_Engine_Works_W,                          /*发动机工作指示灯*/
    em_LED_Bluetooth_Connection_W,                  /*蓝牙显示*/
    em_LED_LED_Open_W,                              /*大灯灯光检测*/
    em_LED_Cruise_Control_W,                        /*定速巡航指示灯*/
    em_LED_Tire_pressure_F_W,                       /*左胎压显示*/
    em_LED_Tire_pressure_R_W,                       /*右胎压显示*/
    em_LED_Cutterhead_Gear_W,                       /*刀盘档位指示灯*/

    em_LED_Working_Hours_One_W,                     /*单次工作时长统计*/
    em_LED_Fault_Codes_W,                           /*故障码显示*/
    
    em_LED_System_Indicator_R,                      //系统指示灯-R-AW21036-OUT
    em_LED_P_GEAR_G,                                //空挡指示灯-G-AW21036-OUT
    em_LED_Fuel_Alarm_W,                            //燃油报警灯-WAW21036-OUT（白色）        
    em_LED_Charging_Connection_R,                   //充电枪连接-R-AW21036-OUT 
    em_LED_Power_Battery_Failure_R,                 //动力电池故障指示灯HV-R-AW21036-OUT

    
    LED_Max ,                            
} LED_Idx_t;


extern uint8_t g_u8EmsFltLv3Count;
extern uint8_t g_EngineMalfunctionStatus;
extern uint8_t g_EngineOilLowCount;
extern uint8_t g_EngineOilLowStatus;
extern uint8_t g_VoltLowStatus;
extern uint8_t g_VoltLowCount;
extern uint8_t g_OverLoadStatus[9];
extern uint8_t g_OverLoadCount[9];
extern uint8_t g_GrassSwStatus;
extern uint8_t g_GrassSwCount;
extern uint8_t g_SeatStatus;
extern uint8_t g_SeatCount;
extern uint8_t g_KeyStatus;
extern uint8_t g_KeyCount;

// extern Tellib_uint8_t Auto_Start_Stop ;

void Telltales_Init(void);
// void Telltales_Auto_Start_Stop(void);
// void Telltales_Auto_Start_Stop_Setting(void);

#endif
