#include "Components.h"
#include "Driving_Information\Data_Time.h"

DataTimeStruct_st_t Time;


void Data_Time_KL30_Init(void)
{
    Time.SingleHour = 0U;
    Time.SingleMin = 0U;
    Time.TotalHour = 0U;
    Time.SingleValid = 0U;
}

void Data_Time_KL15_Init(void)
{

}

void Data_Time_Single_Working_Hours(void)
{
    uint8_t Clock_all = 0;
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
    {
        Clock_all = Get_CAN_Num_MMCU_SingleWorkingHours();
        Time.SingleHour = Clock_all / 10U;
        Time.SingleMin = (Clock_all % 10U) * 6U;
        Time.SingleValid = 1;
    }
    else
    {
        Time.SingleValid = 0;
    }
}

uint32_t u32Data_read[1] = {0};
uint32_t CumulativeWorkHours_Writeback = 0;
uint32_t CumulativeWorkHours_readDiffer = 0;
uint8_t CumulativeWorkHours_MAX_flag = 0;
void Data_Time_Total_Working_Hours(void)
{
    uint32_t u32Data[1] = {0};
    eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
    if (u32Data_read[0] > 99999)
    {
        u32Data[0] = 99999;
        eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
        CumulativeWorkHours_MAX_flag = 1;
    }
    else
    {
        CumulativeWorkHours_MAX_flag = 0;
    }

    Time.TotalHour = u32Data_read[0];
}

void Data_CumulativeWorkHours_EEPROM_Write(void)
{
    uint32_t CurrentData = 0;
    uint32_t u32Data[1] = {0};
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
    {
        CurrentData = Get_CAN_Num_MMCU_AccumulatedWorkHours();
        if (CumulativeWorkHours_MAX_flag == 0)
        {
            if (CurrentData > CumulativeWorkHours_Writeback)
            {
                CumulativeWorkHours_readDiffer = CurrentData - CumulativeWorkHours_Writeback;
                eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                u32Data[0] = u32Data_read[0] + CumulativeWorkHours_readDiffer;
                eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                CumulativeWorkHours_Writeback = CurrentData;
            }
            else if (CurrentData < CumulativeWorkHours_Writeback)
            {
                CumulativeWorkHours_readDiffer = CumulativeWorkHours_Writeback - CurrentData;
                eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                u32Data[0] = u32Data_read[0] - CumulativeWorkHours_readDiffer;
                eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                CumulativeWorkHours_Writeback = CurrentData;
            }
        }
        else
        {
            if (CumulativeWorkHours_Writeback != 0)
            {
                if (CurrentData < CumulativeWorkHours_Writeback)
                {
                    CumulativeWorkHours_readDiffer = CumulativeWorkHours_Writeback - CurrentData;
                    eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data_read, 4);
                    u32Data[0] = u32Data_read[0] - CumulativeWorkHours_readDiffer;
                    eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
                }
                CumulativeWorkHours_Writeback = CurrentData;
            }
        }
    }
}

/******************************************************************************
函数名：Get_SingleHour_Display
功  能：获取单次工作时长小时数函数
参  数：无
返回值：Time.SingleHour x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_SingleHour_Display(void)
{
    return Time.SingleHour;
}

/******************************************************************************
函数名：Get_SingleMin_Display
功  能：获取单次工作时长分钟数函数
参  数：无
返回值：Time.SingleMin x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_SingleMin_Display(void)
{
    return Time.SingleMin;
}

/******************************************************************************
函数名：Get_Single_Working_Hours_Status
功  能：获取单次工作时长状态函数
参  数：无
返回值：Time.SingleValid 0--无效， 1--有效
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Single_Working_Hours_Status(void)
{
    return Time.SingleValid;
}

/******************************************************************************
函数名：Get_Total_Working_Hours
功  能：获取累计工作时长函数
参  数：无
返回值：Time.TotalHour x10
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint32_t Get_Total_Working_Hours(void)
{
    return Time.TotalHour;
}

/******************************************************************************
函数名：Get_Clock_All_lenth
功  能：获取累计工作时长数值长度函数
参  数：无
返回值：num x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Clock_All_lenth(void)
{
    uint8_t num = 0;
    if (Time.TotalHour > 999)
    {
        num = 2;
    }
    else if (Time.TotalHour > 9)
    {
        num = 1;
    }
    return num;
}

