#include "Components.h"
#include "RTE.h"

#define EE_SDA RTE_GPIO_PORT06_PIN01
#define EE_SCL RTE_GPIO_PORT06_PIN00

/*-------------------------------------------------------------------------
* Function Name  : eeprom_StoreInfo_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_StoreInfo_Init(void)
{
    eeprom_SetParameter(AT24C16, distance_100m);
    EE_SCL_OutConfig();
    EE_SDA_OutConfig();
}

/*-------------------------------------------------------------------------
* Function Name  : eeprom_comm_DelayUs
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void eeprom_comm_DelayUs(ee_uint32_t time)
{
    ee_uint32_t i;
    ee_uint32_t dalayCnt = 0;
    dalayCnt = time;
    EE_FeedDog();
    for (i = 0; i < dalayCnt; i++)
    {
        EE_NOP();
    }
    EE_FeedDog();
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_InConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_InConfig(void)
{
    RTE_GPIO_Config(EE_SDA, RTE_GPIO_DIR_IN);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OutConfig(void)
{
    RTE_GPIO_Config(EE_SDA, RTE_GPIO_OUTPUT_OD);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_GetValue
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
ee_uint8_t EE_SDA_GetValue(void)
{
    uint8_t SDA_INPUT = 2;
    SDA_INPUT = RTE_GPIO_Get_Level(EE_SDA);
    return SDA_INPUT;
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SDA_OUT(ee_uint8_t data)
{
    RTE_GPIO_Config(EE_SDA, RTE_GPIO_DIR_OUT | data);
    //RTE_GPIO_Set_Level(EE_SDA, data);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_SDA_OutConfig
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OutConfig(void)
{
    RTE_GPIO_Config(EE_SCL, RTE_GPIO_OUTPUT_OD);
}
/*-------------------------------------------------------------------------
* Function Name  : EE_SCL_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_SCL_OUT(ee_uint8_t data)
{
    RTE_GPIO_Config(EE_SCL, RTE_GPIO_DIR_OUT | data);
    //RTE_GPIO_Set_Level(EE_SCL, data);
}

/*-------------------------------------------------------------------------
* Function Name  : EE_FeedDog
* Description    : 清零 DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_FeedDog(void)
{
    RTE_WDT_Clear();
}

/*-------------------------------------------------------------------------
* Function Name  : EE_NOP
* Description    : nop 指令
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void EE_NOP(void)
{
    __NOP();
}
