/*
 * TrmerM.h
 *
 *  Created on: 2024年2月21日
 */

#ifndef TRMERM_H_
#define TRMERM_H_

#include <stdint.h>
#include "gpio.h"
#include "timm.h"
#include "isr.h"

typedef enum
{
    TIMERM_COUNTER0 = 0U,
    TIMERM_COUNTER1,
    TIMERM_COUNTER_MAX
} TIMERM_PWM_Counter_en_t;

typedef enum
{
    TIMERM_CHB = 0U,
    TIMERM_CHC,
    TIMERM_CHD,
} TIMERM_PWM_Channel_en_t;

typedef enum
{
    ActiveLevel_High = 0,
    ActiveLevel_Low,
} TIMERM_PWM_ActiveLevel_en_t;

extern uint8_t TimerM_PWM_counter_Output_Init(TIMERM_PWM_Counter_en_t counter, uint16_t freq, uint32_t PWM_Clock);//SystemCoreClock  //, uint32_t PWM_Clock
extern uint8_t TimerM_PWM_CH_Output_init(TIMERM_PWM_Counter_en_t counter, TIMERM_PWM_Channel_en_t ch, TIMERM_PWM_ActiveLevel_en_t ActiveLevel);
extern uint8_t TimerM_PWM_set_duty(TIMERM_PWM_Counter_en_t counter, TIMERM_PWM_Channel_en_t ch, uint16_t duty );
extern uint8_t TimerM_PWM_set_freq(TIMERM_PWM_Counter_en_t counter, uint16_t freq );
extern uint8_t TimerM_PWM_set_freq2(TIMERM_PWM_Counter_en_t counter, uint16_t freq );
//extern uint8_t TimerM_PWM_counter_Output_Init(TIMERM_PWM_Counter_en_t counter, uint16_t freq);

#endif /* TRMERM_H_ */
