#ifndef  DATA_SOC_H__
#define  DATA_SOC_H__


#include "Application.h"
#include "Components.h"


#define  SocUpdateTime     10

typedef enum
{
    Soc_Blue,
    Soc_Red,
    Soc_Yellow,
    Soc_Max,
    
}_Soc_Color;


typedef struct //__attribute__((aligned(4))) 
{
    uint8_t  Value1;        //电量1实际值
    uint8_t  Value2;        //电量2实际值
    uint8_t  Valid1;        //电量1状态
    uint8_t  Valid2;        //电量2状态
    uint8_t  Act_Seg1;      /*电量1实际格数*/
    uint8_t  Act_Seg2;      /*电量2实际格数*/
    uint8_t  Dis_Seg1;      /*电量1显示格数*/
    uint8_t  Dis_Seg2;      /*电量2显示格数*/
    uint8_t  Battery1Icon;  /*电池1小图标状态*/
    uint8_t  Battery2Icon;  /*电池2小图标状态*/
    uint8_t  AllSocValue;   /*总SOC值*/
    uint8_t  AllSocValid;   /*总SOC状态*/

}SocStruct_st_t;


extern void Data_Soc_KL30_Init(void);
extern void Data_Soc_KL15_Init(void);
extern void Data_Soc_Service(void);

extern uint8_t Get_Soc1Num_Display(void);
extern uint8_t Get_Soc2Num_Display(void);
extern uint8_t Get_Soc1_Valid(void);
extern uint8_t Get_Soc2_Valid(void);
extern uint8_t Get_CAN_Num_MBMS_Soc_1_Grid(void);
extern uint8_t Get_CAN_Num_SBMS_Soc_2_Grid(void);
extern uint8_t Get_Soc1_Battery_Icon(void);
extern uint8_t Get_Soc2_Battery_Icon(void);
extern uint8_t Get_AllSocValue(void);
extern uint8_t Get_AllSocValid(void);
extern uint8_t Get_EleDial_AllSOC_lenth(void);

#endif

