/*
 * UART.c
 *
 *  Created on: 2024��2��23��
 */
#include <stdint.h>
#include "UART.h"
#include "uart.h"
#include "gpio.h"

int8_t RTE_UART_Init(SCIAFSelect_TypeDef UARTx, uint32_t baudRate, uint16_t bitorder)
{
  
    switch(UARTx)
	{
		case UART0:       
		{
            int8_t ret;
            GPIO_InitTypeDef GPIO_InitStruct = {0};
            UART_InitTypeDef UART_InitStructure = {0};

            GPIO_PinAFConfig(GPIO_PORT5, GPIO_Pin_1, GPIO_P51, GROUP_AF_ODEFAULT);
            GPIO_PinAFConfig(GPIO_PORT5, GPIO_Pin_0, GPIO_P50, GROUP_AF_ODEFAULT);

            /*TX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_1;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_OUT;
            GPIO_InitStruct.GPIO_OType  = GPIO_OType_PP;
            GPIO_InitStruct.GPIO_Level   = GPIO_Level_HIGH;	
            GPIO_InitStruct.GPIO_Ctrl  = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT5, &GPIO_InitStruct);

            /*RX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_0 ;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_IN;
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT5, &GPIO_InitStruct);

            /*USART CONFIG*/
            UART_InitStructure.UART_BaudRate = baudRate;
            UART_InitStructure.UART_WordLength = UART_WordLength_8b;
            UART_InitStructure.UART_StopBits = UART_StopBits_1;
            UART_InitStructure.UART_Parity = UART_Parity_No;
            UART_InitStructure.phase = UART_Phase_Normal;
            UART_InitStructure.bitorder = bitorder;
            UART_InitStructure.UART_Mode = UART_Mode_Rx | UART_Mode_Tx; 

            ret = UART_Init(UART0, &UART_InitStructure);

            if (ret)
            {
                SCI_ERROR_LOG(ret);
                return ret;
            }

//            ISR_Register(ST0_IRQn, uart0_interrupt_send);     
//            ISR_Register(SR0_IRQn, uart0_interrupt_receive);  


            return SCI_SUCCESS;
        }
        // break;
        case UART1:       
		{
            int8_t res ;
            GPIO_InitTypeDef GPIO_InitStruct = {0};
            UART_InitTypeDef UART_InitStructure = {0};

        #ifndef  BAT32G1XX_48PIN	
            GPIO_PinAFConfig(GPIO_PORT0, GPIO_Pin_2, GPIO_P02, GROUP_AF_ODEFAULT);
            GPIO_PinAFConfig(GPIO_PORT0, GPIO_Pin_3, GPIO_P03, GROUP_AF_ODEFAULT);

            /*TX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_2;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_OUT;
            GPIO_InitStruct.GPIO_OType  = GPIO_OType_PP;
            GPIO_InitStruct.GPIO_Level   = GPIO_Level_HIGH;	
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT0, &GPIO_InitStruct);

            /*RX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_3;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_IN;
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT0, &GPIO_InitStruct);
        #else 
            GPIO_PinAFConfig(GPIO_PORT0, GPIO_Pin_0, GPIO_P00, GROUP_AF_ODEFAULT);
            GPIO_PinAFConfig(GPIO_PORT0, GPIO_Pin_1, GPIO_P01, GROUP_AF_ODEFAULT);

            /*TX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_2;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_OUT;
            GPIO_InitStruct.GPIO_OType  = GPIO_OType_PP;
            GPIO_InitStruct.GPIO_Level   = GPIO_Level_HIGH;	
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT0, &GPIO_InitStruct);

            /*RX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_3;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_IN;
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT0, &GPIO_InitStruct);	
        #endif
            /*USART CONFIG*/
            UART_InitStructure.UART_BaudRate = baudRate;
            UART_InitStructure.UART_WordLength = UART_WordLength_8b;
            UART_InitStructure.UART_StopBits = UART_StopBits_1;
            UART_InitStructure.UART_Parity = UART_Parity_No;
            UART_InitStructure.phase = UART_Phase_Normal;
            UART_InitStructure.bitorder = bitorder;
            UART_InitStructure.UART_Mode = UART_Mode_Rx | UART_Mode_Tx; 

            res = UART_Init(UART1, &UART_InitStructure); 

            if (res)
            {
                SCI_ERROR_LOG(res);
                return res;
            }

//            ISR_Register(ST1_IRQn, uart1_interrupt_send);     
//            ISR_Register(SR1_IRQn, uart1_interrupt_receive);  

            return SCI_SUCCESS;
        }
        // break;
        case UART2:       
		{
            int8_t res ;
            GPIO_InitTypeDef GPIO_InitStruct = {0};
            UART_InitTypeDef UART_InitStructure = {0};

            GPIO_PinAFConfig(GPIO_PORT1, GPIO_Pin_3, GPIO_P13, GROUP_AF_ODEFAULT);
            GPIO_PinAFConfig(GPIO_PORT1, GPIO_Pin_4, GPIO_P14, GROUP_AF_ODEFAULT);

            /*TX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_3;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_OUT;
            GPIO_InitStruct.GPIO_OType  = GPIO_OType_PP;
            GPIO_InitStruct.GPIO_Level   = GPIO_Level_HIGH;		
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT1, &GPIO_InitStruct);

            /*RX GPIO CONFIG*/
            GPIO_InitStruct.GPIO_Pin    = GPIO_Pin_4;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_IN;
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_Init(GPIO_PORT1, &GPIO_InitStruct);

            /*USART CONFIG*/
            UART_InitStructure.UART_BaudRate = baudRate;
            UART_InitStructure.UART_WordLength = UART_WordLength_8b;
            UART_InitStructure.UART_StopBits = UART_StopBits_1;
            UART_InitStructure.UART_Parity = UART_Parity_No;
            UART_InitStructure.phase = UART_Phase_Normal;
            UART_InitStructure.bitorder = bitorder;
            UART_InitStructure.UART_Mode = UART_Mode_Rx | UART_Mode_Tx; 

            res = UART_Init(UART2, &UART_InitStructure); 

            if (res)
            {
                SCI_ERROR_LOG(res);
                return res;
            }

//            ISR_Register(ST2_IRQn, uart2_interrupt_send);     
//            ISR_Register(SR2_IRQn, uart2_interrupt_receive);  

            return SCI_SUCCESS;
        }
        // break;
    }

}

//void RTE_UART_Init(SCIAFSelect_TypeDef UARTx, uint32_t baudRate, uint16_t bitorder)
//{
//    UART_Init(UARTx, baudRate, bitorder);
//}

void RTE_UART_SendData(SCIAFSelect_TypeDef UARTx, uint8_t *pData)
{
    switch(UARTx)
		{
				case UART0:       
				{
            UART_SendByte(UART0, *pData);
        }
        break;
        case UART1:       
				{
            UART_SendByte(UART1, *pData);
        }
        break;
        case UART2:       
				{
            UART_SendByte(UART2, *pData);
        }
        break;

    }
}


char RTE_UART_ReceiveData(SCIAFSelect_TypeDef UARTx, uint8_t *pData)
{
    switch(UARTx)
	{
		case UART0:       
		{
            return UART_ReceiveByte(UART0);
        }
        // break;
        case UART1:       
		{
            return UART_ReceiveByte(UART1);
        }
        // break;
        case UART2:       
		{
            return UART_ReceiveByte(UART2);
        }
        // break;
    }
}

