#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "Application.h"

uint16_t poweroff_time = 0;

uint8_t SOC_Count_Time = 0;
uint8_t BUZZER_ON = 0;

// void Gauge_Gear_Display(void)
// {
//     // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
//     if (Common_Get_IG_Sts() == COMMON_POWER_ON)
//     {
//         SEG_SET_GEAR(1,);
//     }
//     else
//     {

//     }
// }

void Gauge_Power_SOC_pull_Display(void)
{
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_ERR_OK || CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_ERR_OK)
        {
            uint8_t SOC_1_Count = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
            uint8_t SOC_2_Count = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
            SEG_SET_EleDial_1SOC(1, SOC_1_Count);
            SEG_SET_EleDial_2SOC(1, SOC_2_Count);
        }
        else
        {
            SEG_SET_EleDial_1SOC(0, 0);
            SEG_SET_EleDial_2SOC(0, 0);
        }
    }
    else
    {
        SEG_SET_EleDial_1SOC(0, 0);
        SEG_SET_EleDial_2SOC(0, 0);
    }
}

void Gauge_Power_SOC_CHAGING_Display(void)
{
    uint8_t MBMS_TOTALSigAcc = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge();
    uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    static uint8_t SOC1_Count = 0;
    static uint8_t SOC2_Count = 0;
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_ERR_OK || CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_ERR_OK)
        {
            uint8_t SOC_1_Count = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
            uint8_t SOC_2_Count = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
            if ((MBMS_TOTALSigAcc == 0x1 && MBMS_TOTALSigCharge == 0x1) || (MBMS_TOTALSigAcc == 0x0 && MBMS_TOTALSigCharge == 0x1)) // 上电充电
            {
                if (MBMS_StatBattWorkState == 0x1) // 主电池
                {
                    if (++SOC_Count_Time > 10)
                    {
                        SOC_Count_Time = 0;

                        SEG_SET_EleDial_1SOC(1, SOC1_Count);
                        SOC1_Count++;
                        if (SOC1_Count > SOC_1_Count)
                        {
                            SOC1_Count = 0;
                        }
                    }
                    SEG_SET_EleDial_2SOC(1, SOC_2_Count);
                }
                else if (MBMS_StatBattWorkState == 0x4) // 副电池
                {
                    if (++SOC_Count_Time > 10)
                    {
                        SOC_Count_Time = 0;

                        SEG_SET_EleDial_2SOC(1, SOC2_Count);
                        SOC2_Count++;
                        if (SOC2_Count > SOC_2_Count)
                        {
                            SOC2_Count = 0;
                        }
                    }
                    SEG_SET_EleDial_1SOC(1, SOC_1_Count);
                }
                else if (MBMS_StatBattWorkState == 0x7) // 主副电池
                {
                    if (++SOC_Count_Time > 10)
                    {
                        SOC_Count_Time = 0;

                        SEG_SET_EleDial_1SOC(1, SOC1_Count);
                        SEG_SET_EleDial_2SOC(1, SOC2_Count);
                        SOC1_Count++;
                        SOC2_Count++;
                        if (SOC_1_Count > SOC_2_Count)
                        {
                            if (SOC2_Count > SOC_2_Count)
                            {
                                SOC2_Count--;
                                if (SOC1_Count > SOC_1_Count)
                                {
                                    SOC1_Count = 0;
                                    SOC2_Count = 0;
                                }
                            }
                        }
                        else
                        {
                            if (SOC1_Count > SOC_1_Count)
                            {
                                SOC1_Count--;
                                if (SOC2_Count > SOC_2_Count)
                                {
                                    SOC1_Count = 0;
                                    SOC2_Count = 0;
                                }
                            }
                        }
                    }
                }
            }
            if (MBMS_TOTALSigAcc == 0x0 && MBMS_TOTALSigCharge == 0x1) // 下电充电
            {
                poweroff_time++;
            }
            else
            {
                poweroff_time = 0;
            }
        }
        else
        {
            SEG_SET_EleDial_1SOC(0, 0);
            SEG_SET_EleDial_2SOC(0, 0);
        }
    }
    else
    {
        SEG_SET_EleDial_1SOC(0, 0);
        SEG_SET_EleDial_2SOC(0, 0);
    }
}

void Gauge_EleDial_AllSOC_Display(void)
{
    uint8_t AllSOC_DIS = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203020_Msg)) == CAN_ERR_OK)
        {
            AllSOC_DIS = Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc();
            SEG_SET_EleDial_AllSOC(1, AllSOC_DIS);
        }
        else
        {
            SEG_SET_EleDial_AllSOC(0, 0);
        }
    }
    else
    {
        SEG_SET_EleDial_AllSOC(0, 0);
    }
}

void Gauge_Clock_Display(void)
{
    uint32_t Clock_all = 0;
    static uint8_t Clock_seconds = 0;
    static uint8_t Clock_hours = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_ERR_OK)
        {
            Clock_all = Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours();
            Clock_hours = Clock_all / 60;
            Clock_seconds = Clock_all % 60;
            SEG_SET_Clock(Clock_hours, Clock_seconds, FLASH_SYNC_1Hz, 1, 1);
        }
        else
        {
            SEG_SET_Clock(Clock_hours, Clock_seconds, 1, 1, 1);
        }
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
    }
}
static uint16_t EEPROM_Write_Time = 0;
void Data_CumulativeWorkHours_EEPROM_Write(void)
{
    uint32_t u32Data[1] = {0};
    uint32_t eeprom_back[1] = {0};
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_ERR_OK)
    {
        u32Data[0] = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
        eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)eeprom_back, 4);
        if (EEPROM_Write_Time == 0)
        {
            if (u32Data[0] >= eeprom_back[0])
            {
                eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
            }
        }
        if (++EEPROM_Write_Time > 6000) // 一分钟存一次
        {
            EEPROM_Write_Time = 0;
        }
    }
    else
    {
        EEPROM_Write_Time = 0;
    }
}

void Gauge_Clock_All_Display(void)
{
    uint32_t u32Data[1] = {0};
    eeprom_ReadRecord(EEPROM_BLOCK_00, (uint8_t *)u32Data, 4);
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        SEG_SET_Clock_ALL(1, u32Data[0]);
    }
    else
    {
        SEG_SET_Clock_ALL(0, 0);
    }
}

void Gauge_Frame_Display(void)
{
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        SEG_SET_Frame(1);
    }
    else
    {
        SEG_SET_Frame(0);
    }
}

void Clear_Bu98(void)
{
    uint8_t i = 0;
    for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}

void Gauge_Service(void)
{
    uint8_t i = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON && ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) <= 16000 && ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) >= 9000)
    {
        if (Get_CAN_Power_State() != PKEY_ON)
        {
            BUZZER_Init();
            if (Common_GetIgnOnTime() > 1500)
            {
                SOC_charge_seg_Flag = 0;
                Checkself_Init();
                Gauge_CAN_setup_Service();
            }
            else
            {
                checkself_seg_Flag = 1;
                Checkself_LED_Display();
                // Checkself_SEG_Display();
            }
        }
        else if (Get_CAN_Power_State() == PKEY_ON)
        {
            if (Buzzer_time == 0)
            {
                Clear_Bu98();
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }

                // Gpio_Init(Gpio_Sleep_Init);
            }
            interact_PWM_Low_Duty = 50;
            if (FLASH_SYNC_05Hz)
            {
                SEG_SET_GEAR(1, 0);
                if (Buzzer_time <= 6000)
                {
                    RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, GpioOut_High); // OUT_EN_1
                    BUZZER_ON = 1;
                }
                else
                {
                    RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, GpioOut_Low); // OUT_EN_1
                    BUZZER_ON = 0;
                }
            }
            else
            {
                SEG_SET_GEAR(0, 0);
                RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, GpioOut_Low); // OUT_EN_1
                BUZZER_ON = 0;
            }
            if (Buzzer_time < 0xFFFF)
            {
                Buzzer_time++;
            }
        }
    }
    else
    {
        BUZZER_Init();
        Clear_Bu98();
        for (i = 0; i < LampCh0_MAX; i++)
        {
            LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
        }
    }
}

void Gauge_CAN_setup_Service(void)
{
    uint8_t state = Get_CAN_Power_State();
    switch (state)
    {
    case KEY_ACC:
    {
        interact_PWM_Low_Duty = 0;
        Gauge_Clock_Display();
        Gauge_Clock_All_Display();
        Gauge_EleDial_AllSOC_Display();
        // SEG_SET_GEAR(1, 1);
        // SEG_SET_Cutterhead(1, 2);
        Gauge_Frame_Display();
        Gauge_Power_SOC_pull_Display();
    }
    break;
    case READY:
    {
        interact_PWM_Low_Duty = 30;
        Gauge_Clock_Display();
        Gauge_Clock_All_Display();
        Gauge_EleDial_AllSOC_Display();
        // SEG_SET_GEAR(1, 1);
        // SEG_SET_Cutterhead(1, 2);
        Gauge_Frame_Display();
        Gauge_Power_SOC_pull_Display();
    }
    break;
    case CHRGING:
    {
        SOC_charge_seg_Flag = 1;
        if (poweroff_time < 3600)
        {
            Gauge_Power_SOC_CHAGING_Display();
            if (poweroff_time == 0)
            {
                Gauge_Clock_Display();
                Gauge_Clock_All_Display();
                Gauge_EleDial_AllSOC_Display();
                // SEG_SET_GEAR(1, 1);
                // SEG_SET_Cutterhead(1, 2);
                Gauge_Frame_Display();
            }
        }
        else
        {
            SEG_SET_EleDial_AllSOC(0, 0);
            SEG_SET_EleDial_1SOC(0, 0);
            SEG_SET_EleDial_2SOC(0, 0);
        }
    }
    break;

    default:
        break;
    }
}

void Checkself_LED_Display(void)
{
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_ON);
    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_ON);
    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_03_P_GEAR_G, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);

    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_External_Discharge_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_ON);
    SEG_SET_LED_STS(SEG_LED_Recharge, 1);
    // SEG_SET_LED_STS(SEG_LED_System_Light, 1);
    SEG_SET_LED_STS(SEG_LED_Chloramine, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 1);
    SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
    SEG_SET_LED_STS(SEG_LED_Key_Access, 1);
    SEG_SET_LED_STS(SEG_LED_Ready, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 1);
    // SEG_SET_LED_STS(SEG_LED_External_Discharge, 1);
    SEG_SET_LED_STS(SEG_LED_Distance_Light, 1);
    SEG_SET_LED_STS(SEG_LED_HHT_Charger, 1);
}

void BUZZER_Init(void)
{
    Buzzer_time = 0;
    BUZZER_ON = 0;
    RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, GpioOut_Low); // OUT_EN_1
}
