
#include "BackLight\BackLight.h"
#include "Components.h"
#include "Application.h"
#include "TrmerM\TrmerM.h"


#define BACK_LIGHT_DAY 200
uint8_t interact_PWM_Low_Duty = 0;
void BackLight_Process(void)
{
    if (Get_CAN_Power_State() != PKEY_ON && Get_CAN_Power_State() != KEY_OFF && Charge_OFF_Flag != 2)
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, BACK_LIGHT_DAY);
        //电量
        if (Get_EleDial_AllSOC_lenth() == 2)
        {
            RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, GpioOut_High);//百位
            RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, GpioOut_High); 
        }
        else if(Get_EleDial_AllSOC_lenth() == 1)
        {
            RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, GpioOut_Low);
            RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, GpioOut_High); 
        }
        else
        {
            RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, GpioOut_Low);
            RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, GpioOut_Low); 
        }
        
    }
    else
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
        RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, GpioOut_Low);
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, GpioOut_Low); 
    }
}

void BackLight_Clock_All_Process(void)
{
    if (Get_CAN_Power_State() != PKEY_ON && Get_CAN_Power_State() != KEY_OFF && Charge_OFF_Flag == 0)
    {
        //总计时间
        if (Get_Clock_All_lenth() == 2)
        {
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, GpioOut_High);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, GpioOut_High);     //总计工作时长统计百十位_MCU_OUT
        }
        else if(Get_Clock_All_lenth() == 1)
        {
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, GpioOut_Low);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, GpioOut_High);     //总计工作时长统计百十位_MCU_OUT
        }
        else
        {
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, GpioOut_Low);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, GpioOut_Low);     //总计工作时长统计百十位_MCU_OUT 
        }
        
    }
    else
    {
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, GpioOut_Low);     //总计工作时长统计千位_MCU_OUT
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, GpioOut_Low);     //总计工作时长统计百十位_MCU_OUT 
    }
}

void Interact_Light_Process(void)
{
    if (Get_CAN_Power_State() != PKEY_ON && Get_CAN_Power_State() != KEY_OFF && Charge_OFF_Flag == 0)
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, interact_PWM_Low_Duty * 10);
    }
    else
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, 0);
    }
}
uint8_t Get_Interact_Light_State(void)
{
    uint8_t stata = 0x0;
    if(interact_PWM_Low_Duty == 0)
    {
        stata = 0x1;
    }
    else if(interact_PWM_Low_Duty == 30)
    {
        stata = 0x2;
    }
    else if(interact_PWM_Low_Duty == 50)
    {
        stata = 0x3;
    }
    return stata;
}
