#include <stdint.h>
#include "GPIO\RTE_GPIO.h"
#include "DeepSleep.h"
#include"isr.h"

void DEEPSLEEP_EXTI0_IRQHandler(void *msg);
void DEEPSLEEP_EXTI1_IRQHandler(void *msg);
void DEEPSLEEP_EXTI2_IRQHandler(void *msg);
void DEEPSLEEP_EXTI3_IRQHandler(void *msg);
void DEEPSLEEP_EXTI4_IRQHandler(void *msg);
void DEEPSLEEP_EXTI5_IRQHandler(void *msg);
void DEEPSLEEP_EXTI6_IRQHandler(void *msg);
void DEEPSLEEP_EXTI7_IRQHandler(void *msg);
void DEEPSLEEP_EXTI8_IRQHandler(void *msg);
void DEEPSLEEP_EXTI9_IRQHandler(void *msg);
void DEEPSLEEP_EXTI10_IRQHandler(void *msg);
void DEEPSLEEP_EXTI11_IRQHandler(void *msg);

typedef enum {
INTP0_Channel = 0x0001,
INTP1_Channel = 0x0002,
INTP2_Channel = 0x0004,
INTP3_Channel = 0x0008,
INTP4_Channel = 0x0010,
INTP5_Channel = 0x0020,
INTP6_Channel = 0x0040,
INTP7_Channel = 0x0080,
INTP8_Channel = 0x0100,
INTP9_Channel = 0x0200,
INTP10_Channel= 0x0400,
INTP11_Channel= 0x0800,
	
}INTP_Select_Channel_t;

typedef struct
{
  uint16_t                                      u16Pin;          //�����б�
	GPIO_Source_t                               GPIO_Source_Grp; //
	GROUP_AF_t                         		  	u16AFt;          //�����ж�ģʽ��Ӧ�ĸ��ù�??
	IRQn_Type                           	  	IRQType;         //�ж�����
    INTP_Select_Channel_t                       INTP_Channel;        //�ж�ͨ��ѡ��
	void                                        *Handler;        //�жϺ���ָ��  

}RTE_DEEPSLEEP_INTP_Table_st_t;

const RTE_DEEPSLEEP_INTP_Table_st_t DEEPSLEEP_INTP_Table[] = 
{
    {RTE_GPIO_PORT00_PIN00,     GPIO_P00,   GROUP_AF_INTP8,       INTP8_IRQn,    INTP8_Channel,   (void *)DEEPSLEEP_EXTI8_IRQHandler},
	{RTE_GPIO_PORT00_PIN01,     GPIO_P01,   GROUP_AF_INTP10,      INTP10_IRQn,   INTP10_Channel,  (void *)DEEPSLEEP_EXTI10_IRQHandler},
	{RTE_GPIO_PORT00_PIN05,     GPIO_P05,   GROUP_AF_INTP10,      INTP10_IRQn,   INTP10_Channel,  (void *)DEEPSLEEP_EXTI10_IRQHandler},
	{RTE_GPIO_PORT00_PIN06,     GPIO_P06,   GROUP_AF_INTP11,      INTP11_IRQn,   INTP11_Channel,  (void *)DEEPSLEEP_EXTI11_IRQHandler},	
	{RTE_GPIO_PORT01_PIN02,     GPIO_P12,   GROUP_AF_INTP5,       INTP5_IRQn,    INTP5_Channel,   (void *)DEEPSLEEP_EXTI5_IRQHandler},
	{RTE_GPIO_PORT01_PIN06,     GPIO_P16,   GROUP_AF_INTP5,       INTP5_IRQn,    INTP5_Channel,   (void *)DEEPSLEEP_EXTI5_IRQHandler},
	{RTE_GPIO_PORT02_PIN00,     GPIO_P20,   GROUP_AF_INTP11,      INTP11_IRQn,   INTP11_Channel,  (void *)DEEPSLEEP_EXTI11_IRQHandler},
	{RTE_GPIO_PORT03_PIN00,     GPIO_P30,   GROUP_AF_INTP3,       INTP3_IRQn,    INTP3_Channel,   (void *)DEEPSLEEP_EXTI3_IRQHandler},
	{RTE_GPIO_PORT03_PIN01,     GPIO_P31,   GROUP_AF_INTP4,       INTP4_IRQn,    INTP4_Channel,   (void *)DEEPSLEEP_EXTI4_IRQHandler},
	{RTE_GPIO_PORT04_PIN02,     GPIO_P42,   GROUP_AF_INTP8,       INTP8_IRQn,    INTP8_Channel,   (void *)DEEPSLEEP_EXTI8_IRQHandler},
	{RTE_GPIO_PORT04_PIN03,     GPIO_P43,   GROUP_AF_INTP9,       INTP9_IRQn,    INTP9_Channel,   (void *)DEEPSLEEP_EXTI9_IRQHandler},
	{RTE_GPIO_PORT05_PIN00,     GPIO_P50,   GROUP_AF_INTP1,       INTP1_IRQn,    INTP1_Channel,   (void *)DEEPSLEEP_EXTI1_IRQHandler},
	{RTE_GPIO_PORT05_PIN01,     GPIO_P51,   GROUP_AF_INTP2,       INTP2_IRQn,    INTP2_Channel,   (void *)DEEPSLEEP_EXTI2_IRQHandler},
	{RTE_GPIO_PORT05_PIN02,     GPIO_P52,   GROUP_AF_INTP1,       INTP1_IRQn,    INTP1_Channel,   (void *)DEEPSLEEP_EXTI1_IRQHandler},
	{RTE_GPIO_PORT05_PIN03,     GPIO_P53,   GROUP_AF_INTP2,       INTP2_IRQn,    INTP2_Channel,   (void *)DEEPSLEEP_EXTI2_IRQHandler},
	{RTE_GPIO_PORT05_PIN04,     GPIO_P54,   GROUP_AF_INTP3,       INTP3_IRQn,    INTP3_Channel,   (void *)DEEPSLEEP_EXTI3_IRQHandler},
	{RTE_GPIO_PORT05_PIN05,     GPIO_P55,   GROUP_AF_INTP4,       INTP4_IRQn,    INTP4_Channel,   (void *)DEEPSLEEP_EXTI4_IRQHandler},	
	{RTE_GPIO_PORT07_PIN04,     GPIO_P74,   GROUP_AF_INTP8,       INTP8_IRQn,    INTP8_Channel,   (void *)DEEPSLEEP_EXTI8_IRQHandler},
	{RTE_GPIO_PORT07_PIN05,     GPIO_P75,   GROUP_AF_INTP9,       INTP9_IRQn,    INTP9_Channel,   (void *)DEEPSLEEP_EXTI9_IRQHandler},
	{RTE_GPIO_PORT07_PIN06,     GPIO_P76,   GROUP_AF_INTP10,      INTP10_IRQn,   INTP10_Channel,  (void *)DEEPSLEEP_EXTI10_IRQHandler},
	{RTE_GPIO_PORT07_PIN07,     GPIO_P77,   GROUP_AF_INTP11,      INTP11_IRQn,   INTP11_Channel,  (void *)DEEPSLEEP_EXTI11_IRQHandler},
	{RTE_GPIO_PORT13_PIN06,   	GPIO_P136,  GROUP_AF_ODEFAULT,    INTP0_IRQn,    INTP0_Channel,   (void *)DEEPSLEEP_EXTI0_IRQHandler},   
	{RTE_GPIO_PORT14_PIN06,   	GPIO_P146,  GROUP_AF_INTP4,       INTP4_IRQn,    INTP4_Channel,   (void *)DEEPSLEEP_EXTI4_IRQHandler},
};

void RTE_DEEPSLEEP_GPIO_Interrupt_Enable(uint16_t u16Pin, Trigger_TypeDef EXTI_Trigger)
{
    // int32_t  i32Result;
		uint8_t  u8Index = 0;
    uint16_t u16PortIndex = 0;
    uint16_t u16PinIndex = 0;

    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    INTP_InitTypeDef INTP_InitStructure;

    u16PinIndex  = u16Pin & 0x00FFU;
    u16PortIndex = (u16Pin >> 8) & 0x00FFU;

        if ((u16PortIndex < RTE_GPIO_PORT_MAX) && (u16PinIndex < RTE_GPIO_PORT_PIN_MAX))
        {
            for (uint8_t i = 0; i < 23U; i++)
            {
                if(DEEPSLEEP_INTP_Table[i].u16Pin == u16Pin)
                {
                    u8Index = i;
                    break;
                }
            }
		    u16PinIndex  = 1 << u16PinIndex;
            GPIO_PinAFConfig(u16PortIndex, u16PinIndex, DEEPSLEEP_INTP_Table[u8Index].GPIO_Source_Grp, DEEPSLEEP_INTP_Table[u8Index].u16AFt); 
				
            GPIO_InitStruct.GPIO_Pin    = u16PinIndex ;
            GPIO_InitStruct.GPIO_Mode   = GPIO_Mode_IN;
            GPIO_InitStruct.GPIO_Ctrl   = GPIO_Control_DIG;
            GPIO_InitStruct.GPIO_PuPd   = GPIO_PuPd_DOWN;
            GPIO_Init(u16PortIndex, &GPIO_InitStruct);	
                
                
            INTP_Stop(DEEPSLEEP_INTP_Table[u8Index].INTP_Channel);                      /* �޸�ǰ��ȷ���ж����ѽ���״?? */
				
			INTP_InitStructure.INTP_Select  = DEEPSLEEP_INTP_Table[u8Index].INTP_Channel;
            INTP_InitStructure.EXTI_Trigger = EXTI_Trigger;
                    
            INTP_Init(&INTP_InitStructure);

			ISR_Register(DEEPSLEEP_INTP_Table[u8Index].IRQType, DEEPSLEEP_INTP_Table[u8Index].Handler);   /* �жϷ���ע��·��*/

			INTP_Start(DEEPSLEEP_INTP_Table[u8Index].INTP_Channel);     /* Enable INTP Interrupt */

//            ISR_DisRegister(DEEPSLEEP_INTP_Table[u8Index].IRQType, DEEPSLEEP_INTP_Table[u8Index].Handler); 

        }

}

void RTE_DEEPSLEEP_Enable(void)
{
    // SysTick->CTRL &= ~SysTick_CTRL_ENABLE_Msk;
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // //PORT->PCLR4 =(1<<1);
	//   __disable_irq();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    __STOP();       // DeepSleep
  
    // if((NVIC->ISPR[0] != 0)&&(NVIC->ISPR[0] != 0x20))
	// {
	// 	while (1)
    //     {
    //         RTE_WDT_Clear();
    //         aaa = 0;
    //     }
	// }
    //  __enable_irq();
    
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // //PORT->PSET4 =(1<<1);
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // __NOP();
    // SysTick->CTRL |= SysTick_CTRL_ENABLE_Msk;
}

/**
 * @brief ���˯���ⲿ�ж�0�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI0_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP0_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�1�жϷ���
 * @warning None
 * @since 1.0.0
 */

// unsigned char g_u8CanrxSleepstate = 0U;
void DEEPSLEEP_EXTI1_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP1_IRQn);
    // g_u8CanrxSleepstate = 1U;
}

/**
 * @brief ���˯���ⲿ�ж�2�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI2_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP2_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�3�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI3_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP3_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�4�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI4_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP4_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�5�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI5_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP5_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�6�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI6_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP6_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�7�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI7_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP7_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�8�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI8_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP8_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�9�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI9_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP9_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�10�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI10_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP10_IRQn);
}

/**
 * @brief ���˯���ⲿ�ж�11�жϷ���
 * @warning None
 * @since 1.0.0
 */
void DEEPSLEEP_EXTI11_IRQHandler(void *msg)
{
    /* ����жϱ�־ */
    INTC_ClearPendingIRQ(INTP11_IRQn);
}
