#include "Components.h"
#include "Driving_Information\Fault_Code.h"

FaultCodeStruct_st_t Code;
uint8_t FaultCodeReflash = 0U;
uint8_t DisplayIndex = 0U;

void Fault_Code_KL30_Init(void)
{
    Code.FaultCodeDis = 0U;
    Code.FaultCodeValid = 0U;
    Code.FaultCodeValidHistory = 0U;
    Code.DisTimeCount = 0U;
    memset(Code.FaultCodeArr, 0x0U, (MAX_CODE_NUM * 2U));
    FaultCodeReflash = 0U;
    DisplayIndex = 0U;
}

void Fault_Code_KL15_Init(void)
{
    Code.FaultCodeDis = 0U;
    Code.FaultCodeValid = 0U;
    Code.FaultCodeValidHistory = 0U;
    Code.DisTimeCount = 0U;
    memset(Code.FaultCodeArr, 0x0U, (MAX_CODE_NUM * 2U));
    FaultCodeReflash = 0U;
    DisplayIndex = 0U;
}

void Fault_Code_Service(void)
{
    #if (PART_NUMBER == G54_A01)
        Code.FaultCodeArr[0] = Get_CAN_CH0_ID_38E_Sig_BMCU_FaultCode();
        Code.FaultCodeArr[1] = Get_CAN_CH0_ID_234_Sig_EMS_FaultCode();
        Code.FaultCodeArr[2] = Get_CAN_CH0_ID_22A_Sig_GCU_FaultCode();
        Code.FaultCodeArr[3] = Get_CAN_CH0_ID_161_Sig_MBMS_FaultNum();
        Code.FaultCodeArr[4] = Get_CAN_CH0_ID_33E_Sig_MMCU_FaultCode();
        Code.FaultCodeArr[5] = Get_CAN_CH0_ID_361_Sig_SMCU_FaultCode();
        Code.FaultCodeArr[6] = Get_CAN_CH0_ID_225_Sig_VCU_FaultCode();

        if ((Code.FaultCodeArr[0] == 0U) && (Code.FaultCodeArr[1] == 0U) && (Code.FaultCodeArr[2] == 0U) && (Code.FaultCodeArr[3] == 0U) &&
            (Code.FaultCodeArr[4] == 0U) && (Code.FaultCodeArr[5] == 0U) && (Code.FaultCodeArr[6] == 0U))
        {
            Code.FaultCodeValid = 0U;
        }
        else
        {
            Code.FaultCodeValid = 1U;
        }

        if ((Code.FaultCodeValid == 1U) && (Code.FaultCodeValidHistory == 0U))
        {
            FaultCodeReflash = 1U;
        }

        if (Code.FaultCodeValid != Code.FaultCodeValidHistory)
        {
            Code.FaultCodeValidHistory = Code.FaultCodeValid;
        }

    #endif
}

void Fault_Code_Display_Queue(uint8_t TaskTime)
{
    #if (PART_NUMBER == G54_A01)
        if (Code.FaultCodeValid == 1U)
        {
            if ((Code.DisTimeCount < CODE_DISPLAY_TIME) && (FaultCodeReflash != 1U))
            {
                Code.DisTimeCount += TaskTime;
            }
            else 
            {
                FaultCodeReflash = 0U;
                for (uint8_t i = 0U; i <= MAX_CODE_NUM; i++)
                {
                    if (Code.FaultCodeArr[DisplayIndex] == 0U)
                    {
                        if (DisplayIndex < (MAX_CODE_NUM - 1U))
                        {
                            DisplayIndex ++;
                        }
                        else 
                        {
                            DisplayIndex = 0U;
                        }
                    }
                    else
                    {
                        Code.FaultCodeDis = Code.FaultCodeArr[DisplayIndex];
                        Code.DisTimeCount = 0U;
                        DisplayIndex ++;
                        break;
                    }
                }
            }
        }
        else
        {
            Code.FaultCodeDis = 0U;
            Code.DisTimeCount = 0U;
        }

    #endif
}

/******************************************************************************
函数名：Get_FaultCode_Value
功  能：获取当前应显示的故障码函数
参  数：无
返回值：Code.FaultCodeDis; 
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint16_t Get_FaultCode_Value(void)
{
    return Code.FaultCodeDis;
}

/******************************************************************************
函数名：Get_FaultCode_Valid
功  能：获取故障码有效状态数
参  数：无
返回值：Code.FaultCodeValid 0--不显示，1--常显
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_FaultCode_Valid(void)
{
    return Code.FaultCodeValid;
}

