#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Components.h"
#include "Application.h"
/* 2024/06/16 14:48:34 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
    {
        {0x3A2ul, 200ul * 100ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3A2, (void *)0},
        {0x3A7ul, 200ul * 100ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_3A7, (void *)0},
        {0x393ul, 200ul * 100ul, 0ul, 0u, MSG_STD, 1u, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_393, (void *)0},
};
uint8_t System_Indicator_CANFlag = 0;
const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
    {
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            3000ul,
            0x398ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            3000ul,
            0x39Dul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            200ul,
            0x157ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2000ul,
            0x38Eul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18200A20ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            1000ul,
            0x18202922ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18203020ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18203220ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            200ul,
            0x125ul,
            ((void *)0),
            (System_Indicator_ON_callback),
            (System_Indicator_OFF_callback),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            20000ul,
            0x339ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            2500ul,
            0x18200A21ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
        {
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
            200ul,
            0x134ul,
            ((void *)0),
            ((void *)0),
            ((void *)0),
        },
};
static uint8_t BMCU_ErrorGrage = 0;
static uint8_t BMCU_BladeSpeedGear = 0;
static uint8_t BMCU_PTOSwicthState = 0;

static uint8_t BMCU_Moto2_Locked_RotorFault = 0;
static uint8_t BMCU_Moto1_Locked_RotorFault = 0;
static uint8_t MBMS_Soc = 0;

static uint8_t MBMS_TOTALWorkState = 0;
static uint8_t MBMS_TOTALSigOn = 0;
static uint8_t MBMS_TOTALSigAcc = 0;
static uint8_t MBMS_TOTALSigCharge = 0;

static uint8_t MBMS_StatSoc = 0;

static uint8_t MBMS_StatBattChargeState = 0;
static uint8_t MBMS_StatBattWorkState = 0;

static uint8_t MMCU_ErrorGrage = 0;
static uint8_t MMCU_ChgProtectState = 0;
static uint8_t MMCU_DCDCEnableState = 0;
static uint8_t MMCU_ParkingGearState = 0;
static uint8_t MMCU_SeatDetectState = 0;
static uint8_t MMCU_LockMotoState = 0;
static uint8_t MMCU_EBSState = 0;
static uint8_t MMCU_TravelSpeedGear = 0;
static uint8_t MMCU_PowerMode = 0;
static uint8_t MMCU_WorkState = 0;

static uint16_t MMCU_AccumulatedWorkHours = 0;
static uint8_t MMCU_SingleWorkingHours = 0;
static uint8_t SBMS_Soc = 0;
static uint8_t SMCU_ErrorGrage = 0;
void Set_CAN_ALL_Signal(void)
{
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_ERR_OK)
    {
        BMCU_ErrorGrage = Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage();
        BMCU_BladeSpeedGear = Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear();
        BMCU_PTOSwicthState = Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x38E_Msg)) == CAN_ERR_OK)
    {
        BMCU_Moto1_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault();
        BMCU_Moto2_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_ERR_OK)
    {
        MBMS_Soc = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18202922_Msg)) == CAN_ERR_OK)
    {
        MBMS_TOTALWorkState = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState();
        MBMS_TOTALSigOn = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn();
        MBMS_TOTALSigAcc = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc();
        MBMS_TOTALSigCharge = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203020_Msg)) == CAN_ERR_OK)
    {
        MBMS_StatSoc = Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_ERR_OK)
    {
        MBMS_StatBattChargeState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState();
        MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_ERR_OK)
    {
        MMCU_ErrorGrage = Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage();
        MMCU_ChgProtectState = Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState();
        MMCU_DCDCEnableState = Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState();
        MMCU_ParkingGearState = Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState();
        MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
        MMCU_LockMotoState = Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState();
        MMCU_EBSState = Get_CAN_CH0_ID_125_Sig_MMCU_EBSState();
        MMCU_TravelSpeedGear = Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear();
        MMCU_PowerMode = Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode();
        MMCU_WorkState = Get_CAN_CH0_ID_125_Sig_MMCU_WorkState();
    }
    else
    {
        MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_ERR_OK)
    {
        MMCU_AccumulatedWorkHours = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
        MMCU_SingleWorkingHours = Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_ERR_OK)
    {
        SBMS_Soc = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_ERR_OK)
    {
        SMCU_ErrorGrage = Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage();
    }
}

uint8_t Get_CAN_Num_BMCU_ErrorGrage(void)
{
    return BMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_BMCU_BladeSpeedGear(void)
{
    return BMCU_BladeSpeedGear;
}
uint8_t Get_CAN_Num_BMCU_PTOSwicthState(void)
{
    return BMCU_PTOSwicthState;
}
uint8_t Get_CAN_Num_BMCU_Moto2_Locked_RotorFault(void)
{
    return BMCU_Moto2_Locked_RotorFault;
}
uint8_t Get_CAN_Num_BMCU_Moto1_Locked_RotorFault(void)
{
    return BMCU_Moto1_Locked_RotorFault;
}
uint8_t Get_CAN_Num_MBMS_Soc(void)
{
    return MBMS_Soc;
}
uint8_t Get_CAN_Num_MBMS_TOTALWorkState(void)
{
    return MBMS_TOTALWorkState;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigOn(void)
{
    return MBMS_TOTALSigOn;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigAcc(void)
{
    return MBMS_TOTALSigAcc;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigCharge(void)
{
    return MBMS_TOTALSigCharge;
}
uint8_t Get_CAN_Num_MBMS_StatSoc(void)
{
    return MBMS_StatSoc;
}
uint8_t Get_CAN_Num_MBMS_StatBattChargeState(void)
{
    return MBMS_StatBattChargeState;
}
uint8_t Get_CAN_Num_MBMS_StatBattWorkState(void)
{
    return MBMS_StatBattWorkState;
}
uint8_t Get_CAN_Num_MMCU_ErrorGrage(void)
{
    return MMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_MMCU_ChgProtectState(void)
{
    return MMCU_ChgProtectState;
}
uint8_t Get_CAN_Num_MMCU_DCDCEnableState(void)
{
    return MMCU_DCDCEnableState;
}
uint8_t Get_CAN_Num_MMCU_ParkingGearState(void)
{
    return MMCU_ParkingGearState;
}
uint8_t Get_CAN_Num_MMCU_SeatDetectState(void)
{
    return MMCU_SeatDetectState;
}
uint8_t Get_CAN_Num_MMCU_LockMotoState(void)
{
    return MMCU_LockMotoState;
}
uint8_t Get_CAN_Num_MMCU_EBSState(void)
{
    return MMCU_EBSState;
}
uint8_t Get_CAN_Num_MMCU_TravelSpeedGear(void)
{
    return MMCU_TravelSpeedGear;
}
uint8_t Get_CAN_Num_MMCU_PowerMode(void)
{
    return MMCU_PowerMode;
}
uint8_t Get_CAN_Num_MMCU_WorkState(void)
{
    return MMCU_WorkState;
}
uint16_t Get_CAN_Num_MMCU_AccumulatedWorkHours(void)
{
    return MMCU_AccumulatedWorkHours;
}
uint8_t Get_CAN_Num_MMCU_SingleWorkingHours(void)
{
    return MMCU_SingleWorkingHours;
}
uint8_t Get_CAN_Num_SBMS_Soc(void)
{
    return SBMS_Soc;
}
uint8_t Get_CAN_Num_SMCU_ErrorGrage(void)
{
    return SMCU_ErrorGrage;
}

void System_Indicator_ON_callback(canlib_uint8_t CopyData [])
{
    System_Indicator_CANFlag = 0;
}
void System_Indicator_OFF_callback(canlib_uint8_t CopyData [])
{
    System_Indicator_CANFlag = 1;
}

uint8_t Get_CAN_Power_State(void)
{
    uint8_t state = 0;
    uint8_t Power_State = Get_CAN_Num_MMCU_PowerMode();
    switch (Power_State)
    {
    case 0x0:
        state = KEY_OFF;
        break;
    case 0x1:
        state = PKEY_ON;
        break;
    case 0x2:
        state = KEY_ACC;
        break;
    case 0x3:
        state = READY;
        break;
    case 0x4:
        state = CHRG_PLUGIN;
        break;
    case 0x5:
        state = CHRGING;
        break;
    case 0x6:
        state = CHRGEND;
        break;
    default:
        break;
    }
    return state;
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN0(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_398_Sig_ICU_SN5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x398_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductDay(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductMon(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductYear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_39D_Sig_ICU_CustomerCode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductCode(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductName(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x39D_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x157_Msg_Count, 0u) >> 3u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x38E_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x38E_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18200A20_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18202922_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203020_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203220_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18203220_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 6u) >> 0u) & 0x07u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 1u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 0u) >> 2u) & 0x0Fu));
}

uint8_t Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x125_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) +
            ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x339_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x18200A21_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0, CAN_CH0_ID_CAN_0x134_Msg_Count, 2u) >> 0u) & 0x07u));
}

uint8_t Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_CAN_0x398_Msg:
        u8Result = CAN_CH0_ID_CAN_0x398_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x39D_Msg:
        u8Result = CAN_CH0_ID_CAN_0x39D_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x157_Msg:
        u8Result = CAN_CH0_ID_CAN_0x157_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x38E_Msg:
        u8Result = CAN_CH0_ID_CAN_0x38E_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18200A20_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18200A20_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18202922_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18202922_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18203020_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18203020_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18203220_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18203220_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x125_Msg:
        u8Result = CAN_CH0_ID_CAN_0x125_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x339_Msg:
        u8Result = CAN_CH0_ID_CAN_0x339_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x18200A21_Msg:
        u8Result = CAN_CH0_ID_CAN_0x18200A21_Msg_Count;
        break;
    case CAN_CH0_ID_CAN_0x134_Msg:
        u8Result = CAN_CH0_ID_CAN_0x134_Msg_Count;
        break;
    default:
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}
