

#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_In\Line_In_user.h"
#include "CAN_APP\CAN_CH0_CAN_Communication_Matrix.h"
#include "Application.h"

#define openLED_flag ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
static Tellib_uint16_t LED_EFI_failure_Judgement(void);
static void LED_EFI_failure_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fuel_Alarm_Judgement(void);
static void LED_Fuel_Alarm_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Lead_Acid_Battery_Failure_Judgement(void);
static void LED_Lead_Acid_Battery_Failure_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Oil_Pressure_Judgement(void);
static void LED_Oil_Pressure_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Grass_Full_Judgement(void);
static void LED_Grass_Full_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_OVERLOAD_Judgement(void);
static void LED_OVERLOAD_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_READY_Judgement(void);
static void LED_READY_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Seat_Detection_Judgement(void);
static void LED_Seat_Detection_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Key_Access_Judgement(void);
static void LED_Key_Access_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Battery_Charging_Judgement(void);
static void LED_Battery_Charging_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Cutterhead_Switch_Judgement(void);
static void LED_Cutterhead_Switch_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_GEAR_Judgement(void);
static void LED_GEAR_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_External_Discharge_Judgement(void);
static void LED_External_Discharge_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Engine_Works_Judgement(void);
static void LED_Engine_Works_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Bluetooth_Connection_Judgement(void);
static void LED_Bluetooth_Connection_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_LED_Open_Judgement(void);
static void LED_LED_Open_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Cruise_Control_Judgement(void);
static void LED_Cruise_Control_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Tire_pressure_F_Judgement(void);
static void LED_Tire_pressure_F_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Tire_pressure_R_Judgement(void);
static void LED_Tire_pressure_R_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Cutterhead_Gear_Judgement(void);
static void LED_Cutterhead_Gear_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Working_Hours_One_Judgement(void);
static void LED_Working_Hours_One_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fault_Codes_Judgement(void);
static void LED_Fault_Codes_Execution(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_SystIndicator_R_Judgement(void);
static void LED_SystIndicator_R_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_P_GEAR_G_Judgement(void);
static void LED_P_GEAR_G_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fuel_Alarm_W_Judgement(void);
static void LED_Fuel_Alarm_W_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Charging_Connection_R_Judgement(void);
static void LED_Charging_Connection_R_Execution(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Power_Battery_Failure_R_Judgement(void);
static void LED_Power_Battery_Failure_R_Execution(Tellib_uint16_t led_status);
uint8_t g_u8EmsFltLv3Count = 0U;
uint8_t g_EngineMalfunctionStatus = 0U;
uint8_t g_EngineOilLowCount = 0U;
uint8_t g_EngineOilLowStatus = 0U;
uint8_t g_VoltLowStatus = 0U;
uint8_t g_VoltLowCount = 0U;
uint8_t g_OverLoadStatus[9] = {0,0,0,0,0,0,0,0,0};
uint8_t g_OverLoadCount[9] = {0,0,0,0,0,0,0,0,0};
uint8_t g_GrassSwStatus = 0U;
uint8_t g_GrassSwCount = 0U;
uint8_t g_SeatStatus = 0U;
uint8_t g_SeatCount = 0U;
uint8_t g_KeyStatus = 0U;
uint8_t g_KeyCount = 0U;
uint8_t g_ReadyStatus = 0U;
uint8_t g_ReadyCount = 0U;
uint8_t g_ChgModeStatus = 0U;
uint8_t g_ChgModeCount = 0U;
uint8_t g_WorkStatus = 0U;
uint8_t g_WorkCount = 0U;
const LED_Attribute_st LED_Attribute[LED_Max] = 
{
    /*  指示灯索引                           是否自检             外部信号自检                 工作电源状态         自检开始时间   自检持续时间   指示灯点亮条件                                   指示灯执行函数                           */
    {em_LED_EFI_failure_Y,                  NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_EFI_failure_Judgement,                      LED_EFI_failure_Execution               },
    {em_LED_Fuel_Alarm_Y,                   NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Fuel_Alarm_Judgement,                       LED_Fuel_Alarm_Execution                },
    {em_LED_Lead_Acid_Battery_Failure_R,    NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Lead_Acid_Battery_Failure_Judgement,        LED_Lead_Acid_Battery_Failure_Execution },
    {em_LED_Oil_Pressure_R,                 NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Oil_Pressure_Judgement,                     LED_Oil_Pressure_Execution              },
    {em_LED_Grass_Full_R,                   NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Grass_Full_Judgement,                       LED_Grass_Full_Execution                },
    {em_LED_OVERLOAD_R,                     NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_OVERLOAD_Judgement,                         LED_OVERLOAD_Execution                  },
    {em_LED_READY_G,                        NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_READY_Judgement,                            LED_READY_Execution                     },
    {em_LED_Seat_Detection_W,               NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Seat_Detection_Judgement,                   LED_Seat_Detection_Execution            },
    {em_LED_Key_Access_W,                   NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Key_Access_Judgement,                       LED_Key_Access_Execution                },
    {em_LED_Battery_Charging_W,             NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Battery_Charging_Judgement,                 LED_Battery_Charging_Execution          },
    {em_LED_Cutterhead_Switch_W,            NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Cutterhead_Switch_Judgement,                LED_Cutterhead_Switch_Execution         },
    {em_LED_GEAR_W,                         NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_GEAR_Judgement,                             LED_GEAR_Execution                      },
    {em_LED_External_Discharge_W,           NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_External_Discharge_Judgement,               LED_External_Discharge_Execution        },
    {em_LED_Engine_Works_W,                 NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Engine_Works_Judgement,                     LED_Engine_Works_Execution              },
    {em_LED_Bluetooth_Connection_W,         NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Bluetooth_Connection_Judgement,             LED_Bluetooth_Connection_Execution      },
    {em_LED_LED_Open_W,                     NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_LED_Open_Judgement,                         LED_LED_Open_Execution                  },
    {em_LED_Cruise_Control_W,               NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Cruise_Control_Judgement,                   LED_Cruise_Control_Execution            },
    {em_LED_Tire_pressure_F_W,              NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Tire_pressure_F_Judgement,                  LED_Tire_pressure_F_Execution           },
    {em_LED_Tire_pressure_R_W,              NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Tire_pressure_R_Judgement,                  LED_Tire_pressure_R_Execution           },
    {em_LED_Cutterhead_Gear_W,              NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Cutterhead_Gear_Judgement,                  LED_Cutterhead_Gear_Execution           },
    {em_LED_Working_Hours_One_W,            NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Working_Hours_One_Judgement,                LED_Working_Hours_One_Execution         },
    {em_LED_Fault_Codes_W,                  NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Fault_Codes_Judgement,                      LED_Fault_Codes_Execution               },
    {em_LED_System_Indicator_R,             NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_SystIndicator_R_Judgement,                  LED_SystIndicator_R_Execution           },
    {em_LED_P_GEAR_G,                       NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_P_GEAR_G_Judgement,                         LED_P_GEAR_G_Execution                  },
    {em_LED_Fuel_Alarm_W,                   NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Fuel_Alarm_W_Judgement,                     LED_Fuel_Alarm_W_Execution              },
    {em_LED_Charging_Connection_R,          NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Charging_Connection_R_Judgement,            LED_Charging_Connection_R_Execution     },
    {em_LED_Power_Battery_Failure_R,        NoSelfCheck,        ExterNalCheck,              LED_IGN_ON,             0u,         3000ul,     LED_Power_Battery_Failure_R_Judgement,          LED_Power_Battery_Failure_R_Execution   },
};

Tellib_uint8_t Tel_Mem[Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition];
uint8_t PowerSts_num;
void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk = Common_Get_IG_Sts;
    PowerSts_num = Common_Get_IG_Sts();
    g_u8EmsFltLv3Count = 0U;
    g_EngineMalfunctionStatus = 0U;
    g_EngineOilLowCount = 0U;
    g_EngineOilLowStatus = 0U;
    g_VoltLowStatus = 0U;
    g_VoltLowCount = 0U;
    g_GrassSwStatus = 0U;
    g_GrassSwCount = 0U;
    g_SeatStatus = 0U;
    g_SeatCount = 0U;
    g_KeyStatus = 0U;
    g_KeyCount = 0U;
    g_ReadyStatus = 0U;
    g_ReadyCount = 0U;
    g_ChgModeStatus = 0U;
    g_ChgModeCount = 0U;
    g_WorkStatus = 0U;
    g_WorkCount = 0U;
    Telltales_KL30_Wakeup_Init(Tel_Mem, LED_Attribute, &m_ExtPara);
}

static Tellib_uint16_t LED_EFI_failure_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    
    #if (PART_NUMBER == G54_A01)
        if ((g_EngineMalfunctionStatus == 0U) && (g_u8EmsFltLv3Count >= 3U))
        {
            g_EngineMalfunctionStatus = 1U;
        }
        else if ((g_EngineMalfunctionStatus == 1U) && (g_u8EmsFltLv3Count >= 3U))
        {
            g_EngineMalfunctionStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_EngineMalfunctionStatus;
    #endif
    return LED_STATE;
}
static void LED_EFI_failure_Execution(Tellib_uint16_t led_status)
{
    #if (PART_NUMBER == G54_A01)
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_EFI_failure_Y, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Engine_Failure, 1U);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_EFI_failure_Y, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_Engine_Failure, 0U);
        }
    #endif
}
static Tellib_uint16_t LED_Fuel_Alarm_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    
    #if (PART_NUMBER == G54_A01)
        if (Get_FuelPilotLamp_Status() < 3U)
        {
            LED_STATE = Get_FuelPilotLamp_Status();
        }
        else
        {
            if (FLASH_SYNC_1Hz)
            {
                LED_STATE = 2U;
            }
            else
            {
                LED_STATE = 0U;
            }
        }
    #endif
    return LED_STATE;
}
static void LED_Fuel_Alarm_Execution(Tellib_uint16_t led_status)
{
    #if (PART_NUMBER == G54_A01)
        if (led_status == 1u)
        {
            /*点亮白灯*/
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_24_Fuel_Alarm_W, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Fuel_Oil, 1U);
        }
        else if (led_status == 2u)
        {
            /*点亮黄灯*/
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_23_Fuel_Alarm_Y, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Fuel_Oil, 1U);
        }
        else
        {
            /*熄灭指示灯*/
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_09_EFI_failure_Y, LED_OFF);
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_24_Fuel_Alarm_W, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_Fuel_Oil, 0U);
        }

    #endif
}
static Tellib_uint16_t LED_Lead_Acid_Battery_Failure_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    
    #if (PART_NUMBER == G54_A01)
        if ((g_VoltLowStatus == 0U) && (g_VoltLowCount >= 3U))
        {
            g_VoltLowStatus = 1U;
        }
        else if ((g_VoltLowStatus == 1U) && (g_VoltLowCount >= 3U))
        {
            g_VoltLowStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_VoltLowStatus;
    #endif

    return LED_STATE;
}
static void LED_Lead_Acid_Battery_Failure_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Lead_Acid_Battery_Failure_R, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Battery_Failure,1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Lead_Acid_Battery_Failure_R, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Battery_Failure,0);
    }
}
static Tellib_uint16_t LED_Oil_Pressure_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;

    #if (PART_NUMBER == G54_A01)
        if ((g_EngineOilLowStatus == 0U) && (g_EngineOilLowCount >= 3U))
        {
            g_EngineOilLowStatus = 1U;
        }
        else if ((g_EngineOilLowStatus == 1U) && (g_EngineOilLowCount >= 3U))
        {
            g_EngineOilLowStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_EngineOilLowStatus;
    #endif
    return LED_STATE;
}
static void LED_Oil_Pressure_Execution(Tellib_uint16_t led_status)
{
    #if (PART_NUMBER == G54_A01)
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Oil_Pressure_R, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Oil_press_Warning, 1U);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_06_Oil_Pressure_R, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_Oil_press_Warning, 0U);
        }
    #endif
}
static Tellib_uint16_t LED_Grass_Full_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        if (Line_In_Get_Status(LINE_IN_GrassFull) && openLED_flag)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        if ((g_GrassSwStatus == 0U) && (g_GrassSwCount >= 3U))
        {
            g_GrassSwStatus = 1U;
        }
        else if ((g_GrassSwStatus == 1U) && (g_GrassSwCount >= 3U))
        {
            g_GrassSwStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_GrassSwStatus;
    #endif

    return LED_STATE;
}
static void LED_Grass_Full_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Chloramine, 1);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Chloramine, 0);
    }
}
static Tellib_uint16_t LED_OVERLOAD_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        Tellib_uint8_t Signal1 = Get_CAN_Num_BMCU_Moto1_Locked_RotorFault();
        Tellib_uint8_t Signal2 = Get_CAN_Num_BMCU_Moto2_Locked_RotorFault();
        if (((Signal1 == 0x1) || (Signal2 == 0x1)) && openLED_flag)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        for(uint8_t i = 0U; i < 9U; i++)
        {
            if ((g_OverLoadStatus[i] == 0U) && (g_OverLoadCount[i] >= 3U))
            {
                g_OverLoadStatus[i] = 1U;
            }
            else if ((g_OverLoadStatus[i] == 1U) && (g_OverLoadCount[i] >= 3U))
            {
                g_OverLoadStatus[i] = 0U;
            }
        }

        if ((g_OverLoadStatus[0] == 0U) && (g_OverLoadStatus[1] == 0U) && (g_OverLoadStatus[2] == 0U) &&
            (g_OverLoadStatus[3] == 0U) && (g_OverLoadStatus[4] == 0U) && (g_OverLoadStatus[5] == 0U) &&
            (g_OverLoadStatus[6] == 0U) && (g_OverLoadStatus[7] == 0U) && (g_OverLoadStatus[8] == 0U))
        {
            LED_STATE = 0U;
        }
        else
        {
            LED_STATE = 1U;
        }

    #endif
    return LED_STATE;
}
static void LED_OVERLOAD_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 0);
    }
}
static Tellib_uint16_t LED_READY_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        Tellib_uint8_t Signal1 = Get_CAN_Power_State();
        if (Signal1 == READY)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        if ((g_ReadyStatus == 0U) && (g_ReadyCount >= 3U))
        {
            g_ReadyStatus = 1U;
        }
        else if ((g_ReadyStatus == 1U) && (g_ReadyCount >= 3U))
        {
            g_ReadyStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_ReadyStatus;
    #endif

    return LED_STATE;
}
static void LED_READY_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Ready, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Ready, 0);
    }
}
static Tellib_uint16_t LED_Seat_Detection_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        Tellib_uint8_t Signal1 = Get_CAN_Num_MMCU_SeatDetectState();
        if ((Signal1 == 0x1) && openLED_flag)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        if ((g_SeatStatus == 0U) && (g_SeatCount >= 3U))
        {
            g_SeatStatus = 1U;
        }
        else if ((g_SeatStatus == 1U) && (g_SeatCount >= 3U))
        {
            g_SeatStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_SeatStatus;

    #endif

    return LED_STATE;
}
static void LED_Seat_Detection_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
    }
    else
    {
        if (FLASH_SYNC_1Hz && openLED_flag)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_Seat_Detection, 0);
        }
        // SEG_SET_LED_STS(1,0);
    }
}
static Tellib_uint16_t LED_Key_Access_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        Tellib_uint8_t Signal1 = Get_CAN_Num_MBMS_TOTALSigAcc();
        if ((Signal1 == 0x1) && openLED_flag)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        if ((g_KeyStatus == 0U) && (g_KeyCount >= 3U))
        {
            g_KeyStatus = 1U;
        }
        else if ((g_KeyStatus == 1U) && (g_KeyCount >= 3U))
        {
            g_KeyStatus = 0U;
        }

        LED_STATE = (Tellib_uint16_t) g_KeyStatus;
        
    #endif

    return LED_STATE;
}
static void LED_Key_Access_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Key_Access, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Key_Access, 0);
    }
}
static Tellib_uint16_t LED_Battery_Charging_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        Tellib_uint8_t Signal1 = Get_CAN_Num_MBMS_TOTALSigAcc();
        Tellib_uint8_t Signal2 = Get_CAN_Num_MBMS_TOTALSigCharge();
        Tellib_uint8_t Signal3 = Get_CAN_Power_State();
        if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
        {
            if (((Signal1 == 0x1) || (Signal1 == 0x0)) && (Signal2 == 0X1))
            {
                if ((Signal3 == CHRG_PLUGIN) || (Signal3 == CHRGEND))
                {
                    LED_STATE = 2;
                }
                else if (Signal3 == CHRGING)
                {
                    LED_STATE = 1;
                }
            }
            else
            {
                LED_STATE = 0;
            }
        }
    #else
        Tellib_uint8_t Signal1 = Get_CAN_CH0_ID_220_Sig_VCU_ChgMode();

        if (Signal1 == 1U)
        {
            if ((g_ChgModeStatus != 1U) && (g_ChgModeCount >= 3U))
            {
                g_ChgModeStatus = 1U;
            }
            else if ((g_ChgModeStatus != 2U) && (g_ChgModeCount >= 3U))
            {
                g_ChgModeStatus = 2U;
            }
            else if ((g_ChgModeStatus != 0U) && (g_ChgModeCount >= 3U))
            {
                g_ChgModeStatus = 0U;
            }

            LED_STATE = (Tellib_uint16_t) g_ChgModeStatus;
        }
        else 
        {
            LED_STATE = 0U; 
        }

    #endif

    return LED_STATE;
}
static void LED_Battery_Charging_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Recharge, 1);
    }
    else if (led_status == 2u)
    {
        #if (PART_NUMBER == RMR42E_60)
        if (FLASH_SYNC_1Hz)
        #else
        if (FLASH_SYNC_05Hz)
        #endif
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
            SEG_SET_LED_STS(SEG_LED_Recharge, 1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_Recharge, 0);
        }
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Recharge, 0);
    }
}
// static Tellib_uint16_t LED_Battery_Charging_POWEROFF_Judgement(void)
// {
//     Tellib_uint16_t LED_STATE = 0u;
//     Tellib_uint8_t Signal1 = Get_CAN_Num_MBMS_TOTALSigAcc();
//     Tellib_uint8_t Signal2 = Get_CAN_Num_MBMS_TOTALSigCharge();
//     Tellib_uint8_t Signal3 = Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode();
//     if(ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) >= 9 && ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) <= 16)
//     {
//         if (Signal1 == 0x0 && Signal2 == 0X1)
//         {
//             if(Signal3 == 0x4 || Signal3 == 0x6)
//             {
//                 LED_STATE = 2;
//             }
//             else if(Signal3 == 0x5)
//             {
//                 LED_STATE = 1;
//             }
//         }
//         else
//         {
//             LED_STATE = 0;
//         }
//     }
//     return LED_STATE;
// }
static Tellib_uint16_t LED_Cutterhead_Switch_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t Signal1 = Get_CAN_Num_BMCU_PTOSwicthState();
    if ((Signal1 == 0x1) && openLED_flag)
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Cutterhead_Switch_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 0);
    }
}
static Tellib_uint16_t LED_GEAR_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Charge_OFF_Flag == 0) && (System_Indicator_CANFlag != 1) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
}
static void LED_GEAR_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_OFF);
    }
}

static Tellib_uint16_t LED_External_Discharge_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_External_Discharge_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}
static Tellib_uint16_t LED_Engine_Works_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    
    #if (PART_NUMBER == G54_A01)
        if ((g_WorkStatus != 2U) && (g_WorkCount >= 3U))
        {
            g_WorkStatus = 2U;
        }
        else if ((g_WorkStatus != 3U) && (g_WorkCount >= 3U))
        {
            g_WorkStatus = 3U;
        }
        else if ((g_WorkStatus != 4U) && (g_WorkCount >= 3U))
        {
            g_WorkStatus = 4U;
        }
        else if ((g_WorkStatus != 0U) && (g_WorkCount >= 3U))
        {
            g_WorkStatus = 0U;
        }

        if ((g_WorkStatus == 2U) || (g_WorkStatus == 3U) || (g_WorkStatus == 4U))
        {
            LED_STATE = 1U;
        }
        else
        {
            LED_STATE = 0U;
        }
        
    #endif

    return LED_STATE;
}
static void LED_Engine_Works_Execution(Tellib_uint16_t led_status)
{
    #if (PART_NUMBER == G54_A01)
    
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_16_Engine_Works_W, LED_ON);
            SEG_SET_LED_STS(SEG_LED_engine_Burn,1);
        }
        else
        {
            LED_Driver_Channel_Set(LampChannel_0, LampCh0_16_Engine_Works_W, LED_OFF);
            SEG_SET_LED_STS(SEG_LED_engine_Burn,0);
        }

    #endif
}
static Tellib_uint16_t LED_Bluetooth_Connection_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // Tellib_uint8_t Signal1 = Get_CAN_CH0_ID_3A2_Sig_ICU_BluetoothConnectState();
    // if (Signal1)
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Bluetooth_Connection_Execution(Tellib_uint16_t led_status)
{
    //  if ( led_status == 1u )
    // {
    //     LED_Driver_Channel_Set(LampChannel_0, LampCh0_22_Bluetooth_Connection_W, LED_ON);
    //     SEG_SET_LED_STS(SEG_LED_bluetooth,1);
    // }
    // else
    // {
    //     LED_Driver_Channel_Set(LampChannel_0, LampCh0_22_Bluetooth_Connection_W, LED_OFF);
    //     SEG_SET_LED_STS(SEG_LED_bluetooth,0);
    // }
}
static Tellib_uint16_t LED_LED_Open_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    #if (PART_NUMBER == RMR42E_60)
        if (Line_In_Get_Status(LINE_IN_BigLED) && openLED_flag)
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #else
        if (Line_In_Get_Status(LINE_IN_BigLED) && (Get_CAN_Power_State() == KEY_ACC))
        {
            LED_STATE = 1;
        }
        else
        {
            LED_STATE = 0;
        }
    #endif
    return LED_STATE;
}
static void LED_LED_Open_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_ON);
        SEG_SET_LED_STS(SEG_LED_Distance_Light, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_Distance_Light, 0);
    }
}
static Tellib_uint16_t LED_Cruise_Control_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Cruise_Control_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}
static Tellib_uint16_t LED_Tire_pressure_F_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Tire_pressure_F_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}
static Tellib_uint16_t LED_Tire_pressure_R_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Tire_pressure_R_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}

static Tellib_uint16_t LED_Cutterhead_Gear_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t CutterheadValid = Get_Gear_Cutterhead_Valid();

    if (CutterheadValid > 0U)
    {
        LED_STATE = 1U;
    }
    else
    {
        LED_STATE = 0U;
    }

    return LED_STATE;
}

static void LED_Cutterhead_Gear_Execution(Tellib_uint16_t led_status)
{
    if (led_status != 0u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_OFF);
    }
}
static Tellib_uint16_t LED_Working_Hours_One_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if ((Get_Single_Working_Hours_Status() == 1) && openLED_flag)
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Working_Hours_One_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_OFF);
    }
}
static Tellib_uint16_t LED_Fault_Codes_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Fault_Codes_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}

static Tellib_uint16_t LED_SystIndicator_R_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t Signal1 = Get_CAN_Num_MMCU_ErrorGrage();
    Tellib_uint8_t Signal2 = Get_CAN_Num_SMCU_ErrorGrage();
    Tellib_uint8_t Signal3 = System_Indicator_CANFlag;
    if (((Signal1 == 0x4) || (Signal1 == 0x5) || (Signal2 == 0x4) || (Signal2 == 0x5) || (Signal3 == 1)))
    {

        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_SystIndicator_R_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_ON);
        SEG_SET_LED_STS(SEG_LED_System_Light, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_System_Light, 0);
    }
}
static Tellib_uint16_t LED_P_GEAR_G_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t Signal2 = Get_CAN_Power_State();
    if (checkself_seg_Flag == 0)
    {
        if ((Signal2 == PKEY_ON))
        {
            LED_STATE = 2;
        }
        else if (openLED_flag)
        {
            LED_STATE = 1;
        }
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_P_GEAR_G_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);
    }
    else if (led_status == 2u)
    {
        if (FLASH_SYNC_1Hz)
        {
            SEG_SET_GEAR(1, Gear_P, 0);
        }
        else
        {
            
            SEG_SET_GEAR(1, Gear_OFF, 0);
        }
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);
    }
    else if (checkself_seg_Flag == 0)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_OFF);
    }
}
static Tellib_uint16_t LED_Fuel_Alarm_W_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // if (Line_In_Get_Status(LINE_IN_HighBeam))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Fuel_Alarm_W_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_ON);
        // SEG_SET_LED_STS(1,1);
    }
    else
    {
        // LED_Driver_Channel_Set(LampChannel_0, LampCh0_07_Key_ISTOP, LED_OFF);
        // SEG_SET_LED_STS(1,0);
    }
}
static Tellib_uint16_t LED_Charging_Connection_R_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t Signal1 = Get_CAN_Num_MBMS_StatBattChargeState();
    if (((Signal1 == 0x1) || (Signal1 == 0x2) || (Signal1 == 0x3)) && ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL)))
    {
        LED_STATE = 1;
    }
    else
    {
        LED_STATE = 0;
    }
    return LED_STATE;
}
static void LED_Charging_Connection_R_Execution(Tellib_uint16_t led_status)
{
    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_ON);
        SEG_SET_LED_STS(SEG_LED_HHT_Charger, 1);
    }
    else
    {
        LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_OFF);
        SEG_SET_LED_STS(SEG_LED_HHT_Charger, 0);
    }
}

static Tellib_uint16_t LED_Power_Battery_Failure_R_Judgement(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    // Tellib_uint8_t Signal1 = Get_CAN_Num_MBMS_StatBattChargeState();
    // if ((Signal1 == 0x1) || (Signal1 == 0x2) ||(Signal1 == 0x3))
    // {
    //     LED_STATE = 1;
    // }
    // else
    // {
    //     LED_STATE = 0;
    // }
    return LED_STATE;
}
static void LED_Power_Battery_Failure_R_Execution(Tellib_uint16_t led_status)
{
    //  if ( (led_status == 1u ) && openLED_flag)
    // {
    //     LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_ON);
    //     SEG_SET_LED_STS(SEG_LED_Power_Battery_Failure,1);
    // }
    // else
    // {
    //     LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_OFF);
    //     SEG_SET_LED_STS(SEG_LED_Power_Battery_Failure,0);
    // }
}
