#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "GPIO_USER\GpioUser.h"
#include "CAN_APP\CAN_CH0_CAN_Communication_Matrix.h"

#define Clr_Bit(p, b) (p) &= (~(1u << (b)))
#define Set_Bit(p, b) (p) |= (1u << (b))
#define Bit_Is_Set(p, b) ((p) & (1u << (b)))
#define Bit_Is_Clr(p, b) (!((p) & (1u << (b))))

/*数字显示数组*/                           /*0,     1     2    3      4        5     6      7      8     9        A     b     C    d      E     F*/
const uint8_t SEG_DISPLAY_NUMBER0[]   = {0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71};
const uint8_t SEG_UNDISPLAY_NUMBER0[] = {0x00u, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu};
uint8_t SOC_charge_seg_Flag = 0;
uint8_t checkself_seg_Flag = 0;
uint8_t g_u8TYWClearEepromFlag = 0;
/**@brief 边框线显示函数
 * @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */

_Fun_Res SEG_SET_Frame(uint8_t m_Flag)
{
    _Fun_Res m_Res = EX_ERR;
    if (m_Flag == 1)
    {
        /*边框*/
        IC2_SEG040 = IC_SEG_ON;
        IC2_SEG140 = IC_SEG_ON;
        IC1_SEG086 = IC_SEG_ON;
        m_Res = EX_OK;
    }
    else
    {
        /*边框*/
        IC2_SEG040 = IC_SEG_OFF;
        IC2_SEG140 = IC_SEG_OFF;
        IC1_SEG086 = IC_SEG_OFF;
        m_Res = EX_OK;
    }
    return m_Res;
}

/**@brief 指示灯显示函数
 * @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */

_Fun_Res SEG_SET_LED_STS(uint8_t LED_NUM, uint8_t m_Flag)
{
    _Fun_Res m_Res;
    uint8_t Flag;
    uint8_t Num;
    if (m_Flag == 0u)
    {
        Flag = IC_SEG_OFF;
    }
    else
    {
        Flag = IC_SEG_ON;
    }
    Num = LED_NUM;
    switch (Num)
    {
    case SEG_LED_Recharge:
        IC1_SEG150 = Flag;
        break;
    case SEG_LED_Engine_Failure:
        IC1_SEG156 = Flag;
        break;
    case SEG_LED_Battery_Failure:
        IC1_SEG155 = Flag;
        break;
    case SEG_LED_Oil_press_Warning:
        IC1_SEG154 = Flag;
        break;
    case SEG_LED_System_Light:
        IC1_SEG153 = Flag;
        break;
    case SEG_LED_Power_Battery_Failure:
        IC1_SEG152 = Flag;
        break;
    case SEG_LED_Chloramine:
        IC1_SEG151 = Flag;
        break;
    case SEG_LED_Cutter_Overload:
        IC1_SEG139 = Flag;
        break;
    case SEG_LED_Seat_Detection:
        IC1_SEG142 = Flag;
        break;
    case SEG_LED_Key_Access:
        IC1_SEG140 = Flag;
        break;
    case SEG_LED_Ready:
        IC1_SEG141 = Flag;
        break;
    case SEG_LED_Cutter_Head_switch:
        IC1_SEG119 = Flag;
        break;
    case SEG_LED_engine_Burn:
        IC1_SEG056 = Flag;
        break;
    case SEG_LED_External_Discharge:
        IC1_SEG057 = Flag;
        break;
    case SEG_LED_bluetooth:
        IC1_SEG055 = Flag;
        break;
    case SEG_LED_Distance_Light:
        IC1_SEG085 = Flag;
        break;
    case SEG_LED_Cruise_Control:
        IC1_SEG084 = Flag;
        break;
    case SEG_LED_HHT_Charger:
        IC2_SEG093 = Flag;
        break;
    case SEG_LED_Fuel_Oil:
        IC2_SEG105 = Flag;
        break;
    default:
        break;
    }

    m_Res = EX_OK;
    return m_Res;
}

/**@brief 刀盘显示函数
 * @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_Cutterhead(uint8_t m_Flag, uint8_t LED_NUM, uint8_t checkself)
{
    _Fun_Res m_Res;
    uint8_t m8 = 0;
    if (m_Flag)
    {
        if (checkself == 1)
        {
            IC1_SEG118 = IC_SEG_ON;
            IC1_SEG073 = IC_SEG_ON;
            IC1_SEG074 = IC_SEG_ON;
            IC1_SEG079 = IC_SEG_ON;
            IC1_SEG117 = IC_SEG_ON;
            IC1_SEG083 = IC_SEG_ON;
            IC1_SEG116 = IC_SEG_ON;
            m8 = SEG_DISPLAY_NUMBER0[LED_NUM];
            if (Bit_Is_Set(m8, 0))
            {
                IC1_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC1_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC1_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC1_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG080 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC1_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG078 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC1_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC1_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG077 = IC_SEG_OFF;
            }
        }
        else
        {
#if (PART_NUMBER == RMR42E_60)
            IC1_SEG118 = IC_SEG_ON;
            IC1_SEG073 = IC_SEG_ON;
            IC1_SEG074 = IC_SEG_ON;
            IC1_SEG079 = IC_SEG_ON;
            IC1_SEG083 = IC_SEG_ON;
            IC1_SEG116 = IC_SEG_ON;
            if (LED_NUM == 1)
            {
                IC1_SEG117 = IC_SEG_ON;
                IC1_SEG075 = IC_SEG_OFF;
                IC1_SEG082 = IC_SEG_ON;
                IC1_SEG081 = IC_SEG_ON;
                IC1_SEG080 = IC_SEG_OFF;
                IC1_SEG078 = IC_SEG_OFF;
                IC1_SEG076 = IC_SEG_OFF;
                IC1_SEG077 = IC_SEG_OFF;
            }
            else if (LED_NUM == 2)
            {
                IC1_SEG117 = IC_SEG_ON;
                IC1_SEG075 = IC_SEG_ON;
                IC1_SEG082 = IC_SEG_ON;
                IC1_SEG081 = IC_SEG_OFF;
                IC1_SEG080 = IC_SEG_ON;
                IC1_SEG078 = IC_SEG_ON;
                IC1_SEG076 = IC_SEG_OFF;
                IC1_SEG077 = IC_SEG_ON;
            }
            else if (LED_NUM == 3)
            {
                IC1_SEG117 = IC_SEG_ON;
                IC1_SEG075 = IC_SEG_ON;
                IC1_SEG082 = IC_SEG_ON;
                IC1_SEG081 = IC_SEG_ON;
                IC1_SEG080 = IC_SEG_ON;
                IC1_SEG078 = IC_SEG_OFF;
                IC1_SEG076 = IC_SEG_OFF;
                IC1_SEG077 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG117 = IC_SEG_OFF;
                IC1_SEG075 = IC_SEG_OFF;
                IC1_SEG082 = IC_SEG_OFF;
                IC1_SEG081 = IC_SEG_OFF;
                IC1_SEG080 = IC_SEG_OFF;
                IC1_SEG078 = IC_SEG_OFF;
                IC1_SEG076 = IC_SEG_OFF;
                IC1_SEG077 = IC_SEG_OFF;
            }
#else
                IC1_SEG118 = IC_SEG_ON;
                IC1_SEG073 = IC_SEG_ON;
                IC1_SEG074 = IC_SEG_ON;
                IC1_SEG079 = IC_SEG_ON;
                IC1_SEG083 = IC_SEG_ON;
                IC1_SEG116 = IC_SEG_ON;
                if (LED_NUM == Gear_H)
                {
                    IC1_SEG076 = IC_SEG_ON;
                    IC1_SEG077 = IC_SEG_ON;
                    IC1_SEG078 = IC_SEG_ON;
                    IC1_SEG081 = IC_SEG_ON;
                    IC1_SEG082 = IC_SEG_ON;
                    IC1_SEG117 = IC_SEG_ON;

                    IC1_SEG075 = IC_SEG_OFF;
                    IC1_SEG080 = IC_SEG_OFF;
                }
                else if (LED_NUM == Gear_L)
                {
                    IC1_SEG076 = IC_SEG_ON;
                    IC1_SEG078 = IC_SEG_ON;
                    IC1_SEG080 = IC_SEG_ON;
                    IC1_SEG117 = IC_SEG_ON;

                    IC1_SEG077 = IC_SEG_OFF;
                    IC1_SEG081 = IC_SEG_OFF;
                    IC1_SEG082 = IC_SEG_OFF;
                    IC1_SEG075 = IC_SEG_OFF;
                }
                else if (LED_NUM == 0)
                {
                    IC1_SEG117 = IC_SEG_ON;

                    IC1_SEG076 = IC_SEG_OFF;
                    IC1_SEG078 = IC_SEG_OFF;
                    IC1_SEG080 = IC_SEG_OFF;
                    IC1_SEG077 = IC_SEG_OFF;
                    IC1_SEG081 = IC_SEG_OFF;
                    IC1_SEG082 = IC_SEG_OFF;
                    IC1_SEG075 = IC_SEG_OFF;
                }
                else
                {
                    IC1_SEG117 = IC_SEG_OFF;
                    IC1_SEG075 = IC_SEG_OFF;
                    IC1_SEG082 = IC_SEG_OFF;
                    IC1_SEG081 = IC_SEG_OFF;
                    IC1_SEG080 = IC_SEG_OFF;
                    IC1_SEG078 = IC_SEG_OFF;
                    IC1_SEG076 = IC_SEG_OFF;
                    IC1_SEG077 = IC_SEG_OFF;
                }
#endif
        }
    }
    else
    {
        IC1_SEG075 = IC_SEG_OFF;
        IC1_SEG082 = IC_SEG_OFF;
        IC1_SEG081 = IC_SEG_OFF;
        IC1_SEG080 = IC_SEG_OFF;
        IC1_SEG078 = IC_SEG_OFF;
        IC1_SEG076 = IC_SEG_OFF;
        IC1_SEG077 = IC_SEG_OFF;
        IC1_SEG118 = IC_SEG_OFF;
        IC1_SEG073 = IC_SEG_OFF;
        IC1_SEG074 = IC_SEG_OFF;
        IC1_SEG079 = IC_SEG_OFF;
        IC1_SEG117 = IC_SEG_OFF;
        IC1_SEG083 = IC_SEG_OFF;
        IC1_SEG116 = IC_SEG_OFF;
    }

    m_Res = EX_OK;
    return m_Res;
}

/**@brief 挡位显示函数
* @param[in]  m_Gear_Flag     挡位符号是否显示     -1 显示 -0 不显示
* @param[in]  m_Gear          符号             Gear_P = 0,  //P
                                               Gear_R,      //R
                                               Gear_N,      //N
                                               Gear_D,      //D

* @return  函数执行结果
* - EX_OK      		上报成功
* - EX_ERR        	上报失败
*/

_Fun_Res SEG_SET_GEAR(uint8_t m_Gear_Flag, uint8_t m_Gear, uint8_t checkself)
{
    /*挡位符号*/
    uint8_t m8 = 0;
    _Fun_Res Res = EX_ERR;
    if (m_Gear_Flag == 1u)
    {
        IC2_SEG094 = IC_SEG_ON;
        IC2_SEG095 = IC_SEG_ON;
        IC2_SEG149 = IC_SEG_ON;
        IC2_SEG145 = IC_SEG_ON;
        IC2_SEG141 = IC_SEG_ON;
        IC2_SEG104 = IC_SEG_ON;
        IC2_SEG103 = IC_SEG_ON;
        IC2_SEG098 = IC_SEG_ON;
        IC2_SEG150 = IC_SEG_ON;
        if (checkself == 1)
        {
            m8 = SEG_DISPLAY_NUMBER0[m_Gear];
            // if (m_Gear == 8)
            // {
            //     IC2_SEG096 = IC_SEG_ON;
            //     IC2_SEG142 = IC_SEG_ON;
            // }
            // else
            // {
            //     IC2_SEG096 = IC_SEG_OFF;
            //     IC2_SEG142 = IC_SEG_OFF;
            // }
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG148 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG148 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG147 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG147 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG144 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG144 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG143 = IC_SEG_ON;
                IC2_SEG102 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG143 = IC_SEG_OFF;
                IC2_SEG102 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG100 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG100 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG097 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG097 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG101 = IC_SEG_ON;
                IC2_SEG099 = IC_SEG_ON;
                IC2_SEG146 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG101 = IC_SEG_OFF;
                IC2_SEG099 = IC_SEG_OFF;
                IC2_SEG146 = IC_SEG_OFF;
            }
            Res = EX_OK;
        }
        else
        {
            if (m_Gear == Gear_P)
            {
                IC2_SEG100 = IC_SEG_ON;
                IC2_SEG097 = IC_SEG_ON;
                IC2_SEG148 = IC_SEG_ON;
                IC2_SEG147 = IC_SEG_ON;
                IC2_SEG146 = IC_SEG_ON;
                IC2_SEG099 = IC_SEG_ON;
                IC2_SEG101 = IC_SEG_ON;

                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
                IC2_SEG143 = IC_SEG_OFF;
                IC2_SEG144 = IC_SEG_OFF;
                IC2_SEG102 = IC_SEG_OFF;
            }
            else if (m_Gear == Gear_1)
            {
                IC2_SEG097 = IC_SEG_OFF;
                IC2_SEG148 = IC_SEG_OFF;
                IC2_SEG147 = IC_SEG_ON;
                IC2_SEG146 = IC_SEG_OFF;
                IC2_SEG099 = IC_SEG_OFF;
                IC2_SEG101 = IC_SEG_OFF;
                IC2_SEG100 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
                IC2_SEG143 = IC_SEG_OFF;

                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG144 = IC_SEG_ON;
                IC2_SEG102 = IC_SEG_OFF;
            }
            else if (m_Gear == Gear_2)
            {

                IC2_SEG097 = IC_SEG_OFF;
                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
                IC2_SEG144 = IC_SEG_OFF;

                IC2_SEG100 = IC_SEG_ON;
                IC2_SEG101 = IC_SEG_ON;
                IC2_SEG099 = IC_SEG_ON;
                IC2_SEG146 = IC_SEG_ON;
                IC2_SEG147 = IC_SEG_ON;
                IC2_SEG148 = IC_SEG_ON;
                IC2_SEG102 = IC_SEG_ON;
                IC2_SEG143 = IC_SEG_ON;
            }
            else if (m_Gear == Gear_H)
            {
                IC2_SEG100 = IC_SEG_ON;
                IC2_SEG097 = IC_SEG_ON;
                IC2_SEG101 = IC_SEG_ON;
                IC2_SEG146 = IC_SEG_ON;
                IC2_SEG099 = IC_SEG_ON;
                IC2_SEG147 = IC_SEG_ON;
                IC2_SEG144 = IC_SEG_ON;

                IC2_SEG148 = IC_SEG_OFF;
                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
                IC2_SEG143 = IC_SEG_OFF;
                IC2_SEG102 = IC_SEG_OFF;
            }
            else if (m_Gear == Gear_L)
            {
                IC2_SEG100 = IC_SEG_ON;
                IC2_SEG097 = IC_SEG_ON;
                IC2_SEG102 = IC_SEG_ON;
                IC2_SEG143 = IC_SEG_ON;

                IC2_SEG148 = IC_SEG_OFF;
                IC2_SEG147 = IC_SEG_OFF;
                IC2_SEG146 = IC_SEG_OFF;
                IC2_SEG099 = IC_SEG_OFF;
                IC2_SEG101 = IC_SEG_OFF;
                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
                IC2_SEG144 = IC_SEG_OFF;
            }
            else if (m_Gear == Gear_OFF)
            {
                IC2_SEG101 = IC_SEG_OFF;
                IC2_SEG099 = IC_SEG_OFF;
                IC2_SEG146 = IC_SEG_OFF;
                IC2_SEG097 = IC_SEG_OFF;
                IC2_SEG100 = IC_SEG_OFF;
                IC2_SEG143 = IC_SEG_OFF;
                IC2_SEG102 = IC_SEG_OFF;
                IC2_SEG144 = IC_SEG_OFF;
                IC2_SEG147 = IC_SEG_OFF;
                IC2_SEG148 = IC_SEG_OFF;

                IC2_SEG096 = IC_SEG_OFF;
                IC2_SEG142 = IC_SEG_OFF;
            }
            else
            {
                ;
            }
        }
        Res = EX_OK;
    }
    else
    {
        IC2_SEG094 = IC_SEG_OFF;
        IC2_SEG095 = IC_SEG_OFF;
        IC2_SEG149 = IC_SEG_OFF;
        IC2_SEG145 = IC_SEG_OFF;
        IC2_SEG141 = IC_SEG_OFF;
        IC2_SEG104 = IC_SEG_OFF;
        IC2_SEG103 = IC_SEG_OFF;
        IC2_SEG098 = IC_SEG_OFF;
        IC2_SEG097 = IC_SEG_OFF;
        IC2_SEG148 = IC_SEG_OFF;
        IC2_SEG147 = IC_SEG_OFF;
        IC2_SEG144 = IC_SEG_OFF;
        IC2_SEG143 = IC_SEG_OFF;
        IC2_SEG102 = IC_SEG_OFF;
        IC2_SEG100 = IC_SEG_OFF;
        IC2_SEG101 = IC_SEG_OFF;
        IC2_SEG096 = IC_SEG_OFF;
        IC2_SEG099 = IC_SEG_OFF;
        IC2_SEG146 = IC_SEG_OFF;
        IC2_SEG142 = IC_SEG_OFF;
        IC2_SEG150 = IC_SEG_OFF;
        Res = EX_ERR;
    }
    return Res;
}
/**@brief 燃油表盘显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             燃油表盘段数0<=m_SEG<=5
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_FuelDial(uint8_t m_Flag, uint8_t m_SEG)
{
    _Fun_Res m_Res;
    // uint8_t  Num;
    uint8_t m8;
    if (m_Flag == 1u)
    {
        IC1_SEG052 = IC_SEG_GREY;
        IC1_SEG051 = IC_SEG_GREY;
        IC1_SEG050 = IC_SEG_GREY;
        IC1_SEG049 = IC_SEG_GREY;
        IC1_SEG048 = IC_SEG_GREY;
        IC1_SEG047 = IC_SEG_GREY;
        IC1_SEG046 = IC_SEG_GREY;
        IC1_SEG045 = IC_SEG_GREY;

        IC1_SEG053 = IC_SEG_ON;
        IC1_SEG105 = IC_SEG_ON;
        IC1_SEG044 = IC_SEG_ON;
        switch (m_SEG)
        {
        case 8u:
            IC1_SEG045 = IC_SEG_ON;
        case 7u:
            IC1_SEG046 = IC_SEG_ON;
        case 6u:
            IC1_SEG047 = IC_SEG_ON;
        case 5u:
            IC1_SEG048 = IC_SEG_ON;
        case 4u:
            IC1_SEG049 = IC_SEG_ON;
        case 3u:
            IC1_SEG050 = IC_SEG_ON;
        case 2u:
            IC1_SEG051 = IC_SEG_ON;
        case 1u:
            IC1_SEG052 = IC_SEG_ON;
        case 0u:
            break;
        default:
            break;
        }
    }
    else
    {
        IC1_SEG052 = IC_SEG_OFF;
        IC1_SEG051 = IC_SEG_OFF;
        IC1_SEG050 = IC_SEG_OFF;
        IC1_SEG049 = IC_SEG_OFF;
        IC1_SEG048 = IC_SEG_OFF;
        IC1_SEG047 = IC_SEG_OFF;
        IC1_SEG046 = IC_SEG_OFF;
        IC1_SEG045 = IC_SEG_OFF;
        IC1_SEG053 = IC_SEG_OFF;
        IC1_SEG105 = IC_SEG_OFF;
        IC1_SEG044 = IC_SEG_OFF;
    }
    m_Res = EX_OK;

    return m_Res;
}

/**@brief 电量表盘1SOC显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             车速表盘段数0<=m_SEG<=10
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_EleDial_1SOC(uint8_t m_Flag, uint8_t m_SEG)
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    #if (PART_NUMBER == RMR42E_60)
    if (((m_Flag == 1u) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL)) || (checkself_seg_Flag == 1))
    #else
    if ((m_Flag == 1u) || (checkself_seg_Flag == 1))
    #endif
    {
        IC1_SEG136 = IC_SEG_GREY;
        IC1_SEG137 = IC_SEG_GREY;
        IC1_SEG138 = IC_SEG_GREY;
        IC1_SEG143 = IC_SEG_GREY;
        IC1_SEG144 = IC_SEG_GREY;
        IC1_SEG145 = IC_SEG_GREY;
        IC1_SEG146 = IC_SEG_GREY;
        IC1_SEG147 = IC_SEG_GREY;
        IC1_SEG148 = IC_SEG_GREY;
        IC1_SEG135 = IC_SEG_GREY;
        // 小电池
        IC1_SEG121 = IC_SEG_ON;
        IC1_SEG122 = IC_SEG_ON;
        #if (PART_NUMBER == RMR42E_60)
        if ((m_SEG == 1) && (Common_GetIgnOnTime() >= 1500) && (SOC_charge_seg_Flag != 1))
        #else
        if ((m_SEG == 1) && (Common_GetIgnOnTime() >= 1500) && (SOC_charge_seg_Flag != 1) && (Get_CAN_CH0_ID_220_Sig_VCU_ChgMode() != 1U))
        #endif
        {
            if (FLASH_SYNC_1Hz)
            {
                IC1_SEG135 = IC_SEG_ON;
            }
            else
            {
                IC1_SEG135 = IC_SEG_GREY;
            }
        }
        else
        {
            switch (m_SEG)
            {

            case 10u:
                IC1_SEG136 = IC_SEG_ON;
            case 9u:
                IC1_SEG137 = IC_SEG_ON;
            case 8u:
                IC1_SEG138 = IC_SEG_ON;
            case 7u:
                IC1_SEG143 = IC_SEG_ON;
            case 6u:
                IC1_SEG144 = IC_SEG_ON;
            case 5u:
                IC1_SEG145 = IC_SEG_ON;
            case 4u:
                IC1_SEG146 = IC_SEG_ON;
            case 3u:
                IC1_SEG147 = IC_SEG_ON;
            case 2u:
                IC1_SEG148 = IC_SEG_ON;
            case 1u:
                IC1_SEG135 = IC_SEG_ON;
            case 0u:
                break;
            default:
                break;
            }
        }
    }
    else
    {

        IC1_SEG136 = IC_SEG_OFF;
        IC1_SEG137 = IC_SEG_OFF;
        IC1_SEG138 = IC_SEG_OFF;
        IC1_SEG143 = IC_SEG_OFF;
        IC1_SEG144 = IC_SEG_OFF;
        IC1_SEG145 = IC_SEG_OFF;
        IC1_SEG146 = IC_SEG_OFF;
        IC1_SEG147 = IC_SEG_OFF;
        IC1_SEG148 = IC_SEG_OFF;
        IC1_SEG135 = IC_SEG_OFF;
        // 小电池
        IC1_SEG121 = IC_SEG_OFF;
        IC1_SEG122 = IC_SEG_OFF;
    }

    return m_Res;
}

/**@brief 电量表盘2SOC显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_SEG             车速表盘段数0<=m_SEG<=10
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_EleDial_2SOC(uint8_t m_Flag, uint8_t m_SEG)
{
    #if (PART_NUMBER == RMR42E_60)
        _Fun_Res m_Res;
        uint8_t Num;
        uint8_t m8;
        if (((m_Flag == 1u) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL)) || (checkself_seg_Flag == 1))
        {
            IC1_SEG124 = IC_SEG_ON;
            IC1_SEG123 = IC_SEG_ON;
            IC1_SEG134 = IC_SEG_GREY;
            IC1_SEG125 = IC_SEG_GREY;
            IC1_SEG126 = IC_SEG_GREY;
            IC1_SEG127 = IC_SEG_GREY;
            IC1_SEG128 = IC_SEG_GREY;
            IC1_SEG129 = IC_SEG_GREY;
            IC1_SEG130 = IC_SEG_GREY;
            IC1_SEG131 = IC_SEG_GREY;
            IC1_SEG132 = IC_SEG_GREY;
            IC1_SEG133 = IC_SEG_GREY;
            IC1_SEG134 = IC_SEG_GREY;

            if ((m_SEG == 1) && (Common_GetIgnOnTime() >= 1500) && (SOC_charge_seg_Flag != 1))
            {
                if (FLASH_SYNC_1Hz)
                {
                    IC1_SEG134 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG134 = IC_SEG_GREY;
                }
            }
            else
            {
                switch (m_SEG)
                {

                case 10u:
                    IC1_SEG125 = IC_SEG_ON;
                case 9u:
                    IC1_SEG126 = IC_SEG_ON;
                case 8u:
                    IC1_SEG127 = IC_SEG_ON;
                case 7u:
                    IC1_SEG128 = IC_SEG_ON;
                case 6u:
                    IC1_SEG129 = IC_SEG_ON;
                case 5u:
                    IC1_SEG130 = IC_SEG_ON;
                case 4u:
                    IC1_SEG131 = IC_SEG_ON;
                case 3u:
                    IC1_SEG132 = IC_SEG_ON;
                case 2u:
                    IC1_SEG133 = IC_SEG_ON;
                case 1u:
                    IC1_SEG134 = IC_SEG_ON;
                case 0u:
                    break;
                default:
                    break;
                }
            }
        }
        else
        {
            IC1_SEG134 = IC_SEG_OFF;
            IC1_SEG125 = IC_SEG_OFF;
            IC1_SEG126 = IC_SEG_OFF;
            IC1_SEG127 = IC_SEG_OFF;
            IC1_SEG128 = IC_SEG_OFF;
            IC1_SEG129 = IC_SEG_OFF;
            IC1_SEG130 = IC_SEG_OFF;
            IC1_SEG131 = IC_SEG_OFF;
            IC1_SEG132 = IC_SEG_OFF;
            IC1_SEG133 = IC_SEG_OFF;
            IC1_SEG134 = IC_SEG_OFF;
            // 小电池
            IC1_SEG124 = IC_SEG_OFF;
            IC1_SEG123 = IC_SEG_OFF;
        }

        return m_Res;
    #else
        return EX_OK;
    #endif
}
/**@brief 电量表盘2SOC显示函数
 * @param[in]  m_Flag            段与数字是否显示     -1 显示 -0 不显示
 * @param[in]  m_NUM             车速表盘段数0<=m_SEG<=10
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_EleDial_AllSOC(uint8_t m_Flag, uint16_t m_NUM)
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    if (m_Flag == 1u)
    {
        IC1_SEG054 = IC_SEG_ON;
        /*百位*/
        if (m_NUM >= 100)
        {
            IC1_SEG072 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG072 = IC_SEG_OFF;
        }
        Num = (m_NUM / 10u) % 10u;
        if (m_NUM > 10)
        {
            m8 = SEG_DISPLAY_NUMBER0[Num];
        }
        else
        {
            m8 = SEG_UNDISPLAY_NUMBER0[Num];
        }
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG069 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG069 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG068 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG068 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG066 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG066 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG065 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG065 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG070 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG070 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG071 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG071 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG067 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG067 = IC_SEG_OFF;
        }
        /*个位*/
        Num = m_NUM % 10u;
        m8 = SEG_DISPLAY_NUMBER0[Num];
        if (Bit_Is_Set(m8, 0))
        {
            IC1_SEG060 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG060 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 1))
        {
            IC1_SEG059 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG059 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 2))
        {
            IC1_SEG058 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG058 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 3))
        {
            IC1_SEG064 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG064 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 5))
        {
            IC1_SEG061 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG061 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 4))
        {
            IC1_SEG063 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG063 = IC_SEG_OFF;
        }
        if (Bit_Is_Set(m8, 6))
        {
            IC1_SEG062 = IC_SEG_ON;
        }
        else
        {
            IC1_SEG062 = IC_SEG_OFF;
        }
    }
    else
    {
        IC1_SEG072 = IC_SEG_OFF;
        IC1_SEG071 = IC_SEG_OFF;
        IC1_SEG070 = IC_SEG_OFF;
        IC1_SEG069 = IC_SEG_OFF;
        IC1_SEG068 = IC_SEG_OFF;
        IC1_SEG067 = IC_SEG_OFF;
        IC1_SEG066 = IC_SEG_OFF;
        IC1_SEG065 = IC_SEG_OFF;
        IC1_SEG064 = IC_SEG_OFF;
        IC1_SEG063 = IC_SEG_OFF;
        IC1_SEG062 = IC_SEG_OFF;
        IC1_SEG061 = IC_SEG_OFF;
        IC1_SEG060 = IC_SEG_OFF;
        IC1_SEG059 = IC_SEG_OFF;
        IC1_SEG058 = IC_SEG_OFF;
        IC1_SEG054 = IC_SEG_OFF;
    }

    return m_Res;
}
/**@brief 故障码显示
 * @param[in]  m_Flag            故障码是否显示     -1 显示 -0 不显示
 * @param[in]  m_NUM             故障码数据      0<=m_NUM<=299
 * @param[in]  checkself          是否自检       0<=m_NUM<=299
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_Fault_Code(uint8_t m_Flag, uint16_t m_NUM, uint8_t checkself)
{
    _Fun_Res m_Res;
    uint8_t m8;
    uint8_t high, mid, low;
    uint16_t Num;

    if ((m_Flag > 3u) || (m_NUM > 0xFFFFu))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_Flag == 1u)
        {
            if (checkself == 1)
            {
                IC1_SEG087 = IC_SEG_ON;
                /*千位*/
                Num = (m_NUM / 1000u) % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];

                if (Bit_Is_Set(m8, 0))
                {
                    IC1_SEG094 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG094 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    IC1_SEG093 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG093 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    IC1_SEG091 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG091 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    IC1_SEG090 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG090 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    IC1_SEG088 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG088 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    IC1_SEG089 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG089 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    IC1_SEG092 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG092 = IC_SEG_OFF;
                }
                /*百位*/
                Num = (m_NUM / 100u) % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];

                if (Bit_Is_Set(m8, 0))
                {
                    IC1_SEG101 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG101 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    IC1_SEG100 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG100 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    IC1_SEG098 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG098 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    IC1_SEG097 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG097 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    IC1_SEG095 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG095 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    IC1_SEG096 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG096 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    IC1_SEG099 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG099 = IC_SEG_OFF;
                }
                /*十位*/
                Num = (m_NUM / 10u) % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];
                if (Bit_Is_Set(m8, 0))
                {
                    IC1_SEG108 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG108 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    IC1_SEG107 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG107 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    IC1_SEG105 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG105 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    IC1_SEG104 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG104 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    IC1_SEG102 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG102 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    IC1_SEG103 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG103 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    IC1_SEG106 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG106 = IC_SEG_OFF;
                }
                /*个位*/
                Num = m_NUM % 10u;
                m8 = SEG_DISPLAY_NUMBER0[Num];
                if (Bit_Is_Set(m8, 0))
                {
                    IC1_SEG115 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG115 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 1))
                {
                    IC1_SEG114 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG114 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 2))
                {
                    IC1_SEG113 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG113 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 3))
                {
                    IC1_SEG112 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG112 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 5))
                {
                    IC1_SEG109 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG109 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 4))
                {
                    IC1_SEG111 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG111 = IC_SEG_OFF;
                }
                if (Bit_Is_Set(m8, 6))
                {
                    IC1_SEG110 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG110 = IC_SEG_OFF;
                }
            }
            else
            {
                if (FLASH_SYNC_1Hz)
                {
                    IC1_SEG087 = IC_SEG_ON;
                }
                else
                {
                    IC1_SEG087 = IC_SEG_GREY;
                }

                IC1_SEG094 = IC_SEG_ON;
                IC1_SEG093 = IC_SEG_ON;
                IC1_SEG091 = IC_SEG_ON;
                IC1_SEG090 = IC_SEG_ON;
                IC1_SEG089 = IC_SEG_ON;
                IC1_SEG088 = IC_SEG_ON;
                IC1_SEG092 = IC_SEG_ON;
                IC1_SEG101 = IC_SEG_ON;
                IC1_SEG100 = IC_SEG_ON;
                IC1_SEG098 = IC_SEG_ON;
                IC1_SEG097 = IC_SEG_ON;
                IC1_SEG096 = IC_SEG_ON;
                IC1_SEG095 = IC_SEG_ON;
                IC1_SEG099 = IC_SEG_ON;
                IC1_SEG108 = IC_SEG_ON;
                IC1_SEG107 = IC_SEG_ON;
                IC1_SEG105 = IC_SEG_ON;
                IC1_SEG104 = IC_SEG_ON;
                IC1_SEG103 = IC_SEG_ON;
                IC1_SEG102 = IC_SEG_ON;
                IC1_SEG106 = IC_SEG_ON;
                IC1_SEG115 = IC_SEG_ON;
                IC1_SEG114 = IC_SEG_ON;
                IC1_SEG113 = IC_SEG_ON;
                IC1_SEG112 = IC_SEG_ON;
                IC1_SEG111 = IC_SEG_ON;
                IC1_SEG109 = IC_SEG_ON;
                IC1_SEG110 = IC_SEG_ON;

                high = (m_NUM >> 12) & 0x0F;  // 高
                mid = (m_NUM >> 8) & 0x0F;    // 次高
                low = (m_NUM >> 4) & 0x0F;    // 次低
                uint8_t lowest = m_NUM & 0x0F;  // 低

                m8 = SEG_DISPLAY_NUMBER0[high];
                IC1_SEG094 = Bit_Is_Set(m8, 0) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG093 = Bit_Is_Set(m8, 1) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG091 = Bit_Is_Set(m8, 2) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG090 = Bit_Is_Set(m8, 3) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG089 = Bit_Is_Set(m8, 4) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG088 = Bit_Is_Set(m8, 5) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG092 = Bit_Is_Set(m8, 6) ? IC_SEG_ON : IC_SEG_OFF;

                m8 = SEG_DISPLAY_NUMBER0[mid];
                IC1_SEG101 = Bit_Is_Set(m8, 0) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG100 = Bit_Is_Set(m8, 1) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG098 = Bit_Is_Set(m8, 2) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG097 = Bit_Is_Set(m8, 3) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG096 = Bit_Is_Set(m8, 4) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG095 = Bit_Is_Set(m8, 5) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG099 = Bit_Is_Set(m8, 6) ? IC_SEG_ON : IC_SEG_OFF;

                m8 = SEG_DISPLAY_NUMBER0[low];
                IC1_SEG108 = Bit_Is_Set(m8, 0) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG107 = Bit_Is_Set(m8, 1) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG105 = Bit_Is_Set(m8, 2) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG104 = Bit_Is_Set(m8, 3) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG103 = Bit_Is_Set(m8, 4) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG102 = Bit_Is_Set(m8, 5) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG106 = Bit_Is_Set(m8, 6) ? IC_SEG_ON : IC_SEG_OFF;

                // 显示低位
                m8 = SEG_DISPLAY_NUMBER0[lowest];
                IC1_SEG115 = Bit_Is_Set(m8, 0) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG114 = Bit_Is_Set(m8, 1) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG113 = Bit_Is_Set(m8, 2) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG112 = Bit_Is_Set(m8, 3) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG111 = Bit_Is_Set(m8, 4) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG109 = Bit_Is_Set(m8, 5) ? IC_SEG_ON : IC_SEG_OFF;
                IC1_SEG110 = Bit_Is_Set(m8, 6) ? IC_SEG_ON : IC_SEG_OFF;
            }
        }
        else
        {
            IC1_SEG074 = IC_SEG_OFF;
            IC1_SEG114 = IC_SEG_OFF;
            IC1_SEG115 = IC_SEG_OFF;
            IC1_SEG116 = IC_SEG_OFF;
            IC1_SEG101 = IC_SEG_OFF;

            IC1_SEG082 = IC_SEG_OFF;
            IC1_SEG083 = IC_SEG_OFF;
            IC1_SEG084 = IC_SEG_OFF;
            IC1_SEG085 = IC_SEG_OFF;
            IC1_SEG087 = IC_SEG_OFF;
            IC1_SEG088 = IC_SEG_OFF;
            IC1_SEG089 = IC_SEG_OFF;
            IC1_SEG090 = IC_SEG_OFF;
            IC1_SEG091 = IC_SEG_OFF;
            IC1_SEG092 = IC_SEG_OFF;
            IC1_SEG093 = IC_SEG_OFF;
            IC1_SEG094 = IC_SEG_OFF;
            IC1_SEG095 = IC_SEG_OFF;
            IC1_SEG096 = IC_SEG_OFF;
            IC1_SEG097 = IC_SEG_OFF;
            IC1_SEG098 = IC_SEG_OFF;
            IC1_SEG099 = IC_SEG_OFF;
            IC1_SEG100 = IC_SEG_OFF;
            IC1_SEG102 = IC_SEG_OFF;
            IC1_SEG103 = IC_SEG_OFF;
            IC1_SEG104 = IC_SEG_OFF;
            IC1_SEG105 = IC_SEG_OFF;
            IC1_SEG106 = IC_SEG_OFF;
            IC1_SEG107 = IC_SEG_OFF;
            IC1_SEG108 = IC_SEG_OFF;
            IC1_SEG109 = IC_SEG_OFF;
            IC1_SEG110 = IC_SEG_OFF;
            IC1_SEG111 = IC_SEG_OFF;
            IC1_SEG112 = IC_SEG_OFF;
            IC1_SEG113 = IC_SEG_OFF;
        }

        m_Res = EX_OK;
    }
    return m_Res;
}

// /**@brief 续航里程显示函数

// * @param[in]  m_Flag           续航里程是否显示     -2 显示---km  -1 显示  -0 不显示
// * @param[in]  m_NUM            续航里程数值   0<=m_NUM<=999
// * @return  函数执行结果
// * - EX_OK      		上报成功
// * - EX_ERR        	上报失败
// */
// _Fun_Res SEG_SET_DTE_NUM(uint8_t m_Flag, uint16_t m_NUM)
// {
//     _Fun_Res m_Res;
//     uint16_t Num;
//     uint8_t m8;
//     if ((m_Flag > 2u) || (m_NUM > 999u))
//     {
//         m_Res = EX_ERR;
//     }
//     else
//     {
//         if (m_Flag == 1u)
//         {
//             IC1_SEG099 = IC_SEG_ON;
//             IC1_SEG065 = IC_SEG_ON;
//             /*百位*/
//             Num = m_NUM / 100u;
//             m8 = SEG_UNDISPLAY_NUMBER0[Num];
//             if (Bit_Is_Set(m8, 0))
//             {
//                 IC1_SEG050 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG050 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 1))
//             {
//                 IC1_SEG049 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG049 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 2))
//             {
//                 IC1_SEG047 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG047 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 3))
//             {
//                 IC1_SEG046 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG046 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 5))
//             {
//                 IC1_SEG045 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG045 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 4))
//             {
//                 IC1_SEG044 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG044 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 6))
//             {
//                 IC1_SEG048 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG048 = IC_SEG_OFF;
//             }
//             /*十位*/
//             Num = (m_NUM / 10u) % 10u;
//             if (m_NUM >= 100u)
//             {
//                 m8 = SEG_DISPLAY_NUMBER0[Num];
//             }
//             else
//             {
//                 m8 = SEG_UNDISPLAY_NUMBER0[Num];
//             }

//             if (Bit_Is_Set(m8, 0))
//             {
//                 IC1_SEG057 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG057 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 1))
//             {
//                 IC1_SEG056 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG056 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 2))
//             {
//                 IC1_SEG054 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG054 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 3))
//             {
//                 IC1_SEG053 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG053 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 5))
//             {
//                 IC1_SEG052 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG052 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 4))
//             {
//                 IC1_SEG051 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG051 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 6))
//             {
//                 IC1_SEG055 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG055 = IC_SEG_OFF;
//             }
//             /*个位*/
//             Num = m_NUM % 10u;
//             m8 = SEG_DISPLAY_NUMBER0[Num];
//             if (Bit_Is_Set(m8, 0))
//             {
//                 IC1_SEG064 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG064 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 1))
//             {
//                 IC1_SEG063 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG063 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 2))
//             {
//                 IC1_SEG061 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG061 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 3))
//             {
//                 IC1_SEG060 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG060 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 5))
//             {
//                 IC1_SEG059 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG059 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 4))
//             {
//                 IC1_SEG058 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG058 = IC_SEG_OFF;
//             }
//             if (Bit_Is_Set(m8, 6))
//             {
//                 IC1_SEG062 = IC_SEG_ON;
//             }
//             else
//             {
//                 IC1_SEG062 = IC_SEG_OFF;
//             }
//         }
//         else if (m_Flag == 2u)
//         {
//             IC1_SEG099 = IC_SEG_ON;
//             IC1_SEG065 = IC_SEG_ON;

//             IC1_SEG044 = IC_SEG_OFF;
//             IC1_SEG045 = IC_SEG_OFF;
//             IC1_SEG046 = IC_SEG_OFF;
//             IC1_SEG047 = IC_SEG_OFF;
//             IC1_SEG048 = IC_SEG_ON;
//             IC1_SEG049 = IC_SEG_OFF;
//             IC1_SEG050 = IC_SEG_OFF;
//             IC1_SEG051 = IC_SEG_OFF;
//             IC1_SEG052 = IC_SEG_OFF;
//             IC1_SEG053 = IC_SEG_OFF;
//             IC1_SEG054 = IC_SEG_OFF;
//             IC1_SEG055 = IC_SEG_ON;
//             IC1_SEG056 = IC_SEG_OFF;
//             IC1_SEG057 = IC_SEG_OFF;
//             IC1_SEG058 = IC_SEG_OFF;
//             IC1_SEG059 = IC_SEG_OFF;
//             IC1_SEG060 = IC_SEG_OFF;
//             IC1_SEG061 = IC_SEG_OFF;
//             IC1_SEG062 = IC_SEG_ON;
//             IC1_SEG063 = IC_SEG_OFF;
//             IC1_SEG064 = IC_SEG_OFF;
//         }

//         else
//         {
//             IC1_SEG099 = IC_SEG_OFF;
//             IC1_SEG065 = IC_SEG_OFF;

//             IC1_SEG044 = IC_SEG_OFF;
//             IC1_SEG045 = IC_SEG_OFF;
//             IC1_SEG046 = IC_SEG_OFF;
//             IC1_SEG047 = IC_SEG_OFF;
//             IC1_SEG048 = IC_SEG_OFF;
//             IC1_SEG049 = IC_SEG_OFF;
//             IC1_SEG050 = IC_SEG_OFF;
//             IC1_SEG051 = IC_SEG_OFF;
//             IC1_SEG052 = IC_SEG_OFF;
//             IC1_SEG053 = IC_SEG_OFF;
//             IC1_SEG054 = IC_SEG_OFF;
//             IC1_SEG055 = IC_SEG_OFF;
//             IC1_SEG056 = IC_SEG_OFF;
//             IC1_SEG057 = IC_SEG_OFF;
//             IC1_SEG058 = IC_SEG_OFF;
//             IC1_SEG059 = IC_SEG_OFF;
//             IC1_SEG060 = IC_SEG_OFF;
//             IC1_SEG061 = IC_SEG_OFF;
//             IC1_SEG062 = IC_SEG_OFF;
//             IC1_SEG063 = IC_SEG_OFF;
//             IC1_SEG064 = IC_SEG_OFF;
//         }

//         m_Res = EX_OK;
//     }
//     return m_Res;
// }

/**@brief 车速8字段显示函数
 * @param[in]  m_Flag            车速是否显示     -1 显示 -0 不显示
 * @param[in]  m_NUM             车速数据      0<=m_NUM<=299
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */

//_Fun_Res SEG_SET_VSpeed_NUM(uint8_t m_Flag, uint16_t m_NUM)
//{
//    _Fun_Res m_Res;
//    uint16_t Num;
//    uint8_t m8;
//    if (m_NUM > 9)
//    {
//        RTE_GPIO_Set_Level(VSPEED_TEN_OUT, 1);
//    }
//    else
//    {
//        RTE_GPIO_Set_Level(VSPEED_TEN_OUT, 0);
//    }

//    if (m_NUM > 99)
//    {
//        RTE_GPIO_Set_Level(VSPEED_HUNDREDS_OUT, 1);
//    }
//    else
//    {
//        RTE_GPIO_Set_Level(VSPEED_HUNDREDS_OUT, 0);
//    }

//    if ((m_Flag > 2u) || (m_NUM > 299u))
//    {
//        m_Res = EX_ERR;
//    }
//    else
//    {
//        if (m_Flag == 1u)
//        {
//            if (ClearODO_Flag == 1)
//            {
//                IC1_SEG059 = IC_SEG_ON;
//                IC1_SEG058 = IC_SEG_ON;
//                LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_MPH, 100);
//                LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_KM_H, 100);
//            }
//            else
//            {
//                if (Common_GetIgnOnTime() < 3000)
//                {
//                    IC1_SEG059 = IC_SEG_ON;
//                    IC1_SEG058 = IC_SEG_ON;
//                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_MPH, 100);
//                    LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_KM_H, 100);
//                }
//                else
//                {
//                    if ((Get_Dis_Unit() == 1))
//                    {
//                        IC1_SEG059 = IC_SEG_OFF;
//                        IC1_SEG058 = IC_SEG_ON;
//                        LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_MPH, 100);
//                        LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_KM_H, 0);
//                    }
//                    else
//                    {
//                        IC1_SEG059 = IC_SEG_ON;
//                        IC1_SEG058 = IC_SEG_OFF;
//                        LED_Driver_Channel_Set(LampChannel_0, LampCh0_29_MPH, 0);
//                        LED_Driver_Channel_Set(LampChannel_0, LampCh0_30_KM_H, 100);
//                    }
//                }
//            }

//            /*百位*/
//            Num = m_NUM / 100u;
//            if (Num == 1u)
//            {
//                IC1_SEG060 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG060 = IC_SEG_OFF;
//            }
//            /*十位*/
//            Num = (m_NUM / 10u) % 10u;
//            if (m_NUM >= 100u)
//            {
//                m8 = SEG_DISPLAY_NUMBER0[Num];
//            }
//            else
//            {
//                m8 = SEG_UNDISPLAY_NUMBER0[Num];
//            }

//            if (Bit_Is_Set(m8, 0))
//            {
//                IC1_SEG129 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG129 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 1))
//            {
//                IC1_SEG066 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG066 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 2))
//            {
//                IC1_SEG065 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG065 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 3))
//            {
//                IC1_SEG064 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG064 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 4))
//            {
//                IC1_SEG063 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG063 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 5))
//            {
//                IC1_SEG061 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG061 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 6))
//            {
//                IC1_SEG062 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG062 = IC_SEG_OFF;
//            }
//            /*个位*/
//            Num = m_NUM % 10u;
//            m8 = SEG_DISPLAY_NUMBER0[Num];
//            if (Bit_Is_Set(m8, 0))
//            {
//                IC1_SEG130 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG130 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 1))
//            {
//                IC1_SEG136 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG136 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 2))
//            {
//                IC1_SEG135 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG135 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 3))
//            {
//                IC1_SEG134 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG134 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 5))
//            {
//                IC1_SEG131 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG131 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 4))
//            {
//                IC1_SEG133 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG133 = IC_SEG_OFF;
//            }
//            if (Bit_Is_Set(m8, 6))
//            {
//                IC1_SEG132 = IC_SEG_ON;
//            }
//            else
//            {
//                IC1_SEG132 = IC_SEG_OFF;
//            }
//        }

//        else
//        {
//            IC1_SEG058 = IC_SEG_OFF;
//            IC1_SEG059 = IC_SEG_OFF;

//            IC1_SEG060 = IC_SEG_OFF;
//            IC1_SEG061 = IC_SEG_OFF;
//            IC1_SEG062 = IC_SEG_OFF;
//            IC1_SEG063 = IC_SEG_OFF;
//            IC1_SEG064 = IC_SEG_OFF;
//            IC1_SEG065 = IC_SEG_OFF;
//            IC1_SEG066 = IC_SEG_OFF;
//            IC1_SEG129 = IC_SEG_OFF;
//            IC1_SEG130 = IC_SEG_OFF;
//            IC1_SEG131 = IC_SEG_OFF;
//            IC1_SEG132 = IC_SEG_OFF;
//            IC1_SEG133 = IC_SEG_OFF;
//            IC1_SEG134 = IC_SEG_OFF;
//            IC1_SEG135 = IC_SEG_OFF;
//            IC1_SEG136 = IC_SEG_OFF;
//        }

//        m_Res = EX_OK;
//    }
//    return m_Res;
//}

/**@brief L8字段显示函数
 * @param[in]  m_Flag            车速是否显示     -2 L-  -1 显示 -0 不显示
 * @param[in]  m_NUM             车速数据      0<=m_NUM<=9
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */

_Fun_Res SEG_SET_L8_NUM(uint8_t m_Flag, uint8_t m_NUM)
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    if ((m_Flag > 2u) || (m_NUM > 9u))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_Flag == 1u)
        {
            IC2_SEG051 = IC_SEG_ON;
            Num = m_NUM;
            m8 = SEG_DISPLAY_NUMBER0[Num];

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG055 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG052 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG056 = IC_SEG_OFF;
            }
        }
        else if (m_Flag == 2u)
        {
            IC2_SEG051 = IC_SEG_ON;

            IC2_SEG052 = IC_SEG_OFF;
            IC2_SEG053 = IC_SEG_OFF;
            IC2_SEG054 = IC_SEG_OFF;
            IC2_SEG055 = IC_SEG_OFF;
            IC2_SEG056 = IC_SEG_ON;
            IC2_SEG057 = IC_SEG_OFF;
            IC2_SEG058 = IC_SEG_OFF;
        }
        else
        {

            IC2_SEG051 = IC_SEG_OFF;

            IC2_SEG052 = IC_SEG_OFF;
            IC2_SEG053 = IC_SEG_OFF;
            IC2_SEG054 = IC_SEG_OFF;
            IC2_SEG055 = IC_SEG_OFF;
            IC2_SEG056 = IC_SEG_OFF;
            IC2_SEG057 = IC_SEG_OFF;
            IC2_SEG058 = IC_SEG_OFF;
        }

        m_Res = EX_OK;
    }
    return m_Res;
}

/**@brief 单次时间显示函数
 * @param[in]  m_hour            小时
 * @param[in]  m_minute          分钟
 * @param[in]  m_icon            中间冒号是否显示 -1 显示 -0 不显示
 * @param[in]  m_Flag1           小时是否显示     -1 显示 -0 不显示
 * @param[in]  m_Flag2           分钟是否显示     -1 显示 -0 不显示
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2)
{
    _Fun_Res m_Res;
    uint8_t Num;
    uint8_t m8;
    if ((m_hour > 99u) || (m_minute > 99u) || (m_icon > 1u) || (m_Flag1 > 1u) || (m_Flag2 > 1u))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_icon == 1u)
        {
            IC2_SEG084 = IC_SEG_ON;
        }
        else
        {
            IC2_SEG084 = IC_SEG_OFF;
        }
        if (m_Flag1 == 1u)
        {
            Num = m_hour / 10u; /*86104-11*/
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG036 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG036 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG035 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG035 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG079 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG079 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG078 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG078 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG037 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG037 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG039 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG039 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG038 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG038 = IC_SEG_OFF;
            }
            Num = m_hour % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG033 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG033 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG032 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG032 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG083 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG083 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG082 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG082 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG034 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG034 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG081 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG081 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG080 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG080 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG036 = IC_SEG_OFF;
            IC2_SEG035 = IC_SEG_OFF;
            IC2_SEG079 = IC_SEG_OFF;
            IC2_SEG078 = IC_SEG_OFF;
            IC2_SEG039 = IC_SEG_OFF;
            IC2_SEG037 = IC_SEG_OFF;
            IC2_SEG038 = IC_SEG_OFF;
            IC2_SEG033 = IC_SEG_OFF;
            IC2_SEG032 = IC_SEG_OFF;
            IC2_SEG083 = IC_SEG_OFF;
            IC2_SEG082 = IC_SEG_OFF;
            IC2_SEG081 = IC_SEG_OFF;
            IC2_SEG034 = IC_SEG_OFF;
            IC2_SEG080 = IC_SEG_OFF;
        }
        if (m_Flag2 == 1u)
        {
            Num = m_minute / 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG030 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG030 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG029 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG029 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG088 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG088 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG087 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG087 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG031 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG031 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG086 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG086 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG085 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG085 = IC_SEG_OFF;
            }
            Num = m_minute % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG027 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG027 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG026 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG026 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG092 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG092 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG091 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG091 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG028 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG028 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG090 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG090 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG089 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG089 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG030 = IC_SEG_OFF;
            IC2_SEG029 = IC_SEG_OFF;
            IC2_SEG088 = IC_SEG_OFF;
            IC2_SEG087 = IC_SEG_OFF;
            IC2_SEG086 = IC_SEG_OFF;
            IC2_SEG031 = IC_SEG_OFF;
            IC2_SEG085 = IC_SEG_OFF;
            IC2_SEG027 = IC_SEG_OFF;
            IC2_SEG026 = IC_SEG_OFF;
            IC2_SEG092 = IC_SEG_OFF;
            IC2_SEG091 = IC_SEG_OFF;
            IC2_SEG090 = IC_SEG_OFF;
            IC2_SEG028 = IC_SEG_OFF;
            IC2_SEG089 = IC_SEG_OFF;
        }
        m_Res = EX_OK;
    }
    return m_Res;
}

/**@brief 累计时间显示函数
 * @param[in]  m_Flag           是否显示     -1 显示 -0 不显示
 * @param[in]  m_NUM            显示时间
 * @return  函数执行结果
 * - EX_OK      		上报成功
 * - EX_ERR        	上报失败
 */
_Fun_Res SEG_SET_Clock_ALL(uint8_t m_Flag, uint32_t m_NUM)
{
    _Fun_Res m_Res;
    uint32_t Num;
    uint8_t m8;
    if ((m_Flag > 2u) || (m_NUM > 99999u))
    {
        m_Res = EX_ERR;
    }
    else
    {
        if (m_Flag == 1u)
        {
            IC2_SEG077 = IC_SEG_ON;

            Num = m_NUM / 10000u;
            if ((m_NUM > 10000) || (checkself_seg_Flag == 1))
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG047 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG047 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG046 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG046 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG044 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG044 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG043 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG043 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG042 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG042 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG041 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG041 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG045 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG045 = IC_SEG_OFF;
            }
            /*千位*/
            Num = (m_NUM / 1000u) % 10u;
            if ((m_NUM > 1000) || (checkself_seg_Flag == 1))
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG054 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG054 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG053 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG053 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG051 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG051 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG050 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG050 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG049 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG049 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG048 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG048 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG052 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG052 = IC_SEG_OFF;
            }
            /*百位*/
            Num = (m_NUM / 100u) % 10u;
            if ((m_NUM > 100) || (checkself_seg_Flag == 1))
            {
                m8 = SEG_DISPLAY_NUMBER0[Num];
            }
            else
            {
                m8 = SEG_UNDISPLAY_NUMBER0[Num];
            }

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG061 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG061 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG060 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG060 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG058 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG058 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG057 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG057 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG056 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG056 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG055 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG055 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG059 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG059 = IC_SEG_OFF;
            }
            /*十位*/
            Num = (m_NUM / 10u) % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            IC2_SEG069 = IC_SEG_ON;

            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG068 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG068 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG067 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG067 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG066 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG066 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG065 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG065 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG064 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG064 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG062 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG062 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG063 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG063 = IC_SEG_OFF;
            }
            /*个位*/
            Num = m_NUM % 10u;
            m8 = SEG_DISPLAY_NUMBER0[Num];
            if (Bit_Is_Set(m8, 0))
            {
                IC2_SEG076 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG076 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 1))
            {
                IC2_SEG075 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG075 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 2))
            {
                IC2_SEG073 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG073 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 3))
            {
                IC2_SEG072 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG072 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 4))
            {
                IC2_SEG071 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG071 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 5))
            {
                IC2_SEG070 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG070 = IC_SEG_OFF;
            }
            if (Bit_Is_Set(m8, 6))
            {
                IC2_SEG074 = IC_SEG_ON;
            }
            else
            {
                IC2_SEG074 = IC_SEG_OFF;
            }
        }
        else
        {
            IC2_SEG041 = IC_SEG_OFF;
            IC2_SEG042 = IC_SEG_OFF;
            IC2_SEG043 = IC_SEG_OFF;
            IC2_SEG044 = IC_SEG_OFF;
            IC2_SEG045 = IC_SEG_OFF;
            IC2_SEG046 = IC_SEG_OFF;
            IC2_SEG047 = IC_SEG_OFF;
            IC2_SEG048 = IC_SEG_OFF;
            IC2_SEG049 = IC_SEG_OFF;
            IC2_SEG050 = IC_SEG_OFF;
            IC2_SEG051 = IC_SEG_OFF;
            IC2_SEG052 = IC_SEG_OFF;
            IC2_SEG053 = IC_SEG_OFF;
            IC2_SEG054 = IC_SEG_OFF;
            IC2_SEG055 = IC_SEG_OFF;
            IC2_SEG056 = IC_SEG_OFF;
            IC2_SEG057 = IC_SEG_OFF;
            IC2_SEG058 = IC_SEG_OFF;
            IC2_SEG059 = IC_SEG_OFF;
            IC2_SEG060 = IC_SEG_OFF;
            IC2_SEG061 = IC_SEG_OFF;
            IC2_SEG062 = IC_SEG_OFF;
            IC2_SEG063 = IC_SEG_OFF;
            IC2_SEG064 = IC_SEG_OFF;
            IC2_SEG065 = IC_SEG_OFF;
            IC2_SEG066 = IC_SEG_OFF;
            IC2_SEG067 = IC_SEG_OFF;
            IC2_SEG068 = IC_SEG_OFF;
            IC2_SEG069 = IC_SEG_OFF;
            IC2_SEG070 = IC_SEG_OFF;
            IC2_SEG071 = IC_SEG_OFF;
            IC2_SEG072 = IC_SEG_OFF;
            IC2_SEG073 = IC_SEG_OFF;
            IC2_SEG074 = IC_SEG_OFF;
            IC2_SEG075 = IC_SEG_OFF;
            IC2_SEG076 = IC_SEG_OFF;
            IC2_SEG077 = IC_SEG_OFF;
        }

        m_Res = EX_OK;
    }
    return m_Res;
}
uint8_t check_SEG_step = 0;


/*仪表段码扫描函数*/
void Check_SEG_Display(void)
{
    uint16_t hour = 0;
    uint16_t min = 0;
    uint8_t soc_all = 0;
    uint8_t Checkself_num = ((check_SEG_step * 10) / 48);
    if (Checkself_num >= 10)
    {
        Checkself_num = 9;
    }
    uint32_t allhour = Checkself_num * 11111;
    if (PART_NUMBER == G54_A01)
    {
        uint8_t Fuel = 0;
        uint32_t fau_code = Checkself_num * 1111;
        Fuel = Checkself_SEG_step / 5u;
        SEG_SET_FuelDial(1, Fuel);
        SEG_SET_Fault_Code(1, fau_code, 1);
    }
    uint32_t EleDial_2SOC = ((check_SEG_step * 10) / 48);

    SEG_SET_EleDial_2SOC(1, EleDial_2SOC);
    SEG_SET_EleDial_1SOC(1, EleDial_2SOC);
    soc_all = Checkself_num * 11 + 100;
    SEG_SET_EleDial_AllSOC(1, soc_all);
    checkself_seg_Flag = 1;
    SEG_SET_Clock_ALL(1, allhour);
    hour = Checkself_num * 11;
    min = Checkself_num * 11;
    SEG_SET_Clock(hour, min, 1, 1, 1);
    SEG_SET_GEAR(1, Checkself_num, 1);
    SEG_SET_Cutterhead(1, Checkself_num, 1);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_ON);
    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);

    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_External_Discharge_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_ON);
    SEG_SET_LED_STS(SEG_LED_Recharge, 1);
    SEG_SET_LED_STS(SEG_LED_System_Light, 1);
    SEG_SET_LED_STS(SEG_LED_Chloramine, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 1);
    SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
    SEG_SET_LED_STS(SEG_LED_Key_Access, 1);
    SEG_SET_LED_STS(SEG_LED_Ready, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 1);
    // SEG_SET_LED_STS(SEG_LED_External_Discharge, 1);
    SEG_SET_LED_STS(SEG_LED_Distance_Light, 1);
    SEG_SET_LED_STS(SEG_LED_HHT_Charger, 1);
    SEG_SET_Frame(1);
    if (check_SEG_step < 50)
    {
        check_SEG_step++;
    }
    else
    {
        check_SEG_step = 0;
    }
}

uint8_t Checkself_SEG_step = 0;
uint8_t Checkself_SEG_step_count = 0;
void Checkself_Init(void)
{
    Checkself_SEG_step = 0;
    Checkself_SEG_step_count = 0;
    checkself_seg_Flag = 0;
    check_SEG_step = 0;
    Buzzer_time = 0;
}
uint8_t soc_all = 0;
void Checkself_SEG_Display(void)
{
    // uint16_t Fuel = 0;
    uint16_t Trip = 0;
    uint16_t hour = 0;
    uint16_t min = 0;
    uint8_t Checkself_num = ((Checkself_SEG_step * 10) / 48);
    if (Checkself_num >= 10)
    {
        Checkself_num = 9;
    }
    uint32_t allhour = Checkself_num * 11111;
    if (PART_NUMBER == G54_A01)
    {
        uint8_t Fuel = 0;
        uint32_t fau_code = Checkself_num * 1111;
        Fuel = Checkself_SEG_step / 5u;
        SEG_SET_FuelDial(1, Fuel);
        SEG_SET_Fault_Code(1, fau_code, 1);
    }
    uint32_t EleDial_2SOC = ((Checkself_SEG_step * 10) / 48);

    SEG_SET_EleDial_2SOC(1, EleDial_2SOC);
    SEG_SET_EleDial_1SOC(1, EleDial_2SOC);
    soc_all = Checkself_num * 11 + 100;
    SEG_SET_EleDial_AllSOC(1, soc_all);
    SEG_SET_Clock_ALL(1, allhour);
    hour = Checkself_num * 11;
    min = Checkself_num * 11;
    SEG_SET_Clock(hour, min, 1, 1, 1);
    SEG_SET_GEAR(1, Checkself_num, 1);
    SEG_SET_Cutterhead(1, Checkself_num, 1);
    if (Checkself_SEG_step_count < 100)
    {
        Checkself_SEG_step_count++;
    }
    else
    {
        Checkself_SEG_step_count = 100;
    }

    if (Checkself_SEG_step_count < 50)
    {
        Checkself_SEG_step++;
    }
    else
    {
        if (Checkself_SEG_step == 0)
        {
            Checkself_SEG_step = 0;
        }
        else
        {
            Checkself_SEG_step--;
        }
    }

    // if (Checkself_SEG_step_count < 60)
    // {
    //     Checkself_SEG_step_count++;
    // }
    // else
    // {
    //     Checkself_SEG_step_count = 60;
    // }

    // if (Checkself_SEG_step_count < 30)
    // {
    //     Checkself_SEG_step++;
    // }
    // else
    // {
    //     if (Checkself_SEG_step == 0)
    //     {
    //         Checkself_SEG_step = 0;
    //         SEG_SET_EleDial_2SOC(1, 0);
    //         SEG_SET_EleDial_1SOC(1, 0);
    //     }
    //     else
    //     {
    //         Checkself_SEG_step--;
    //     }
    // }
}
