#include "Components.h"
#include "Data_Soc\Data_Soc.h"

SocStruct_st_t Soc;

uint8_t SOC_Count_Time = 0;
uint16_t SocPoweroffTime = 0;

static void Data_Soc_Battery_Level_Service(void);
static void Data_Soc_DisplayEffect_Service(void);
static void Data_Soc_Battery_Icon_Service(void);
static void Data_Soc_All_Soc_Service(void);

void Data_Soc_KL30_Init(void)
{
    Soc.Value1 = 0U;        //电量1实际值
    Soc.Value2 = 0U;        //电量2实际值
    Soc.Valid1 = 0U;        //电量1状态
    Soc.Valid2 = 0U;        //电量2状态
    Soc.Act_Seg1 = 0U;
    Soc.Act_Seg2 = 0U;
    Soc.Dis_Seg1 = 0U;
    Soc.Dis_Seg2 = 0U;
    Soc.Battery1Icon = 0U;
    Soc.Battery2Icon = 0U;
    Soc.AllSocValue = 0U;
    Soc.AllSocValid = 0U;
    SocPoweroffTime = 0U;
}

void Data_Soc_KL15_Init(void)
{
    Soc.Value1 = 0;        //电量1实际值
    Soc.Value2 = 0;        //电量2实际值
    Soc.Valid1 = 0;        //电量1状态
    Soc.Valid2 = 0;        //电量2状态
    Soc.Dis_Seg1 = 0;
    Soc.Dis_Seg2 = 0;
    Soc.Battery1Icon = 0U;
    Soc.Battery2Icon = 0U;
    Soc.AllSocValue = 0U;
    Soc.AllSocValid = 0U;
    SocPoweroffTime = 0U;
}

static void Data_Soc_Battery_Level_Service(void)
{
    if ((Get_CAN_Power_State() >= KEY_ACC) && (Get_CAN_Power_State() <= CHRGEND))
    {
        #if (PART_NUMBER == RMR42E_60)
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL)
            {
                Soc.Value1 = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
                Soc.Valid1 = 1U;
            }
            else
            {
                Soc.Value1 = 0U;
                Soc.Valid1 = 0U;
            }
        #else
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x17A_Msg)) == CAN_SIG_NORMAL)
            {
                Soc.Value1 = Get_CAN_CH0_ID_17A_Sig_MBMS_StatSoc();
                Soc.Valid1 = 1U;
            }
            else
            {
                Soc.Value1 = 0U;
                Soc.Valid1 = 0U;
            }
        #endif

        if (Soc.Valid1 != 0U)
        {
            Soc.Act_Seg1 = (Soc.Value1 / 10U);
            if ((Soc.Value1 % 10) != 0)
            {
                Soc.Act_Seg1++;
            }
            if (Soc.Act_Seg1 > 10)
            {
                Soc.Act_Seg1 = 10;
            }
        }
        else
        {
            Soc.Act_Seg1 = 0U;
        }
        
        #if (PART_NUMBER == RMR42E_60)
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL)
            {
                Soc.Value2 = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
                Soc.Valid2 = 1U;
            }
            else
            {
                Soc.Value2 = 0U;
                Soc.Valid2 = 0U;
            }

            if (Soc.Valid2 != 0U)
            {
                Soc.Act_Seg2 = (Soc.Value2 / 10);
                if ((Soc.Value2 % 10) != 0)
                {
                    Soc.Act_Seg2++;
                }
                if (Soc.Act_Seg2 > 10)
                {
                    Soc.Act_Seg2 = 10;
                }
            }
            else
            {
                Soc.Act_Seg2 = 0U;
            }
        #endif
    }
    else
    {
        Soc.Value1 = 0U;
        Soc.Valid1 = 0U;
        Soc.Value2 = 0U;
        Soc.Valid2 = 0U;
        Soc.Act_Seg1 = 0U;
        Soc.Act_Seg2 = 0U;
    }
}

static void Data_Soc_DisplayEffect_Service(void)
{
    #if (PART_NUMBER == RMR42E_60)
    uint8_t MBMS_TOTALSigAcc = Get_CAN_Num_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_Num_MBMS_TOTALSigCharge();
    uint8_t MBMS_StatBattWorkState = Get_CAN_Num_MBMS_StatBattWorkState();

    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
    {
        if (((Get_CAN_Power_State() >= KEY_ACC) && (Get_CAN_Power_State() < CHRGING)) || (Get_CAN_Power_State() == CHRGEND))
        {
            /*保证电量条1和2闪烁同步*/
            if (FLASH_SYNC_1Hz)
            {
                if(Soc.Act_Seg1 == 1U)
                {
                    Soc.Dis_Seg1 = 1U;
                }
                if(Soc.Act_Seg2 == 1U)
                {
                    Soc.Dis_Seg2 = 1U;
                }
            }
            else
            {
                if(Soc.Act_Seg1 == 1U)
                {
                    Soc.Dis_Seg1 = 0U;
                }
                if(Soc.Act_Seg2 == 1U)
                {
                    Soc.Dis_Seg2 = 0U;
                }
            }
            if(Soc.Act_Seg1 != 1U)
            {
                Soc.Dis_Seg1 = Soc.Act_Seg1;
            }

            if(Soc.Act_Seg2 != 1U)
            {
                Soc.Dis_Seg2 = Soc.Act_Seg2;
            }   

            SocPoweroffTime = 0U;
        }
        else if (Get_CAN_Power_State() == CHRGING)
        {
            if ((MBMS_TOTALSigCharge == 1U) && (MBMS_TOTALSigAcc == 0U))
            {
                if (SocPoweroffTime >= 3600U)
                {
                    Soc.Valid1 = 0U;
                    Soc.Valid2 = 0U;
                }
                else 
                {
                    SocPoweroffTime ++;
                }
            }

            if ((MBMS_TOTALSigCharge == 1U) && ((MBMS_TOTALSigAcc == 0U) || (MBMS_TOTALSigAcc == 1U)))
            {
                if (MBMS_StatBattWorkState == 0x1) // 主电池
                {
                    if (Soc.Act_Seg2 == 1U)
                    {
                        if (FLASH_SYNC_1Hz)
                        {
                            Soc.Dis_Seg2 = 1U;
                        }
                        else
                        {
                            Soc.Dis_Seg2 = 0U;
                        }
                    }
                    else
                    {
                        Soc.Dis_Seg2 = Soc.Act_Seg2;
                    }
                    if (++SOC_Count_Time > 10U)
                    {
                        SOC_Count_Time = 0U;
                        Soc.Dis_Seg1 ++;
                        if (Soc.Dis_Seg1 > Soc.Act_Seg1)
                        {
                            Soc.Dis_Seg1 = 0U;
                        }
                    }
                }
                else if (MBMS_StatBattWorkState == 0x4) // 副电池
                {
                    if (Soc.Act_Seg1 == 1U)
                    {
                        if (FLASH_SYNC_1Hz)
                        {
                            Soc.Dis_Seg1 = 1U;
                        }
                        else
                        {
                            Soc.Dis_Seg1 = 0U;
                        }
                    }
                    else
                    {
                        Soc.Dis_Seg1 = Soc.Act_Seg1;
                    }
                    
                    if (++SOC_Count_Time > 10U)
                    {
                        SOC_Count_Time = 0U;
                        Soc.Dis_Seg2 ++;
                        if (Soc.Dis_Seg2 > Soc.Act_Seg2)
                        {
                            Soc.Dis_Seg2 = 0U;
                        }
                    }
                }
                else if (MBMS_StatBattWorkState == 0x7) // 主副电池
                {
                    if (++SOC_Count_Time > 10U)
                    {
                        SOC_Count_Time = 0U;
                        Soc.Dis_Seg1 ++;
                        Soc.Dis_Seg2 ++;
                        if (Soc.Act_Seg1 > Soc.Act_Seg2)
                        {
                            if (Soc.Dis_Seg2 > Soc.Act_Seg2)
                            {
                                Soc.Dis_Seg2 = Soc.Act_Seg2;
                                if (Soc.Dis_Seg1 > Soc.Act_Seg1)
                                {
                                    Soc.Dis_Seg1 = 0U;
                                    Soc.Dis_Seg2 = 0U;
                                }
                            }
                        }
                        else
                        {
                            if (Soc.Dis_Seg1 > Soc.Act_Seg1)
                            {
                                Soc.Dis_Seg1 = Soc.Act_Seg1;
                                if (Soc.Dis_Seg2 > Soc.Act_Seg2)
                                {
                                    Soc.Dis_Seg1 = 0U;
                                    Soc.Dis_Seg2 = 0U;
                                }
                            }
                        }
                    }
                }
                else
                {
                    SOC_Count_Time = 0U;
                    /*保证电量条1和2闪烁同步*/
                    if (FLASH_SYNC_1Hz)
                    {
                        if(Soc.Act_Seg1 == 1U)
                        {
                            Soc.Dis_Seg1 = 1U;
                        }
                        if(Soc.Act_Seg2 == 1U)
                        {
                            Soc.Dis_Seg2 = 1U;
                        }
                    }
                    else
                    {
                        if(Soc.Act_Seg1 == 1U)
                        {
                            Soc.Dis_Seg1 = 0U;
                        }
                        if(Soc.Act_Seg2 == 1U)
                        {
                            Soc.Dis_Seg2 = 0U;
                        }
                    }
                    if(Soc.Act_Seg1 != 1U)
                    {
                        Soc.Dis_Seg1 = Soc.Act_Seg1;
                    }

                    if(Soc.Act_Seg2 != 1U)
                    {
                        Soc.Dis_Seg2 = Soc.Act_Seg2;
                    }   

                    SocPoweroffTime = 0U;
                }
            }
        }
        else 
        {
            Soc.Valid1 = 0U;
            Soc.Valid2 = 0U;
            Soc.Dis_Seg1 = 0U;
            Soc.Dis_Seg2 = 0U;
            SocPoweroffTime = 0U;
        }
    }
    #else
        uint8_t VCUChgMode = Get_CAN_CH0_ID_220_Sig_VCU_ChgMode();

        if (VCUChgMode == 1U)
        {
            if (++SOC_Count_Time > 10U)
            {
                SOC_Count_Time = 0U;
                Soc.Dis_Seg1 ++;
                if (Soc.Dis_Seg1 > Soc.Act_Seg1)
                {
                    Soc.Dis_Seg1 = 0U;
                }
            }
            if ((Get_CAN_Power_State() < KEY_ACC) || (Common_Get_IG_Sts() == COMMON_POWER_OFF))
            {
                if (SocPoweroffTime >= 3600U)
                {
                    Soc.Valid1 = 0U;
                }
                else 
                {
                    Soc.Valid1 = 1U;
                    SocPoweroffTime ++;
                }
            }
            else 
            {
                Soc.Valid1 = 1U;
            }
        }
        else 
        {
            if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
            {
                Soc.Dis_Seg1 = Soc.Act_Seg1;
                Soc.Valid1 = 1U;
            }
            else
            {
                Soc.Dis_Seg1 = 0U;
                Soc.Valid1 = 0U;
            } 
        }

    #endif
}

static void Data_Soc_Battery_Icon_Service(void)
{
    #if (PART_NUMBER == RMR42E_60)
    uint8_t MBMSStatBattWorkState = 0U;

    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL) && (Soc.Value1 != 0U))
        {
            Soc.Battery1Icon = 1U;
        }
        else
        {
            Soc.Battery1Icon = 0U;
        }
    }
    else
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL) && 
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL))
        {
            MBMSStatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
            if ((MBMSStatBattWorkState == 0x1U) || (MBMSStatBattWorkState == 0x7U))
            {
                Soc.Battery1Icon = 1U;
            }
            else
            {
                Soc.Battery1Icon = 0U;
            }
        }
        else
        {
            Soc.Battery1Icon = 0U;
        }
    }

    
        if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
        {
            if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL) && (Soc.Value2 != 0U))
            {
                Soc.Battery2Icon = 1U;
            }
            else
            {
                Soc.Battery2Icon = 0U;
            }
        }
        else
        {
            if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL) && 
                (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL))
            {
                MBMSStatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
                if ((MBMSStatBattWorkState == 0x4U) || (MBMSStatBattWorkState == 0x7U))
                {
                    Soc.Battery2Icon = 1U;
                }
                else
                {
                    Soc.Battery2Icon = 0U;
                }
            }
            else
            {
                Soc.Battery2Icon = 0U;
            }
        }
    #else
        if (Soc.Valid1 == 1U)
        {
            Soc.Battery1Icon = 1U;
        }
        else 
        {
            Soc.Battery1Icon = 0U;
        }
    #endif
}

static void Data_Soc_All_Soc_Service(void)
{
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))
    {
        #if (PART_NUMBER == RMR42E_60)
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203020_Msg)) == CAN_SIG_NORMAL)
        #else
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x17A_Msg)) == CAN_SIG_NORMAL)
        #endif
        {
            // Soc.AllSocValue = Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc();
        }
        else 
        {
            ;
        }
        if (Soc.AllSocValue > 100U)
        {
            Soc.AllSocValue = 100U;
        }
        Soc.AllSocValid = 1U;
    }
    else
    {
        Soc.AllSocValue = 0U;
        Soc.AllSocValid = 0U;
    }
}

void Data_Soc_Service(void)
{
    Data_Soc_Battery_Level_Service();
    Data_Soc_DisplayEffect_Service();
    Data_Soc_Battery_Icon_Service();
    Data_Soc_All_Soc_Service();
}

/******************************************************************************
函数名：Get_Soc1Num_Display
功  能：获取电量表1显示电量值函数
参  数：无
返回值：显示的电量值 x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc1Num_Display(void)
{
    return Soc.Value1;
}

/******************************************************************************
函数名：Get_Soc2Num_Display
功  能：获取电量表2显示电量值函数
参  数：无
返回值：显示的电量值 x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc2Num_Display(void)
{
    return Soc.Value2;
}

/******************************************************************************
函数名：Get_Soc1_Valid
功  能：判断电量1信号是否有效函数
参  数：无
返回值：Soc.Valid1        0--无效，1--有效
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc1_Valid(void)
{
    return Soc.Valid1;
}

/******************************************************************************
函数名：Get_Soc2_Valid
功  能：判断电量2信号是否有效函数
参  数：无
返回值：Soc.Valid2        0--无效，1--有效
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc2_Valid(void)
{
    return Soc.Valid2;
}

/******************************************************************************
函数名：Get_CAN_Num_MBMS_Soc_1_Grid
功  能：获取电量表1显示电量格数函数
参  数：无
返回值：Soc.Dis_Seg1 电量格数
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_CAN_Num_MBMS_Soc_1_Grid(void)
{
    return Soc.Dis_Seg1;
}

/******************************************************************************
函数名：Get_CAN_Num_SBMS_Soc_2_Grid
功  能：获取电量表1显示电量格数函数
参  数：无
返回值：Soc.Dis_Seg2 电量格数
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_CAN_Num_SBMS_Soc_2_Grid(void)
{
    return Soc.Dis_Seg2;
}

/******************************************************************************
函数名：Get_Soc1_Battery_Icon
功  能：获取电量表1是否显示电池小图标函数
参  数：无
返回值：Soc.Battery1Icon 0--熄灭，1--点亮
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc1_Battery_Icon(void)
{
    return Soc.Battery1Icon;
}

/******************************************************************************
函数名：Get_Soc2_Battery_Icon
功  能：获取电量表2是否显示电池小图标函数
参  数：无
返回值：Soc.Battery2Icon 0--熄灭，1--点亮
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Soc2_Battery_Icon(void)
{
    return Soc.Battery2Icon;
}

/******************************************************************************
函数名：Get_AllSocValue
功  能：获取总SOC显示值函数
参  数：无
返回值：Soc.AllSocValue 放大倍数：x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_AllSocValue(void)
{
    return Soc.AllSocValue;
}

/******************************************************************************
函数名：Get_AllSocValid
功  能：获取总SOC显示状态函数
参  数：无
返回值：Soc.AllSocValid 0--无效，1--有效
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_AllSocValid(void)
{
    return Soc.AllSocValid;
}
/******************************************************************************
函数名：Get_EleDial_AllSOC_lenth
功  能：获取总SOC数值长度函数
参  数：无
返回值：num 0--1位数，1--2位数，2--3位数
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_EleDial_AllSOC_lenth(void)
{
    uint8_t num = 0;

    if (Soc.AllSocValue > 99)
    {
        num = 2;
    }
    else if (Soc.AllSocValue > 9)
    {
        num = 1;
    }
    return num;
}
