#ifndef _GUI_DISPLAY_H_
#define _GUI_DISPLAY_H_

#include "Components.h"

#define EEPROM_BLOCK_00 0

typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}PowerSegMap_st_t;

typedef struct 
{
    uint16_t value;
    uint8_t  segNum;
}BatterySegMap_st_t;



typedef struct
{
    uint16_t  Year;
    uint8_t   Month;
    uint8_t   Date;
    uint8_t   Hour;
    uint8_t   Minute;
    uint8_t   Second;
    uint8_t   Rsvd;
} RTC_Time_Setting_st_t;


#define POSITIVE_POWER_SEG_MAP_MAX (sizeof(PositivePowerSegMap)/sizeof(PowerSegMap_st_t))
#define NEGATIVE_POWER_SEG_MAP_MAX (sizeof(NegativePowerSegMap)/sizeof(PowerSegMap_st_t))
#define BATTERY_SEG_MAP_MAX (sizeof(batterySegMap)/sizeof(BatterySegMap_st_t))

#define POWERON_SCAN_TIMER   3000ul
extern uint8_t BUZZER_ON;
extern uint8_t Charge_OFF_Flag;
extern uint8_t EEPROM_Cumulativee_clean;
extern uint16_t poweroff_time;
void Gauge_Power_SOC_pull_Display(void);
// void Gauge_Power_2_SOC_Display(void);

void Gauge_Power_Display(void);
void Gauge_Battery_Display(void);

void Gauge_Clock_Display(void);
// void Gauge_Gear_Display(void);
void Gauge_Clock_All_Display(void);
void Gauge_DrivingRange_Display(void);
//void Gauge_Gear_Display(void);
void Gauge_Frame_Display(void);
void Gauge_MaintenanceMileage_Display(void);
void Gauge_EnergyRecoveryLevel_Display(void);
void Gauge_EleDial_AllSOC_Display(void);
void Data_CumulativeWorkHours_EEPROM_Write(void);
void Gauge_Cutterhead_Gear_Display(void);
void Gauge_Gears_Display(void);
void Gauge_KL30_Init(void);
void Gauge_KL15_Init(void);
void Gauge_Service(void);

void Temp_Calc_Init(void);
void Temp_Calc_Send(void);
uint32_t Get_Temp_Calc(void);
void Gauge_CAN_setup_Service(void);
void Checkself_LED_Display(void);
void BUZZER_Init(void);
uint8_t Get_Clock_All_lenth(void);
uint8_t Get_EleDial_AllSOC_lenth(void);
uint8_t Get_Clockonetime_lenth(void);
uint8_t Get_CAN_Num_SBMS_Soc_2_Grid(void);
uint8_t Get_CAN_Num_MBMS_Soc_1_Grid(void);

#endif
