#include "Can_User.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"
#include <string.h>
#include "can.h"
#include "RTE.h"

__align(4)
uint32_t pRXBuff[CAN_RX_MSG_Block * CAN_CH0_ID_TOTAL_MAX];
uint32_t pTXBuff[CAN_TX_MSG_Block * CAN_CH0_ID_SEND_TOTAL];
static RSCAN0BusoffMonitorStruct RSCAN0Busoff;

void Can_Init(void)
{
    can_config_st_t Can_Config;
    Can_Config.ch = CAN_CH_0;
    Can_Config.freq = CAN_250Kbps;
    Can_Config.MASK[0] = 0x001fffffU;
    Can_Config.MASK[1] = 0x000fffffU;
    Can_Config.MASK[2] = 0x1fffffffU;
    Can_Config.MASK[3] = 0x1fffffffU;
    Can_Config.rx_callback = Can_Rx_Cak;
    COM_CAN_Init();
    rte_can_init(&Can_Config);

    Can_Tx_Apply_Buff();
    Can_RX_Apply_Buff();

    RTE_GPIO_Set_Level(RTE_GPIO_PORT05_PIN02,RTE_GPIO_LEVEL_LOW);

}

/**
 * @brief 用于申请RXBUFF CAN0MSG00~CAN0MSG07
 *
 */
void Can_RX_Apply_Buff(void)
{
    CAN_RecvMsg.Id = 0x125;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG00);
    CAN_MessageCache_Init(CAN0MSG00, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG00, ENABLE);

    CAN_RecvMsg.Id = 0x134;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG01);
    CAN_MessageCache_Init(CAN0MSG01, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG01, ENABLE);

    CAN_RecvMsg.Id = 0x157;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG02);
    CAN_MessageCache_Init(CAN0MSG02, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG02, ENABLE);

    CAN_RecvMsg.Id = 0x38E;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG03);
    CAN_MessageCache_Init(CAN0MSG03, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG03, ENABLE);

    CAN_RecvMsg.Id = 0x3A2;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG04);
    CAN_MessageCache_Init(CAN0MSG04, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG04, ENABLE);

    CAN_RecvMsg.Id = 0x339;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG05);
    CAN_MessageCache_Init(CAN0MSG05, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG05, ENABLE);
    
    CAN_RecvMsg.Id = 0x18202922;
    CAN_RecvMsg.IDE = CAN_Id_Extended;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG06);
    CAN_MessageCache_Init(CAN0MSG06, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG06, ENABLE);

    CAN_RecvMsg.Id = 0x18200A20;
    CAN_RecvMsg.IDE = CAN_Id_Extended;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG07);
    CAN_MessageCache_Init(CAN0MSG07, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG07, ENABLE);

    CAN_RecvMsg.Id = 0x18200A21;
    CAN_RecvMsg.IDE = CAN_Id_Extended;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG12);
    CAN_MessageCache_Init(CAN0MSG12, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG12, ENABLE);

    CAN_RecvMsg.Id = 0x18203220;
    CAN_RecvMsg.IDE = CAN_Id_Extended;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG09);
    CAN_MessageCache_Init(CAN0MSG09, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG09, ENABLE);

    CAN_RecvMsg.Id = 0x18203020;
    CAN_RecvMsg.IDE = CAN_Id_Extended;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG13);
    CAN_MessageCache_Init(CAN0MSG13, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG13, ENABLE);

    CAN_RecvMsg.Id = DIAG_ID_Rx_PHY;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG10);
    CAN_MessageCache_Init(CAN0MSG10, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG10, ENABLE);

    CAN_RecvMsg.Id = DIAG_ID_Rx_FUN;
    CAN_RecvMsg.IDE = CAN_Id_Standard;
    CAN_RecvMsg.CacheType = CAN_CacheType_Rx_NoMask;
    CAN_RecvMsg.RTR = CAN_RTR_Data;
    CAN_RecvMsg.Interrupt = ENABLE;
    CAN_MessageCache_DeInit(CAN0MSG11);
    CAN_MessageCache_Init(CAN0MSG11, &CAN_RecvMsg);
    CAN_MessageCache_OverWriteConfig(CAN0MSG11, ENABLE);
}

/**
 * @brief 用于申请TXBUFF
 *
 */
void Can_Tx_Apply_Buff(void)
{
    CanTxRxMsg CAN_SendMsg;
    CanTxRxMsg CAN_SendMsg_Diag_Tx;
	CAN_SendMsg.Id = 0x3A2;
	CAN_SendMsg.IDE = CAN_Id_Standard;
	CAN_SendMsg.CacheType = CAN_CacheType_Tx;
	CAN_SendMsg.RTR = CAN_RTR_Data;
	CAN_RecvMsg.Interrupt = DISABLE;
	CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN1MSG00);
    CAN_MessageCache_Init(CAN1MSG00, &CAN_SendMsg);

    CAN_SendMsg.Id = 0x3A7;
	CAN_SendMsg.IDE = CAN_Id_Standard;
	CAN_SendMsg.CacheType = CAN_CacheType_Tx;
	CAN_SendMsg.RTR = CAN_RTR_Data;
	CAN_RecvMsg.Interrupt = DISABLE;
	CAN_SendMsg.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg.DLC; i++)
    {
        CAN_SendMsg.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN1MSG01);
    CAN_MessageCache_Init(CAN1MSG01, &CAN_SendMsg);

    
	CAN_SendMsg_Diag_Tx.Id = DIAG_ID_Tx;
	CAN_SendMsg_Diag_Tx.IDE = CAN_Id_Standard;
	CAN_SendMsg_Diag_Tx.CacheType = CAN_CacheType_Tx;
	CAN_SendMsg_Diag_Tx.RTR = CAN_RTR_Data;
	CAN_SendMsg_Diag_Tx.Interrupt = DISABLE;
	CAN_SendMsg_Diag_Tx.DLC = 8;
    for (uint8_t i = 0; i < CAN_SendMsg_Diag_Tx.DLC; i++)
    {
        CAN_SendMsg_Diag_Tx.Data[i] = 0;
    }

    CAN_MessageCache_DeInit(CAN1MSG02);
    CAN_MessageCache_Init(CAN1MSG02, &CAN_SendMsg_Diag_Tx);
}
/**
 * @brief 用于接收回调函数
 * @code
 */
void Can_Rx_Cak(CanTxRxMsg *Msg)
{
    Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(Msg->Id), Msg->DLC, Msg->Data);

    if ((Msg->Id == DIAG_ID_Rx_FUN) || (Msg->Id == DIAG_ID_Rx_PHY))
    {
      DoCAN_L_Data_Indication(Msg->Id, Msg->DLC, Msg->Data);
    }
}
/**
 * @brief CAN库初始化TX/RX
 *
 */
void COM_CAN_Init(void)
{
    memset(pRXBuff, 0, sizeof(pRXBuff));
    CAN_CH0_CanMsgOp.CAN_MSG_Analysis = (st_CANMsgStruct *)pRXBuff;
    CAN_CH0_CanMsgOp.pAttrubute = CAN_CH0_CAN_MSG_CONST_ARRAY;
    CAN_CH0_CanMsgOp.Total_Msg = CAN_CH0_ID_TOTAL_MAX;
    CAN_CH0_CanMsgOp.u8CAN_RX_ENABLE = CAN_N_RX_Enable;
    Can_RX_BuffInit(&CAN_CH0_CanMsgOp, CAN_CH0_CAN_MSG_CONST_ARRAY, CAN_CH0_ID_TOTAL_MAX);
    CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Enable);

    memset(pTXBuff, 0, sizeof(pTXBuff));
    CAN_CH0_CanMsgTxOp.CanMsg = (st_CAN_SendOperation *)pTXBuff;
    Can_TX_BuffInit(&CAN_CH0_CanMsgTxOp, CAN_CH0_CANSendAttr, CAN_CH0_ID_SEND_TOTAL, COM_APP_Process);
    CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
}


/**
 * @brief Buff恢复函数
 * @param deltaTime 调用时间 单位ms 10MS调用
 */
void Can_BusOff_Recover(uint8_t deltaTime)
{
    if (get_can_busoff(CAN_CH_0) == 2)
    {
        if (RSCAN0Busoff.Status == RSCAN0_BUS_STABLE)
        {
            RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV1;
        }

        if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV1)
        {
            RSCAN0Busoff.Timer++;
            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV1_RECOVERY_TIME / deltaTime)
            {
                RSCAN0Busoff.Timer = 0U;

                RSCAN0Busoff.Cnt++;
                if (RSCAN0Busoff.Cnt >= 10U)
                {

                    RSCAN0Busoff.Cnt = 0U;

                    RSCAN0Busoff.Status = RSCAN0_BUS_OFF_LV2;
                }
                reset_busoff(CAN_CH_0);
            }
        }
        else if (RSCAN0Busoff.Status == RSCAN0_BUS_OFF_LV2)
        {
            RSCAN0Busoff.Timer++;

            if (RSCAN0Busoff.Timer >= RSCAN0_BUS_OFF_LV2_RECOVERY_TIME / deltaTime)
            {
                RSCAN0Busoff.Timer = 0U;
                reset_busoff(CAN_CH_0);
            }
        }
        else
        {
        }
    }
    else /* 总线正常,没有Bus-off发生*/
    {
        
    }
}

/**
 * @brief 获取busoff状态
 * @return 0 没有busoff
 *         1 错误的操作
 *         2 busoff
 */
uint8_t Get_Busoff_Status(void)
{
    return get_can_busoff(CAN_CH_0);
}

uint8_t COM_APP_Process(st_CAN_Msg *Msg)
{
    Can_Write((st_CAN_Msg *)Msg);
    return 0;
}

void Can_Write(st_CAN_Msg *Msg)
{
    uint32_t i = 0;
    CanTxRxMsg CAN_SendMsg;

    CAN_SendMsg.Id = Msg->MsgID;       /* ID */
    CAN_SendMsg.DLC = Msg->MsgDLC;     /* Len */
    CAN_SendMsg.RTR = Msg->MsgRTR;     /* Default 0 */
    CAN_SendMsg.IDE = CAN_Id_Standard; /* Stand 0 Ext 1 */
    CAN_SendMsg.CacheType = CAN_CacheType_Tx;

    for (i = 0; i < CAN_SendMsg.DLC; i++) /* 获取数据 */
    {
        CAN_SendMsg.Data[i] = Msg->Msg[i];
    }

    switch (CAN_SendMsg.Id)
    {
    case 0x3A2:
        CAN_Transmit(CAN0MSG08, &CAN_SendMsg);
        break;
    case 0x3A7:
        CAN_Transmit(CAN0MSG10, &CAN_SendMsg);
        break;
    default:
        break;
    }
}
