#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "Application.h"
#define DISPLAY_OPEN ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))


uint8_t Charge_OFF_Flag = 0;

void Clear_Bu98_Conditions(DoNot_Close_Seg_en_t closeType); 

void Gauge_Power_SOC_pull_Display(void)
{
    uint8_t u8Soc1Seg = Get_CAN_Num_MBMS_Soc_1_Grid();
    uint8_t u8Soc2Seg = Get_CAN_Num_SBMS_Soc_2_Grid();
    uint8_t u8Soc1Valid = Get_Soc1_Valid();
    uint8_t u8Soc2Valid = Get_Soc2_Valid();

    SEG_SET_EleDial_1SOC(u8Soc1Valid, u8Soc1Seg);
    SEG_SET_EleDial_2SOC(u8Soc2Valid, u8Soc2Seg);
}

void Gauge_Cutterhead_Gear_Display(void)
{
    uint8_t CutterheadValue = Get_Gear_Cutterhead_Value();
    uint8_t CutterheadValid = Get_Gear_Cutterhead_Valid();
#if (PART_NUMBER == RMR42E_60)
    if (CutterheadValid == 2U)
    {
        if (FLASH_SYNC_1Hz)
        {
            SEG_SET_Cutterhead(1, CutterheadValue, 0);
        }
        else
        {
            SEG_SET_Cutterhead(1, 4, 0);
        }
    }
    else
    {
        SEG_SET_Cutterhead(CutterheadValid, CutterheadValue, 0);
    }
#else
    SEG_SET_Cutterhead(CutterheadValid, CutterheadValue, 0);
#endif
}

void Gauge_Gears_Display(void)
{
    uint8_t GearValue = Get_Gear_Value();
    uint8_t GearValid = Get_Gear_Valid();

    SEG_SET_GEAR(GearValid, GearValue, 0);
    if (Get_CAN_Power_State() == KEY_ACC)
    {
        SEG_SET_GEAR_FRAME(1U);
    }
    else
    {
        SEG_SET_GEAR_FRAME(0U);
    }
    
}

void Gauge_EleDial_AllSOC_Display(void)
{
    uint8_t u8AllSocValid = Get_AllSocValid();
    uint8_t u8AllSocValue = Get_AllSocValue();
    SEG_SET_EleDial_AllSOC(u8AllSocValid, u8AllSocValue);
}

/*单次工作时长显示函数*/
void Gauge_Clock_Display(void)
{
    uint8_t Clock_hours = Get_SingleHour_Display();
    uint8_t Clock_min = Get_SingleMin_Display();

    if (Get_Single_Working_Hours_Status() == 1U)
    {
        SEG_SET_Clock(Clock_hours, Clock_min, FLASH_SYNC_1Hz, 1, 1);
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
    }
}

/*累计工作时长显示函数*/
void Gauge_Clock_All_Display(void)
{
    uint32_t TotalHours = Get_Total_Working_Hours();

    if (DISPLAY_OPEN)
    {
        SEG_SET_Clock_ALL(1, TotalHours);
    }
    else
    {
        SEG_SET_Clock_ALL(0, 0);
    }
}

void Gauge_Frame_Display(void)
{
    if (DISPLAY_OPEN)
    {
        SEG_SET_Frame(1);
    }
    else
    {
        SEG_SET_Frame(0);
    }
}

void Gauge_flue_Display(void)
{
    uint8_t u8fuelValid = Get_FuelStatus_Valid();
    uint8_t u8fuelValue = Get_FuelSeg_Display();
    SEG_SET_FuelDial(u8fuelValid, u8fuelValue);
}

void Gauge_faultcode_Display(void)
{
    uint8_t u8faucodeValid = Get_FaultCode_Valid();
    uint16_t u16faucodelValue = Get_FaultCode_Value();
    uint8_t u8FaultCodeNum = Get_FaultCode_Num();
    SEG_SET_Fault_Code(u8faucodeValid, u16faucodelValue, 0);
    SEG_SET_Fault_Code_Spanner(u8faucodeValid, 0, u8faucodeValid);
}

void Clear_Bu98(void)
{
    uint8_t i = 0;
    for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}

void Clear_Bu98_Conditions(DoNot_Close_Seg_en_t closeType)
{
    uint8_t i = 0;
    uint8_t transitionData = 0U;
    if(closeType == ONLY_TEL)
    {
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
            if (i == 74U)
            {
                transitionData = ((BU98R10Chip0DDRAM.Byte[i] >> 4U) & 0xFU);
                BU98R10Chip0DDRAM.Byte[i] = ((transitionData << 4U) + 0);
                transitionData = 0;
            }
            else if (i == 43U)
            {
                transitionData = ((BU98R10Chip0DDRAM.Byte[i]) & 0xFU);
                BU98R10Chip0DDRAM.Byte[i] = transitionData;
                transitionData = 0;
            }
            else
            {
                BU98R10Chip0DDRAM.Byte[i] = 0;
            }
            
            if(i == 46U)
            {
                transitionData = ((BU98R10Chip1DDRAM.Byte[i]) & 0xFU);
                BU98R10Chip1DDRAM.Byte[i] = transitionData;
                transitionData = 0;
            }
            else
            {
                BU98R10Chip1DDRAM.Byte[i] = 0;
            }
        }
    }
    else if (closeType == TEL_AND_SOC)
    {
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
            if((i == 26) || (i == 28) || (i == 74U))
            {
                transitionData = ((BU98R10Chip0DDRAM.Byte[i] >> 4U) & 0xFU);
                BU98R10Chip0DDRAM.Byte[i] = ((transitionData << 4U) + 0);
                transitionData = 0;
            }
            else if (i == 43U)
            {
                transitionData = ((BU98R10Chip0DDRAM.Byte[i]) & 0xFU);
                BU98R10Chip0DDRAM.Byte[i] = transitionData;
                transitionData = 0;
            }
            else if ((i == 29U) || (i == 30U) || (i == 31U) || (i == 32U) || (i == 33U) || (i == 34U) || (i == 35U) ||
                    (i == 60U) || (i == 67U) || (i == 68U) ||(i == 71U) || (i == 72U) || (i == 73U))
            {
                ;
            }
            else
            {
                BU98R10Chip0DDRAM.Byte[i] = 0;
            }
            
            if(i == 46U)
            {
                transitionData = ((BU98R10Chip1DDRAM.Byte[i]) & 0xFU);
                BU98R10Chip1DDRAM.Byte[i] = transitionData;
                transitionData = 0;
            }
            else
            {
                BU98R10Chip1DDRAM.Byte[i] = 0;
            }
        }
    }
    else 
    {
        for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
        {
            BU98R10Chip0DDRAM.Byte[i] = 0;
            BU98R10Chip1DDRAM.Byte[i] = 0;
        }
    }
    
}

void Gauge_Service(void)
{
    uint8_t i = 0;
    #if(PART_NUMBER == G54_A01)
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Get_CAN_Power_State() == KEY_ACC))
    #else
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    #endif
    {
        if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
        {
            if (g_u8TYWClearEepromFlag >= 1)
            {
                TYW_RESET_TIME();
                Check_SEG_Display();
            }
            else
            {
                TYW_Clear_Eeprom_Service();
                interact_PWM_Low_Duty = 100;
                if (Common_GetIgnOnTime() > 1500)
                {
                    SOC_charge_seg_Flag = 0;
                    Checkself_Init();
                    Gauge_CAN_setup_Service();
                }
                else
                {
                    checkself_seg_Flag = 1;
                    if (Get_CAN_Power_State() == KEY_ACC)
                    {
                        interact_PWM_Low_Duty = 0;
                    }

                    Checkself_LED_Display();
                    // Checkself_SEG_Display();
                }
            }
        }
        else if (Get_CAN_Power_State() == PKEY_ON)
        {
            if (Buzzer_time == 0)
            {
                Clear_Bu98();
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
                Checkself_Init();
                // Gpio_Init(Gpio_Sleep_Init);
            }
            interact_PWM_Low_Duty = 50;
        }
        else
        {
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL)
            {
                // poweroff_time = 0;
                Clear_Bu98();
                interact_PWM_Low_Duty = 100;
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
            }
        }
    }
    else
    {
        #if(PART_NUMBER == G54_A01)
        if(Get_CAN_Power_State() == PKEY_ON)
        {
            if ((Get_CAN_Power_State() == PKEY_ON) && (Get_Soc1_Valid() == 1U))
            {
                Gauge_Power_SOC_pull_Display();
                Gauge_EleDial_AllSOC_Display();
                Clear_Bu98_Conditions(TEL_AND_SOC);
            }
            else 
            {
                Clear_Bu98_Conditions(ONLY_TEL);
            }
            for (i = 0; i < LampCh0_MAX; i++)
            {
                if ((i == LampCh0_08_Battery_Charging_W) || (i == LampCh0_32_Charging_Connection_R) || (i == LampCh0_19_Fault_Codes_W))
                {
                    ;
                }
                else 
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
            }
        }
        else 
        {
            Clear_Bu98();
            for (i = 0; i < LampCh0_MAX; i++)
            {
                LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
            }
        }
        #else
        Clear_Bu98();
        interact_PWM_Low_Duty = 100;
        for (i = 0; i < LampCh0_MAX; i++)
        {
            LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
        }
        #endif
    }
}

void Gauge_CAN_setup_Service(void)
{
    uint8_t state = Get_CAN_Power_State();
    Gauge_Clock_Display();
    Gauge_Clock_All_Display();
    Gauge_EleDial_AllSOC_Display();
    if (PART_NUMBER == G54_A01)
    {
        Gauge_flue_Display();
        Gauge_faultcode_Display();
    }

    // SEG_SET_GEAR(1, 1);
    // SEG_SET_Cutterhead(1, 2);
    Gauge_Frame_Display();
    Gauge_Cutterhead_Gear_Display();
    Gauge_Gears_Display();
    uint8_t MBMS_TOTALSigAcc = Get_CAN_Num_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_Num_MBMS_TOTALSigCharge();
    Gauge_Power_SOC_pull_Display();
    switch (state)
    {
    case KEY_ACC:
    {
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 0;
    }
    break;
    case READY:
    {
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 30;
    }
    break;
    case CHRGING:
    {
        SOC_charge_seg_Flag = 1;
    }
    break;
    case CHRG_PLUGIN:
    case CHRGEND:
    {
        if ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1)) // 下电充电)
        {
            Charge_OFF_Flag = 1;
        }
        else if ((MBMS_TOTALSigAcc == 0x1) && (MBMS_TOTALSigCharge == 0x1))
        {
            Charge_OFF_Flag = 0;
        }
    }
    break;

    default:
        break;
    }
}

void Checkself_LED_Display(void)
{
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_19_Fault_Codes_W, LED_ON);
    SEG_SET_Frame(1);
}


