#include "Components.h"
#include "Data_Fuel\Data_Fuel.h"

FuelStruct_st_t Fuel;

void Data_Fuel_KL30_Init(void)
{
    Fuel.FuelSeg = 0U;
    Fuel.FuelSegDis = 0U;
    Fuel.FuelStatusCount = 0U;
    Fuel.FuelValid = 0U;
}

void Data_Fuel_KL15_Init(void)
{

}

void MsgID_0x18E_Receive(void)
{
    if((Fuel.FuelSeg != Fuel.FuelSegDis) && (Fuel.FuelStatusCount >= 3U))
    {
        Fuel.FuelSegDis = Fuel.FuelSeg;
        Fuel.FuelStatusCount = 0U;
    }
    else if((Fuel.FuelSeg != Fuel.FuelSegDis) && (Fuel.FuelStatusCount < 3U))
    {
        Fuel.FuelStatusCount ++;
    }
    else 
    {
        Fuel.FuelStatusCount = 0U;
    }
}

void Data_Fuel_Service(void)
{

    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18E_Msg)) == CAN_SIG_NORMAL)
    {
        Fuel.FuelSeg = Get_CAN_CH0_ID_18E_Sig_EMS_FuelRemainLevel();
        Fuel.FuelValid = 1U;
        if (Fuel.FuelSeg > 8U) 
        {
            Fuel.FuelSeg = 8U;
        }
    }
    else
    {
        Fuel.FuelValid = 0U;
        Fuel.FuelStatusCount = 0U;
    }

}

/******************************************************************************
函数名：Get_FuelSeg_Display
功  能：获取显示燃油格数函数
参  数：无
返回值：Fuel.FuelSeg 显示的电量值 x1
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_FuelSeg_Display(void)
{
    return Fuel.FuelSegDis;
}

/******************************************************************************
函数名：Get_FuelStatus_Valid
功  能：获取燃油表有效状态函数
参  数：无
返回值：Fuel.FuelValid  0--无效，1--有效
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_FuelStatus_Valid(void)
{
    return Fuel.FuelValid;
}

/******************************************************************************
函数名：Get_FuelPilotLamp_Status
功  能：获取燃油指示灯状态函数
参  数：无
返回值：LampStatus 0--熄灭，1--白色，2--黄色，3--黄色闪烁
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_FuelPilotLamp_Status(void)
{
    uint8_t LampStatus = 0U;

    if((Fuel.FuelValid == 1U) && (Fuel.FuelSegDis == 1U))
    {
        LampStatus = 2U;
    }
    else if ((Fuel.FuelValid == 1U) && (Fuel.FuelSegDis == 0U))
    {
        LampStatus = 3U;
    }
    else if ((Fuel.FuelValid == 1U) && (Fuel.FuelSegDis > 1U))
    {
        LampStatus = 1U;
    }
    else
    {
        LampStatus = 0U;
    }

    return LampStatus;
}

