#include "Can_App.h"
#include "Components.h"
#include "Application.h"


void Can_Set_Buff_220(canlib_uint8_t CopyData[])
{
    CANMsg220Union *p220;
    uint8_t i = 0;

    p220 = (CANMsg220Union *)CopyData;
    if ( p220 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p220->Msg [ i ] = 0xFFu;
        }
    }
    p220 -> Sig.TCS_TX = Get_Dis_Tcs_Val();
}
void Can_Set_Buff_6EE(canlib_uint8_t CopyData[])
{
    CANMsg6EEUnion *p6EE;
    uint8_t i = 0;
    uint16_t Vspeed_tx = 0;
    uint32_t ODO_tx = Data_ODO_Read() / 10;    
    Vspeed_tx = Get_DispVechileSpeed_TX()/10;
    p6EE = (CANMsg6EEUnion *)CopyData;
    
    if ( p6EE != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p6EE->Msg [ i ] = 0xFFu;
        }
    } 

 
    
}
void Can_Set_Buff_6EF(canlib_uint8_t CopyData[])
{
    CANMsg6EFUnion *p6EF;
    uint8_t i = 0;
    uint16_t Espeed_tx = 0;
    uint16_t TripA_tx = 0;
    Espeed_tx = Get_ActualEngineSpeed()/100;
    TripA_tx  = Data_Read_Trip(EM_TRIP_A);
    p6EF = (CANMsg6EFUnion *)CopyData;
    if ( p6EF != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p6EF->Msg [ i ] = 0xFFu;
        }
    }
    p6EF -> Sig.Espeed_TX  = Espeed_tx;
    p6EF -> Sig.TripA_H    = (TripA_tx >> 8) & 0xFF;
    p6EF -> Sig.TripA_L    = TripA_tx  & 0xFF;

}
void Can_Set_Buff_450(canlib_uint8_t CopyData[])
{
    CANMsg450Union *p450;
    uint8_t i = 0;

    p450 = (CANMsg450Union *)CopyData;
    if ( p450 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p450->Msg [ i ] = 0xFFu;
        }
    }
    p450 -> Sig.Front_Pressure_TX_H  = (Get_Front_TPMS_TX() >> 8) & 0xFF;
    p450 -> Sig.Front_Pressure_TX_L  = Get_Front_TPMS_TX() & 0xFF;
    p450 -> Sig.Rear_Pressure_TX_H   = (Get_Rear_TPMS_TX() >> 8) & 0xFF;
    p450 -> Sig.Rear_Pressure_TX_L   = Get_Rear_TPMS_TX() & 0xFF;
}
void Can_Set_Buff_580(canlib_uint8_t CopyData[])
{
    CANMsg580Union *p580;
    uint8_t i = 0;

    p580 = (CANMsg580Union *)CopyData;
    if ( p580 != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            p580->Msg [ i ] = 0xFFu;
        }
    }
    if(Get_Tpms_TX_Flag() == 1)
    {
        p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x31;
        p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x01;
        p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x59;
        p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x08;
        p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x00;
    }
    else if(Get_Tpms_TX_Flag() == 1)
    {
        p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x31;
        p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x01;
        p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x59;
        p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x08;
        p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x01;
    }
    else
    {
        p580 -> Sig.TPMS_LEARN_CND_BYTE0 = 0x0;
        p580 -> Sig.TPMS_LEARN_CND_BYTE1 = 0x0;
        p580 -> Sig.TPMS_LEARN_CND_BYTE2 = 0x0;
        p580 -> Sig.TPMS_LEARN_CND_BYTE3 = 0x0;
        p580 -> Sig.TPMS_LEARN_CND_BYTE4 = 0x02;
    }

}


