
#include "Line_In\Line_In_user.h"
#include "Components.h"
#include "Application.h"

#if (PART_NUMBER == RMR42E_60)
const Line_In_Attribute_st g_stLineInAttribute[LINE_IN_MAX] =
{
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     470U,  20U,  Get_LINE_IN_GrassFull,       },
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     470U,  20U,  Get_LINE_IN_BigLED,          },
};
#else
const Line_In_Attribute_st g_stLineInAttribute[LINE_IN_MAX] =
{
    {LEVEL_LOW,    LEVEL_HIGH,   LINE_IN_IG_ON,     470U,  20U,  Get_LINE_IN_GrassFull,       },
    {LEVEL_HIGH,   LEVEL_LOW,    LINE_IN_IG_ON,     470U,  20U,  Get_LINE_IN_BigLED,          },
};
#endif


Linelib_uint8_t Get_LINE_IN_GrassFull(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(Grass_Full))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_BigLED(void)
{
    Linelib_uint8_t ret = 0U;
    if (RTE_GPIO_Get_Level(Headlights_start))
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

__align(4)
Linelib_uint8_t LINE_IN_Men[LINE_IN_MAX * LINE_IN_BLOCK_SIZE];

static Linelib_uint16_t LINE_GET_PWR(void)
{
    Linelib_uint16_t Res;
    Res = Common_Get_IG_Sts() & 0x00FFu;
    return Res;
}

void LINE_IN_Init(void)
{
    Line_In_KL30_WakeUp_Init(LINE_IN_Men, g_stLineInAttribute, LINE_IN_MAX, LINE_GET_PWR);
}
