#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_

#ifdef Platform_16Bit
#define Light_uint8_t unsigned char
#define Light_uint16_t unsigned int
#define Light_uint32_t unsigned long

#else
#define Light_uint8_t unsigned char
#define Light_uint16_t unsigned short
#define Light_uint32_t unsigned int
#define Light_uint64_t unsigned long long

#endif

#define Backlight_NTC_Max 10            /* 背光NTC阻值表格元素最大值 */
#define BacklightLevel_Max 10       /* 背光等级表格元素最大值 */
#define BackLight_Up_Timer  400     /* 背光精度上升1%的时间 单位 10ms */
#define BackLight_Down_Timer  200   /* 背光精度下降1%的时间 单位 10ms */
typedef struct //__attribute__((aligned(4))) 
{
    Light_uint16_t Temperature; /* 温度 */
    Light_uint16_t Resistance;  /* 阻值 */
} _st_Backlight_NtcTable;

typedef struct //__attribute__((aligned(4))) 
{
    Light_uint16_t BacklightLevel; /* 背光等级 */
    Light_uint16_t BacklightDuty;  /* 背光占空比 */
} _st_BacklightLevel;

typedef void (*SetPwm)(Light_uint16_t Pwm);
typedef Light_uint8_t (*SetPwmEnable)(void);
typedef Light_uint8_t (*SetPwmLevel)(void);
typedef Light_uint16_t (*GetNtcRes)(void);

typedef struct //__attribute__((aligned(4))) 
{
    SetPwm SetPwmCbk;                          /* 设置PWM回调函数 */
    SetPwmEnable SetPwmEnCbk;                  /* 设置PWM使能回调函数 */
    SetPwmLevel SetPwmLevelCbk;                /* 背光等级回调函数 */
    GetNtcRes NtcResCbk;                       /* 获取NTC电阻值回调函数 如无NTC传入空 */
    _st_Backlight_NtcTable *BacklightNTCTable; /* NTC 数据表 */
    _st_BacklightLevel *BacklightLevelTable;   /* 背光等级数据表 */
} _st_BackLight_Init;

/**
 * @brief 初始化背光模块，KL30/唤醒初始化调用一次即可
 * @param backlightInit 背光初始化配置结构体指针，包含所需的回调函数和数据表。
 * @note 调用此初始化前需先初始化硬件相关
 */
extern void Backlight_KL30_WakeUp_Init(_st_BackLight_Init *backlightInit);

/**
 * @brief 初始化背光模块，休眠初始化调用一次即可
 * @note 调用此初始化前需先初始化硬件相关
 */
extern void BackLight_Sleep_Init(void);

/**
 * @brief 背光服务函数 必须10ms调用
 */
extern void BackLight_Service(void);

#endif

