#ifndef _BU98B10_USER_H_
#define _BU98B10_USER_H_
#include "Components.h"

#define BU98B10SEGMAX 180   /* 段码段码最大值 */
// #define BU98B10NUMBERMAX 7 /* 数字段数最大值 */
typedef enum
{
    BU98B10_NUMBER_SEG_7 = 0,
    BU98B10_NUMBER_SEG_27,
    BU98B10_NUMBER_SEG_25,
    BU98B10_NUMBER_SEG_23,
    BU98B10_NUMBER_SEG_16,
    BU98B10_NUMBER_SEG_MAX,
} BU98B10_Number_SEG_en_t; /* 段码段 */
typedef enum
{
    BU98B10_CHANNEL_0 = 0,
    BU98B10_CHANNEL_1,
    BU98B10_CHANNEL_MAX,
} BU98B10_Channel_en_t; /* 段码通道 */

typedef enum
{
    BU98B10_OFF = 0,
    BU98B10_GRAY_LEVEL1,
    BU98B10_GRAY_LEVEL2,
    BU98B10_GRAY_LEVEL3,
    BU98B10_GRAY_LEVEL4,
    BU98B10_GRAY_LEVEL5,
    BU98B10_GRAY_LEVEL6,
    BU98B10_ON,
} BU98B10_Color_en_t; /* 段码点亮等级 */

typedef enum
{
    BU98B10_Disable = 0,
    BU98B10_Enable,
} BU98B10_Enable_en_t; /* 段码点亮等级 */

typedef enum
{
    BU98B10DIS_NUMBLE_0 = 0,
    BU98B10DIS_NUMBLE_1,
    BU98B10DIS_NUMBLE_2,
    BU98B10DIS_NUMBLE_3,
    BU98B10DIS_NUMBLE_4,
    BU98B10DIS_NUMBLE_5,
    BU98B10DIS_NUMBLE_6,
    BU98B10DIS_NUMBLE_7,
    BU98B10DIS_NUMBLE_8,
    BU98B10DIS_NUMBLE_9,
    BU98B10DIS_ALPHABET_A,
    BU98B10DIS_ALPHABET_B,
    BU98B10DIS_ALPHABET_C,
    BU98B10DIS_ALPHABET_D,
    BU98B10DIS_ALPHABET_E,
    BU98B10DIS_ALPHABET_F,
    BU98B10DIS_ALPHABET_U,
    BU98B10DIS_ALPHABET_P,
    BU98B10DIS_ALPHABET_L,
    BU98B10DIS_ALPHABET_H,
    BU98B10DIS_NUMBLE_LINE,
    BU98B10DIS_NUMBLE_NULL,
    BU98B10DIS_MAX_7,
} BU98B10_Numble7_Mask_en_t; /* 段码掩码(7段适用) */
typedef enum
{
    BU98B10DIS16_NUMBLE_0 = 0,
    BU98B10DIS16_NUMBLE_1,
    BU98B10DIS16_NUMBLE_2,
    BU98B10DIS16_NUMBLE_3,
    BU98B10DIS16_NUMBLE_4,
    BU98B10DIS16_NUMBLE_5,
    BU98B10DIS16_NUMBLE_6,
    BU98B10DIS16_NUMBLE_7,
    BU98B10DIS16_NUMBLE_8,
    BU98B10DIS16_NUMBLE_9,
    BU98B10DIS16_ALPHABET_A,
    BU98B10DIS16_ALPHABET_B,
    BU98B10DIS16_ALPHABET_C,
    BU98B10DIS16_ALPHABET_D,
    BU98B10DIS16_ALPHABET_E,
    BU98B10DIS16_ALPHABET_F,
    BU98B10DIS16_ALPHABET_G,
    BU98B10DIS16_ALPHABET_H,
    BU98B10DIS16_ALPHABET_I,
    BU98B10DIS16_ALPHABET_J,
    BU98B10DIS16_ALPHABET_K,
    BU98B10DIS16_ALPHABET_L,
    BU98B10DIS16_ALPHABET_M,
    BU98B10DIS16_ALPHABET_N,
    BU98B10DIS16_ALPHABET_O,
    BU98B10DIS16_ALPHABET_P,
    BU98B10DIS16_ALPHABET_Q,
    BU98B10DIS16_ALPHABET_R,
    BU98B10DIS16_ALPHABET_S,
    BU98B10DIS16_ALPHABET_T,
    BU98B10DIS16_ALPHABET_U,
    BU98B10DIS16_ALPHABET_V,
    BU98B10DIS16_ALPHABET_W,
    BU98B10DIS16_ALPHABET_X,
    BU98B10DIS16_ALPHABET_Y,
    BU98B10DIS16_ALPHABET_Z,
    BU98B10DIS16_NUMBLE_mul,//乘        x
    BU98B10DIS16_NUMBLE_add,//加        +
    BU98B10DIS16_NUMBLE_sub,//减        -
    BU98B10DIS16_NUMBLE_exc,//除        /
    BU98B10DIS16_NUMBLE_LMPar,//左中括号 [
    BU98B10DIS16_NUMBLE_RMPar,//右中括号 ]
    BU98B10DIS16_NUMBLE_LSPar,//左小括号 (
    BU98B10DIS16_NUMBLE_RSPar,//右小括号 )
    BU98B10DIS16_NUMBLE_equal,//等于     =
    BU98B10DIS16_NUMBLE_degrees,//度     °
    BU98B10DIS16_NUMBLE_NULL,//空
    BU98B10DIS16_MAX_16,
} BU98B10_Numble16_Mask_en_t; /* 段码掩码(16段适用) */
typedef enum
{
    BU98B10DIS27_NUMBLE_ = 0,
    BU98B10DIS27_NUMBLE_1,
    BU98B10DIS27_NUMBLE_2,
    BU98B10DIS27_NUMBLE_3,
    BU98B10DIS27_NUMBLE_4,
    BU98B10DIS27_NUMBLE_5,
    BU98B10DIS27_NUMBLE_6,
    BU98B10DIS27_NUMBLE_7,
    BU98B10DIS27_NUMBLE_8,
    BU98B10DIS27_NUMBLE_9,
    BU98B10DIS27_NUMBLE_NULL,
    BU98B10DIS27_MAX_27,

} BU98B10_Numble27_Mask_en_t; /* 段码掩码(27段适用) */

typedef enum
{
    BU98B10DIS25_NUMBLE_0 = 0,
    BU98B10DIS25_NUMBLE_1,
    BU98B10DIS25_NUMBLE_2,
    BU98B10DIS25_NUMBLE_3,
    BU98B10DIS25_NUMBLE_4,
    BU98B10DIS25_NUMBLE_5,
    BU98B10DIS25_NUMBLE_6,
    BU98B10DIS25_NUMBLE_7,
    BU98B10DIS25_NUMBLE_8,
    BU98B10DIS25_NUMBLE_9,
    BU98B10DIS25_NUMBLE_NULL,
    BU98B10DIS25_MAX_25,

} BU98B10_Numble25_Mask_en_t; /* 段码掩码(25段适用) */

typedef enum
{
    BU98B10DIS23_NUMBLE_P = 0,
    BU98B10DIS23_NUMBLE_R,
    BU98B10DIS23_NUMBLE_N,
    BU98B10DIS23_NUMBLE_H,
    BU98B10DIS23_NUMBLE_L,
    BU98B10DIS23_NUMBLE_NULL,
    BU98B10DIS23_MAX_23,

} BU98B10_Numble23_Mask_en_t; /* 段码掩码(23段适用) */

typedef struct
{
    BU98B10_Channel_en_t enBU98B10Channel; /* 选择第几片段码 */
    uint8_t u8BU98B10_Seg;                 /* 需显示的SEG值 */
} BU98B10_USER_st_t;


/**
 * @brief 设置段码显示数字或字母显示
 * @param pBU98B10User 传入BU98B10_USER_st_t指针
 * @param enBU98B10Value 需要显示的内容 数字或者字母详见BU98B10_Numble7_Mask_en_t BU98B10_Numble27_Mask_en_t BU98B10_Numble25_Mask_en_t BU98B10_Numble23_Mask_en_t
 * @param enBU98B10SEGNum 需要显示的段码段数 详见 BU98B10_Number_SEG_en_t 以及示例图 若没有可以联系作者补上掩码
 * @param Enable 是否点亮
 * @return 0:正确 1 传入关闭等级错误 2 传入空指针 3 传入SEG错误或设置段码通道错误 或传入enBU98B10Value错误
 */
uint8_t BU98B10_Set_Numble(const BU98B10_USER_st_t* pBU98B10User, uint8_t enBU98B10Value, BU98B10_Number_SEG_en_t enBU98B10SEGNum, uint8_t Enable);

/**
 * @brief 设置段码SEG等级
 * @param enBU98B10Channel 传入要设置的段码通道
 * @param u8Seg 传入要设置的段码
 * @param enColor 传入要设置的等级
 * @return 0:设置成功，1:传入的通道错误，2:传入的段码错误，3:传入的等级错误
 */
extern uint8_t BU98B10_Set_Seg_Level(BU98B10_Channel_en_t enBU98B10Channel, uint8_t u8Seg, BU98B10_Color_en_t enColor);

/**
 * @brief 设置段码全开 默认等级 7
 * @param enBU98B10Channel 选择第几片段码
 */
extern uint8_t BU98B10_ALL_OPEN(BU98B10_Channel_en_t enBU98B10Channel);
/**
 * @brief 设置段码全关 默认等级 7
 * @param enBU98B10Channel 选择第几片段码
 */
extern uint8_t BU98B10_ALL_CLOSE(BU98B10_Channel_en_t enBU98B10Channel);
#endif
