#ifndef  DATA_TIME_H__
#define  DATA_TIME_H__

#include "Application.h"
#include "Components.h"

#define   SINGLE_MAX_TIME_SECOND    91800U                /*单次计时最大显示时长，单位s*/

typedef struct //__attribute__((aligned(4))) 
{
    uint8_t   SingleHour;       /*单次计时小时*/
    uint8_t   SingleHourHistory;/*单次计时小时历史值，用于对比小时数是否变化，补偿时间用*/
    uint8_t   SingleMin;        /*单次计时分钟*/
    uint8_t   SingleValid;      /*单次工作时间有效状态*/
    uint32_t  TotalHour;        /*累计计时小时*/
    uint32_t  KeepTimeCount;    /*单次工作时长自主计时，单位s*/

}DataTimeStruct_st_t;

extern uint8_t g_u8ID339flag;

extern void Data_Time_KL30_Init(void);
extern void Data_Time_KL15_Init(void);
extern void Data_Time_Single_Working_Hours(void);
extern void Data_Time_Total_Working_Hours(void);
extern void Data_CumulativeWorkHours_EEPROM_Write(void);
extern void Single_Working_Hours_Count(void);

extern uint8_t Get_SingleHour_Display(void);
extern uint8_t Get_SingleMin_Display(void);
extern uint8_t Get_Single_Working_Hours_Status(void);
extern uint32_t Get_Total_Working_Hours(void);
extern uint8_t Get_Clock_All_lenth(void);

extern void TYW_Clear_Eeprom_Service(void);
extern void TYW_RESET_TIME(void);

#endif
