
#include "BackLight\BackLight.h"
#include "Components.h"
#include "Application.h"
#include "TrmerM\TrmerM.h"


#define BACK_LIGHT_DAY 200
#define  openLED_flag  (Get_CAN_Power_State() != PKEY_ON && Get_CAN_Power_State() != KEY_OFF &&(ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) <= 16000 && ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) >= 9000))
uint8_t interact_PWM_Low_Duty = 0;

void BackLight_Process(void)
{
    if (openLED_flag && Charge_OFF_Flag != 2)
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, BACK_LIGHT_DAY);
        //电量
        if (Get_EleDial_AllSOC_lenth() == 2 || checkself_seg_Flag == 1)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_HIGH);//百位
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_HIGH); 
        }
        else if(Get_EleDial_AllSOC_lenth() == 1)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_HIGH); 
        }
        else
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_LOW); 
        }
        
    }
    else
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
        RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);
        RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_LOW); 
    }
}

void BackLight_Clock_All_Process(void)
{
    if (openLED_flag && Charge_OFF_Flag == 0)
    {
        //总计时间
        if (Get_Clock_All_lenth() == 2|| checkself_seg_Flag == 1)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计百十位_MCU_OUT
        }
        else if(Get_Clock_All_lenth() == 1)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计百十位_MCU_OUT
        }
        else
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计百十位_MCU_OUT 
        }
        
    }
    else
    {
        RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
        RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计百十位_MCU_OUT 
    }
}

void Interact_Light_Process(void)
{
    if (openLED_flag && Charge_OFF_Flag == 0)
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, interact_PWM_Low_Duty * 10);
    }
    else
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, 0);
    }
}
uint8_t Get_Interact_Light_State(void)
{
    uint8_t stata = 0x0;
    if(interact_PWM_Low_Duty == 0)
    {
        stata = 0x1;
    }
    else if(interact_PWM_Low_Duty == 30)
    {
        stata = 0x2;
    }
    else if(interact_PWM_Low_Duty == 50)
    {
        stata = 0x3;
    }
    return stata;
}
