

#include "isr.h"
#include "gpio.h"
#include "RTE_AD.h"

void RTC_ADC_Interrupt(void *msg)
{
	INTC_ClearPendingIRQ(ADC_IRQn);     //clear INTAD interrupt flag

}


void RTC_ADC_INIT(uint16_t u16Pin)
{
	uint16_t u16PortIndex;
  uint16_t u16PinIndex;

	GPIO_InitTypeDef      GPIO_InitStructure = {0};
	ADC_InitTypeDef       ADC_InitStructure = {0};
	
	u16PinIndex  = u16Pin & 0x00FFU;
  u16PortIndex = (u16Pin >> 8) & 0x00FFU;
	
	GPIO_InitStructure.GPIO_Pin  = 1U << u16PinIndex;  
	GPIO_InitStructure.GPIO_Ctrl = GPIO_Control_ANA; 
	GPIO_Init(u16PortIndex, &GPIO_InitStructure);

  ADC_InitStructure.ADC_Mode = ADC_Mode_Select; 
	ADC_InitStructure.ADC_ConvSpeed = ADC_ConvSpeed_High; 
	ADC_InitStructure.ADC_Prescaler = ADC_Prescaler_Div32;
	ADC_InitStructure.ADC_RefVoltage = ADC_Ref_Vdd; //????VDD????????
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrig_Software; //?��????��?
	ADC_InitStructure.ADC_ContinuousConvMode = ADC_Conv_Continuous;//????????��???
	ADC_InitStructure.ADC_TwoSamplingDelay = ADC_TwoSamplingDelay_13p5Cycles; 
	ADC_InitStructure.ADC_UpLimit = ADC_UpLimit_Setting; //adc???��??8?? ???����???��??��??????????
	ADC_InitStructure.ADC_LowLimit = ADC_LowLimit_Setting; //adc???��??8?? ???����???��?????????????
	ADC_Init(&ADC_InitStructure);

	ISR_Register(ADC_IRQn, RTC_ADC_Interrupt); //????��????��??��??��
	ISR_DisRegister(ADC_IRQn, RTC_ADC_Interrupt);

}

void RTC_ADC_Converse(ADC_Channel_t ch, uint32_t times, uint16_t *buf)
{
	ADC_Converse(ch, times, buf);
}


void RTC_ADC_Start(ADC_Channel_t ch)
{
  ADC_Start(ch);
}

void RTC_ADC_Stop(void)
{
  ADC_Stop();
}

