#ifndef _SEG_DISPLAY_H_
#define _SEG_DISPLAY_H_

#include "SEG_Ref.h"
#include "Components.h"


typedef enum
{
    SEG_LED_Voltage = 0u,        
    SEG_LED_Auto_Start_Stop,
    SEG_LED_Fuel,
    

    SEG_LED_MAX
} SEG_LED_Idx_t;

enum
{
  Gear_P = 0,  //P
  Gear_R,      //R
  Gear_N,      //N
  Gear_D,      //D
}; 

/**@brief 边框线显示函数*/
_Fun_Res SEG_SET_Frame(uint8_t m_Flag);

/**@brief 挡位显示函数*/
_Fun_Res SEG_SET_GEAR(uint8_t m_Gear_Flag,uint8_t m_Gear);

/**@brief 电量表盘显示函数*/
_Fun_Res SEG_SET_EleDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_NUM);

/**@brief 燃油表盘显示函数*/
_Fun_Res SEG_SET_FuelDial(uint8_t m_Flag,uint8_t m_SEG);

/**@brief 转速表盘显示函数*/
_Fun_Res SEG_SET_EspeedDial(uint8_t m_Flag, uint8_t m_SEG, uint16_t m_NUM);

/**@brief 功率表盘显示函数*/
_Fun_Res SEG_SET_PowerDial(uint8_t m_Flag,uint8_t m_SEG,uint8_t m_Sign,uint8_t m_NUM);

/**@brief 续航里程显示函数*/
_Fun_Res SEG_SET_DTE_NUM(uint8_t m_Flag, uint16_t m_NUM);


/**@brief L8字段显示函数*/
_Fun_Res SEG_SET_L8_NUM(uint8_t m_Flag , uint8_t m_NUM);

/**@brief 总计里程显示函数*/
_Fun_Res SEG_SET_ODO_NUM(uint8_t m_Flag,uint32_t m_NUM);

/**@brief 小计里程显示函数*/
_Fun_Res SEG_SET_TRIP_NUM(uint8_t m_Flag,uint16_t m_NUM);

/**@brief 时间显示函数*/
_Fun_Res SEG_SET_Clock(uint8_t m_hour, uint8_t m_minute, uint8_t m_icon, uint8_t m_Flag1, uint8_t m_Flag2 );

void Check_SEG_Display(void);

extern uint8_t check_SEG_step;
extern uint8_t Espeed_check_SEG_step;


#define IC_SEG_OFF   0x00u
#define IC_SEG_ON    0x07u
#define IC_SEG_GREY  0x01u 

/**@brief 指示灯显示函数*/
_Fun_Res SEG_SET_LED_STS(uint8_t LED_NUM , uint8_t m_Flag);

//扫盘用
_Fun_Res SEG_Scan_SET_EleDial(uint8_t m_SEG);
_Fun_Res SEG_Scan_SET_PowerDial(uint8_t m_SEG);

void SEG_Scan_SET_FuelDial(void);
void SEG_Scan_SET_EspeedDial(void);

extern void Checkself_Init (void);
extern void Checkself_SEG_Display(void);
void TYW_Check_Count(void);




#endif
