
#include "BackLight\BackLight.h"
#include "Components.h"
#include "Application.h"
#include "TrmerM\TrmerM.h"


#define BACK_LIGHT_DAY 50
#define BACK_LIGHT_NIGHT 200
_Light g_Light;
_Light interact_Light;
uint8_t interact_PWM_Low_Duty = 0;
void BackLight_Init(void)
{
    g_Light.Light_Day    = 0XFFFF;
    g_Light.Light_Night  = 0XFFFF;
    interact_Light.Light_Day    = 0XFFFF;
    interact_Light.Light_Night  = 0XFFFF;
}

void BackLight_Process(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(ALS_Get_Data1() > 200)//data1 500以内,data0 3000以内
        {
            if (g_Light.Light_Day < 15)//1.5s 1500ms
            {
                g_Light.Light_Day++;//100ms
            }
            else
            {
                g_Light.Light_Night = 0;
                TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, BACK_LIGHT_DAY);
            }
        }
        else
        {
            if (g_Light.Light_Night < 15)
            {
                g_Light.Light_Night++;
            }
            else
            {
                g_Light.Light_Day = 0;
                TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, BACK_LIGHT_NIGHT);
            }
        }
    }
    else
    {
        g_Light.Light_Day = 0;
        g_Light.Light_Night = 0;
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
    }
}

void Interact_Light_Process(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(ALS_Get_Data1() > 200)//data1 500以内,data0 3000以内
        {
            if (interact_Light.Light_Day < 15)//1.5s 1500ms
            {
                interact_Light.Light_Day++;//100ms
            }
            else
            {
                interact_Light.Light_Night = 0;
                TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, interact_PWM_Low_Duty * 10);
            }
        }
        else
        {
            if (interact_Light.Light_Night < 15)
            {
                interact_Light.Light_Night++;
            }
            else
            {
                interact_Light.Light_Day = 0;
                TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, BACK_LIGHT_NIGHT);
            }
        }
    }
    else
    {
        interact_Light.Light_Day = 0;
        interact_Light.Light_Night = 0;
        TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, 0);
    }
}
