#include "BU98B10_User.h"

/*数字显示数组*/                                /*0,     1     2       3      4      5       6      7      8     9     A     b       C    d      E     F    U     P    L      -    null*/
const uint8_t BU98B10MASK[BU98B10DIS_MAX_7] = { 0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71 ,0x3E, 0x73, 0x38, 0x76,0x40,  0x00};
/*数字显示数组*/                                     /*0,        1       2          3           4           5           6           7           8           9      null       */
const uint32_t BU98B10MASK_27[BU98B10DIS27_MAX_27] = { 0x3FFFFFu, 0xFF8u, 0x387F8FFu, 0x384FFFFu, 0x3B40FF9u, 0x3B4FE8Fu, 0x3BFFE8Fu, 0x540201Fu, 0x3BFFFFFu, 0x3B4FFFFu, 0x00000000u};
/*数字显示数组*/                                     /*0,        1       2       3           4          5          6          7           8           9      null       */
const uint32_t BU98B10MASK_25[BU98B10DIS25_MAX_25] = { 0xFFFFFu, 0x7F8u, 0xE3FCFFu, 0xE27FFFu, 0xEE07F9u, 0xEE7F8Fu, 0xEFFF8Fu, 0x150101Fu, 0xEFFFFFu, 0xEE7FFFu, 0x00000000u};
/*数字显示数组*/                                   /*P,       R          N          H           L        null       */
const uint32_t BU98B10MASK_23[BU98B10DIS23_MAX_23] = { 0x3BE03Fu, 0x7BED3Fu,0x57EFFBu, 0x3BE7F9u, 0x3FE01u,0x00000000u};
/*数字显示数组*/                                      /*0,      1        2        3        4        5        6        7        8        9   */
const uint16_t BU98B10MASK_16[BU98B10DIS16_MAX_16] = { 0x00FFu, 0x040Cu, 0x8877u, 0x083Fu, 0x888Cu, 0x88BBu, 0x88FBu, 0x000Fu, 0x88FFu, 0x88BFu, \
    /* A      B        C        D        E        F        G        H        I        J        K        L       M        N      O        P   */ 
    0x88CFu,  0x2A3Fu, 0x00F3u, 0x223Fu, 0x80F3u, 0x80C3u ,0x08FBu, 0x88CCu, 0x2233u, 0x007Cu, 0x94C0u, 0x00F0u,0x05CCu,0x11CCu,0x00FFu,0x88C7u,\
    /* Q      R        S        T        U        V        W        X        Y        Z        乘x      +        -        除/      [        ]   */ 
    0x10FFu,  0x98C7u, 0x88BBu, 0x2203u, 0x00FCu, 0x44C0u, 0x50CCu, 0x5500u, 0x88BCu, 0x4433u, 0x5500u, 0xAA00u, 0x8800u, 0x4400u, 0x00E1u,0x2221u,\
    /* (      )        =        度°       null */ 
    0x1400u, 0x4100u, 0x8830u,  0x0A06u,  0x0000u,};
uint8_t BU98B10_Set_Numble(const BU98B10_USER_st_t* pBU98B10User, uint8_t enBU98B10Value, BU98B10_Number_SEG_en_t enBU98B10SEGNum, uint8_t Enable)
{
    uint8_t i = 0;
    uint8_t u8Index = 0;
    uint8_t BU98B10NUMBERMAX = 0;
    if (pBU98B10User == (void*)0)
    {
        return 2;
    }
    if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_7)
    {
        BU98B10NUMBERMAX = 7;
    }
    else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_27)
    {
        BU98B10NUMBERMAX = 27;
    }
    else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_25)
    {
        BU98B10NUMBERMAX = 25;
    }
    else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_23)
    {
        BU98B10NUMBERMAX = 23;
    }
    else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_16)
    {
        BU98B10NUMBERMAX = 16;
    }
    else
    {
        return 2;
    }
    for (i = 0; i < BU98B10NUMBERMAX; i++)
    {
        if ((pBU98B10User[i].u8BU98B10_Seg <= BU98B10SEGMAX) && (pBU98B10User[i].enBU98B10Channel <= BU98B10_CHANNEL_1))
        {
            if (pBU98B10User[i].u8BU98B10_Seg != 0)
            {
                u8Index = pBU98B10User[i].u8BU98B10_Seg - 1;
            }
            else
            {
                u8Index = 0;
            }
            if (pBU98B10User[i].enBU98B10Channel == BU98B10_CHANNEL_0)
            {
                if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_7)
                {
                    if (Enable)
                    {
                    
                        if ((BU98B10MASK[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_27)
                {
                    if (Enable)
                    {
                    
                        if ((BU98B10MASK_27[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_25)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_25[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_23)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_23[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_16)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_16[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else
                {
                    return 2;
                }
                    
            }
            else
            {
#if   USE_BU98R10_CHIP_1

                if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_7)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_27)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_27[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_25)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_25[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_23)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_23[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else if(enBU98B10SEGNum == BU98B10_NUMBER_SEG_16)
                {
                    if (Enable)
                    {
                        if ((BU98B10MASK_16[enBU98B10Value] & (1 << i)) != 0)
                        {
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_ON << ((u8Index % 2) * 4));
    
                        }
                        else
                        {
                        
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                            BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                        }
                    }
                    else
                    {
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
                        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (BU98B10_OFF << ((u8Index % 2) * 4));
                    }
                }
                else
                {
                    return 2;
                }
                    
#endif
            }
        }
        else
        {
            return 3;
        }
    }

    return 0;
}

uint8_t BU98B10_Set_Seg_Level(BU98B10_Channel_en_t enBU98B10Channel, uint8_t u8Seg, BU98B10_Color_en_t enColor)
{

    uint8_t u8Index = 0;
#if   USE_BU98R10_CHIP_1
    if (enBU98B10Channel > BU98B10_CHANNEL_MAX)
    {
        return 1;
    }
#else
    if (enBU98B10Channel > BU98B10_CHANNEL_0)
    {
        return 1;
    }

#endif

    if (u8Seg > BU98B10SEGMAX)
    {
        return 2;
    }

    if (enColor > BU98B10_ON)
    {
        return 3;
    }

    if (u8Seg != 0)
    {

        u8Index = u8Seg - 1;
    }
    else
    {
        u8Index = 0;
    }
    if (enBU98B10Channel == BU98B10_CHANNEL_0)
    {
        BU98R10Chip0DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
        BU98R10Chip0DDRAM.Byte[u8Index / 2] |= (enColor << ((u8Index % 2) * 4));
    }
    else
    {
#if   USE_BU98R10_CHIP_1
        BU98R10Chip1DDRAM.Byte[u8Index / 2] &= ~(0xF << ((u8Index % 2) * 4));
        BU98R10Chip1DDRAM.Byte[u8Index / 2] |= (enColor << ((u8Index % 2) * 4));
#endif
			
    }
    return 0;
}

/**
 * @brief 设置段码全开 默认等级 7
 * @param enBU98B10Channel 选择第几片段码
 */
uint8_t BU98B10_ALL_OPEN(BU98B10_Channel_en_t enBU98B10Channel)
{
    uint8_t i = 0;

#if   USE_BU98R10_CHIP_1
    if (enBU98B10Channel > BU98B10_CHANNEL_MAX)
    {
        return 1;
    }
#else
    if (enBU98B10Channel > BU98B10_CHANNEL_0)
    {
        return 1;
    }

#endif
    for (i = 0; i < BU98B10SEGMAX / 2; i++)
    {
        if (enBU98B10Channel == BU98B10_CHANNEL_0)
        {
            BU98R10Chip0DDRAM.Byte[i] = 0x77;
        }
        else
        {
#if   USE_BU98R10_CHIP_1
            BU98R10Chip1DDRAM.Byte[i] = 0x77;
#endif
        }
    }

    return 0;
}


/**
 * @brief 设置段码全关 默认等级 7
 * @param enBU98B10Channel 选择第几片段码
 */
uint8_t BU98B10_ALL_CLOSE(BU98B10_Channel_en_t enBU98B10Channel)
{
    uint8_t i = 0;
#if   USE_BU98R10_CHIP_1
    if (enBU98B10Channel > BU98B10_CHANNEL_MAX)
    {
        return 1;
    }
#else
    if (enBU98B10Channel > BU98B10_CHANNEL_0)
    {
        return 1;
    }

#endif
    for (i = 0; i < BU98B10SEGMAX / 2; i++)
    {
        if (enBU98B10Channel == BU98B10_CHANNEL_0)
        {
            BU98R10Chip0DDRAM.Byte[i] = 0;
        }
        else
        {
#if   USE_BU98R10_CHIP_1
            BU98R10Chip1DDRAM.Byte[i] = 0;
#endif
        }
    }

    return 0;
}







/* example */

// #define ODO_SEG_ONE(channel, segment) {channel, segment}


// const BU98B10_USER_st_t ODONUMLIST[BU98B10NUMBERMAX] = {
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  149), /* A */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  148), /* B */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  146), /* C */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  145), /* D */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  76),  /* E */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  75),  /* F */
//     ODO_SEG_ONE(BU98B10_CHANNEL_0,  147)  /* G */
// };

// #define VSPEED_SEG_MAX 10
// #define VSPEED_SEG(channel, segment) {channel, segment}
// const BU98B10_USER_st_t VSPEEDSEGLIST[VSPEED_SEG_MAX] = {
//     VSPEED_SEG(BU98B10_CHANNEL_0, 96),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 97),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 98),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 99),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 100),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 101),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 102),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 103),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 105),
//     VSPEED_SEG(BU98B10_CHANNEL_0, 106),
// };
// uint8_t u8vspeedseg = 10;
// void example(void)
// {
//     uint8_t i = 0;
//     BU98B10_Set_Numble(&ODONUMLIST[0], BU98B10DIS_NUMBLE_8, BU98B10_OFF);

//     for (i = 0; i < VSPEED_SEG_MAX; i++)
//     {
//         if (i < u8vspeedseg)
//         {
//             BU98B10_Set_Seg_Level(VSPEEDSEGLIST[i].enBU98B10Channel, VSPEEDSEGLIST[i].u8BU98B10_Seg, BU98B10_ON);
//         }
//         else
//         {
//             BU98B10_Set_Seg_Level(VSPEEDSEGLIST[i].enBU98B10Channel, VSPEEDSEGLIST[i].u8BU98B10_Seg, BU98B10_GRAY_LEVEL1);
//         }
//     }
// }
