
#include "BackLight_User.h"
#include "BackLight.h"
#include "TrmerM\TrmerM.h"


#define BACK_LIGHT_DAY 200
#define  openLED_flag  ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
uint8_t interact_PWM_Low_Duty = 0;

Backlight_User_OPT3004_st_t opt3004;
uint8_t g_u8BacklightUserDayTimecount = 0;
uint16_t u16Backlightcount = 0U;
uint8_t u8BacklightLevel = 0U;

/* 填写NTC阻值温度对应表*/
_st_Backlight_NtcTable BacklightNTCTable[Backlight_NTC_Max] =
    {
        /*温度   阻值 */
        { 550, 2709},
        { 600, 2224},
        { 650, 1832},
        { 700, 1518},
        { 750, 1263},
        { 800, 1056},
        { 850,  887},
        { 900,  748},
        { 950,  633},
        {1000,  538},
};
/* 填写背光等级及占空比对应表 */
_st_BacklightLevel BacklightLevelTable[BacklightLevel_Max] =
{
    /*背光等级   背光占空比 */
    {1,    50},             /*夜间背光1级*/
    {2,   100},             /*夜间背光2级*/
    {3,   150},             /*夜间背光3级*/
    {4,   200},             /*夜间背光4级*/
    {5,   250},             /*夜间背光5级*/
    {6,   100},             /*白天背光1级*/
    {7,   200},             /*白天背光2级*/       
    {8,   300},             /*白天背光3级*/
    {9,   400},             /*白天背光4级*/
    {10,  500},             /*白天背光5级*/
};

/**
 * @brief 获取背光使能回调函数
 * 用于控制背光开启关闭
 */
uint8_t Get_BackLight_En(void)
{
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (openLED_flag))
    {
        return 1;
    }
    else
    {
        #if(PART_NUMBER == G54_A01)
        if ((Get_CAN_Power_State() == PKEY_ON) && (Get_Soc1_Valid() == 1U))
        {
            return 1;
        }
        else 
        {
            return 0;
        }
        #else
        return 0;
        #endif
    }
}
/**
 * @brief 设置PWM回调函数
 */
void Set_Pwm_Cbk(uint16_t PWM)
{
    TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, PWM);
}

/**
 * @brief 获取当前背光等级回调函数
 */
uint8_t Get_BackLight_Level(void)
{
    // uint16_t u8PositionStatus = 0U;
    // // u8PositionStatus = (Line_In_Get_Status(LINE_IN_PositionLight));
    // if (u8PositionStatus == 1U)
    // {
    //     return u8BacklightLevel;
    // }
    // else
    // {
    //     return u8BacklightLevel + 5U; 
    // }
    return 5;
}

/**
 * @brief 获取当前显示背光等级函数
 */
uint8_t Get_BackLight_Level_Display(void)
{
    return u8BacklightLevel;
}

// /**
//  * @brief 获取当前NTC阻值 ,本项目没有NTC热敏电阻采集
//  */
// uint16_t Get_NTC_Rec(void)
// {
    
//     // uint16_t u16NTCresistance = 0U;

//     // u16NTCresistance = ADC_Read_Signal(ADC_CH_NTC_R);

//     // return u16NTCresistance;
// }

void BackLight_User_Init(void)
{
    _st_BackLight_Init BackLightInit;
    BackLightInit.SetPwmCbk = Set_Pwm_Cbk;
    BackLightInit.SetPwmEnCbk = Get_BackLight_En;
    BackLightInit.SetPwmLevelCbk = Get_BackLight_Level;
    BackLightInit.NtcResCbk = ((void *)0);
    BackLightInit.BacklightNTCTable = &BacklightNTCTable[0];
    BackLightInit.BacklightLevelTable = &BacklightLevelTable[0];
    Backlight_KL30_WakeUp_Init(&BackLightInit);
    // opt3004.u8DayandNightSts = DAY_SCREEN;
    // opt3004.u32Result = 0;
    u8BacklightLevel = 3U;
}

void BackLight_Process(void)
{
    #if (PART_NUMBER == RMR42E_60)
    if (openLED_flag)
    #else
    if (((Get_CAN_Power_State() > KEY_OFF) && (Get_AllSocValid() == 1U)) || ((Get_CAN_Power_State() == KEY_ACC) && (checkself_seg_Flag == 1)))
    #endif
    {
        //电量
        if ((Get_EleDial_AllSOC_lenth() == 2) || (checkself_seg_Flag == 1))
        {
            #if (PART_NUMBER == RMR42E_60)
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_HIGH);//百位
            #else
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN05, RTE_GPIO_LEVEL_HIGH);//百位
            #endif
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_HIGH); 
        }
        else if(Get_EleDial_AllSOC_lenth() == 1)
        {
            #if (PART_NUMBER == RMR42E_60)
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);//百位
            #else
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN05, RTE_GPIO_LEVEL_LOW);//百位
            #endif
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_HIGH); 
        }
        else
        {
            #if (PART_NUMBER == RMR42E_60)
            RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);//百位
            #else
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN05, RTE_GPIO_LEVEL_LOW);//百位
            #endif
            RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_LOW); 
        }
        
    }
    else
    {
        #if (PART_NUMBER == RMR42E_60)
        RTE_GPIO_Set_Level(RTE_GPIO_PORT03_PIN00, RTE_GPIO_LEVEL_LOW);//百位
        #else
        RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN05, RTE_GPIO_LEVEL_LOW);//百位
        #endif
        RTE_GPIO_Set_Level(RTE_GPIO_PORT02_PIN04, RTE_GPIO_LEVEL_LOW); 
    }
}

void BackLight_Clock_All_Process(void)
{
    if (openLED_flag && (Charge_OFF_Flag == 0))
    {
        //总计时间
        if ((Get_Clock_All_lenth() == 2)|| (checkself_seg_Flag == 1))
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计百十位_MCU_OUT
        }
        else if(Get_Clock_All_lenth() == 1)
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_HIGH);     //总计工作时长统计百十位_MCU_OUT
        }
        else
        {
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
            RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计百十位_MCU_OUT 
        }
        
    }
    else
    {
        RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN05, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计千位_MCU_OUT
        RTE_GPIO_Set_Level(RTE_GPIO_PORT01_PIN06, RTE_GPIO_LEVEL_LOW);     //总计工作时长统计百十位_MCU_OUT 
    }
}

void Interact_Light_Process(void)
{
    #if (PART_NUMBER == RMR42E_60)
        if ((Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL) && (Charge_OFF_Flag == 0))
        {
            TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, interact_PWM_Low_Duty * 10);
        }
        else
        {
            TimerM_PWM_set_duty(TIMERM_COUNTER0, TIMERM_CHD, 1000);
        }
    #endif
}
uint8_t Get_Interact_Light_State(void)
{
    uint8_t stata = 0x0;
    if(interact_PWM_Low_Duty == 0)
    {
        stata = 0x1;
    }
    else if(interact_PWM_Low_Duty == 30)
    {
        stata = 0x2;
    }
    else if(interact_PWM_Low_Duty == 50)
    {
        stata = 0x3;
    }
    return stata;
}


