#include "Can_RX_User.h"
#include "DoCAN_ISO15765.h"
#include "can.h"
#include "RTE.h"

static uint8_t BMCU_ErrorGrage = 0;
static uint8_t BMCU_BladeSpeedGear = 0;
static uint8_t BMCU_PTOSwicthState = 0;

static uint8_t BMCU_Moto2_Locked_RotorFault = 0;
static uint8_t BMCU_Moto1_Locked_RotorFault = 0;
static uint8_t MBMS_Soc = 0;

static uint8_t MBMS_TOTALWorkState = 0;
static uint8_t MBMS_TOTALSigOn = 0;
static uint8_t MBMS_TOTALSigAcc = 0;
static uint8_t MBMS_TOTALSigCharge = 0;

static uint8_t MBMS_StatSoc = 0;

static uint8_t MBMS_StatBattChargeState = 0;
static uint8_t MBMS_StatBattWorkState = 0;

static uint8_t MMCU_ErrorGrage = 0;
static uint8_t MMCU_ChgProtectState = 0;
static uint8_t MMCU_DCDCEnableState = 0;
static uint8_t MMCU_ParkingGearState = 0;
static uint8_t MMCU_SeatDetectState = 0;
static uint8_t MMCU_LockMotoState = 0;
static uint8_t MMCU_EBSState = 0;
static uint8_t MMCU_TravelSpeedGear = 0;
static uint8_t MMCU_PowerMode = 0;
static uint8_t MMCU_WorkState = 0;

static uint16_t MMCU_AccumulatedWorkHours = 0;
static uint8_t MMCU_SingleWorkingHours = 0;
static uint8_t SBMS_Soc = 0;
static uint8_t SMCU_ErrorGrage = 0;
void Set_CAN_ALL_Signal(void)
{
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL)
    {
        BMCU_ErrorGrage = Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage();
        BMCU_BladeSpeedGear = Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear();
        BMCU_PTOSwicthState = Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x38E_Msg)) == CAN_SIG_NORMAL)
    {
        BMCU_Moto1_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault();
        BMCU_Moto2_Locked_RotorFault = Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A20_Msg)) == CAN_SIG_NORMAL)
    {
        MBMS_Soc = Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18202922_Msg)) == CAN_SIG_NORMAL)
    {
        MBMS_TOTALWorkState = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState();
        MBMS_TOTALSigOn = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn();
        MBMS_TOTALSigAcc = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc();
        MBMS_TOTALSigCharge = Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203020_Msg)) == CAN_SIG_NORMAL)
    {
        MBMS_StatSoc = Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL)
    {
        MBMS_StatBattChargeState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState();
        MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL)
    {
        MMCU_ErrorGrage = Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage();
        MMCU_ChgProtectState = Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState();
        MMCU_DCDCEnableState = Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState();
        MMCU_ParkingGearState = Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState();
        MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
        MMCU_LockMotoState = Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState();
        MMCU_EBSState = Get_CAN_CH0_ID_125_Sig_MMCU_EBSState();
        MMCU_TravelSpeedGear = Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear();
        MMCU_PowerMode = Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode();
        MMCU_WorkState = Get_CAN_CH0_ID_125_Sig_MMCU_WorkState();
    }
    else
    {
        MMCU_SeatDetectState = Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(); // 掉线需要做处理
        MMCU_PowerMode = POWER_CHECK_NULL;
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_SIG_NORMAL)
    {
        MMCU_AccumulatedWorkHours = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
        MMCU_SingleWorkingHours = Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18200A21_Msg)) == CAN_SIG_NORMAL)
    {
        SBMS_Soc = Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc();
    }
    if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x134_Msg)) == CAN_SIG_NORMAL)
    {
        SMCU_ErrorGrage = Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage();
    }
    
}

uint8_t Get_CAN_Num_BMCU_ErrorGrage(void)
{
    return BMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_BMCU_BladeSpeedGear(void)
{
    return BMCU_BladeSpeedGear;
}
uint8_t Get_CAN_Num_BMCU_PTOSwicthState(void)
{
    return BMCU_PTOSwicthState;
}
uint8_t Get_CAN_Num_BMCU_Moto2_Locked_RotorFault(void)
{
    return BMCU_Moto2_Locked_RotorFault;
}
uint8_t Get_CAN_Num_BMCU_Moto1_Locked_RotorFault(void)
{
    return BMCU_Moto1_Locked_RotorFault;
}
uint8_t Get_CAN_Num_MBMS_Soc(void)
{
    return MBMS_Soc;
}
uint8_t Get_CAN_Num_MBMS_TOTALWorkState(void)
{
    return MBMS_TOTALWorkState;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigOn(void)
{
    return MBMS_TOTALSigOn;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigAcc(void)
{
    return MBMS_TOTALSigAcc;
}
uint8_t Get_CAN_Num_MBMS_TOTALSigCharge(void)
{
    return MBMS_TOTALSigCharge;
}
uint8_t Get_CAN_Num_MBMS_StatSoc(void)
{
    return MBMS_StatSoc;
}
uint8_t Get_CAN_Num_MBMS_StatBattChargeState(void)
{
    return MBMS_StatBattChargeState;
}
uint8_t Get_CAN_Num_MBMS_StatBattWorkState(void)
{
    return MBMS_StatBattWorkState;
}
uint8_t Get_CAN_Num_MMCU_ErrorGrage(void)
{
    return MMCU_ErrorGrage;
}
uint8_t Get_CAN_Num_MMCU_ChgProtectState(void)
{
    return MMCU_ChgProtectState;
}
uint8_t Get_CAN_Num_MMCU_DCDCEnableState(void)
{
    return MMCU_DCDCEnableState;
}
uint8_t Get_CAN_Num_MMCU_ParkingGearState(void)
{
    return MMCU_ParkingGearState;
}
uint8_t Get_CAN_Num_MMCU_SeatDetectState(void)
{
    return MMCU_SeatDetectState;
}
uint8_t Get_CAN_Num_MMCU_LockMotoState(void)
{
    return MMCU_LockMotoState;
}
uint8_t Get_CAN_Num_MMCU_EBSState(void)
{
    return MMCU_EBSState;
}
uint8_t Get_CAN_Num_MMCU_TravelSpeedGear(void)
{
    return MMCU_TravelSpeedGear;
}
uint8_t Get_CAN_Num_MMCU_PowerMode(void)
{
    return MMCU_PowerMode;
}
uint8_t Get_CAN_Num_MMCU_WorkState(void)
{
    return MMCU_WorkState;
}
uint16_t Get_CAN_Num_MMCU_AccumulatedWorkHours(void)
{
    return MMCU_AccumulatedWorkHours;
}
uint8_t Get_CAN_Num_MMCU_SingleWorkingHours(void)
{
    return MMCU_SingleWorkingHours;
}
uint8_t Get_CAN_Num_SBMS_Soc(void)
{
    return SBMS_Soc;
}
uint8_t Get_CAN_Num_SMCU_ErrorGrage(void)
{
    return SMCU_ErrorGrage;
}



uint8_t Get_CAN_Power_State(void)
{
    uint8_t state = 0;
    uint8_t Power_State = Get_CAN_Num_MMCU_PowerMode();

    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (System_Indicator_CANFlag != 1))
    {
        switch (Power_State)
        {
        case 0x0:
            state = KEY_OFF;
            break;
        case 0x1:
            state = PKEY_ON;
            break;
        case 0x2:
            state = KEY_ACC;
            break;
        case 0x3:
            state = READY;
            break;
        case 0x4:
            state = CHRG_PLUGIN;
            break;
        case 0x5:
            state = CHRGING;
            break;
        case 0x6:
            state = CHRGEND;
            break;
        default:
            state = POWER_CHECK_NULL;
            break;
        }
    }
    else 
    {
        state = POWER_CHECK_NULL;
    }
    return state;
}
