#include "Components.h"
#include "Driving_Information\Data_Gear.h"

GearStruct_st_t Gear;

void Data_Gear_KL30_Init(void)
{
    Gear.CutterHeadNum = 0U;
    Gear.CutterheadValid = 0U;
    Gear.GearNum = 0U;
}

void Data_Gear_KL15_Init(void)
{

}

void Data_Gear_Cutterhead_Service(void)
{
    uint8_t Signal1 = Get_CAN_Num_BMCU_BladeSpeedGear();
    uint8_t Signal2 = Get_CAN_Num_BMCU_ErrorGrage();
    // uint8_t MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
    if ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Get_CAN_Power_State() >= KEY_ACC) && (Get_CAN_Power_State() < CHRGEND) && (System_Indicator_CANFlag != 1))
    {
        if ((Signal1 > 0U) && (Signal1 <= 3U))
        {
            Gear.CutterHeadNum = Signal1;
        }
        else
        {
            Gear.CutterHeadNum = 0U;
        }
        if ((Signal2 == 0x1) || (Signal2 == 0x2) || (Signal2 == 0x3) || (Signal2 == 0x4))
        {
            Gear.CutterheadValid = 0x2U;
        }
        else
        {
            Gear.CutterheadValid = 0x1U;
        }
    }
    else
    {
        Gear.CutterheadValid = 0x0U;
        Gear.CutterHeadNum = 0U;
    }
}

void Data_Gear_Service(void)
{

}

/******************************************************************************
函数名：Get_Gear_Cutterhead_Value
功  能：获取刀盘挡位数函数
参  数：无
返回值：Gear.CutterHeadNum; 
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Gear_Cutterhead_Value(void)
{
    return Gear.CutterHeadNum;
}

/******************************************************************************
函数名：Get_Gear_Cutterhead_Valid
功  能：获取刀盘挡位状态函数
参  数：无
返回值：Gear.CutterheadValid 0--不显示，1--常显，2--闪烁
******************************************************************************
注  意：该函数必须每 ms被调用一次
******************************************************************************/
uint8_t Get_Gear_Cutterhead_Valid(void)
{
    return Gear.CutterheadValid;
}

