#include "GUI_Display\GUI_Display.h"
#include "SEG_DISPLAY\SEG_DISPLAY.h"
#include "Application.h"
#define DISPLAY_OPEN ((Common_Get_IG_Sts() == COMMON_POWER_ON) && (Charge_OFF_Flag == 0) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != PKEY_ON) && (System_Indicator_CANFlag != 1))


uint8_t Charge_OFF_Flag = 0;

void TYW_Clear_Eeprom_Service(void)
{
    #if (PART_NUMBER == RMR42E_60)
        uint8_t u8MBMS_StatBattChargeState = 0;
        uint8_t u8MBMS_StatBattWorkState = 0;
        uint8_t u8BMCU_BladeSpeedGear = 0;
        uint16_t u16MMCU_AccumulatedWorkHours = 0;
        if (Get_CAN_Power_State() == READY)
        {
            if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x18203220_Msg)) == CAN_SIG_NORMAL) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x157_Msg)) == CAN_SIG_NORMAL) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x339_Msg)) == CAN_SIG_NORMAL))
            {
                u8MBMS_StatBattChargeState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState();
                u8MBMS_StatBattWorkState = Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState();
                u16MMCU_AccumulatedWorkHours = Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours();
                u8BMCU_BladeSpeedGear = Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear();
                if ((u8MBMS_StatBattChargeState == 0x7U) && (u8MBMS_StatBattWorkState == 0xfU) && (u8BMCU_BladeSpeedGear == 0x7U) && (u16MMCU_AccumulatedWorkHours >= 60000UL))
                {
                    g_u8TYWClearEepromFlag = 1;
                }
                else
                {
                    g_u8TYWClearEepromFlag = 0;
                }
            }
            else
            {
                g_u8TYWClearEepromFlag = 0;
            }
        }
        else
        {
            g_u8TYWClearEepromFlag = 0;
        }
    #else

    #endif
}

void Gauge_Power_SOC_pull_Display(void)
{
    uint8_t u8Soc1Seg = Get_CAN_Num_MBMS_Soc_1_Grid();
    uint8_t u8Soc2Seg = Get_CAN_Num_SBMS_Soc_2_Grid();
    uint8_t u8Soc1Valid = Get_Soc1_Valid();
    uint8_t u8Soc2Valid = Get_Soc2_Valid();

    SEG_SET_EleDial_1SOC(u8Soc1Valid, u8Soc1Seg);
    SEG_SET_EleDial_2SOC(u8Soc2Valid, u8Soc2Seg);
}

void Gauge_Cutterhead_Gear_Display(void)
{
    uint8_t CutterheadValue = Get_Gear_Cutterhead_Value();
    uint8_t CutterheadValid = Get_Gear_Cutterhead_Valid();
#if (PART_NUMBER == RMR42E_60)
    if (CutterheadValid == 2U)
    {
        if (FLASH_SYNC_1Hz)
        {
            SEG_SET_Cutterhead(1, CutterheadValue, 0);
        }
        else
        {
            SEG_SET_Cutterhead(1, 4, 0);
        }
    }
    else
    {
        SEG_SET_Cutterhead(CutterheadValid, CutterheadValue, 0);
    }
#else
    SEG_SET_Cutterhead(CutterheadValid, CutterheadValue, 0);
#endif
}

void Gauge_Gears_Display(void)
{
    uint8_t GearValue = Get_Gear_Value();
    uint8_t GearValid = Get_Gear_Valid();

    SEG_SET_GEAR(GearValid, GearValue, 0);
}

void Gauge_EleDial_AllSOC_Display(void)
{
    uint8_t u8AllSocValid = Get_AllSocValid();
    uint8_t u8AllSocValue = Get_AllSocValue();
    SEG_SET_EleDial_AllSOC(u8AllSocValid, u8AllSocValue);
}

/*单次工作时长显示函数*/
void Gauge_Clock_Display(void)
{
    uint8_t Clock_hours = Get_SingleHour_Display();
    uint8_t Clock_min = Get_SingleMin_Display();

    if (Get_Single_Working_Hours_Status() == 1U)
    {
        SEG_SET_Clock(Clock_hours, Clock_min, FLASH_SYNC_1Hz, 1, 1);
    }
    else
    {
        SEG_SET_Clock(0, 0, 0, 0, 0);
    }
}

/*累计工作时长显示函数*/
void Gauge_Clock_All_Display(void)
{
    uint32_t TotalHours = Get_Total_Working_Hours();

    if (DISPLAY_OPEN)
    {
        SEG_SET_Clock_ALL(1, TotalHours);
    }
    else
    {
        SEG_SET_Clock_ALL(0, 0);
    }
}

void Gauge_Frame_Display(void)
{
    if (DISPLAY_OPEN)
    {
        SEG_SET_Frame(1);
    }
    else
    {
        SEG_SET_Frame(0);
    }
}

void Gauge_flue_Display(void)
{
    uint8_t u8fuelValid = Get_FuelStatus_Valid();
    uint8_t u8fuelValue = Get_FuelSeg_Display();
    SEG_SET_FuelDial(u8fuelValid, u8fuelValue);
}

void Gauge_faultcode_Display(void)
{
    uint8_t u8faucodeValid = Get_FaultCode_Valid();
    uint16_t u16faucodelValue = Get_FaultCode_Value();
    SEG_SET_Fault_Code(u8faucodeValid, u16faucodelValue, 0);
}

void Clear_Bu98(void)
{
    uint8_t i = 0;
    for (i = 0; i < BU98R10_DDRAM_SIZE; i++)
    {
        BU98R10Chip0DDRAM.Byte[i] = 0;
        BU98R10Chip1DDRAM.Byte[i] = 0;
    }
}

void Gauge_Service(void)
{
    uint8_t i = 0;
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if ((Get_CAN_Power_State() != PKEY_ON) && (Get_CAN_Power_State() != KEY_OFF) && (Get_CAN_Power_State() != POWER_CHECK_NULL))
        {
            if (g_u8TYWClearEepromFlag >= 1)
            {
                TYW_RESET_TIME();
            }
            else
            {
                TYW_Clear_Eeprom_Service();
                interact_PWM_Low_Duty = 100;
                if (Common_GetIgnOnTime() > 1500)
                {
                    SOC_charge_seg_Flag = 0;
                    Checkself_Init();
                    Gauge_CAN_setup_Service();
                }
                else
                {
                    checkself_seg_Flag = 1;
                    if (Get_CAN_Power_State() == KEY_ACC)
                    {
                        interact_PWM_Low_Duty = 0;
                    }

                    Checkself_LED_Display();
                    // Checkself_SEG_Display();
                }
            }
        }
        else if (Get_CAN_Power_State() == PKEY_ON)
        {
            if (Buzzer_time == 0)
            {
                Clear_Bu98();
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
                Checkself_Init();
                // Gpio_Init(Gpio_Sleep_Init);
            }
            interact_PWM_Low_Duty = 50;
        }
        else
        {
            if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(CAN_CH0_ID_CAN_0x125_Msg)) == CAN_SIG_NORMAL)
            {
                // poweroff_time = 0;
                Clear_Bu98();
                interact_PWM_Low_Duty = 100;
                for (i = 0; i < LampCh0_MAX; i++)
                {
                    LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
                }
            }
        }
    }
    else
    {
        Clear_Bu98();
        interact_PWM_Low_Duty = 100;
        for (i = 0; i < LampCh0_MAX; i++)
        {
            LED_Driver_Channel_Set(LampChannel_0, i, LED_OFF);
        }
    }
}

void Gauge_CAN_setup_Service(void)
{
    uint8_t state = Get_CAN_Power_State();
    Gauge_Clock_Display();
    Gauge_Clock_All_Display();
    Gauge_EleDial_AllSOC_Display();
    if (PART_NUMBER == G54_A01)
    {
        Gauge_flue_Display();
        Gauge_faultcode_Display();
    }

    // SEG_SET_GEAR(1, 1);
    // SEG_SET_Cutterhead(1, 2);
    Gauge_Frame_Display();
    Gauge_Cutterhead_Gear_Display();
    Gauge_Gears_Display();
    uint8_t MBMS_TOTALSigAcc = Get_CAN_Num_MBMS_TOTALSigAcc();
    uint8_t MBMS_TOTALSigCharge = Get_CAN_Num_MBMS_TOTALSigCharge();
    Gauge_Power_SOC_pull_Display();
    switch (state)
    {
    case KEY_ACC:
    {
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 0;
    }
    break;
    case READY:
    {
        Charge_OFF_Flag = 0;
        interact_PWM_Low_Duty = 30;
    }
    break;
    case CHRGING:
    {
        SOC_charge_seg_Flag = 1;
    }
    break;
    case CHRG_PLUGIN:
    case CHRGEND:
    {
        if ((MBMS_TOTALSigAcc == 0x0) && (MBMS_TOTALSigCharge == 0x1)) // 下电充电)
        {
            Charge_OFF_Flag = 1;
        }
        else if ((MBMS_TOTALSigAcc == 0x1) && (MBMS_TOTALSigCharge == 0x1))
        {
            Charge_OFF_Flag = 0;
        }
    }
    break;

    default:
        break;
    }
}

void Checkself_LED_Display(void)
{
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_00_Grass_Full_R, LED_ON);
    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_01_Power_Battery_Failure_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_02_System_Indicator_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_05_Gears_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_04_GEAR_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_08_Battery_Charging_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_10_READY_G, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_11_Key_Access_W, LED_ON);

    LED_Driver_Channel_Set(LampChannel_0, LampCh0_12_Seat_Detection_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_13_OVERLOAD_R, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_14_Cutterhead_Switch_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_15_Cutterhead_Gear_W, LED_ON);

    // LED_Driver_Channel_Set(LampChannel_0, LampCh0_17_External_Discharge_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_21_LED_Open_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_31_Working_Hours_One_W, LED_ON);
    LED_Driver_Channel_Set(LampChannel_0, LampCh0_32_Charging_Connection_R, LED_ON);
    SEG_SET_LED_STS(SEG_LED_Recharge, 1);
    SEG_SET_LED_STS(SEG_LED_System_Light, 1);
    SEG_SET_LED_STS(SEG_LED_Chloramine, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Overload, 1);
    SEG_SET_LED_STS(SEG_LED_Seat_Detection, 1);
    SEG_SET_LED_STS(SEG_LED_Key_Access, 1);
    SEG_SET_LED_STS(SEG_LED_Ready, 1);
    SEG_SET_LED_STS(SEG_LED_Cutter_Head_switch, 1);
    // SEG_SET_LED_STS(SEG_LED_External_Discharge, 1);
    SEG_SET_LED_STS(SEG_LED_Distance_Light, 1);
    SEG_SET_LED_STS(SEG_LED_HHT_Charger, 1);
    SEG_SET_Frame(1);
}


void TYW_RESET_TIME(void)
{
    uint32_t Clear_EE[1] = {0};
    if (g_u8TYWClearEepromFlag == 1)
    {
        g_u8TYWClearEepromFlag = 2;
        Clear_EE[0] = 0;
        eeprom_WriteRecord(EEPROM_BLOCK_00, (uint8_t *)&Clear_EE, 4);
    }
    Check_SEG_Display();
}
