#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

//#include "TYW_stdint.h"
//#include "CAN_Lib.h"
#include "Components.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_CAN_0x393_Msg_Count,
    CAN_CH0_ID_CAN_0x398_Msg_Count,
    CAN_CH0_ID_CAN_0x39D_Msg_Count,
    CAN_CH0_ID_CAN_0x3A2_Msg_Count,
    CAN_CH0_ID_CAN_0x3A7_Msg_Count,
    CAN_CH0_ID_CAN_0x157_Msg_Count,
    CAN_CH0_ID_CAN_0x38E_Msg_Count,
    CAN_CH0_ID_CAN_0x18200A20_Msg_Count,
    CAN_CH0_ID_CAN_0x18202922_Msg_Count,
    CAN_CH0_ID_CAN_0x18203020_Msg_Count,
    CAN_CH0_ID_CAN_0x18203220_Msg_Count,
    CAN_CH0_ID_CAN_0x125_Msg_Count,
    CAN_CH0_ID_CAN_0x339_Msg_Count,
    CAN_CH0_ID_CAN_0x18200A21_Msg_Count,
    CAN_CH0_ID_CAN_0x134_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    KEY_OFF = 0,
    PKEY_ON,
    KEY_ACC,
    READY,
    CHRG_PLUGIN,
    CHRGING,
    CHRGEND,

} POWER_CHECK_STATE_t;

typedef enum
{

    CAN_CH0_ID_SEND_3A2_TOTAL,
    CAN_CH0_ID_SEND_3A7_TOTAL,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_CAN_0x393_Msg         0x393ul
#define  CAN_CH0_ID_CAN_0x398_Msg         0x398ul
#define  CAN_CH0_ID_CAN_0x39D_Msg         0x39Dul
#define  CAN_CH0_ID_CAN_0x3A2_Msg         0x3A2ul
#define  CAN_CH0_ID_CAN_0x3A7_Msg         0x3A7ul
#define  CAN_CH0_ID_CAN_0x157_Msg         0x157ul
#define  CAN_CH0_ID_CAN_0x38E_Msg         0x38Eul
#define  CAN_CH0_ID_CAN_0x18200A20_Msg    0x18200A20ul
#define  CAN_CH0_ID_CAN_0x18202922_Msg    0x18202922ul
#define  CAN_CH0_ID_CAN_0x18203020_Msg    0x18203020ul
#define  CAN_CH0_ID_CAN_0x18203220_Msg    0x18203220ul
#define  CAN_CH0_ID_CAN_0x125_Msg         0x125ul
#define  CAN_CH0_ID_CAN_0x339_Msg         0x339ul
#define  CAN_CH0_ID_CAN_0x18200A21_Msg    0x18200A21ul
#define  CAN_CH0_ID_CAN_0x134_Msg         0x134ul

extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_ProtoSubVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_ProtoVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_SoftPhaseVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_SubSoftVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_SoftVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_SubHardVer(void);
extern uint8_t  Get_CAN_CH0_ID_393_Sig_ICU_HardVer(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN0(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN1(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN2(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN3(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN4(void);
extern uint8_t  Get_CAN_CH0_ID_398_Sig_ICU_SN5(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductDay(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductMon(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_ProductYear(void);
extern uint8_t  Get_CAN_CH0_ID_39D_Sig_ICU_CustomerCode(void);
extern uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductCode(void);
extern uint16_t Get_CAN_CH0_ID_39D_Sig_ICU_ProductName(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_BluetoothConnectState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_kEY_EState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_kEY_DState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_kEY_CState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_kEY_BState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_kEY_AState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_GrassFullState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_IndicatorLightPowerState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_IndicatorLightState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_BuzzerState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_LEDLightState(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_KL15State(void);
extern uint8_t  Get_CAN_CH0_ID_3A2_Sig_ICU_POWERStateFB(void);
extern uint8_t  Get_CAN_CH0_ID_3A7_Sig_ICU_VCUCommunicatlost(void);
extern uint8_t  Get_CAN_CH0_ID_3A7_Sig_ICU_MCUCommunicatlost(void);
extern uint8_t  Get_CAN_CH0_ID_3A7_Sig_ICU_SlaveBMSCommunicatlost(void);
extern uint8_t  Get_CAN_CH0_ID_3A7_Sig_ICU_MasterBMSCommunicatlost(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_ErrorGrage(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_BladeSpeedGear(void);
extern uint8_t  Get_CAN_CH0_ID_157_Sig_BMCU_PTOSwicthState(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto2_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_38E_Sig_BMCU_Moto1_Locked_RotorFault(void);
extern uint8_t  Get_CAN_CH0_ID_18200A20_Sig_MBMS_Soc(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALWorkState(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigOn(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigAcc(void);
extern uint8_t  Get_CAN_CH0_ID_18202922_Sig_MBMS_TOTALSigCharge(void);
extern uint8_t  Get_CAN_CH0_ID_18203020_Sig_MBMS_StatSoc(void);
extern uint8_t  Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattChargeState(void);
extern uint8_t  Get_CAN_CH0_ID_18203220_Sig_MBMS_StatBattWorkState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ErrorGrage(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ChgProtectState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_DCDCEnableState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_ParkingGearState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_SeatDetectState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_LockMotoState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_EBSState(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_TravelSpeedGear(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_PowerMode(void);
extern uint8_t  Get_CAN_CH0_ID_125_Sig_MMCU_WorkState(void);
extern uint16_t Get_CAN_CH0_ID_339_Sig_MMCU_AccumulatedWorkHours(void);
extern uint8_t  Get_CAN_CH0_ID_339_Sig_MMCU_SingleWorkingHours(void);
extern uint8_t  Get_CAN_CH0_ID_18200A21_Sig_SBMS_Soc(void);
extern uint8_t  Get_CAN_CH0_ID_134_Sig_SMCU_ErrorGrage(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);
extern uint8_t System_Indicator_CANFlag;
void System_Indicator_ON_callback(void);
void System_Indicator_OFF_callback(void);
extern  uint8_t Get_CAN_Power_State(void);

#endif
