# 读取excel文件内的数据并生成bin文件
import openpyxl
from CRC32 import *

# EXCEL表格名称
file_name = '检测台信息录入-XML_CANFD_Template'

# 自己位置定义
byte_0 = 0
byte_1 = 1
byte_2 = 2
byte_3 = 3

# 起始地址
start_address = 0x050000
# 报文存储区地址 
message_storage_area_address = start_address + 64

# 总校验长度
total_check_length = 0
# 总步数
total_step_number = 0
# 总报文数
total_message_number = 0

# 第N部步骤存储区地址
step_address_storage_area_address_N = 0
# 第N步IO数据首地址
IO_data_address_N = 0
# 第N步PWM数据首地址
PWM_data_address_N = 0

# 存储所有数据的列表包括CRC
all_data_list = [
    # CRC
    0x00, 0x00, 0x00, 0x00,
    # 总校验长度
    0x00, 0x00, 0x00, 0x00,
]

# 除CRC和总校验长度的头部数据列表
data_list = [
    # 报文存储区地址
    0x00, 0x00, 0x00, 0x00,
    # 总报文数
    0x00, 0x00, 0x00, 0x00,
    # 步骤存储区地址
    0x00, 0x00, 0x00, 0x00,
    # 总步数
    0x00, 0x00, 0x00, 0x00,
    # 预留
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
]

# 报文存储区数组
message_storage_area_list = []
# 步骤地址存储区数组
step_address_storage_area_list = []
# 步骤存储区数组
step_storage_area_list = []

########################### 各个工作表的列定义 ###########################

# Sheet1：外发报文录入
# 报文ID
message_id_index = 0
# 索引号
message_index_number_index = 1
# 周期（ms）
message_period_index = 2
# 通道
message_channel_index = 3
# DLC
message_DLC_index = 4
# CANFD
message_CANFD_index = 5
# 扩展帧
message_extended_frame_index = 6


# Sheet2：检测台步骤录入
# 检测台步数列索引
detecting_set_index = 0
# 需要发送的报文ID列索引
detecting_set_message_id_index = 1
# 在外发报文表中的索引号（无需手动输入下拉自动生成）列索引
index_number_index = 2
# 报文内容0-3字节列索引
message_content_0_3_index = 3
# 报文内容4-7字节列索引
message_content_4_7_index = 4
# 报文内容8-11字节列索引
message_content_8_11_index = 5
# 报文内容12-15字节列索引
message_content_12_15_index = 6
# 报文内容16-19字节列索引
message_content_16_19_index = 7
# 报文内容20-23字节列索引
message_content_20_23_index = 8
# 报文内容24-27字节列索引
message_content_24_27_index = 9
# 报文内容28-31字节列索引
message_content_28_31_index = 10
# 报文内容32-35字节列索引
message_content_32_35_index = 11
# 报文内容36-39字节列索引
message_content_36_39_index = 12
# 报文内容40-43字节列索引
message_content_40_43_index = 13
# 报文内容44-47字节列索引
message_content_44_47_index = 14
# 报文内容48-51字节列索引
message_content_48_51_index = 15
# 报文内容52-55字节列索引
message_content_52_55_index = 16
# 报文内容56-59字节列索引
message_content_56_59_index = 17
# 报文内容60-63字节列索引
message_content_60_63_index = 18


# Sheet3：GPIO
# 检测台步数列索引
GPIO_detecting_set_step_num_index = 0
# 需要控制的IO列索引
GPIO_control_IO_index = 1
# 电平(0 低电平 1高电平)列索引
GPIO_level_index = 2
# 方向(DIR 0输入  1输出)列索引
GPIO_direction_index = 3


# Sheet4：PWM
# 检测台步数列索引
PWM_detecting_set_step_num_index = 0
# 需要控制的通道列索引
PWM_control_channel_index = 1
# 方向(DIR 0输入  1输出)列索引
PWM_direction_index = 2
# 占空比(%)列索引
PWM_duty_cycle_index = 3
# 频率(HZ)列索引
PWM_frequency_index = 4


# Sheet5：检测台步数统计
# 检测台步数列索引
detecting_set_step_number_index = 'A'
# 此步操作的报文数量（无需手动输入下拉自动生成）列索引
current_step_message_number = 'B'
# 此步操作的IO数量（无需手动输入下拉自动生成）列索引
current_step_IO_number = 'C'
# 此步操作的PWM数量（无需手动输入下拉自动生成）列索引
current_step_PWM_number = 'D'


########################### 函数区 ###########################

# 获取32位4字节数据指定字节的数据
def get_uint32_data_specified_byte_data(data, specified_byte):
    if specified_byte == 0:
        return (data & 0X000000FF) >> 0
    elif specified_byte == 1:
        return (data & 0X0000FF00) >> 8
    elif specified_byte == 2:
        return (data & 0X00FF0000) >> 16
    elif specified_byte == 3:
        return (data & 0XFF000000) >> 24
    else:
        return 0

# 读取excel文件函数
def read_excel_file(file_name):
    print("EXCEL表格名称：" + file_name)
    excel_file_object = openpyxl.load_workbook(file_name, data_only=True)
    return excel_file_object


# 关闭excel文件函数
def close_excel_file(excel_file_object):
    excel_file_object.close()
    pass


# 获取总步数
def get_total_step_number(sheet_object):
    global total_step_number
    # 获取总步数
    i = 0
    for row in sheet_object.iter_rows(values_only=True, min_row=2):
        if row[i] != None:
            total_step_number = row[i]
        elif row[i] == None :
            break
    print("总步数：" + str(total_step_number))


# 获取总报文数
def get_total_message_number(sheet_object):
    global total_message_number
    i = 0
    for row in sheet_object.iter_rows(values_only=True, min_row=2):
        if row[i] != None:
            total_message_number += 1
        elif row[i] == None :
            break
    print("总报文数：" + str(total_message_number))


# 处理报文存储区
def handle_message_storage_area(sheet_object):
    # 遍历外发报文录入工作表
    for row in sheet1_object.iter_rows(values_only=True, min_row=2):
        # 获取报文ID
        message_id = row[0]
        # 将字符串转换为整型
        message_id = int(str(message_id), 16)
        # 获取周期（ms）
        period = row[2]
        # 获取通道
        channel = row[3]
        # 获取DLC
        DLC = row[4]
        # 获取CANFD
        CANFD = row[5]
        # 获取扩展帧
        extended_frame = row[6]
        # 写入ID
        message_storage_area_list.append((message_id & 0X00FF) >> 0)
        message_storage_area_list.append((message_id & 0XFF00) >> 8)
        # 写入周期
        message_storage_area_list.append((period & 0X00FF) >> 0)
        message_storage_area_list.append((period & 0XFF00) >> 8)
        # 写入通道，DLC，CANFD，扩展帧
        message_storage_area_list.append(channel)
        message_storage_area_list.append(DLC)
        message_storage_area_list.append(CANFD)
        message_storage_area_list.append(extended_frame)


# 步骤地址存储区处理函数
def handle_step_address_storage_area(sheet_object):
    # 步骤地址存储区大小（检测台步数 * 32）
    step_address_storage_area_max_length = total_step_number * 32
    print("步骤地址存储区数组大小：" + str(step_address_storage_area_max_length))
    # 扩充步骤地址存储区数组大小
    for i in range(step_address_storage_area_max_length):
        step_address_storage_area_list.append(0)
        pass
    
    # 步骤存储区基地址索引
    step_storage_area_base_address_index = 0
    # 写入各个步骤的此步操作的报文数量、此步操作的IO数量、此步操作的PWM数量、
    for row in sheet_object.iter_rows(values_only=True, min_row=2):
        # 获取当前步骤的报文数量
        current_step_message_number = row[1]
        # 获取当前步骤的IO数量
        current_step_IO_number = row[2]
        # 获取当前步骤的PWM数量
        current_step_PWM_number = row[3]
        
        # 写入此步操作的报文数量
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 4] = get_uint32_data_specified_byte_data(current_step_message_number, byte_0)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 5] = get_uint32_data_specified_byte_data(current_step_message_number, byte_1)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 6] = get_uint32_data_specified_byte_data(current_step_message_number, byte_2)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 7] = get_uint32_data_specified_byte_data(current_step_message_number, byte_3)
        # 写入此步操作的IO数量
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 12] = get_uint32_data_specified_byte_data(current_step_IO_number, byte_0)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 13] = get_uint32_data_specified_byte_data(current_step_IO_number, byte_1)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 14] = get_uint32_data_specified_byte_data(current_step_IO_number, byte_2)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 15] = get_uint32_data_specified_byte_data(current_step_IO_number, byte_3)
        # 写入此步操作的PWM数量
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 20] = get_uint32_data_specified_byte_data(current_step_PWM_number, byte_0)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 21] = get_uint32_data_specified_byte_data(current_step_PWM_number, byte_1)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 22] = get_uint32_data_specified_byte_data(current_step_PWM_number, byte_2)
        step_address_storage_area_list[step_storage_area_base_address_index * 32 + 23] = get_uint32_data_specified_byte_data(current_step_PWM_number, byte_3)
        step_storage_area_base_address_index += 1


# 步骤存储区处理函数
def handle_step_storage_area(sheet_list):
    global step_address_storage_area_address_N
    global IO_data_address_N
    global PWM_data_address_N
    
    # 检测台步骤录入表行数索引
    step_row_index = 2
    # GPIO表行数索引
    GPIO_row_index = 2
    # PWM表行数索引
    PWM_row_index = 2
    
    # 检测台步骤录入表当前数组长度
    current_step_row_length = 0
    # GPIO表当前数组长度
    current_GPIO_row_length = 0
    # PWM表当前数组长度
    current_PWM_row_length = 0

    # 各个部分的数组
    current_step_row = []
    current_GPIO_row = []
    current_PWM_row = []
    
    # 遍历检测台步骤
    for current_step_number in range(1, total_step_number + 1):
        print()
        print("当前步骤：" + str(current_step_number) + " -------------------------------------------------------------------")
        print()
        # 检测台步骤录入表处理
        for row in sheet_list[1].iter_rows(values_only=True, min_row=step_row_index):
            if row[0] == None:
                break
            if int(str(row[0])) == current_step_number:
                step_row_index +=1
                # 获取报文索引
                message_index = int(str(row[2]))
                # 写入报文索引
                current_step_row.append(get_uint32_data_specified_byte_data(message_index, byte_0))
                current_step_row.append(get_uint32_data_specified_byte_data(message_index, byte_1))
                current_step_row.append(get_uint32_data_specified_byte_data(message_index, byte_2))
                current_step_row.append(get_uint32_data_specified_byte_data(message_index, byte_3))
                
                # 循环获取报文内容索引3到19
                for i in range(3, 19):
                    # 获取报文内容
                    message_content = int(str(row[i]), 16)
                    # 写入报文内容
                    current_step_row.append(get_uint32_data_specified_byte_data(message_content, byte_3))
                    current_step_row.append(get_uint32_data_specified_byte_data(message_content, byte_2))
                    current_step_row.append(get_uint32_data_specified_byte_data(message_content, byte_1))
                    current_step_row.append(get_uint32_data_specified_byte_data(message_content, byte_0))
            else:
                break
        # 一个检测台步骤完事需要做的操作
        print("步骤行数索引:"+ str(step_row_index))
        current_step_row_length = len(current_step_row)
        print("当前步骤报文字节数量：" + str(current_step_row_length))
        print('当前步骤报文数组：')
        print(current_step_row)
        
        # 追加当前数组
        step_storage_area_list.extend(current_step_row)
        # 追加完清空当前步骤数组
        current_step_row.clear()
        
        # 计算I0数据首地址
        IO_data_address_N = step_address_storage_area_address_N + current_step_row_length
        # IO处理区域
        for row in sheet_list[2].iter_rows(values_only = True, min_row = GPIO_row_index):
            if int(str(row[0])) == current_step_number:
                GPIO_row_index += 1
                current_GPIO_row.append(int(str(row[1])))
                current_GPIO_row.append(int(str(row[2])))
                current_GPIO_row.append(int(str(row[3])))
                current_GPIO_row.append(0)
            else:
                break
        # 一个IO步骤完事需要做的操作
        print("IO行数索引:"+ str(GPIO_row_index))
        current_GPIO_row_length = len(current_GPIO_row)
        print("当前步骤IO字节数量：" + str(current_GPIO_row_length))
        print('当前步骤IO数组：')
        print(current_GPIO_row)
        # 追加当前IO
        step_storage_area_list.extend(current_GPIO_row)
        # 追加完清空当前IO数组
        current_GPIO_row.clear()
        
        
        # 计算PWM数据首地址
        PWM_data_address_N = IO_data_address_N + current_GPIO_row_length
        # PWM处理区域
        for row in sheet_list[3].iter_rows(values_only = True, min_row = PWM_row_index):
            if int(str(row[0])) == current_step_number:
                PWM_row_index += 1
                current_PWM_row.append(int(str(row[PWM_control_channel_index])))
                current_PWM_row.append(int(str(row[PWM_direction_index])))
                current_PWM_row.append((int(str(row[PWM_duty_cycle_index]))& 0x00FF) >> 0)
                current_PWM_row.append((int(str(row[PWM_duty_cycle_index]))& 0xFF00) >> 8)
                current_PWM_row.append((int(str(row[PWM_frequency_index])) & 0x00FF) >> 0)
                current_PWM_row.append((int(str(row[PWM_frequency_index])) & 0xFF00) >> 8)
                current_PWM_row.append(0)
                current_PWM_row.append(0)
                pass
            else:
                pass
        # 一个PWM步骤完事需要做的操作
        print("PWM行数索引:"+ str(PWM_row_index))
        current_PWM_row_length = len(current_PWM_row)
        print("当前步骤PWM字节数量：" + str(current_PWM_row_length))
        print('当前步骤PWM数组：')
        print(current_PWM_row)
        # 追加当前PWM
        step_storage_area_list.extend(current_PWM_row)
        # 追加完清空当前PWM数组
        current_PWM_row.clear()
        
        # 写入当前步骤的首地址
        step_address_storage_area_list[(current_step_number - 1) * 32 + 0] = get_uint32_data_specified_byte_data(step_address_storage_area_address_N, byte_0)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 1] = get_uint32_data_specified_byte_data(step_address_storage_area_address_N, byte_1)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 2] = get_uint32_data_specified_byte_data(step_address_storage_area_address_N, byte_2)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 3] = get_uint32_data_specified_byte_data(step_address_storage_area_address_N, byte_3)
        # 写入当前步骤的IO数据首地址
        step_address_storage_area_list[(current_step_number - 1) * 32 + 8] = get_uint32_data_specified_byte_data(IO_data_address_N, byte_0)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 9] = get_uint32_data_specified_byte_data(IO_data_address_N, byte_1)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 10] = get_uint32_data_specified_byte_data(IO_data_address_N, byte_2)
        step_address_storage_area_list[(current_step_number - 1) * 32 + 11] = get_uint32_data_specified_byte_data(IO_data_address_N, byte_3)
        # 写入当前步骤的PWM数据首地址
        step_address_storage_area_list[(current_step_number - 1) * 32 + 16] = get_uint32_data_specified_byte_data(PWM_data_address_N, byte_0) 
        step_address_storage_area_list[(current_step_number - 1) * 32 + 17] = get_uint32_data_specified_byte_data(PWM_data_address_N, byte_1) 
        step_address_storage_area_list[(current_step_number - 1) * 32 + 18] = get_uint32_data_specified_byte_data(PWM_data_address_N, byte_2) 
        step_address_storage_area_list[(current_step_number - 1) * 32 + 19] = get_uint32_data_specified_byte_data(PWM_data_address_N, byte_3) 
        # 计算下一个步骤的步骤存储区地址
        step_address_storage_area_address_N = PWM_data_address_N + current_PWM_row_length 


# 创建bin文件函数斌写入文件
def create_bin_file(file_name, binary_data):
    # 以二进制写入模式打开文件
    # print(binary_data)
    with open(file_name, 'wb') as bin_file:
        bin_file.write(binary_data)
        pass


if __name__ == '__main__':
    # 读取excel工作簿对象
    excel_file_object = read_excel_file(file_name + ".xlsx")
    
    # 获取工作表名称列表
    sheet_names = excel_file_object.sheetnames
    # 外发报文录入
    sheet1_object = excel_file_object[sheet_names[0]]
    # 检测台步骤录入
    sheet2_object = excel_file_object[sheet_names[1]]
    # GPIO
    sheet3_object = excel_file_object[sheet_names[2]]
    # PWM
    sheet4_object = excel_file_object[sheet_names[3]]
    # 检测台步数统计
    sheet5_object = excel_file_object[sheet_names[4]]
    
    # 工作表数组
    sheet_list = [
        sheet1_object,
        sheet2_object,
        sheet3_object,
        sheet4_object,
        sheet5_object,
    ]
    
    # 获取总步数
    get_total_step_number(sheet5_object)
    # 将总步数赋值到对应的列表中
    data_list[12] = get_uint32_data_specified_byte_data(total_step_number, byte_0)
    data_list[13] = get_uint32_data_specified_byte_data(total_step_number, byte_1)
    data_list[14] = get_uint32_data_specified_byte_data(total_step_number, byte_2)
    data_list[15] = get_uint32_data_specified_byte_data(total_step_number, byte_3)
    
    # 获取总报文数
    get_total_message_number(sheet1_object)
    # 将总报文数赋值到对应的列表中
    data_list[4] = get_uint32_data_specified_byte_data(total_message_number, byte_0)
    data_list[5] = get_uint32_data_specified_byte_data(total_message_number, byte_1)
    data_list[6] = get_uint32_data_specified_byte_data(total_message_number, byte_2)
    data_list[7] = get_uint32_data_specified_byte_data(total_message_number, byte_3)
    
    # 处理报文存储区
    handle_message_storage_area(sheet1_object)
    # 获取报文存储区长度
    message_storage_area_length = len(message_storage_area_list)
    # 获取步骤地址存储区地址
    step_address_storage_area_address = message_storage_area_address + message_storage_area_length
    
    # 写入报文存储区地址 message_storage_area_address
    data_list[0] = get_uint32_data_specified_byte_data(message_storage_area_address, byte_0)
    data_list[1] = get_uint32_data_specified_byte_data(message_storage_area_address, byte_1)
    data_list[2] = get_uint32_data_specified_byte_data(message_storage_area_address, byte_2)
    data_list[3] = get_uint32_data_specified_byte_data(message_storage_area_address, byte_3)
    
    # 写入步骤地址存储区地址
    data_list[8] = get_uint32_data_specified_byte_data(step_address_storage_area_address, byte_0)
    data_list[9] = get_uint32_data_specified_byte_data(step_address_storage_area_address, byte_1)
    data_list[10] = get_uint32_data_specified_byte_data(step_address_storage_area_address, byte_2)
    data_list[11] = get_uint32_data_specified_byte_data(step_address_storage_area_address, byte_3)

    # 步骤地址存储区处理函数
    handle_step_address_storage_area(sheet5_object)
    
    # 获取步骤地址存储区大小
    step_address_storage_area_length = len(step_address_storage_area_list)
    # 计算步骤存储区的首地址
    step_address_storage_area_address_N = step_address_storage_area_address + step_address_storage_area_length

    # 调用步骤区处理函数
    handle_step_storage_area(sheet_list)

    # 合并所有数据
    data_list.extend(message_storage_area_list)
    data_list.extend(step_address_storage_area_list)
    data_list.extend(step_storage_area_list)
    
    
    # 获取总校验长度
    total_check_length = len(data_list)
    # 将总校验长度赋值到对应的列表中
    all_data_list[4] = get_uint32_data_specified_byte_data(total_check_length, byte_0)
    all_data_list[5] = get_uint32_data_specified_byte_data(total_check_length, byte_1)
    all_data_list[6] = get_uint32_data_specified_byte_data(total_check_length, byte_2)
    all_data_list[7] = get_uint32_data_specified_byte_data(total_check_length, byte_3)
    # 获取校验
    crc_number = check_infordata_crc_32(data_list, total_check_length)
    print("CRC校验值：" + str(hex(crc_number)))
    # 将CRC校验赋值到对应的列表中 crc_number
    all_data_list[0] = get_uint32_data_specified_byte_data(crc_number, byte_0)
    all_data_list[1] = get_uint32_data_specified_byte_data(crc_number, byte_1)
    all_data_list[2] = get_uint32_data_specified_byte_data(crc_number, byte_2)
    all_data_list[3] = get_uint32_data_specified_byte_data(crc_number, byte_3)
    
    # 将数据列表和CRC列表合并
    all_data_list.extend(data_list)
    # 将列表转换为字节数据
    binary_data = bytes(all_data_list)
    # 创建bin文件并写入数据
    create_bin_file(file_name + ".bin", binary_data)
    
    # 关闭excel文件
    close_excel_file(excel_file_object)