#include "Check_Ctrl.h"
#include "TYW_stdint.h"
#include "RTE_GPIO.h"
#include "UDS_ISO14229_Server.h"
#include "string.h"
#include "Display_Info.h"
#include "Analog_Signals.h"
#include "CANFD_CH0_CANFD_Communication_Matrix.h"
#include "COM_CAN.h"
#include "GenDelay.h"
uint32_t NO_IPK_EXIST_Status;
uint32_t NO_IPK_EXIST;
uint32_t NO_IPK_EXIST_TIMER;

uint8_t InterNal_Version [ 128 ];
uint8_t SW_Version [ 128 ];
uint8_t HW_Version [ 128 ];
uint8_t Part_Version [ 128 ];
uint8_t Risk_Evade [ 128 ];
uint8_t Evade_ODO  [ 128 ];
uint8_t Line_IN_St [ 128 ];
uint8_t Res_St [ 128 ];

uint32_t LCD_CHECN_BEGIN;
uint32_t LCD_CHECN_Retry;

uint32_t LINE_IN_CHECK_BEGIN;
uint32_t LINE_IN_CHECK_Retry;

uint32_t TFT_CHECN_BEGIN;
uint32_t TFT_CHECN_Retry;

uint32_t VOICE_BACK_BEGIN;
uint32_t VOICE_BACK_Retry;

uint32_t VOICE_CHECK_BEGIN;
uint32_t VOICE_CHECK_Retry;

uint32_t VOICE_CHECN_BEGIN;
uint32_t VOICE_CHECN_Retry;

uint32_t LINE_ODO_CLEAR_BEGIN;
uint32_t VOICE_ODO_CLEAR_Retry;

uint32_t RES_CHECK_BEGIN;
uint32_t RES_CHECK_Retry;

uint32_t UnLock_Flag;
uint32_t UnLock_Retry;

uint8_t  KEYBUFFER [ 4 ];
uint32_t loc_V1;
uint32_t loc_V2;
uint32_t CAN_Msg_Tx_Enable;

uint16_t Fuel_Res;
uint16_t KEY1_Res;
uint16_t KEY2_Res;
uint16_t NTC_Res;
uint32_t MENU_CHECK_STEP;
// uint32_t MENU_ODO_CLEAR;
uint32_t Global_Session;
uint32_t loc_Step;

uint8_t ODO_BACK;
#define RESULT_DUI 1u
#define RESULT_CUO 0u

void Function_Check_Ctrl(uint32_t cmd);

void MENU_CHECK_STEP_ADD(void)
{
    MENU_CHECK_STEP++;
}
void MENU_CHECK_STEP_SUB(void)
{
    if ( MENU_CHECK_STEP != 0 )
        MENU_CHECK_STEP--;
}
// void MENU_ODO_CLEAR_STEP()
// {
//     MENU_ODO_CLEAR ++;
// }
void MENU_CHECK_Init(void)
{
    MENU_CHECK_STEP = 0;
}


void HW_CHECK_Ctrl(uint32_t cmd)
{
    static uint32_t status = 0;
    uint8_t         DIAG_BUFER [ 10 ];
    uint8_t Part_Number[]={0x39, 0x32, 0x31, 0x30, 0x30, 0x30, 0x31, 0x2D, 0x44, 0x45, 0x31, 0x30};

    if ( cmd == 0u )
    {
        LINE_IN_CHECK_BEGIN = 0U;
        status              = 0U;
    }
    else if ( cmd == 1u )
    {
        switch ( status )
        {
            case 0U:
                // output
                // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 0U;
                    LINE_OUT_OIL         = 0U;
                    LINE_OUT_BREAK_LEVEL = 0U;
                    LINE_OUT_WARSH_LEVEL = 0U;
                    LINE_OUT_PARK        = 0U;
                    LINE_OUT_EPS         = 0U;
                }
                // else 
                // {

                // }
                LINE_IN_CHECK_BEGIN  = 0u;
                status               = 1U;
                break;
            case 1U:

                if ( LINE_IN_CHECK_BEGIN == 0 )
                {
                    LINE_IN_CHECK_BEGIN = 1U;
                    LINE_IN_CHECK_Retry = 10U;
                    DIAG_BUFER [ 0 ]    = 0x22;
                    DIAG_BUFER [ 1 ]    = 0x62;
                    DIAG_BUFER [ 2 ]    = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    /*
                      机油压力	BYTE0     4
                      制动液位	BYTE1     2
                      蓄电池充电	BYTE2   3
                      洗涤液位	BYTE3     1
                      手刹	BYTE4         0
                      EPS开关	BYTE5       5

                      PARK_INFO_TEXT
                      WASHLEVEL_INFO_TEXT
                      BREAK_LEVEL_INFO_TEXT
                      BAT_Info_TEXT
                      OIL_PRESS_TEXT
                      EPS_Info_TEXT
                     */
                    if ( Line_IN_St [ 0 ] == 1U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 1U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 1U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 1U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 1U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 1U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 2U;
                }

                // read
                break;
            case 2U:
            //    if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 1U;
                    LINE_OUT_OIL         = 1U;
                    LINE_OUT_BREAK_LEVEL = 1U;
                    LINE_OUT_WARSH_LEVEL = 1U;
                    LINE_OUT_PARK        = 1U;
                    LINE_OUT_EPS         = 1U;
                }
                // else 
                // {
                    
                // }
                LINE_IN_CHECK_BEGIN  = 0u;
                status               = 3U;
                // output
                break;
            case 3U:
                if ( LINE_IN_CHECK_BEGIN == 0 )
                {

                    LINE_IN_CHECK_BEGIN = 1U;
                    LINE_IN_CHECK_Retry = 10U;

                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    if ( Line_IN_St [ 0 ] == 0U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 0U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 0U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 0U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 0U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 0U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 4U;
                }
                // read
                break;
            case 4U:
                // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 0U;
                    LINE_OUT_OIL         = 0U;
                    LINE_OUT_BREAK_LEVEL = 0U;
                    LINE_OUT_WARSH_LEVEL = 0U;
                    LINE_OUT_PARK        = 0U;
                    LINE_OUT_EPS         = 0U;
                }
                // else 
                // {
                    
                // }
                LINE_IN_CHECK_BEGIN  = 0u;

                status = 5U;
                // output
                break;
            case 5U:
                if ( LINE_IN_CHECK_BEGIN == 0 )
                {

                    LINE_IN_CHECK_BEGIN = 1U;
                    LINE_IN_CHECK_Retry = 10U;

                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    if ( Line_IN_St [ 0 ] == 1U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 1U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 1U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 1U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 1U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 1U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 6U;
                }
                // read
                break;
            case 6U:
                // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 1U;
                    LINE_OUT_OIL         = 1U;
                    LINE_OUT_BREAK_LEVEL = 1U;
                    LINE_OUT_WARSH_LEVEL = 1U;
                    LINE_OUT_PARK        = 1U;
                    LINE_OUT_EPS         = 1U;
                }
                // else 
                // {
                    
                // }
                LINE_IN_CHECK_BEGIN  = 0u;

                status = 7U;
                // output
                break;
            case 7U:
                if ( LINE_IN_CHECK_BEGIN == 0 )
                {
                    LINE_IN_CHECK_Retry = 10U;
                    LINE_IN_CHECK_BEGIN = 1U;
                    DIAG_BUFER [ 0 ]    = 0x22;
                    DIAG_BUFER [ 1 ]    = 0x62;
                    DIAG_BUFER [ 2 ]    = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    if ( Line_IN_St [ 0 ] == 0U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 0U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 0U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 0U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 0U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 0U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 8U;
                }
                // read
                break;
            case 8U:
                // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 0U;
                    LINE_OUT_OIL         = 0U;
                    LINE_OUT_BREAK_LEVEL = 0U;
                    LINE_OUT_WARSH_LEVEL = 0U;
                    LINE_OUT_PARK        = 0U;
                    LINE_OUT_EPS         = 0U;
                }
                // else 
                // {
                    
                // }
                LINE_IN_CHECK_BEGIN  = 0u;

                status = 9U;
                // output
                break;
            case 9U:
                if ( LINE_IN_CHECK_BEGIN == 0 )
                {
                    LINE_IN_CHECK_Retry = 10U;
                    LINE_IN_CHECK_BEGIN = 1U;
                    DIAG_BUFER [ 0 ]    = 0x22;
                    DIAG_BUFER [ 1 ]    = 0x62;
                    DIAG_BUFER [ 2 ]    = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    if ( Line_IN_St [ 0 ] == 1U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 1U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 1U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 1U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 1U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 1U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 10U;
                }
                // read
                break;
            case 10U:
                // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
                {
                    LINE_OUT_CHARGER     = 1U;
                    LINE_OUT_OIL         = 1U;
                    LINE_OUT_BREAK_LEVEL = 1U;
                    LINE_OUT_WARSH_LEVEL = 1U;
                    LINE_OUT_PARK        = 1U;
                    LINE_OUT_EPS         = 1U;
                }
                // else 
                // {
                    
                // }
                LINE_IN_CHECK_BEGIN  = 0u;

                status = 11U;
                // output
                break;
            case 11U:
                if ( LINE_IN_CHECK_BEGIN == 0 )
                {
                    LINE_IN_CHECK_Retry = 10U;
                    LINE_IN_CHECK_BEGIN = 1U;
                    DIAG_BUFER [ 0 ]    = 0x22;
                    DIAG_BUFER [ 1 ]    = 0x62;
                    DIAG_BUFER [ 2 ]    = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( LINE_IN_CHECK_BEGIN == 1U )
                {
                    // WAIT
                }
                else if ( LINE_IN_CHECK_BEGIN == 2U )
                {
                    LINE_IN_CHECK_BEGIN = 3U;
                    if ( Line_IN_St [ 0 ] == 0U )
                    {
                        Display_OIL_R_W(4, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(4, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 1 ] == 0U )
                    {
                        Display_OIL_R_W(2, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(2, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 2 ] == 0U )
                    {
                        Display_OIL_R_W(3, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(3, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 3 ] == 0U )
                    {
                        Display_OIL_R_W(1, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(1, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 4 ] == 0U )
                    {
                        Display_OIL_R_W(0, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(0, RESULT_CUO);
                    }
                    if ( Line_IN_St [ 5 ] == 0U )
                    {
                        Display_OIL_R_W(5, RESULT_DUI);
                    }
                    else
                    {
                        Display_OIL_R_W(5, RESULT_CUO);
                    }
                }
                else
                {
                    status = 11U;
                }

                // read
                break;
        }
    }
    else
    {
        status = 0U;
    }
}

void HW_RES_CHECK(uint32_t cmd)
{
    static uint32_t status       = 0;
    static uint8_t  status_Timer = 0;
    uint8_t         DIAG_BUFER [ 40 ];
    uint8_t         p [ 20 ];

    if ( cmd == 0u )
    {
        status          = 0U;
        RES_CHECK_BEGIN = 0U;
        Fuel_Res        = 0U;
        KEY1_Res        = 0U;
        KEY2_Res        = 0U;
        NTC_Res         = 0U;
        status_Timer    = 0u;
    }
    else if ( cmd == 1u )
    {

        switch ( status )
        {
            case 0U:
                FUEL_RES_1      = 1U;
                FUEL_RES_2      = 0U;
                FUEL_RES_3      = 0U;
                FUEL_RES_4      = 0U;
                RES_CHECK_BEGIN = 0U;
                // output
                status = 1U;
                break;
            case 1U:
                if ( RES_CHECK_BEGIN == 0u )
                {
                    RES_CHECK_BEGIN  = 1U;
                    RES_CHECK_Retry  = 10u;
                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x02;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( RES_CHECK_BEGIN == 1U )
                {
                }
                else if ( RES_CHECK_BEGIN == 2U )
                {
                    RES_CHECK_BEGIN = 3U;
                    Fuel_Res        = (Res_St [ 0 ] << 8) + Res_St [ 1 ];
                    KEY1_Res        = (Res_St [ 2 ] << 8) + Res_St [ 3 ];
                    KEY2_Res        = (Res_St [ 4 ] << 8) + Res_St [ 5 ];
                    NTC_Res         = (Res_St [ 6 ] << 8) + Res_St [ 7 ];
                    p [ 0 ]         = Fuel_Res / 10000;    // 65535
                    p [ 1 ]         = (Fuel_Res % 10000) / 1000;
                    p [ 2 ]         = (Fuel_Res % 1000) / 100;
                    p [ 3 ]         = (Fuel_Res % 100) / 10;
                    p [ 4 ]         = (Fuel_Res % 10) / 1;
                    p [ 5 ]         = 0xff;
                    General_Number_Disp(p, 40, 48 + 32);
                    p [ 0 ] = KEY1_Res / 10000;    // 65535
                    p [ 1 ] = (KEY1_Res % 10000) / 1000;
                    p [ 2 ] = (KEY1_Res % 1000) / 100;
                    p [ 3 ] = (KEY1_Res % 100) / 10;
                    p [ 4 ] = (KEY1_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 64 + 32);
                    p [ 0 ] = KEY2_Res / 10000;    // 65535
                    p [ 1 ] = (KEY2_Res % 10000) / 1000;
                    p [ 2 ] = (KEY2_Res % 1000) / 100;
                    p [ 3 ] = (KEY2_Res % 100) / 10;
                    p [ 4 ] = (KEY2_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 128);
                    p [ 0 ] = NTC_Res / 10000;    // 65535
                    p [ 1 ] = (NTC_Res % 10000) / 1000;
                    p [ 2 ] = (NTC_Res % 1000) / 100;
                    p [ 3 ] = (NTC_Res % 100) / 10;
                    p [ 4 ] = (NTC_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 160 + 32);
                }
                else
                {
                    status = 2U;
                }
                // read
                break;
            case 2U:
                FUEL_RES_1      = 0U;
                FUEL_RES_2      = 1U;
                FUEL_RES_3      = 0U;
                FUEL_RES_4      = 0U;
                RES_CHECK_BEGIN = 0U;
                status          = 3U;
                // output
                break;
            case 3U:
                if ( RES_CHECK_BEGIN == 0u )
                {
                    RES_CHECK_BEGIN  = 1U;
                    RES_CHECK_Retry  = 10u;
                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x02;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( RES_CHECK_BEGIN == 1U )
                {
                }
                else if ( RES_CHECK_BEGIN == 2U )
                {
                    RES_CHECK_BEGIN = 3U;
                    Fuel_Res        = (Res_St [ 0 ] << 8) + Res_St [ 1 ];
                    KEY1_Res        = (Res_St [ 2 ] << 8) + Res_St [ 3 ];
                    KEY2_Res        = (Res_St [ 4 ] << 8) + Res_St [ 5 ];
                    NTC_Res         = (Res_St [ 6 ] << 8) + Res_St [ 7 ];
                    p [ 0 ]         = Fuel_Res / 10000;    // 65535
                    p [ 1 ]         = (Fuel_Res % 10000) / 1000;
                    p [ 2 ]         = (Fuel_Res % 1000) / 100;
                    p [ 3 ]         = (Fuel_Res % 100) / 10;
                    p [ 4 ]         = (Fuel_Res % 10) / 1;
                    p [ 5 ]         = 0xff;
                    General_Number_Disp(p, 40, 48 + 32);
                    p [ 0 ] = KEY1_Res / 10000;    // 65535
                    p [ 1 ] = (KEY1_Res % 10000) / 1000;
                    p [ 2 ] = (KEY1_Res % 1000) / 100;
                    p [ 3 ] = (KEY1_Res % 100) / 10;
                    p [ 4 ] = (KEY1_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 64 + 32);
                    p [ 0 ] = KEY2_Res / 10000;    // 65535
                    p [ 1 ] = (KEY2_Res % 10000) / 1000;
                    p [ 2 ] = (KEY2_Res % 1000) / 100;
                    p [ 3 ] = (KEY2_Res % 100) / 10;
                    p [ 4 ] = (KEY2_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 128);
                    p [ 0 ] = NTC_Res / 10000;    // 65535
                    p [ 1 ] = (NTC_Res % 10000) / 1000;
                    p [ 2 ] = (NTC_Res % 1000) / 100;
                    p [ 3 ] = (NTC_Res % 100) / 10;
                    p [ 4 ] = (NTC_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 160 + 32);
                }
                else
                {
                    status = 4U;
                }
                // read
                // read
                break;
            case 4U:
                FUEL_RES_1      = 0U;
                FUEL_RES_2      = 0U;
                FUEL_RES_3      = 1U;
                FUEL_RES_4      = 0U;
                RES_CHECK_BEGIN = 0U;
                status          = 5U;
                // output
                break;
            case 5U:
                if ( RES_CHECK_BEGIN == 0u )
                {
                    RES_CHECK_BEGIN  = 1U;
                    RES_CHECK_Retry  = 10u;
                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x02;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( RES_CHECK_BEGIN == 1U )
                {
                }
                else if ( RES_CHECK_BEGIN == 2U )
                {
                    RES_CHECK_BEGIN = 3U;
                    Fuel_Res        = (Res_St [ 0 ] << 8) + Res_St [ 1 ];
                    KEY1_Res        = (Res_St [ 2 ] << 8) + Res_St [ 3 ];
                    KEY2_Res        = (Res_St [ 4 ] << 8) + Res_St [ 5 ];
                    NTC_Res         = (Res_St [ 6 ] << 8) + Res_St [ 7 ];
                    p [ 0 ]         = Fuel_Res / 10000;    // 65535
                    p [ 1 ]         = (Fuel_Res % 10000) / 1000;
                    p [ 2 ]         = (Fuel_Res % 1000) / 100;
                    p [ 3 ]         = (Fuel_Res % 100) / 10;
                    p [ 4 ]         = (Fuel_Res % 10) / 1;
                    p [ 5 ]         = 0xff;
                    General_Number_Disp(p, 40, 48 + 32);
                    p [ 0 ] = KEY1_Res / 10000;    // 65535
                    p [ 1 ] = (KEY1_Res % 10000) / 1000;
                    p [ 2 ] = (KEY1_Res % 1000) / 100;
                    p [ 3 ] = (KEY1_Res % 100) / 10;
                    p [ 4 ] = (KEY1_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 64 + 32);
                    p [ 0 ] = KEY2_Res / 10000;    // 65535
                    p [ 1 ] = (KEY2_Res % 10000) / 1000;
                    p [ 2 ] = (KEY2_Res % 1000) / 100;
                    p [ 3 ] = (KEY2_Res % 100) / 10;
                    p [ 4 ] = (KEY2_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 128);
                    p [ 0 ] = NTC_Res / 10000;    // 65535
                    p [ 1 ] = (NTC_Res % 10000) / 1000;
                    p [ 2 ] = (NTC_Res % 1000) / 100;
                    p [ 3 ] = (NTC_Res % 100) / 10;
                    p [ 4 ] = (NTC_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 160 + 32);
                }
                else
                {
                    status = 6U;
                }
                // read
                // read
                break;
            case 6U:
                FUEL_RES_1      = 0U;
                FUEL_RES_2      = 0U;
                FUEL_RES_3      = 0U;
                FUEL_RES_4      = 1U;
                RES_CHECK_BEGIN = 0U;
                status          = 7U;
                // output
                break;
            case 7U:
                if ( RES_CHECK_BEGIN == 0u )
                {
                    RES_CHECK_BEGIN  = 1U;
                    RES_CHECK_Retry  = 10u;
                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = 0x62;
                    DIAG_BUFER [ 2 ] = 0x02;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //硬线检测
                }
                else if ( RES_CHECK_BEGIN == 1U )
                {
                }
                else if ( RES_CHECK_BEGIN == 2U )
                {
                    RES_CHECK_BEGIN = 3U;
                    Fuel_Res        = (Res_St [ 0 ] << 8) + Res_St [ 1 ];
                    KEY1_Res        = (Res_St [ 2 ] << 8) + Res_St [ 3 ];
                    KEY2_Res        = (Res_St [ 4 ] << 8) + Res_St [ 5 ];
                    NTC_Res         = (Res_St [ 6 ] << 8) + Res_St [ 7 ];
                    p [ 0 ]         = Fuel_Res / 10000;    // 65535
                    p [ 1 ]         = (Fuel_Res % 10000) / 1000;
                    p [ 2 ]         = (Fuel_Res % 1000) / 100;
                    p [ 3 ]         = (Fuel_Res % 100) / 10;
                    p [ 4 ]         = (Fuel_Res % 10) / 1;
                    p [ 5 ]         = 0xff;
                    General_Number_Disp(p, 40, 48 + 32);
                    p [ 0 ] = KEY1_Res / 10000;    // 65535
                    p [ 1 ] = (KEY1_Res % 10000) / 1000;
                    p [ 2 ] = (KEY1_Res % 1000) / 100;
                    p [ 3 ] = (KEY1_Res % 100) / 10;
                    p [ 4 ] = (KEY1_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 64 + 32);
                    p [ 0 ] = KEY2_Res / 10000;    // 65535
                    p [ 1 ] = (KEY2_Res % 10000) / 1000;
                    p [ 2 ] = (KEY2_Res % 1000) / 100;
                    p [ 3 ] = (KEY2_Res % 100) / 10;
                    p [ 4 ] = (KEY2_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 128);
                    p [ 0 ] = NTC_Res / 10000;    // 65535
                    p [ 1 ] = (NTC_Res % 10000) / 1000;
                    p [ 2 ] = (NTC_Res % 1000) / 100;
                    p [ 3 ] = (NTC_Res % 100) / 10;
                    p [ 4 ] = (NTC_Res % 10) / 1;
                    p [ 5 ] = 0xff;
                    General_Number_Disp(p, 40, 48 + 32 + 160 + 32);
                }
                else
                {
                    if ( status_Timer < 10 )
                    {
                        status_Timer++;
                        status = 6U;
                    }
                    else
                    {
                        status = 8U;
                    }
                }
                break;
        }
    }
    else
    {
        status = 0U;
    }
}
void HW_ODO_Clear(void)
{
    // static uint32_t status = 0;
    uint8_t         DIAG_BUFER [ 40 ];
    static uint8_t UDS_DID_F1F8 = 0;
    // DIAG_BUFER [ 0 ]  = 0x2F;
    // DIAG_BUFER [ 1 ]  = 0x62;
    // DIAG_BUFER [ 2 ]  = 0x05;
    // DIAG_BUFER [ 3 ]  = 0x03;
    // DIAG_BUFER [ 4 ]  = 0x01;
    // UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 5);
    //VOICE_ODO_CLEAR_Retry = 200;
    while((UDS_DID_F1F8 < 3))
    {
        if(UDS_DID_F1F8 == 0)
        {
            Execute_Specify_Step(7);
            UDS_DID_F1F8 = 1;
        }
        else if(UDS_DID_F1F8 == 1)
        {
            // DIAG_BUFER [ 0 ]  = 0x2E;
            // DIAG_BUFER [ 1 ]  = 0xF1;
            // DIAG_BUFER [ 2 ]  = 0xF8;
            // DIAG_BUFER [ 3 ]  = 0x45;
            // DIAG_BUFER [ 4 ]  = 0x60;
            // DIAG_BUFER [ 5 ]  = 0x1F;
            // DIAG_BUFER [ 6 ]  = 0x00;
            // DIAG_BUFER [ 7 ]  = 0x00;
            // DIAG_BUFER [ 8 ]  = 0x30;
            // DIAG_BUFER [ 9 ]  = 0x71;
            // DIAG_BUFER [ 10 ]  = 0x02;
            // DIAG_BUFER [ 11 ]  = 0x48;
            // DIAG_BUFER [ 12 ]  = 0x88;
            // DIAG_BUFER [ 13]  = 0x32;
            // DIAG_BUFER [ 14]  = 0x74;
            // DIAG_BUFER [ 15]  = 0x00;
            // DIAG_BUFER [ 16]  = 0x00;
            // DIAG_BUFER [ 17]  = 0x00;
            // DIAG_BUFER [ 18]  = 0x00;
            // UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 19);
            UDS_DID_F1F8 = 2;
        }
        else if(UDS_DID_F1F8 == 2)
        {
            Execute_Specify_Step(6);
            UDS_DID_F1F8 =3;
            LINE_ODO_CLEAR_BEGIN = 1u;
            VOICE_ODO_CLEAR_Retry = 150;
        }
    }
    if(UDS_DID_F1F8 >= 3)
    {
        UDS_DID_F1F8 = 0;
    }
}
void SET_ODO_Clear_F(void)
{
    static uint8_t ODO_BEGIN = 2u;
    static uint8_t ODO_Retry;
    uint8_t         DIAG_BUFER [ 40 ];
    uint8_t Part_Number[]={0x39, 0x32, 0x31, 0x30, 0x30, 0x30, 0x31, 0x2D, 0x44, 0x45, 0x31, 0x30};
    if((VOICE_ODO_CLEAR_Retry == 0) && (ODO_Retry != VOICE_ODO_CLEAR_Retry))
    {
        Execute_Specify_Step(7);
        ODO_BACK = 1u;
    }
    ODO_Retry = VOICE_ODO_CLEAR_Retry;
    if((LINE_ODO_CLEAR_BEGIN == 2) && (ODO_BEGIN != LINE_ODO_CLEAR_BEGIN))
    {
        // if(memcmp(&Part_Number,&Part_Version ,12) == 0)
        // {/*高配*/
        //     DIAG_BUFER [ 0 ]  = 0x2E;
        //     DIAG_BUFER [ 1 ]  = 0xF1;
        //     DIAG_BUFER [ 2 ]  = 0xF8;
        //     DIAG_BUFER [ 3 ]  = 0x45;
        //     DIAG_BUFER [ 4 ]  = 0x60;
        //     DIAG_BUFER [ 5 ]  = 0x1F;
        //     DIAG_BUFER [ 6 ]  = 0x00;
        //     DIAG_BUFER [ 7 ]  = 0x00;
        //     DIAG_BUFER [ 8 ]  = 0x30;
        //     DIAG_BUFER [ 9 ]  = 0x71;
        //     DIAG_BUFER [ 10 ]  = 0x02;
        //     DIAG_BUFER [ 11 ]  = 0x48;
        //     DIAG_BUFER [ 12 ]  = 0x88;
        //     DIAG_BUFER [ 13]  = 0x32;
        //     DIAG_BUFER [ 14]  = 0x74;
        //     DIAG_BUFER [ 15]  = 0x00;
        //     DIAG_BUFER [ 16]  = 0x00;
        //     DIAG_BUFER [ 17]  = 0x00;
        //     DIAG_BUFER [ 18]  = 0x00;
        //     UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 19);
        // }
        // else 
        // {
        //     DIAG_BUFER [ 0 ]  = 0x2E;
        //     DIAG_BUFER [ 1 ]  = 0xF1;
        //     DIAG_BUFER [ 2 ]  = 0xF8;
        //     DIAG_BUFER [ 3 ]  = 0x45;
        //     DIAG_BUFER [ 4 ]  = 0x60;
        //     DIAG_BUFER [ 5 ]  = 0x1F;
        //     DIAG_BUFER [ 6 ]  = 0x00;
        //     DIAG_BUFER [ 7 ]  = 0x00;
        //     DIAG_BUFER [ 8 ]  = 0x30;
        //     DIAG_BUFER [ 9 ]  = 0x71;
        //     DIAG_BUFER [ 10 ]  = 0x02;
        //     DIAG_BUFER [ 11 ]  = 0x48;
        //     DIAG_BUFER [ 12 ]  = 0x88;
        //     DIAG_BUFER [ 13]  = 0x32;
        //     DIAG_BUFER [ 14]  = 0x74;
        //     DIAG_BUFER [ 15]  = 0x00;
        //     DIAG_BUFER [ 16]  = 0x00;
        //     DIAG_BUFER [ 17]  = 0x00;
        //     DIAG_BUFER [ 18]  = 0x00;
        //     UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 19);
        // }
    }
    else 
    {
        ODO_BEGIN = LINE_ODO_CLEAR_BEGIN;
    }
}
void HW_BACKLIGHT_CHECK(uint32_t cmd)
{
    static uint32_t status    = 0;
    static uint32_t MENU_BACKLIGHT = 0;
    static uint32_t USD_BACKLIGHT = 0;
    uint8_t         DIAG_BUFER [ 40 ];
    uint8_t         DIAG_BUFER_L [ 40 ];
    uint8_t         p [ 20 ];
    if ( cmd == 0u )
    {
        status            = 0U;
        VOICE_BACK_BEGIN = 0u;
        if(USD_BACKLIGHT == 1)
        {
            DIAG_BUFER [ 0 ]  = 0x2F;
            DIAG_BUFER [ 1 ]  = 0x62;
            DIAG_BUFER [ 2 ]  = 0x06;
            DIAG_BUFER [ 3 ]  = 0x00;
            //DIAG_BUFER [ 4 ]  = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);

            DIAG_BUFER_L [ 0 ]  = 0x2F;
            DIAG_BUFER_L [ 1 ]  = 0xF0;
            DIAG_BUFER_L [ 2 ]  = 0x01;
            DIAG_BUFER_L [ 3 ]  = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER_L, 4);
            USD_BACKLIGHT = 0;
        }
    }
    else if ( cmd == 1u )
    {
        USD_BACKLIGHT = 1;
        if ( MENU_CHECK_STEP > 10 )
        {
            MENU_CHECK_STEP = 0;
        }
        if ( MENU_BACKLIGHT != MENU_CHECK_STEP )
        {
            if ( VOICE_BACK_BEGIN == 0 )
            {
                VOICE_BACK_BEGIN = 1u;
                VOICE_BACK_Retry = 10u;
                DIAG_BUFER [ 0 ]  = 0x2F;
                DIAG_BUFER [ 1 ]  = 0x62;
                DIAG_BUFER [ 2 ]  = 0x06;
                DIAG_BUFER [ 3 ]  = 0x03;
                DIAG_BUFER [ 4 ]  = (MENU_CHECK_STEP * 10);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 5);
                p [ 0 ] = (MENU_CHECK_STEP % 100) / 10;
                p [ 1 ] = MENU_CHECK_STEP % 10;    // 65535
                p [ 2 ] = 0xff;
                General_Number_Disp(p, 40, 48 + 64);

            }
            else if ( VOICE_BACK_BEGIN == 1 )
            {
                if(MENU_CHECK_STEP % 2)
                {
                    DIAG_BUFER_L [ 0 ]  = 0x2F;
                    DIAG_BUFER_L [ 1 ]  = 0xF0;
                    DIAG_BUFER_L [ 2 ]  = 0x01;
                    DIAG_BUFER_L [ 3 ]  = 0x03;
                    DIAG_BUFER_L [ 4 ]  = 0x00;
                    DIAG_BUFER_L [ 5 ]  = 0x00;
                    DIAG_BUFER_L [ 6 ]  = 0xFF;
                    DIAG_BUFER_L [ 7 ]  = 0x00;
                    DIAG_BUFER_L [ 8 ]  = 0x00;
                    DIAG_BUFER_L [ 9 ]  = 0x00;
                    DIAG_BUFER_L [ 10]  = 0x00;
                    DIAG_BUFER_L [ 11]  = 0xFF;
                    DIAG_BUFER_L [ 12]  = 0x00;
                    DIAG_BUFER_L [ 13]  = 0x00;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER_L, 14);
                }
                else 
                {
                    DIAG_BUFER_L [ 0 ]  = 0x2F;
                    DIAG_BUFER_L [ 1 ]  = 0xF0;
                    DIAG_BUFER_L [ 2 ]  = 0x01;
                    DIAG_BUFER_L [ 3 ]  = 0x03;
                    DIAG_BUFER_L [ 4 ]  = 0x00;
                    DIAG_BUFER_L [ 5 ]  = 0x00;
                    DIAG_BUFER_L [ 6 ]  = 0x00;
                    DIAG_BUFER_L [ 7 ]  = 0x00;
                    DIAG_BUFER_L [ 8 ]  = 0x00;
                    DIAG_BUFER_L [ 9 ]  = 0x00;
                    DIAG_BUFER_L [ 10]  = 0x00;
                    DIAG_BUFER_L [ 11]  = 0xFF;
                    DIAG_BUFER_L [ 12]  = 0x00;
                    DIAG_BUFER_L [ 13]  = 0x00;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER_L, 14);
                }
                MENU_BACKLIGHT = MENU_CHECK_STEP;
            }
            else if ( VOICE_BACK_BEGIN == 2 )
            {
                MENU_BACKLIGHT = MENU_CHECK_STEP;
            }
            else
            {
            }
        }
    }
}
void HW_Voice_CHECK(uint32_t cmd)
{
    static uint32_t status    = 0;
    static uint32_t MENU_BACK = 0;
    static uint32_t USD_BACK = 0;
    uint8_t         DIAG_BUFER [ 40 ];
    uint8_t         p [ 20 ];
    if ( cmd == 0u )
    {
        status            = 0U;
        VOICE_CHECN_BEGIN = 0u;
        if(USD_BACK == 1)
        {
            DIAG_BUFER [ 0 ]  = 0x2F;
            DIAG_BUFER [ 1 ]  = 0x62;
            DIAG_BUFER [ 2 ]  = 0x02;
            DIAG_BUFER [ 3 ]  = 0x00;
            //DIAG_BUFER [ 4 ]  = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
            USD_BACK = 0;
        }
    }
    else if ( cmd == 1u )
    {
        USD_BACK = 1;
        if ( MENU_CHECK_STEP > 3 )
        {
            MENU_CHECK_STEP = 0;
        }
        if ( MENU_BACK != MENU_CHECK_STEP )
        {
            if ( VOICE_CHECN_BEGIN == 0 )
            {
                VOICE_CHECN_BEGIN = 1u;
                VOICE_CHECN_Retry = 10u;
                if(MENU_CHECK_STEP == 0)
                {
                    DIAG_BUFER [ 0 ]  = 0x2F;
                    DIAG_BUFER [ 1 ]  = 0x62;
                    DIAG_BUFER [ 2 ]  = 0x02;
                    DIAG_BUFER [ 3 ]  = 0x00;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
                }
                else 
                {
                    DIAG_BUFER [ 0 ]  = 0x2F;
                    DIAG_BUFER [ 1 ]  = 0x62;
                    DIAG_BUFER [ 2 ]  = 0x02;
                    DIAG_BUFER [ 3 ]  = 0x03;
                    DIAG_BUFER [ 4 ]  = MENU_CHECK_STEP;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 5);
                }
                p [ 0 ] = MENU_CHECK_STEP;    // 65535

                p [ 1 ] = 0xff;
                General_Number_Disp(p, 40, 48 + 64);
            }
            else if ( VOICE_CHECN_BEGIN == 1 )
            {
                MENU_BACK = MENU_CHECK_STEP;
            }
            else if ( VOICE_CHECN_BEGIN == 2 )
            {
                MENU_BACK = MENU_CHECK_STEP;
            }
            else
            {
            }
        }
    }
}

void HW_TFT_CHECK(uint32_t cmd)
{
    static uint32_t status    = 0;
    static uint32_t MENU_BACK = 0;
    static uint32_t USD_BACK = 0;
    uint8_t         DIAG_BUFER [ 10 ];
    uint8_t         p [ 20 ];

    if ( cmd == 0u )
    {
        status = 0U;
        if(USD_BACK == 1)
        {
            DIAG_BUFER [ 0 ] = 0x2F;
            DIAG_BUFER [ 1 ] = 0x62;
            DIAG_BUFER [ 2 ] = 0x04;
            DIAG_BUFER [ 3 ] = 0x00;
            //DIAG_BUFER [ 4 ] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
            USD_BACK = 0;
        }
    }
    else if ( cmd == 1u )
    {
        USD_BACK = 1;
        if ( MENU_CHECK_STEP > 6 )
        {
            MENU_CHECK_STEP = 0;
        }
        if ( MENU_BACK != MENU_CHECK_STEP )
        {
            if ( TFT_CHECN_BEGIN == 0 )
            {
                TFT_CHECN_BEGIN  = 1u;
                TFT_CHECN_Retry  = 10u;
                DIAG_BUFER [ 0 ] = 0x2F;
                DIAG_BUFER [ 1 ] = 0x62;
                DIAG_BUFER [ 2 ] = 0x04;
                DIAG_BUFER [ 3 ] = 0x03;
                DIAG_BUFER [ 4 ] = MENU_CHECK_STEP;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 5);
                p [ 0 ] = MENU_CHECK_STEP;    // 65535
                p [ 1 ] = 0xff;
                General_Number_Disp(p, 40, 48 + 64);
            }
            else if ( TFT_CHECN_BEGIN == 1 )
            {
            }
            else if ( TFT_CHECN_BEGIN == 2 )
            {
                MENU_BACK = MENU_CHECK_STEP;
            }
            else
            {
            }
        }
    }
}

void HW_LCD_CHECK(uint32_t cmd)
{
    static uint32_t status       = 0;
    static uint32_t MENU_BACK    = 0;
    static uint32_t USD_BACK    = 0;
    uint32_t        odo_val      = 0;
    static uint32_t odo_val_Back = 0;
    uint8_t         DIAG_BUFER [ 10 ];
    uint8_t         p [ 20 ];

    if ( cmd == 0u )
    {
        status       = 0U;
        odo_val_Back = 0;
        if(USD_BACK == 1)
        {
            DIAG_BUFER [ 0 ] = 0x2F;
            DIAG_BUFER [ 1 ] = 0x62;
            DIAG_BUFER [ 2 ] = 0x01;
            DIAG_BUFER [ 3 ] = 0x00;
            //DIAG_BUFER [ 4 ] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);
            USD_BACK = 0;
        }
    }
    else if ( cmd == 1u )
    {
        USD_BACK = 1;
        if ( MENU_CHECK_STEP > 1 )
        {
            MENU_CHECK_STEP = 0;
        }
        if ( MENU_BACK != MENU_CHECK_STEP )
        {
            if ( LCD_CHECN_BEGIN == 0 )
            {
                LCD_CHECN_BEGIN  = 1u;
                LCD_CHECN_Retry  = 10u;
                DIAG_BUFER [ 0 ] = 0x2F;
                DIAG_BUFER [ 1 ] = 0x62;
                DIAG_BUFER [ 2 ] = 0x01;
                DIAG_BUFER [ 3 ] = 0x03;
                DIAG_BUFER [ 4 ] = MENU_CHECK_STEP;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 5);
                p [ 0 ] = MENU_CHECK_STEP;    // 65535

                p [ 1 ] = 0xff;
                General_Number_Disp(p, 80, 48 + 32);
            }
            else if ( LCD_CHECN_BEGIN == 1 )
            {
            }
            else if ( LCD_CHECN_BEGIN == 2 )
            {
                MENU_BACK = MENU_CHECK_STEP;
            }
            else
            {
            }
        }
        odo_val = Get_ID_ODO( );
        if ( odo_val_Back != odo_val )
        {
            odo_val_Back = odo_val;

            p [ 0 ] = odo_val / 100000;    // 65535
            p [ 1 ] = (odo_val % 100000) / 10000;
            p [ 2 ] = (odo_val % 10000) / 1000;
            p [ 3 ] = (odo_val % 1000) / 100;
            p [ 4 ] = (odo_val % 100) / 10;
            p [ 5 ] = odo_val % 10;
            p [ 6 ] = 0xff;
            General_Number_Disp(p, 40, 48 + 32 + 64);
        }
    }
}

void HW_Static_Current_Check(uint32_t cmd)
{
    uint8_t         p [ 20 ];
    uint32_t        loc_Current_0 = 0;
    uint32_t        loc_Current_1 = 0;
    static uint32_t loc_Timer     = 0;
    static uint32_t loc_ret       = 0;

    if ( cmd == 0u )
    {

        loc_V1 = 0;
        loc_V2 = 0;
    }
    else if ( cmd == 1u )
    {
        LINE_OUT_CHARGER     = 1U;
        LINE_OUT_OIL         = 1U;
        LINE_OUT_BREAK_LEVEL = 1U;
        LINE_OUT_WARSH_LEVEL = 1U;
        LINE_OUT_PARK        = 1U;
        LINE_OUT_EPS         = 1U;

        loc_Current_0 = ADC_Read_Signal_Voltage(KL30);
        loc_Current_0 *= 5000;
        loc_Current_0 /= 4096;
        // loc_Current_0 *= (33);
        loc_Current_0 *= 10; 
        loc_Current_0 /= 100;

        loc_ret += loc_Current_0;
        loc_Timer++;
        if ( loc_Timer >= 30 )
        {
            loc_Timer = 0;
            loc_ret /= 30;
            p [ 0 ] = loc_ret / 10000;    // 65535
            p [ 1 ] = (loc_ret % 10000) / 1000;
            p [ 2 ] = (loc_ret % 1000) / 100;
            p [ 3 ] = (loc_ret % 100) / 10;
            p [ 4 ] = (loc_ret % 10) / 1;
            p [ 5 ] = 0xff;
            General_Number_Disp(p, 40, 48 + 32);
            loc_ret  = 0;
        }
    }
}

void Diag_Version_Check(void)
{
}

void HW_CHECK_IPK_EXIST(void)
{

    uint8_t DIAG_BUFER [ 2 ];

    DIAG_BUFER [ 0 ] = 0x3E;
    DIAG_BUFER [ 1 ] = 0x00;
    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
    SET_IPK_NONE( );
}

void SET_IPK_NONE(void)
{
    NO_IPK_EXIST_TIMER = 12;
    NO_IPK_EXIST       = 12345678;
}
void Clear_IPK_NONE(void)
{
    NO_IPK_EXIST        = 0;
    NO_IPK_EXIST_Status = 0x55667788;
}
void CHECK_IPK_COUNT(void)
{
    if ( CAN_Msg_Tx_Enable == 1u )
    {
        if ( NO_IPK_EXIST_TIMER != 0 )
        {
            NO_IPK_EXIST_TIMER--;
        }
        else
        {
            if ( NO_IPK_EXIST == 12345678 )
            {
                NO_IPK_EXIST_Status = 0x11223344;
                memset(InterNal_Version, 0xFF, sizeof(InterNal_Version));
                memset(SW_Version, 0xFF, sizeof(SW_Version));
                memset(HW_Version, 0xFF, sizeof(HW_Version));
                memset(Part_Version, 0xFF, sizeof(Part_Version));
                memset(Risk_Evade, 0xFF, sizeof(Risk_Evade));
                memset(Evade_ODO, 0xFF, sizeof(Evade_ODO));
                Display_Menu_Type = 0;
                Display_TFT_Clear( );
                Display_Sch( );
                MENU_CHECK_Init( );
            }
        }
        if(LINE_ODO_CLEAR_BEGIN == 1u)
        {
            if(VOICE_ODO_CLEAR_Retry != 0)
            {
                VOICE_ODO_CLEAR_Retry --;
            }
            else 
            {
                LINE_ODO_CLEAR_BEGIN = 2u;
            }
        }
        if ( LINE_IN_CHECK_BEGIN == 1U )
        {
            if ( LINE_IN_CHECK_Retry != 0 )
            {
                LINE_IN_CHECK_Retry--;
            }
            else
            {
                LINE_IN_CHECK_BEGIN = 0;
            }
        }
        if ( RES_CHECK_BEGIN == 1U )
        {
            if ( RES_CHECK_Retry != 0 )
            {
                RES_CHECK_Retry--;
            }
            else
            {
                RES_CHECK_BEGIN = 0;
            }
        }
        if ( VOICE_BACK_BEGIN == 1U )
        {
            if ( VOICE_BACK_Retry != 0 )
            {
                VOICE_BACK_Retry--;
            }
            else
            {
                VOICE_BACK_BEGIN = 0;
            }
        }
        if(VOICE_CHECK_BEGIN == 1u)
        {
            if ( VOICE_CHECK_Retry != 0 )
            {
                VOICE_CHECK_Retry--;
            }
            else
            {
                VOICE_CHECK_BEGIN = 0;
            }
        }
        if ( VOICE_CHECN_BEGIN == 1U )
        {
            if ( VOICE_CHECN_Retry != 0 )
            {
                VOICE_CHECN_Retry--;
            }
            else
            {
                VOICE_CHECN_BEGIN = 0;
            }
        }
        if ( TFT_CHECN_BEGIN == 1U )
        {
            if ( TFT_CHECN_Retry != 0 )
            {
                TFT_CHECN_Retry--;
            }
            else
            {
                TFT_CHECN_BEGIN = 0;
            }
        }
        if ( LCD_CHECN_BEGIN == 1U )
        {
            if ( LCD_CHECN_Retry != 0 )
            {
                LCD_CHECN_Retry--;
            }
            else
            {
                LCD_CHECN_BEGIN = 0;
            }
        }
    }
}

// 0x11223344 不在线
// 0x55667788 在线

uint32_t Get_IPK_Status(void)
{
    return NO_IPK_EXIST_Status;
}
void Diag_Info_Init(void)
{
    NO_IPK_EXIST_Status = 0x11223344;
    CAN_Msg_Tx_Enable   = 1u;

    memset(InterNal_Version, 0xFF, sizeof(InterNal_Version));
    memset(SW_Version, 0xFF, sizeof(SW_Version));
    memset(HW_Version, 0xFF, sizeof(HW_Version));
    memset(Part_Version, 0xFF, sizeof(Part_Version));
    memset(Risk_Evade, 0xFF, sizeof(Risk_Evade));
    memset(Evade_ODO, 0xFF, sizeof(Evade_ODO));
}

void Total_Check(void)
{
    uint32_t loc_Type = 0;
    loc_Type          = Get_Display_Type( );

    switch ( loc_Type )
    {
        case 1:    // Display_Version_Info

            Version_Info(1);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);

            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 2:    // Display_Line_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(1);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 3:    // Display_Res_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(1);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 4:    // Display_Voice_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(1);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 5:    // Display_TFT_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(1);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 6:    // Display_SegLCD_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(1);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 7:    // Display_BACK_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(1);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 8:    // Display_Static_Current_CheckResult
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            Function_Check_Ctrl(1);
            HW_Static_Current_Check(0);
            CAN_Msg_Tx_Enable = 1u;
            POWER_CTRL_KL30   = 1u;
            POWER_CTRL_KL15   = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
        case 9:    // Display_FUNC_CHECK
            Version_Info(0);
            HW_CHECK_Ctrl(0);
            HW_RES_CHECK(0);
            HW_Voice_CHECK(0);
            HW_TFT_CHECK(0);
            HW_LCD_CHECK(0);
            HW_BACKLIGHT_CHECK(0);
            HW_Static_Current_Check(1);
            CAN_Msg_Tx_Enable = 0u;
            // if(CANFD_MSG_Status( &CANFD_CH0_CanFDMsgOp, ID_GW_530_Msg_Count) == CAN_SIG_LOST)
            {
                POWER_CTRL_KL30   = 0u;
                POWER_CTRL_KL30_Current = 1u;
            }
            // else 
            // {
            //     POWER_CTRL_KL30   = 1u;
            //     POWER_CTRL_KL30_Current = 0u;
            // }
            POWER_CTRL_KL15   = 0u;
            break;
        default:
            POWER_CTRL_KL30 = 1u;
            POWER_CTRL_KL15 = 1u;
            POWER_CTRL_KL30_Current = 0u;
            break;
    }
}

void Read_IPK_Session_Type(void)
{
    static uint32_t loc_timer = 0;
    uint8_t         DIAG_BUFER [ 10 ];

    switch ( loc_Step )
    {
        case 0:
            DIAG_BUFER [ 0 ] = 0x22;
            DIAG_BUFER [ 1 ] = 0x62;
            DIAG_BUFER [ 2 ] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //天有为版本
            break;

        case 1:
            if ( Global_Session != 3 )
            {
                DIAG_BUFER [ 0 ] = 0x10;
                DIAG_BUFER [ 1 ] = 0x03;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
            }
            else
            {
                loc_timer++;
                if ( loc_timer >= 2 )
                {
                    //  HW_CHECK_IPK_EXIST( );
                }
            }
            break;
        case 2:
            if ( UnLock_Flag == 0 )
            {
                UnLock_Retry     = 10;
                UnLock_Flag      = 1;
                DIAG_BUFER [ 0 ] = 0x27;
                DIAG_BUFER [ 1 ] = 0x01;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);    //天有为版本
            }
            if ( UnLock_Flag == 0x55 )
            {
                loc_Step = 3;
            }
            break;
        case 3:
            if ( UnLock_Flag == 2 )
            {
                UnLock_Flag      = 3;
                UnLock_Retry     = 10;
                DIAG_BUFER [ 0 ] = 0x27;
                DIAG_BUFER [ 1 ] = 0x02;
                DIAG_BUFER [ 2 ] = KEYBUFFER [ 0 ];
                DIAG_BUFER [ 3 ] = KEYBUFFER [ 1 ];
                DIAG_BUFER [ 4 ] = KEYBUFFER [ 2 ];
                DIAG_BUFER [ 5 ] = KEYBUFFER [ 3 ];
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6);    //天有为版本
            }
            if ( UnLock_Flag == 0x55 )
            {
                loc_Step = 4;
            }
            break;
        case 4:

            if ( InterNal_Version [ 0 ] == 0xff )
            {

                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0xf0;
                DIAG_BUFER [ 2 ] = 0x86;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //天有为版本
            }
            loc_Step = 5;
            break;
        case 5:
            if ( SW_Version [ 0 ] == 0xff )
            {

                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0xf1;
                DIAG_BUFER [ 2 ] = 0x89;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //长安定义的ECU软件版本编号
            }
            loc_Step = 6;

            break;
        case 6:
            if ( HW_Version [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0xf0;
                DIAG_BUFER [ 2 ] = 0x89;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //长安定义的ECU硬件版本编号
            }
            loc_Step = 7;

            break;
        case 7:
            if ( Part_Version [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0xf1;
                DIAG_BUFER [ 2 ] = 0x88;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //零件号
            }
            loc_Step = 0;

            break;
    }

    if ( (UnLock_Flag == 1) || (UnLock_Flag == 3) )
    {
        if ( UnLock_Retry != 0 )
        {
            UnLock_Retry--;
        }
        else
        {
            if ( UnLock_Flag == 1 )
            {
                UnLock_Flag = 0u;
            }
            else if ( UnLock_Flag == 3 )
            {
                UnLock_Flag = 2;
            }
        }
    }
}

void Function_Check_Ctrl(uint32_t cmd)
{
    uint8_t         p [ 20 ];
    uint8_t         DIAG_BUFER [ 40 ];
    uint32_t        i;
    uint32_t        j;
    static uint32_t status    = 0;
    static uint32_t MENU_BACK = 0;
    static uint8_t  UDS_EunD = 0;

    if ( cmd == 0 )
    {
        // LINE_OUT_CHARGER = 0;
        // LINE_OUT_OIL = 0;
        // LINE_OUT_BREAK_LEVEL = 0;
        // LINE_OUT_WARSH_LEVEL = 0;
        // LINE_OUT_EPS = 0;
    }
    else if(cmd == 1)
    {
        if ( MENU_CHECK_STEP > 5 )
        {
            MENU_CHECK_STEP = 0;
        }
        if ( UDS_EunD != MENU_CHECK_STEP )
        {

            if ( VOICE_CHECK_BEGIN == 0 )
            {
                VOICE_CHECK_BEGIN = 1u;
                VOICE_CHECK_Retry = 10u;
                p [ 0 ] = (MENU_CHECK_STEP) / 100;    // 65535
                p [ 1 ] = ((MENU_CHECK_STEP) % 100) / 10;
                p [ 2 ] = (MENU_CHECK_STEP) % 10;    // 65535
                p [ 3 ] = 0xff;
                General_Number_Disp(p, 40, 48 + 64);
            }
            else if ( VOICE_CHECK_BEGIN == 1 )
            {
                UDS_EunD = MENU_CHECK_STEP;
            }
            else if ( VOICE_CHECK_BEGIN == 2 )
            {
                UDS_EunD = MENU_CHECK_STEP;
            }
            else
            {
            }
        }

        if(MENU_CHECK_STEP != 0)
        {
            /*if(MENU_CHECK_STEP == 1)
            {
                LINE_OUT_CHARGER = 0;
                LINE_OUT_OIL = 0;
                LINE_OUT_BREAK_LEVEL = 0;
                LINE_OUT_WARSH_LEVEL = 0;
                LINE_OUT_EPS = 0;

                DIAG_BUFER [ 0 ]  = 0x00;
                DIAG_BUFER [ 1 ]  = 0xE0;
                DIAG_BUFER [ 2 ]  = 0x7F;
                DIAG_BUFER [ 3 ]  = 0x80;
                DIAG_BUFER [ 4 ]  = 0x00;
                DIAG_BUFER [ 5 ]  = 0x4F;
                DIAG_BUFER [ 6 ]  = 0x71;
                DIAG_BUFER [ 7 ]  = 0x02;
                DIAG_BUFER [ 8 ]  = 0x68;
                DIAG_BUFER [ 9 ]  = 0x88;
                DIAG_BUFER [ 10]  = 0x22;
                DIAG_BUFER [ 11]  = 0x74;
                DIAG_BUFER [ 12]  = 0x00;
                DIAG_BUFER [ 13]  = 0x00;
                DIAG_BUFER [ 14]  = 0x00;
                DIAG_BUFER [ 15]  = 0x00;
                DIAG_BUFER [ 16]  = 0x00;
                DIAG_BUFER [ 17]  = 0x00; 
                DIAG_BUFER [ 18]  = 0x00;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 19);
            }
            else */
            // if(MENU_CHECK_STEP == 1)
            // {
            //     LINE_OUT_CHARGER = 1;
            //     LINE_OUT_OIL = 0u;
            //     LINE_OUT_BREAK_LEVEL = 0u;
            //     LINE_OUT_WARSH_LEVEL = 0u;
            //     LINE_OUT_EPS = 0u;
            // }
            // else if(MENU_CHECK_STEP == 2)
            // {
            //     LINE_OUT_CHARGER = 0;
            //     LINE_OUT_OIL = 1u;
            //     LINE_OUT_BREAK_LEVEL = 0u;
            //     LINE_OUT_WARSH_LEVEL = 0u;
            //     LINE_OUT_EPS = 0u;
            // }
            // else if(MENU_CHECK_STEP == 3)
            // {
            //     LINE_OUT_CHARGER = 0;
            //     LINE_OUT_OIL = 0u;
            //     LINE_OUT_BREAK_LEVEL = 1u;
            //     LINE_OUT_WARSH_LEVEL = 0u;
            //     LINE_OUT_EPS = 0u;
            // }
            // else if(MENU_CHECK_STEP == 4)
            // {
            //     LINE_OUT_CHARGER = 0;
            //     LINE_OUT_OIL = 0u;
            //     LINE_OUT_BREAK_LEVEL = 0u;
            //     LINE_OUT_WARSH_LEVEL = 1u;
            //     LINE_OUT_EPS = 0u;
            // }
            // else if(MENU_CHECK_STEP == 5)
            // {
            //     LINE_OUT_CHARGER = 0;
            //     LINE_OUT_OIL = 0u;
            //     LINE_OUT_BREAK_LEVEL = 0u;
            //     LINE_OUT_WARSH_LEVEL = 0u;
            //     LINE_OUT_EPS = 1u;
            // }
            // else 
            {
                if ( MENU_CHECK_STEP > Get_Total_CheckStep( ) )
                {
                    MENU_CHECK_STEP = 0;
                }

                if ( MENU_BACK != MENU_CHECK_STEP )
                {
                    Execute_Specify_Step((MENU_CHECK_STEP));
                    MENU_BACK = MENU_CHECK_STEP;
                }
            }
        } 
    }
}


void Get_ODO_Call(void)
{
    uint8_t         DIAG_BUFER [ 10 ];
    uint8_t Risk_Evade_M[]={0, 0, 0, 0, 0, 0, 0, 0};
    uint8_t Evade_ODO_M[]={0, 0, 0, 0, 0, 0, 0, 0};
    static uint8_t Clear;
    static uint8_t ODO_DEL;
    if(Clear < 15)
    {
        Clear ++;
    }
    else 
    {
        Clear = 0u;
    }
    switch (Clear)
    {
    case 6:
        /* code */
        if(Risk_Evade[0] == 0xFF)
        {
            DIAG_BUFER [ 0 ] = 0x22;
            DIAG_BUFER [ 1 ] = 0xf2;
            DIAG_BUFER [ 2 ] = 0x03;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);
        }
        break;
    case 12:
        if(Evade_ODO[0] == 0xFF)
        {
            DIAG_BUFER [ 0 ] = 0x22;
            DIAG_BUFER [ 1 ] = 0xf2;
            DIAG_BUFER [ 2 ] = 0x02;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);
        }
        break;
    
    default:
        break;
    }
    if(((Get_ID_ODO() / 10) > 0) || (memcmp(Risk_Evade, Risk_Evade_M, 3) != 0) 
    || (memcmp(Evade_ODO, Evade_ODO_M, 3) != 0))
    {
        // if((Risk_Evade[0] != 255)||(Risk_Evade[1] != 255)||(Risk_Evade[2] != 255))
        // &&((Evade_ODO[0] != 255)||(Evade_ODO[1] != 255)||(Evade_ODO[2] != 255))
        {
            if((LINE_ODO_CLEAR_BEGIN == 2))
            {
                PWM_FMQ = 1u;
                DIAG_BUFER [ 0 ] = 0x2E;
                DIAG_BUFER [ 1 ] = 0xf2;
                DIAG_BUFER [ 2 ] = 0x02;
                DIAG_BUFER [ 3 ] = 0x00;
                DIAG_BUFER [ 4 ] = 0x00;
                DIAG_BUFER [ 5 ] = 0x00;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6);

                DIAG_BUFER [ 0 ] = 0x2E;
                DIAG_BUFER [ 1 ] = 0xf2;
                DIAG_BUFER [ 2 ] = 0x03;
                DIAG_BUFER [ 3 ] = 0x00;
                DIAG_BUFER [ 4 ] = 0x00;
                DIAG_BUFER [ 5 ] = 0x00;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6);

                while(1)
                {
                    // if(ODO_DEL == 199)
                    {
                        DIAG_BUFER [ 0 ] = 0x11;
                        DIAG_BUFER [ 1 ] = 0x01;
                        UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
                    }
                    // ODO_DEL --;
                }
            }
            else 
            {
                ODO_DEL = 200u;
                PWM_FMQ = 0u;
            }
        }
        // else 
        // {
        //     if((Get_ID_ODO() / 10) > 0)
        //     PWM_FMQ = 1u;
        //     else 
        //     PWM_FMQ = 0u;
        // }
    }
    else 
    {
        if((LINE_ODO_CLEAR_BEGIN == 2))
        {
            PWM_FMQ = 1u;
            DIAG_BUFER [ 0 ] = 0x2E;
            DIAG_BUFER [ 1 ] = 0xf2;
            DIAG_BUFER [ 2 ] = 0x02;
            DIAG_BUFER [ 3 ] = 0x00;
            DIAG_BUFER [ 4 ] = 0x00;
            DIAG_BUFER [ 5 ] = 0x00;

            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6);
            DIAG_BUFER [ 0 ] = 0x2E;
            DIAG_BUFER [ 1 ] = 0xf2;
            DIAG_BUFER [ 2 ] = 0x03;
            DIAG_BUFER [ 3 ] = 0x00;
            DIAG_BUFER [ 4 ] = 0x00;
            DIAG_BUFER [ 5 ] = 0x00;
            UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 6);
            
            while(1)
            {
                // if(ODO_DEL == 199)
                {
                    DIAG_BUFER [ 0 ] = 0x11;
                    DIAG_BUFER [ 1 ] = 0x01;
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
                }
                // ODO_DEL --;
            }
        }
        else 
        {
            ODO_DEL = 200u;
            PWM_FMQ = 0u;
        }
    }
}
